/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.PersistentTimer;
import com.ibm.ejs.container.TimedObjectWrapper;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.dopriv.GetContextClassLoaderPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejbcontainer.runtime.AbstractEJBRuntime;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Date;
import javax.ejb.EJBException;

public abstract class PersistentTimerTaskHandler
implements Runnable,
Serializable {
    private static final TraceComponent tc = Tr.register(PersistentTimerTaskHandler.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = PersistentTimerTaskHandler.class.getName();
    private static final long serialVersionUID = -8200752857441853748L;
    private static final byte[] EYECATCHER = Constants.TIMER_TASK_EYE_CATCHER;
    private static final short PLATFORM = 1;
    protected transient J2EEName j2eeName;
    protected transient int methodId;
    private transient String automaticMethodName;
    private transient String automaticClassName;
    private transient byte[] userInfoBytes;
    protected transient long expiration;
    protected transient long interval;
    protected transient ParsedScheduleExpression parsedSchedule;

    private PersistentTimerTaskHandler(J2EEName j2eeName, Serializable info) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + j2eeName + ", " + Util.identity((Object)info)), (Object[])new Object[0]);
        }
        this.j2eeName = j2eeName;
        this.userInfoBytes = PersistentTimerTaskHandler.serializeObject(info);
    }

    protected PersistentTimerTaskHandler(J2EEName j2eeName, Serializable info, Date expiration, long interval) {
        this(j2eeName, info);
        this.expiration = expiration.getTime();
        this.interval = interval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + this), (Object[])new Object[0]);
        }
    }

    protected PersistentTimerTaskHandler(J2EEName j2eeName, Serializable info, ParsedScheduleExpression parsedSchedule) {
        this(j2eeName, info);
        this.parsedSchedule = parsedSchedule;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + this), (Object[])new Object[0]);
        }
    }

    protected PersistentTimerTaskHandler(J2EEName j2eeName, Serializable info, ParsedScheduleExpression parsedSchedule, int methodId, String methodName, String className) {
        this(j2eeName, info);
        this.parsedSchedule = parsedSchedule;
        this.methodId = methodId;
        this.automaticMethodName = methodName;
        this.automaticClassName = className;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + this), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EJSHome home;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("run: " + this), (Object[])new Object[0]);
        }
        try {
            home = EJSContainer.getDefaultContainer().getInstalledHome(this.j2eeName);
            if (home.beanMetaData.timedMethodInfos == null) {
                Tr.warning((TraceComponent)tc, (String)"HOME_NOT_FOUND_CNTR0092W", (Object[])new Object[]{this.j2eeName});
                throw new EJBNotFoundException("Incompatible Application Change: " + this.j2eeName + " no longer supports timers.");
            }
        }
        catch (EJBNotFoundException ejbnfex) {
            FFDCFilter.processException((Throwable)ejbnfex, (String)(CLASS_NAME + ".run"), (String)"305", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run: Failed locating timer bean " + this.j2eeName + " : " + ejbnfex));
            }
            throw new TimerServiceException("Failed locating timer bean " + this.j2eeName, ejbnfex);
        }
        if (this.automaticMethodName != null && !this.validateAutomaticTimer(home.beanMetaData)) {
            Tr.error((TraceComponent)tc, (String)"AUTOMATIC_TIMER_VALIDATION_FAILED_CNTR0301E", (Object[])new Object[]{this.j2eeName.getComponent(), this.j2eeName.getModule(), this.j2eeName.getApplication(), this.automaticMethodName});
            throw new EJBException("CNTR0220I: The " + this.j2eeName.getComponent() + " enterprise bean in the " + this.j2eeName.getModule() + " module of the " + this.j2eeName.getApplication() + " application has an automatic timer for the " + this.automaticMethodName + " method, but an incompatible change was made to the application since the server created the timer.");
        }
        AbstractEJBRuntime ejbRuntime = (AbstractEJBRuntime)home.container.getEJBRuntime();
        PersistentTimer timer = this.createTimer(ejbRuntime);
        TimedObjectWrapper timedObject = home.getTimedObjectWrapper(home.ivStatelessId);
        if (ejbRuntime.isStopping()) {
            EJBMethodInfoImpl methodInfo = timedObject.methodInfos[this.methodId];
            EJBException failure = new EJBException("Timeout method " + methodInfo.getBeanClassName() + "." + methodInfo.getMethodName() + " will not be invoked because server is stopping");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run: " + (Object)((Object)failure)));
            }
            throw failure;
        }
        try {
            timer.isTimeoutCallback = true;
            boolean runInGlobalTx = PersistentTimerTaskHandler.runInGlobalTransaction(timedObject.methodInfos[this.methodId]);
            timedObject.invokeCallback(timer, this.methodId, runInGlobalTx);
        }
        finally {
            timer.isTimeoutCallback = false;
            home.putTimedObjectWrapper(timedObject);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run: " + this));
            }
        }
    }

    protected abstract PersistentTimer createTimer(EJBRuntime var1);

    private boolean validateAutomaticTimer(BeanMetaData bmd) {
        if (bmd.timedMethodInfos == null || this.methodId > bmd.timedMethodInfos.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validateAutomaticTimer: ivMethodId=" + this.methodId + " > " + Arrays.toString(bmd.timedMethodInfos)), (Object[])new Object[0]);
            }
            return false;
        }
        Method method = bmd.timedMethodInfos[this.methodId].ivMethod;
        if (!method.getName().equals(this.automaticMethodName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validateAutomaticTimer: ivAutomaticMethodName=" + this.automaticMethodName + " != " + method.getName()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.automaticClassName != null && !this.automaticClassName.equals(method.getDeclaringClass().getName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validateAutomaticTimer: ivAutomaticClassName=" + this.automaticClassName + " != " + method.getDeclaringClass().getName()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected EJSDeployedSupport lockSingleton() {
        EJSHome home;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("lockSingleton: " + this), (Object[])new Object[0]);
        }
        EJSDeployedSupport s = null;
        try {
            home = EJSContainer.getDefaultContainer().getInstalledHome(this.j2eeName);
        }
        catch (EJBNotFoundException ejbnfex) {
            FFDCFilter.processException((Throwable)ejbnfex, (String)(CLASS_NAME + ".lockSingleton"), (String)"305", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("lockSingleton: Failed locating timer bean " + this.j2eeName + " : " + ejbnfex));
            }
            throw new TimerServiceException("Failed locating timer bean " + this.j2eeName, ejbnfex);
        }
        if (home.ivSingletonSessionHome && !home.beanMetaData.ivSingletonUsesBeanManagedConcurrency) {
            EJBMethodInfoImpl[] timerMethodInfos = home.beanMetaData.timedMethodInfos;
            if (timerMethodInfos != null && this.methodId < timerMethodInfos.length) {
                if (PersistentTimerTaskHandler.runInGlobalTransaction(timerMethodInfos[this.methodId])) {
                    s = new EJSDeployedSupport();
                    s.methodId = this.methodId;
                    s.methodInfo = timerMethodInfos[this.methodId];
                    s.beanO = home.createSingletonBeanO();
                    try {
                        s.beanO.preInvoke(s, null);
                    }
                    catch (Throwable ex) {
                        block18: {
                            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".lockSingleton"), (String)"403", (Object)this);
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Unexpected failure calling beanO.preInvoke: " + ex), (Object[])new Object[0]);
                            }
                            try {
                                s.beanO.postInvoke(this.methodId, s);
                            }
                            catch (Throwable exPost) {
                                FFDCFilter.processException((Throwable)exPost, (String)(CLASS_NAME + ".lockSingleton"), (String)"409", (Object)this);
                                if (!isTraceOn || !tc.isDebugEnabled()) break block18;
                                Tr.debug((TraceComponent)tc, (String)("Unexpected failure calling beanO.postInvoke: " + exPost), (Object[])new Object[0]);
                            }
                        }
                        if (isTraceOn && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("lockSingleton: Failure acquiring lock for bean " + this.j2eeName + " : " + ex));
                        }
                        throw ExceptionUtil.EJBException("Failure acquiring lock for bean " + this.j2eeName, ex);
                    }
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Timer method no longer present on bean??", (Object[])new Object[0]);
            }
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"not a container managed concurrency singleton bean", (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("lockSingleton: " + s));
        }
        return s;
    }

    protected void unlockSingleton(EJSDeployedSupport s) {
        boolean isTraceOn;
        block5: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("unlockSingleton: " + this + ", " + s), (Object[])new Object[0]);
            }
            if (s != null && s.beanO != null) {
                try {
                    s.beanO.postInvoke(s.methodId, s);
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".unlockSingleton"), (String)"305", (Object)this);
                    if (!isTraceOn || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring unexpected failure calling beanO.postInvoke: " + ex), (Object[])new Object[0]);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unlockSingleton");
        }
    }

    protected boolean isAutomaticTimer() {
        return this.automaticMethodName != null;
    }

    public String getAutomaticTimerMethodName() {
        return this.automaticMethodName;
    }

    public Serializable getUserInfo() throws TimerServiceException {
        if (this.userInfoBytes == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getUserInfo: null", (Object[])new Object[0]);
            }
            return null;
        }
        Serializable userInfo = null;
        try {
            ClassLoader loader = EJSContainer.getClassLoader(this.j2eeName);
            if (loader == null) {
                loader = (ClassLoader)AccessController.doPrivileged(new GetContextClassLoaderPrivileged());
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(this.userInfoBytes);
            EJBRuntime ejbRuntime = EJSContainer.getDefaultContainer().getEJBRuntime();
            final ObjectInputStream objIstream = ejbRuntime.createObjectInputStream(bais, loader);
            userInfo = (Serializable)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException, IOException {
                    return objIstream.readObject();
                }
            });
        }
        catch (PrivilegedActionException paex) {
            TimerServiceException ex = new TimerServiceException("Failure deserializing timer info object.", paex.getException());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUserInfo: " + (Object)((Object)ex)), (Object[])new Object[0]);
            }
            throw ex;
        }
        catch (IOException ioex) {
            FFDCFilter.processException((Throwable)ioex, (String)(CLASS_NAME + ".getUserInfo"), (String)"406");
            TimerServiceException ex = new TimerServiceException("Failure deserializing timer info object.", ioex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getUserInfo: " + (Object)((Object)ex)), (Object[])new Object[0]);
            }
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUserInfo: " + Util.identity((Object)userInfo)), (Object[])new Object[0]);
        }
        return userInfo;
    }

    public abstract Date getNextTimeout(Date var1, Date var2);

    public ParsedScheduleExpression getParsedSchedule() {
        return this.parsedSchedule;
    }

    public J2EEName getJ2EEName() {
        return this.j2eeName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeObject: " + this), (Object[])new Object[0]);
        }
        int version = 1;
        if (this.parsedSchedule != null) {
            version = 2;
        }
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(version);
        out.writeObject(this.j2eeName.getBytes());
        out.writeObject(this.userInfoBytes);
        switch (version) {
            case 1: {
                out.writeLong(this.expiration);
                out.writeLong(this.interval);
                break;
            }
            case 2: {
                out.writeObject(this.parsedSchedule);
                out.writeInt(this.methodId);
                out.writeObject(this.automaticMethodName);
                out.writeObject(this.automaticClassName);
                break;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        in.defaultReadObject();
        byte[] eyeCatcher = new byte[EYECATCHER.length];
        int bytesRead = 0;
        for (int offset = 0; offset < EYECATCHER.length; offset += bytesRead) {
            bytesRead = in.read(eyeCatcher, offset, EYECATCHER.length - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < EYECATCHER.length; ++i) {
            if (EYECATCHER[i] == eyeCatcher[i]) continue;
            String eyeCatcherString = new String(eyeCatcher);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in TimerHandle input stream");
        }
        short incoming_platform = in.readShort();
        short incoming_vid = in.readShort();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("version = " + incoming_vid), (Object[])new Object[0]);
        }
        if (incoming_vid != 1 && incoming_vid != 2) {
            throw new InvalidObjectException("EJB TimerTaskHandler data stream is not of the correct version, this client should be updated.");
        }
        byte[] j2eeNameBytes = (byte[])in.readObject();
        this.j2eeName = EJSContainer.j2eeNameFactory.create(j2eeNameBytes);
        this.userInfoBytes = (byte[])in.readObject();
        switch (incoming_vid) {
            case 1: {
                this.expiration = in.readLong();
                this.interval = in.readLong();
                break;
            }
            case 2: {
                this.parsedSchedule = (ParsedScheduleExpression)in.readObject();
                this.methodId = in.readInt();
                this.automaticMethodName = (String)in.readObject();
                this.automaticClassName = (String)in.readObject();
                break;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readObject: " + this));
        }
    }

    protected static boolean runInGlobalTransaction(EJBMethodInfoImpl methodInfo) {
        return methodInfo.getTransactionAttribute() == TransactionAttribute.TX_REQUIRED;
    }

    protected BeanMetaData getBeanMetaData() {
        EJSHome home;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getBeanMetaData: " + this), (Object[])new Object[0]);
        }
        try {
            home = EJSContainer.getDefaultContainer().getInstalledHome(this.j2eeName);
            if (home.beanMetaData.timedMethodInfos == null) {
                Tr.warning((TraceComponent)tc, (String)"HOME_NOT_FOUND_CNTR0092W", (Object[])new Object[]{this.j2eeName});
                throw new EJBNotFoundException("Incompatible Application Change: " + this.j2eeName + " no longer supports timers.");
            }
        }
        catch (EJBNotFoundException ejbnfex) {
            FFDCFilter.processException((Throwable)ejbnfex, (String)(CLASS_NAME + ".getBeanMetaData"), (String)"635", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getBeanMetaData: Failed locating timer bean " + this.j2eeName + " : " + ejbnfex));
            }
            throw new TimerServiceException("Failed locating timer bean " + this.j2eeName, ejbnfex);
        }
        BeanMetaData bmd = home.beanMetaData;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getBeanMetaData: " + bmd));
        }
        return bmd;
    }

    private static byte[] serializeObject(Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.flush();
        }
        catch (IOException ioex) {
            throw new EJBException("Timer info object failed to serialize.", (Exception)ioex);
        }
        return baos.toByteArray();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("(");
        builder.append(this.j2eeName).append(", ");
        if (this.parsedSchedule == null) {
            builder.append(new Date(this.expiration)).append(", ").append(this.interval);
        } else {
            builder.append(this.methodId).append(", ");
            builder.append(ScheduleExpressionParser.toString(this.parsedSchedule.getSchedule()));
        }
        builder.append(")");
        return builder.toString();
    }
}

