/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.MethodMetaData;

public class EJBMethodInfoStack {
    private static final TraceComponent tc = Tr.register(EJSContainer.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.EJBMethodInfoStack");
    private EJBMethodInfoImpl[] elements;
    private int topOfStack = 0;
    private boolean ivSetup = false;
    private int capacity = 0;
    private boolean orig = false;

    private void setup(BeanMetaData bmd) {
        if (!this.ivSetup) {
            int slotSize = bmd.container.getEJBRuntime().getMetaDataSlotSize(MethodMetaData.class);
            for (int i = 0; i < this.capacity; ++i) {
                EJBMethodInfoImpl methodInfo = bmd.createEJBMethodInfoImpl(slotSize);
                methodInfo.initializeInstanceData(null, null, null, null, null, false);
                this.elements[i] = methodInfo;
            }
            this.ivSetup = true;
        }
    }

    public EJBMethodInfoStack(int cap) {
        this.capacity = cap;
        this.elements = new EJBMethodInfoImpl[this.capacity];
    }

    public final void done(EJBMethodInfoImpl mi) {
        if (this.orig || mi == null || this.topOfStack == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In orig mode returning:  orig: " + this.orig + " top: " + this.topOfStack + " mi:  " + mi), (Object[])new Object[0]);
            }
            this.orig = true;
            this.elements = null;
        } else {
            --this.topOfStack;
            if (this.topOfStack < this.capacity) {
                if (mi != this.elements[this.topOfStack]) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("EJBMethodInfoStack::done called with wrong TopOfStack value: " + mi + "!=" + this.elements[this.topOfStack]), (Object[])new Object[0]);
                    }
                    this.orig = true;
                    this.elements = null;
                } else {
                    this.elements[this.topOfStack].initializeInstanceData(null, null, null, null, null, false);
                }
            }
        }
    }

    public final EJBMethodInfoImpl get(String methodSignature, String methodNameOnly, EJSWrapperBase wrapper, MethodInterface methodInterface, TransactionAttribute txAttr) {
        EJBMethodInfoImpl retVal = null;
        BeanMetaData bmd = wrapper.bmd;
        this.setup(bmd);
        if (this.topOfStack < 0 || this.orig) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("EJBMethodInfoStack::get called with neg TopOfStack or in orig mode:" + this.topOfStack + " orig: " + this.orig), (Object[])new Object[0]);
            }
            this.orig = true;
            this.elements = null;
            retVal = bmd.createEJBMethodInfoImpl(bmd.container.getEJBRuntime().getMetaDataSlotSize(MethodMetaData.class));
        } else if (this.topOfStack < this.elements.length) {
            retVal = this.elements[this.topOfStack++];
        } else {
            ++this.topOfStack;
            retVal = bmd.createEJBMethodInfoImpl(bmd.container.getEJBRuntime().getMetaDataSlotSize(MethodMetaData.class));
        }
        retVal.initializeInstanceData(null, methodNameOnly, bmd, methodInterface, txAttr, false);
        return retVal;
    }
}

