/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJBThreadData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import com.ibm.ws.uow.embeddable.SystemException;
import com.ibm.ws.uow.embeddable.UOWToken;
import java.util.Map;
import javax.transaction.TransactionRolledbackException;

class CallbackContextHelper {
    private static final String CLASS_NAME = CallbackContextHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CallbackContextHelper.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final BeanO ivBeanO;
    private UOWToken ivUowToken;
    protected LocalTransactionCurrent ivLocalTransactionCurrent;
    protected EmbeddableWebSphereTransactionManager ivTransactionManager;
    private EJBThreadData ivThreadData;
    private Contexts ivPopContexts;
    private int ivSavedLifecycleMethodContextIndex;
    private Tx ivSavedLifecycleMethodBeginTx;
    private Map<String, Object> ivSavedLifecycleContextData;

    CallbackContextHelper(BeanO beanO) {
        this.ivBeanO = beanO;
    }

    public void begin(Tx beginTx, Contexts pushContexts) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("begin: tx=" + (Object)((Object)beginTx) + ", contexts=" + (Object)((Object)pushContexts)), (Object[])new Object[0]);
        }
        this.ivThreadData = EJSContainer.getThreadData();
        if (pushContexts == Contexts.All) {
            this.ivThreadData.pushContexts(this.ivBeanO);
        } else {
            this.ivThreadData.pushCallbackBeanO(this.ivBeanO);
        }
        this.ivPopContexts = pushContexts;
        this.ivSavedLifecycleContextData = this.ivThreadData.ivLifecycleContextData;
        this.ivThreadData.ivLifecycleContextData = null;
        this.ivSavedLifecycleMethodContextIndex = this.ivThreadData.ivLifecycleMethodContextIndex;
        this.ivThreadData.ivLifecycleMethodContextIndex = this.ivThreadData.getNumMethodContexts();
        if (beginTx == Tx.CompatLTC) {
            beginTx = this.ivBeanO.home.beanMetaData.ivModuleVersion >= 30 ? Tx.LTC : null;
        }
        this.ivSavedLifecycleMethodBeginTx = this.ivThreadData.ivLifecycleMethodBeginTx;
        this.ivThreadData.ivLifecycleMethodBeginTx = beginTx;
        if (beginTx != null) {
            boolean ltc;
            if (this.ivUowToken != null) {
                throw new CSIException("Cannot begin until prior TX is resumed");
            }
            UOWCurrent uowCurrent = EmbeddableTransactionManagerFactory.getUOWCurrent();
            if (uowCurrent != null) {
                try {
                    this.ivUowToken = this.ivBeanO.container.ivUOWManager.suspend();
                    if (isTraceOn && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Suspended TX/LTC cntxt: " + this.ivUowToken), (Object[])new Object[0]);
                    }
                }
                catch (SystemException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".begin"), (String)"140", (Object)this);
                    throw new CSIException("Cannot begin due to failure in suspend.", e);
                }
            }
            boolean bl = ltc = beginTx == Tx.LTC;
            if (ltc) {
                this.ivLocalTransactionCurrent = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent();
                this.ivLocalTransactionCurrent.begin();
                if (isTraceOn && tc.isEventEnabled()) {
                    LocalTransactionCoordinator lCoord = this.ivLocalTransactionCurrent.getLocalTranCoord();
                    if (lCoord != null) {
                        Tr.event((TraceComponent)tc, (String)("Began LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
                    } else {
                        Tr.event((TraceComponent)tc, (String)"Began LTC cntxt: null Coordinator!", (Object[])new Object[0]);
                    }
                }
            } else {
                try {
                    this.ivTransactionManager = EmbeddableTransactionManagerFactory.getTransactionManager();
                    this.ivTransactionManager.begin();
                    if (isTraceOn && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Began TX cntxt: " + this.ivTransactionManager.getTransaction()), (Object[])new Object[0]);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".begin"), (String)"214", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Begin global tx failed", (Object[])new Object[]{ex});
                    }
                    throw new CSIException("Begin global tx failed", ex);
                }
            }
            this.ivBeanO.container.getCurrentTx((SynchronizationRegistryUOWScope)this.getUOWCoordinator(), ltc);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"begin");
        }
    }

    void complete(boolean commit) throws CSIException {
        boolean isTraceOn;
        block30: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("complete called with commit argument set to: " + commit), (Object[])new Object[0]);
            }
            if (this.ivPopContexts != null) {
                if (this.ivPopContexts == Contexts.All) {
                    this.ivThreadData.popContexts();
                } else {
                    this.ivThreadData.popCallbackBeanO();
                }
                this.ivThreadData.ivLifecycleContextData = this.ivSavedLifecycleContextData;
                this.ivThreadData.ivLifecycleMethodContextIndex = this.ivSavedLifecycleMethodContextIndex;
                this.ivThreadData.ivLifecycleMethodBeginTx = this.ivSavedLifecycleMethodBeginTx;
                this.ivThreadData = null;
            }
            try {
                if (this.ivTransactionManager != null) {
                    if (commit) {
                        int status;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Committing TX cntxt: " + this.ivTransactionManager.getTransaction()), (Object[])new Object[0]);
                        }
                        if ((status = this.ivTransactionManager.getStatus()) == 1 || status == 9 || status == 4) {
                            try {
                                this.ivTransactionManager.completeTxTimeout();
                            }
                            catch (TransactionRolledbackException e) {
                                this.ivTransactionManager.rollback();
                                throw e;
                            }
                            this.ivTransactionManager.rollback();
                            break block30;
                        }
                        this.ivTransactionManager.commit();
                        break block30;
                    }
                    if (isTraceOn && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Rolling back TX cntxt due to bean exception: " + this.ivTransactionManager.getTransaction()), (Object[])new Object[0]);
                    }
                    this.ivTransactionManager.rollback();
                    break block30;
                }
                if (this.ivLocalTransactionCurrent != null) {
                    int endMode;
                    int n = endMode = commit ? 0 : 1;
                    if (isTraceOn && tc.isEventEnabled()) {
                        LocalTransactionCoordinator lCoord = this.ivLocalTransactionCurrent.getLocalTranCoord();
                        if (lCoord != null) {
                            Tr.event((TraceComponent)tc, (String)("Completing LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
                        } else {
                            Tr.event((TraceComponent)tc, (String)"Completing LTC cntxt: null Coordinator!", (Object[])new Object[0]);
                        }
                    }
                    this.ivLocalTransactionCurrent.complete(endMode);
                }
            }
            catch (Throwable t) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unspecified UOW completion failure: " + t), (Object[])new Object[]{t});
                }
                throw new CSIException("unspecified UOW completion failure: " + t, t);
            }
            finally {
                if (this.ivUowToken != null) {
                    if (isTraceOn) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("complete is resuming UOW with UOWToken = " + this.ivUowToken), (Object[])new Object[0]);
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Resuming TX/LTC cntxt: " + this.ivUowToken), (Object[])new Object[0]);
                        }
                    }
                    UOWToken token = this.ivUowToken;
                    this.ivUowToken = null;
                    try {
                        this.ivBeanO.container.ivUOWManager.resume(token);
                    }
                    catch (SystemException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".complete"), (String)"216", (Object)this);
                        throw new CSIException("Cannot complete due to failure in resume.", e);
                    }
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete");
        }
    }

    private UOWCoordinator getUOWCoordinator() {
        UOWCoordinator uowCoord = null;
        UOWCurrent uowCurrent = EmbeddableTransactionManagerFactory.getUOWCurrent();
        if (uowCurrent != null) {
            uowCoord = uowCurrent.getUOWCoord();
        }
        return uowCoord;
    }

    public void resetContextData() {
        this.ivThreadData.ivLifecycleContextData = null;
    }

    static enum Contexts {
        CallbackBean,
        All;

    }

    static enum Tx {
        LTC,
        CompatLTC,
        Global;

    }
}

