/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.security.common.random.RandomUtils;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Jose4jEllipticCurveJWK
extends EllipticCurveJsonWebKey
implements JWK {
    private static final long serialVersionUID = 1787582L;
    private static final TraceComponent tc = Tr.register(Jose4jEllipticCurveJWK.class, (String)"SecurityCommonJWK", (String)"com.ibm.ws.security.common.jwk.internal.resources.JWKCommonMessages");
    protected long created = new Date().getTime();

    public static Jose4jEllipticCurveJWK getInstance(String alg, String use) {
        String kid = RandomUtils.getRandomAlphaNumeric((int)20);
        KeyPair keypair = Jose4jEllipticCurveJWK.getKeyPair(alg);
        if (keypair == null) {
            return null;
        }
        ECPublicKey pubKey = (ECPublicKey)keypair.getPublic();
        ECPrivateKey priKey = (ECPrivateKey)keypair.getPrivate();
        Jose4jEllipticCurveJWK jwk = Jose4jEllipticCurveJWK.getInstance(pubKey, alg, use);
        jwk.setPrivateKey(priKey);
        jwk.setKeyId(kid);
        return jwk;
    }

    public static Jose4jEllipticCurveJWK getInstance(ECPublicKey publicKey, String alg, String use) {
        Jose4jEllipticCurveJWK jwk = new Jose4jEllipticCurveJWK(publicKey);
        jwk.setAlgorithm(alg);
        jwk.setUse(use == null ? "sig" : use);
        return jwk;
    }

    /*
     * WARNING - void declaration
     */
    static KeyPair getKeyPair(String alg) {
        KeyPairGenerator keyGenerator = null;
        try {
            keyGenerator = KeyPairGenerator.getInstance("EC");
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.common.jwk.impl.Jose4jEllipticCurveJWK", (String)"84", null, (Object[])new Object[]{alg});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"hit exception", (Object[])new Object[]{e});
            }
            return null;
        }
        try {
            String ecParameterSpecName = Jose4jEllipticCurveJWK.getECParameterSpecName(alg);
            if (ecParameterSpecName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed to find a matching ECGenParameterSpec name for algorithm [" + alg + "]"), (Object[])new Object[0]);
                }
                return null;
            }
            keyGenerator.initialize(new ECGenParameterSpec(ecParameterSpecName));
        }
        catch (InvalidAlgorithmParameterException ecParameterSpecName) {
            FFDCFilter.processException((Throwable)ecParameterSpecName, (String)"com.ibm.ws.security.common.jwk.impl.Jose4jEllipticCurveJWK", (String)"99", null, (Object[])new Object[]{alg});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Failed to initialize the key generator: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        return keyGenerator.generateKeyPair();
    }

    static String getECParameterSpecName(String alg) {
        if (alg.endsWith("256")) {
            return "secp256r1";
        }
        if (alg.endsWith("384")) {
            return "secp384r1";
        }
        if (alg.endsWith("512")) {
            return "secp521r1";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Jose4jEllipticCurveJWK getInstance(JSONObject keyObject) {
        Jose4jEllipticCurveJWK jwk;
        block4: {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Set entries = keyObject.entrySet();
            for (Map.Entry entry : entries) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Entry Key:" + (String)entry.getKey() + " value:" + entry.getValue().toString()), (Object[])new Object[0]);
                }
                params.put((String)entry.getKey(), entry.getValue());
            }
            jwk = null;
            try {
                jwk = new Jose4jEllipticCurveJWK(params);
            }
            catch (JoseException entry) {
                void e;
                FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.security.common.jwk.impl.Jose4jEllipticCurveJWK", (String)"138", null, (Object[])new Object[]{keyObject});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("hit exception = " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return jwk;
    }

    public Jose4jEllipticCurveJWK(ECPublicKey publicKey) {
        super(publicKey);
    }

    public Jose4jEllipticCurveJWK(Map<String, Object> params) throws JoseException {
        super(params);
    }

    public String getKeyID() {
        return this.getKeyId();
    }

    public String getKeyX5t() {
        return null;
    }

    public String getKeyUse() {
        return this.getUse();
    }

    public byte[] getSharedKey() {
        return null;
    }

    public long getCreated() {
        return this.created;
    }

    @Override
    public void parse() {
    }

    @Override
    public void generateKey() {
    }

    @Override
    public JSONObject getJsonObject() {
        Map params = this.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        JSONObject jsonObject = new JSONObject();
        this.addProp(jsonObject, params, "kid");
        this.addProp(jsonObject, params, "use");
        this.addProp(jsonObject, params, "alg");
        this.addProp(jsonObject, params, "kty");
        this.addProp(jsonObject, params, "x");
        this.addProp(jsonObject, params, "y");
        this.addProp(jsonObject, params, "crv");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JSON Web Key(EC):", (Object[])new Object[]{jsonObject});
        }
        return jsonObject;
    }

    protected void addProp(JSONObject jsonObject, Map<String, Object> params, String key) {
        Object obj = params.get(key);
        if (obj != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key:" + key + " json-type:" + obj.toString()), (Object[])new Object[0]);
            }
            if (obj instanceof String) {
                jsonObject.put((Object)key, (Object)((String)obj));
            } else if (obj instanceof JSONObject) {
                jsonObject.put((Object)key, (Object)((JSONObject)obj).toString());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error json type:" + obj.getClass().getName() + " value:" + obj.toString()), (Object[])new Object[0]);
                }
                jsonObject.put((Object)key, (Object)((JSONObject)obj).toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key:" + key + " return null"), (Object[])new Object[0]);
        }
    }
}

