/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility;

import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandConstants;
import java.io.Console;
import java.io.IOError;
import java.io.PrintStream;
import java.text.MessageFormat;

public class DefaultCommandConsole
implements CommandConsole {
    private final Console console;
    private final PrintStream stderr;
    private final PrintStream stdout;

    public DefaultCommandConsole(Console console, PrintStream stdout, PrintStream stderr) {
        this.console = console;
        this.stderr = stderr;
        this.stdout = stdout;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return this.console != null;
    }

    @Override
    public String readMaskedText(String prompt) {
        if (!this.isInputStreamAvailable()) {
            this.stderr.println(CommandConstants.PRODUCT_MESSAGES.getString("ERROR_INPUT_CONSOLE_NOT_AVAILABLE"));
            return null;
        }
        try {
            char[] in = this.console.readPassword(prompt, new Object[0]);
            if (in == null) {
                return null;
            }
            return String.valueOf(in);
        }
        catch (IOError e) {
            this.stderr.println(MessageFormat.format(CommandConstants.PRODUCT_MESSAGES.getString("ERROR_UNABLE_READ_FROM_CONSOLE"), e.getMessage()));
            return null;
        }
    }

    @Override
    public String readText(String prompt) {
        if (!this.isInputStreamAvailable()) {
            this.stderr.println(CommandConstants.PRODUCT_MESSAGES.getString("ERROR_INPUT_CONSOLE_NOT_AVAILABLE"));
            return null;
        }
        try {
            return this.console.readLine(prompt, new Object[0]);
        }
        catch (IOError e) {
            this.stderr.println(MessageFormat.format(CommandConstants.PRODUCT_MESSAGES.getString("ERROR_UNABLE_READ_FROM_CONSOLE"), e.getMessage()));
            return null;
        }
    }

    @Override
    public void printInfoMessage(String message) {
        this.stdout.print(message);
    }

    @Override
    public void printlnInfoMessage(String message) {
        this.stdout.println(message);
    }

    @Override
    public void printErrorMessage(String errorMessage) {
        this.stderr.print(errorMessage);
    }

    @Override
    public void printlnErrorMessage(String errorMessage) {
        this.stderr.println(errorMessage);
    }
}

