/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.wsspi.webcontainer.servlet.ITransferContextService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;

public class ThreadContextManager {
    private static final TraceComponent tc = Tr.register(ThreadContextManager.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private static final String ComponentMetaData = "com-ibm-ws-runtime-metadata-ComponentMetaData-V1";
    private ClassLoader originalCL;
    private ClassLoader currentCL;
    private HashMap<String, Object> originalCD;
    private HashMap<String, Object> currentCD = null;

    public ThreadContextManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ThreadContextManager created, getting the initial data", (Object[])new Object[0]);
        }
        this.originalCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ThreadContextManager saving the original thread's context data", (Object[])new Object[0]);
        }
        this.originalCD = this.saveContextData();
    }

    public HashMap<String, Object> saveContextData() {
        Iterator TransferIterator;
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        ComponentMetaData cmd = cmdai.getComponentMetaData();
        if (cmd != null) {
            contextData.put(ComponentMetaData, cmd);
        }
        if ((TransferIterator = WebContainer.getITransferContextServices()) != null) {
            while (TransferIterator.hasNext()) {
                ITransferContextService tcs = (ITransferContextService)TransferIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling storeState on: " + tcs), (Object[])new Object[0]);
                }
                tcs.storeState(contextData);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No implmenting services found", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Saving the context data : " + contextData), (Object[])new Object[0]);
        }
        return contextData;
    }

    public void pushContextData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pushContextData", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting the original thread's class loader and saving off the current one", (Object[])new Object[0]);
        }
        this.currentCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(ThreadContextManager.this.originalCL);
                return cl;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Saving the current thread's context data", (Object[])new Object[0]);
        }
        this.currentCD = this.saveContextData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting the original thread's context data : " + this.originalCD), (Object[])new Object[0]);
        }
        if (this.originalCD != null) {
            Iterator TransferIterator;
            ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            ComponentMetaData cmd = (ComponentMetaData)this.originalCD.get(ComponentMetaData);
            if (cmd != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling begin on the ComponentMetaData : " + cmdai + ", with : " + cmd), (Object[])new Object[0]);
                }
                cmdai.beginContext(cmd);
            }
            if ((TransferIterator = WebContainer.getITransferContextServices()) != null) {
                while (TransferIterator.hasNext()) {
                    ITransferContextService tcs = (ITransferContextService)TransferIterator.next();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Calling restoreState on: " + tcs), (Object[])new Object[0]);
                    }
                    tcs.restoreState(this.originalCD);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pushContextData");
        }
    }

    public void popContextData() {
        ITransferContextService tcs;
        Iterator TransferIterator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"popContextData", (Object[])new Object[0]);
        }
        if (this.originalCD != null && (TransferIterator = WebContainer.getITransferContextServices()) != null) {
            while (TransferIterator.hasNext()) {
                tcs = (ITransferContextService)TransferIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling resetState on: " + tcs), (Object[])new Object[0]);
                }
                tcs.resetState();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Restoring the current thread's class loader", (Object[])new Object[0]);
        }
        if (this.currentCL != null) {
            AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread.currentThread().setContextClassLoader(ThreadContextManager.this.currentCL);
                    return ThreadContextManager.this.currentCL;
                }
            });
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Restoring the current thread's context data", (Object[])new Object[0]);
        }
        if (this.currentCD != null && (TransferIterator = WebContainer.getITransferContextServices()) != null) {
            while (TransferIterator.hasNext()) {
                tcs = (ITransferContextService)TransferIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("calling restoreState on: " + tcs), (Object[])new Object[0]);
                }
                tcs.restoreState(this.currentCD);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Ending the current ComponentMetaData context", (Object[])new Object[0]);
        }
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        cmdai.endContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"popContextData");
        }
    }
}

