/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.UDPChannel;
import com.ibm.ws.udpchannel.internal.UDPChannelConfiguration;
import com.ibm.ws.udpchannel.internal.UDPNetworkLayer;
import com.ibm.ws.udpchannel.internal.UDPReadRequestContextImpl;
import com.ibm.ws.udpchannel.internal.UDPWriteRequestContextImpl;
import com.ibm.ws.udpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.OutboundConnectorLink;
import com.ibm.wsspi.udpchannel.UDPContext;
import com.ibm.wsspi.udpchannel.UDPReadRequestContext;
import com.ibm.wsspi.udpchannel.UDPRequestContext;
import com.ibm.wsspi.udpchannel.UDPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;

public class UDPConnLink
extends OutboundConnectorLink
implements ConnectionLink,
OutboundConnectionLink,
UDPContext {
    private static final TraceComponent tc = Tr.register(UDPConnLink.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private WorkQueueManager workQueueMgr = null;
    private UDPChannel udpChannel = null;
    private UDPChannelConfiguration cfg = null;
    private UDPNetworkLayer udpNetworkLayer = null;
    private UDPReadRequestContextImpl reader = null;
    private UDPWriteRequestContextImpl writer = null;

    public UDPConnLink(WorkQueueManager wqm, VirtualConnection vc, UDPChannel channel, UDPChannelConfiguration cfg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UDPConnLink", (Object[])new Object[0]);
        }
        this.init(vc);
        this.workQueueMgr = wqm;
        this.udpChannel = channel;
        this.cfg = cfg;
        this.reader = new UDPReadRequestContextImpl(this, this.workQueueMgr);
        this.writer = new UDPWriteRequestContextImpl(this, this.workQueueMgr);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UDPConnLink");
        }
    }

    private void connectCommon(Object _udpRequestContextObject) throws IOException {
        String localAddress = "*";
        int localPort = 0;
        Map<Object, Object> vcStateMap = this.getVirtualConnection().getStateMap();
        if (vcStateMap != null) {
            String value = (String)vcStateMap.get("receiveBufferSizeChannel");
            if (value != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("receiveBufferSizeChannel " + value), (Object[])new Object[0]);
                }
                this.cfg.setChannelReceiveBufferSize(Integer.parseInt(value));
            }
            if ((value = (String)vcStateMap.get("receiveBufferSizeSocket")) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("receiveBufferSizeSocket " + value), (Object[])new Object[0]);
                }
                this.cfg.setReceiveBufferSize(Integer.parseInt(value));
            }
            if ((value = (String)vcStateMap.get("sendBufferSizeSocket")) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sendBufferSizeSocket " + value), (Object[])new Object[0]);
                }
                this.cfg.setSendBufferSize(Integer.parseInt(value));
            }
        }
        if (_udpRequestContextObject != null) {
            UDPRequestContext udpRequestContext = (UDPRequestContext)_udpRequestContextObject;
            InetSocketAddress addr = udpRequestContext.getLocalAddress();
            localAddress = addr.getAddress().getHostAddress();
            localPort = addr.getPort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connect with local address: " + localAddress + " local port: " + localPort), (Object[])new Object[0]);
            }
        }
        this.udpNetworkLayer = new UDPNetworkLayer(this.udpChannel, this.workQueueMgr, localAddress, localPort);
        this.udpNetworkLayer.initDatagramSocket(this.getVirtualConnection());
        this.udpNetworkLayer.setConnLink(this);
    }

    @Override
    public void connectAsynch(Object _udpRequestContextObject) {
        try {
            this.connectCommon(_udpRequestContextObject);
            this.getApplicationCallback().ready(this.vc);
        }
        catch (IOException e) {
            this.getApplicationCallback().destroy(e);
        }
    }

    @Override
    public void connect(Object _udpRequestContextObject) throws Exception {
        this.connectCommon(_udpRequestContextObject);
    }

    @Override
    public Object getChannelAccessor() {
        return this;
    }

    @Override
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Ready should not be called", (Object[])new Object[0]);
        }
    }

    @Override
    public UDPReadRequestContext getReadInterface() {
        return this.reader;
    }

    @Override
    public InetAddress getLocalAddress() {
        InetAddress address = null;
        if (this.udpNetworkLayer != null) {
            address = this.udpNetworkLayer.getDatagramSocket().getLocalAddress();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && address == null) {
                Tr.debug((TraceComponent)tc, (String)"getLocalAddress == null", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLocalAddress; udpNetworkLayer == null", (Object[])new Object[0]);
        }
        return address;
    }

    @Override
    public int getLocalPort() {
        int port = 0;
        if (this.udpNetworkLayer != null) {
            port = this.udpNetworkLayer.getDatagramSocket().getLocalPort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && port == 0) {
                Tr.debug((TraceComponent)tc, (String)"getLocalPort == 0", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLocalPort; udpNetworkLayer == null", (Object[])new Object[0]);
        }
        return port;
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy(exc)", (Object[])new Object[0]);
        }
        if (null != this.udpNetworkLayer) {
            this.workQueueMgr.removeChannel(this.udpNetworkLayer.getDatagramChannel());
            this.udpNetworkLayer.destroy();
            this.udpNetworkLayer = null;
        }
        if (this.udpChannel != null) {
            this.udpChannel.removeConnLink(this);
        }
        super.destroy(e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy(exc)");
        }
    }

    @Override
    public UDPWriteRequestContext getWriteInterface() {
        return this.writer;
    }

    public void setUDPNetworkLayer(UDPNetworkLayer layer) {
        this.udpNetworkLayer = layer;
    }

    public UDPNetworkLayer getUDPNetworkLayer() {
        return this.udpNetworkLayer;
    }
}

