/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.java;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NetworkInterfaces
implements Introspector {
    static final long serialVersionUID = 1798272804337708852L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "NetworkInterfaces";
    }

    public String getIntrospectorDescription() {
        return "Network interface information from java.net.NetworkInterface";
    }

    /*
     * WARNING - void declaration
     */
    public void introspect(final PrintWriter writer) throws Exception {
        writer.println("Network Interface Information");
        writer.println("-----------------------------");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                static final long serialVersionUID = 2514999927092038584L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() throws IOException {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterfaces.this.getInterfaceInfo(interfaces.nextElement(), writer);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.java.NetworkInterfaces$1", 1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.diagnostics.java.NetworkInterfaces", (String)"67", (Object)this, (Object[])new Object[]{writer});
            throw (Exception)pae.getCause();
        }
    }

    private void getInterfaceInfo(NetworkInterface networkInterface, PrintWriter out) throws IOException {
        String indent = "    ";
        out.println();
        out.append("Interface: ").append(networkInterface.getDisplayName()).println();
        out.append("    ").append("          loopback: ").append(Boolean.toString(networkInterface.isLoopback())).println();
        out.append("    ").append("               mtu: ").append(Integer.toString(networkInterface.getMTU())).println();
        out.append("    ").append("    point-to-point: ").append(Boolean.toString(networkInterface.isPointToPoint())).println();
        out.append("    ").append("supports multicast: ").append(Boolean.toString(networkInterface.supportsMulticast())).println();
        out.append("    ").append("                up: ").append(Boolean.toString(networkInterface.isUp())).println();
        out.append("    ").append("           virtual: ").append(Boolean.toString(networkInterface.isVirtual())).println();
        List<InterfaceAddress> intfAddresses = networkInterface.getInterfaceAddresses();
        for (int i = 0; i < intfAddresses.size(); ++i) {
            out.append("    ").append("InterfaceAddress #").append(Integer.toString(i + 1)).append(": ").append(String.valueOf(intfAddresses.get(i))).println();
        }
        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
        int i = 1;
        while (inetAddresses.hasMoreElements()) {
            InetAddress inetAddress = inetAddresses.nextElement();
            out.append("    ").append("InetAddress #").append(Integer.toString(i)).println(":");
            out.append("    ").append("    ").append("    IP address: ").append(inetAddress.getHostAddress()).println();
            out.append("    ").append("    ").append("     host name: ").append(inetAddress.getHostName()).println();
            out.append("    ").append("    ").append("FQDN host name: ").append(inetAddress.getCanonicalHostName()).println();
            ++i;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.java.NetworkInterfaces", NetworkInterfaces.class, null, null);
    }
}

