/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogRepositorySpaceAlert {
    public static final long CHECK_INTERVAL = 120000L;
    private static final LogRepositorySpaceAlert logRepositorySpaceAlert = new LogRepositorySpaceAlert();
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = LogRepositorySpaceAlert.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    private static final HashMap<LogRepositoryManager, RepositoryInfo> repositoryInfo = new HashMap();
    private static final HashMap<File, FileSystemInfo> fsInfo = new HashMap();
    private final Timer fileSystemCheckTimer = AccessHelper.createTimer();
    private final TimerTask fileSystemCheckTask = new FileSystemCheckTask();

    public static LogRepositorySpaceAlert getInstance() {
        return logRepositorySpaceAlert;
    }

    private LogRepositorySpaceAlert() {
        this.fileSystemCheckTimer.schedule(this.fileSystemCheckTask, new Date(System.currentTimeMillis() + 120000L), 120000L);
    }

    public synchronized void setRepositoryInfo(LogRepositoryManager manager, File repositoryLocation, long repositorySpaceNeeded) throws IllegalArgumentException {
        if (manager == null) {
            throw new IllegalArgumentException("Null manager passed to LogRepositorySpaceAlert.setRepositoryInfo");
        }
        if (repositoryLocation == null) {
            throw new IllegalArgumentException("Null repositoryLocation passed to LogRepositorySpaceAlert.setRepositoryInfo");
        }
        RepositoryInfo curRI = repositoryInfo.get(manager);
        if (curRI == null) {
            File fsRoot = this.calculateFsRoot(repositoryLocation);
            FileSystemInfo fs = fsInfo.get(fsRoot);
            if (fs == null) {
                fs = new FileSystemInfo();
                fsInfo.put(fsRoot, fs);
            }
            curRI = new RepositoryInfo(fs);
            repositoryInfo.put(manager, curRI);
        }
        curRI.setRespositorySpaceNeeded(repositorySpaceNeeded);
    }

    public synchronized void removeRepositoryInfo(LogRepositoryManager manager) {
        RepositoryInfo curRI = repositoryInfo.remove(manager);
        if (curRI != null) {
            curRI.setRespositorySpaceNeeded(0L);
        }
    }

    public synchronized void stop() {
        this.fileSystemCheckTimer.cancel();
        repositoryInfo.clear();
        fsInfo.clear();
    }

    private synchronized void checkFileSystems() {
        for (Map.Entry<File, FileSystemInfo> fsEntry : fsInfo.entrySet()) {
            if (!fsEntry.getValue().processThisCycle()) continue;
            long fsFreeSpace = AccessHelper.getFreeSpace(fsEntry.getKey());
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, className, "checkFileSystems", "fileSystem: " + fsEntry.getKey().getPath() + " Need: " + fsEntry.getValue().fsSpaceNeeded + " Available Spc: " + fsFreeSpace);
            }
            if (!fsEntry.getValue().isWarning(fsFreeSpace)) continue;
            logger.logp(Level.WARNING, className, "checkFileSystems", "HPEL_FileSystem_Space_Warning", new Object[]{fsEntry.getKey().getPath(), fsEntry.getValue().fsSpaceNeeded, fsFreeSpace});
        }
    }

    private File calculateFsRoot(File repositoryLocation) {
        while (!AccessHelper.isDirectory(repositoryLocation)) {
            repositoryLocation = repositoryLocation.getParentFile();
        }
        if (repositoryLocation.getName().equals("logdata") || repositoryLocation.getName().equals("tracedata")) {
            File parentFile = repositoryLocation.getParentFile();
            if (AccessHelper.getTotalSpace(repositoryLocation) == AccessHelper.getTotalSpace(parentFile)) {
                long thisFsSpace = AccessHelper.getFreeSpace(repositoryLocation);
                long parentFsSpace = AccessHelper.getFreeSpace(parentFile);
                if (thisFsSpace > 0L && parentFsSpace > 0L && thisFsSpace > (long)((double)parentFsSpace * 0.95) && thisFsSpace < (long)((double)parentFsSpace * 1.05)) {
                    repositoryLocation = parentFile;
                }
            }
        }
        return repositoryLocation;
    }

    private class FileSystemCheckTask
    extends TimerTask {
        private FileSystemCheckTask() {
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, className, "FileSystemCheckTask.run", "Checking w/repository cnt {0} and filesystem cnt {1}", new Object[]{repositoryInfo.size(), fsInfo.size()});
            }
            LogRepositorySpaceAlert.this.checkFileSystems();
        }
    }

    private static class RepositoryInfo {
        final FileSystemInfo fs;
        long repositorySpaceNeeded = 0L;

        RepositoryInfo(FileSystemInfo fs) {
            this.fs = fs;
        }

        void setRespositorySpaceNeeded(long repositorySpaceNeeded) {
            this.fs.fsSpaceNeeded += repositorySpaceNeeded - this.repositorySpaceNeeded;
            this.repositorySpaceNeeded = repositorySpaceNeeded;
        }
    }

    private static class FileSystemInfo {
        long fsSpaceNeeded = 0L;
        private int numberOfNotifications = 0;
        private int cyclesSkipped = 0;

        private FileSystemInfo() {
        }

        boolean processThisCycle() {
            if (this.cyclesSkipped < this.numberOfNotifications) {
                ++this.cyclesSkipped;
                return false;
            }
            this.cyclesSkipped = 0;
            return true;
        }

        boolean isWarning(long freeSpace) {
            if (freeSpace < this.fsSpaceNeeded) {
                ++this.numberOfNotifications;
                return true;
            }
            this.numberOfNotifications = 0;
            return false;
        }
    }
}

