/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal;

import com.ibm.websphere.monitor.MonitorManager;
import com.ibm.websphere.monitor.Probe;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.MonitoringProxyActivator;
import com.ibm.ws.monitor.internal.MonitoringUtility;
import com.ibm.ws.monitor.internal.ProbeFilter;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.ReflectionHelper;
import com.ibm.ws.monitor.internal.bci.ClassAvailableTransformer;
import com.ibm.ws.monitor.internal.bci.ProbeClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.objectweb.asm.Type;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ProbeManagerImpl
implements MonitorManager {
    private static final TraceComponent tc = Tr.register(ProbeManagerImpl.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    private final AtomicLong probeIdCount = new AtomicLong();
    boolean includeBootstrap = Boolean.getBoolean("probes.include.bootstrap");
    ComponentContext componentContext = null;
    Instrumentation instrumentation = null;
    ClassAvailableTransformer classAvailableTransformer = null;
    public static Map<Object, String> moduleInstanceToBundleMap = new HashMap<Object, String>();
    ProbeClassFileTransformer transformer = null;
    MonitoringProxyActivator proxyActivator = null;
    final Set<Class<?>> notMonitorable = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    final Set<Class<?>> monitorable = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    final ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    Map<Object, Set<ProbeListener>> listenersForMonitor = new HashMap<Object, Set<ProbeListener>>();
    Set<ProbeListener> allRegisteredListeners = new HashSet<ProbeListener>();
    Map<Class<?>, Set<ProbeListener>> listenersByClass = new WeakHashMap();
    Map<Class<?>, Map<String, ProbeImpl>> probesByKey = new WeakHashMap();
    Map<ProbeListener, Set<ProbeImpl>> probesByListener = new HashMap<ProbeListener, Set<ProbeImpl>>();
    Map<Long, ProbeImpl> activeProbesById = new ConcurrentHashMap<Long, ProbeImpl>();
    ConcurrentMap<ProbeImpl, Set<ProbeListener>> listenersByProbe = new ConcurrentHashMap<ProbeImpl, Set<ProbeListener>>();
    boolean shuttingDown = false;
    long prevTime;
    private final Set<String> probeMonitorSet = Collections.newSetFromMap(new ConcurrentHashMap());
    static final long serialVersionUID = 4065305433076847754L;

    synchronized void activate(ComponentContext componentContext) throws Exception {
        this.componentContext = componentContext;
        this.classAvailableTransformer = new ClassAvailableTransformer(this, this.instrumentation, this.includeBootstrap);
        this.transformer = new ProbeClassFileTransformer(this, this.instrumentation, this.includeBootstrap);
        this.proxyActivator = new MonitoringProxyActivator(componentContext.getBundleContext(), this, this.instrumentation);
        this.proxyActivator.activate();
        for (Class<?> clazz : MonitoringUtility.loadMonitoringClasses(componentContext.getBundleContext().getBundle())) {
            for (int i = 0; i < clazz.getMethods().length; ++i) {
                ProbeSite anno = clazz.getMethods()[i].getAnnotation(ProbeSite.class);
                if (anno == null) continue;
                String temp = anno.clazz();
                this.probeMonitorSet.add(temp);
            }
        }
        this.instrumentation.addTransformer(this.transformer, true);
        this.instrumentation.addTransformer(this.classAvailableTransformer);
        for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
            this.classAvailable(clazz);
        }
    }

    synchronized void deactivate() throws Exception {
        this.proxyActivator.deactivate();
        this.instrumentation.removeTransformer(this.classAvailableTransformer);
        this.instrumentation.removeTransformer(this.transformer);
        this.shuttingDown = true;
        Collection<Class<?>> probedClasses = this.processRemovedListeners(this.allRegisteredListeners);
        this.listenersLock.writeLock().lock();
        try {
            this.listenersForMonitor.clear();
            this.allRegisteredListeners.clear();
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
        this.activeProbesById.clear();
        this.listenersByProbe.clear();
        this.listenersByClass.clear();
        this.probesByKey.clear();
        this.probesByListener.clear();
        this.proxyActivator = null;
        this.transformer = null;
        this.componentContext = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("deactivate: probedClasses.size() = " + probedClasses.size()), (Object[])new Object[0]);
        }
        for (Class<?> clazz : probedClasses) {
            this.instrumentation.retransformClasses(clazz);
        }
        this.instrumentation = null;
    }

    protected void setInstrumentation(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    protected void unsetInstrumentation(Instrumentation instrumentation) {
        if (instrumentation == this.instrumentation) {
            this.instrumentation = null;
        }
    }

    @Override
    public boolean registerMonitor(Object monitor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("monitor = " + monitor), (Object[])new Object[0]);
        }
        long startTime = System.nanoTime();
        Set<ProbeListener> listeners = this.buildListenersFromAnnotated(monitor);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("buildListenersFromAnnotated time = " + TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime) + "usec"), (Object[])new Object[0]);
        }
        startTime = System.nanoTime();
        if (!this.addListenersForMonitor(monitor, listeners)) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("addListenersForMonitorTime = " + TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime) + "usec"), (Object[])new Object[0]);
        }
        startTime = System.nanoTime();
        Collection<Class<?>> effectedClasses = this.processNewListeners(listeners);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("processNewListeners time = " + TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime) + "usec"), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("effectedClasses.size() = " + effectedClasses.size()), (Object[])new Object[0]);
        }
        startTime = System.nanoTime();
        this.transformer.instrumentWithProbes(effectedClasses);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("instrumentWithProbes time = " + TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime) + "usec"), (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public boolean registerMonitor(Object monitor, Map<String, Object> config) {
        return false;
    }

    @Override
    public boolean unregisterMonitor(Object annotatedObject) {
        Set<ProbeListener> listeners;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("unregisteringMonitor =  " + annotatedObject), (Object[])new Object[0]);
        }
        if ((listeners = this.removeListenersForMonitor(annotatedObject)) == null) {
            return false;
        }
        Collection<Class<?>> effectedClasses = this.processRemovedListeners(listeners);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("effectedClasses.size() =  " + effectedClasses.size()), (Object[])new Object[0]);
        }
        this.transformer.instrumentWithProbes(effectedClasses);
        Set<Map.Entry<Object, String>> set = moduleInstanceToBundleMap.entrySet();
        for (Map.Entry<Object, String> mapE : set) {
            if (mapE == null || !mapE.getValue().equals(annotatedObject.getClass().getName())) continue;
            PmiAbstractModule s = (PmiAbstractModule)mapE.getKey();
            s.unregister();
        }
        return true;
    }

    public Probe getProbe(long probeId) {
        return this.activeProbesById.get(probeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ProbeListener> buildListenersFromAnnotated(Object monitor) {
        HashSet<ProbeListener> listeners = new HashSet<ProbeListener>();
        Class<?> clazz = monitor.getClass();
        for (Method method : ReflectionHelper.getMethods(clazz)) {
            ProbeSite probeSite = method.getAnnotation(ProbeSite.class);
            if (probeSite == null) continue;
            Set<Class<?>> set = this.notMonitorable;
            synchronized (set) {
                Class<?> rClass = null;
                for (Class<?> tClass : this.notMonitorable) {
                    if (tClass == null || !tClass.getName().equals(probeSite.clazz())) continue;
                    rClass = tClass;
                    this.monitorable.add(tClass);
                    break;
                }
                if (rClass != null) {
                    this.notMonitorable.remove(rClass);
                }
            }
            Monitor monitorData = clazz.getAnnotation(Monitor.class);
            ListenerConfiguration config = new ListenerConfiguration(monitorData, probeSite, method);
            ProbeListener listener = new ProbeListener(null, config, monitor, method);
            listeners.add(listener);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addListenersForMonitor(Object monitor, Set<ProbeListener> listeners) {
        this.listenersLock.writeLock().lock();
        try {
            if (this.listenersForMonitor.containsKey(monitor)) {
                boolean bl = false;
                return bl;
            }
            this.listenersForMonitor.put(monitor, listeners);
            this.allRegisteredListeners.addAll(listeners);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
        return true;
    }

    Set<ProbeListener> removeListenersForMonitor(Object monitor) {
        Set<ProbeListener> listeners = null;
        this.listenersLock.writeLock().lock();
        try {
            listeners = this.listenersForMonitor.remove(monitor);
            if (listeners == null) {
                listeners = Collections.emptySet();
            } else {
                this.allRegisteredListeners.removeAll(listeners);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Class<?>> processNewListeners(Collection<ProbeListener> listeners) {
        HashSet monitorableTemp;
        HashSet classesToTransform = new HashSet();
        HashSet<ProbeListener> matchingListeners = new HashSet<ProbeListener>();
        Set<Class<?>> set = this.monitorable;
        synchronized (set) {
            monitorableTemp = new HashSet(this.monitorable);
        }
        for (Class clazz : monitorableTemp) {
            if (!this.isMonitorable(clazz)) continue;
            for (ProbeListener listener : listeners) {
                ProbeFilter filter = listener.getProbeFilter();
                if (!filter.matches(clazz)) continue;
                matchingListeners.add(listener);
            }
            if (!matchingListeners.isEmpty()) {
                classesToTransform.add(clazz);
                this.addInterestedByClass(clazz, matchingListeners);
            }
            matchingListeners.clear();
        }
        return classesToTransform;
    }

    synchronized Collection<Class<?>> processRemovedListeners(Collection<ProbeListener> listeners) {
        HashSet classesToTransform = new HashSet();
        for (ProbeListener listener : listeners) {
            Collection<ProbeImpl> listenerProbes = this.removeProbesByListener(listener);
            for (ProbeImpl probe : listenerProbes) {
                Class<?> clazz = probe.getSourceClass();
                this.removeInterestedByClass(clazz, listener);
                if (!this.removeListenerByProbe(probe, listener)) continue;
                classesToTransform.add(clazz);
            }
        }
        return classesToTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classAvailable(Class<?> clazz) {
        if (!this.isMonitorable(clazz)) {
            return;
        }
        this.listenersLock.readLock().lock();
        try {
            for (ProbeListener listener : this.allRegisteredListeners) {
                ProbeFilter filter = listener.getProbeFilter();
                if (!filter.matches(clazz)) continue;
                this.addInterestedByClass(clazz, Collections.singleton(listener));
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        if (!this.getInterestedByClass(clazz).isEmpty()) {
            this.transformer.instrumentWithProbes(Collections.singleton(clazz));
        }
    }

    synchronized void addInterestedByClass(Class<?> clazz, Collection<ProbeListener> newListeners) {
        Set<ProbeListener> currentListeners = this.listenersByClass.get(clazz);
        if (currentListeners == null) {
            currentListeners = new HashSet<ProbeListener>();
            this.listenersByClass.put(clazz, currentListeners);
        }
        currentListeners.addAll(newListeners);
    }

    synchronized void removeInterestedByClass(Class<?> clazz, ProbeListener listener) {
        Set<ProbeListener> listeners = this.listenersByClass.get(clazz);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listenersByClass.remove(clazz);
            }
        }
    }

    public synchronized Set<ProbeListener> getInterestedByClass(Class<?> clazz) {
        Set<ProbeListener> listeners = this.listenersByClass.get(clazz);
        if (listeners == null) {
            listeners = Collections.emptySet();
        }
        return new HashSet<ProbeListener>(listeners);
    }

    public synchronized ProbeImpl getProbe(Class<?> probedClass, String key) {
        Map<String, ProbeImpl> classProbes = this.probesByKey.get(probedClass);
        if (classProbes != null) {
            return classProbes.get(key);
        }
        return null;
    }

    public synchronized ProbeImpl createProbe(Class<?> probedClass, String key, Constructor<?> ctor, Method method) {
        ProbeImpl probeImpl = this.getProbe(probedClass, key);
        if (probeImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("createProbe: " + key), (Object[])new Object[0]);
            }
            probeImpl = new ProbeImpl(this, probedClass, key, ctor, method);
            this.activeProbesById.put(probeImpl.getIdentifier(), probeImpl);
            Map<String, ProbeImpl> classProbes = this.probesByKey.get(probedClass);
            if (classProbes == null) {
                classProbes = new HashMap<String, ProbeImpl>();
                this.probesByKey.put(probedClass, classProbes);
            }
            classProbes.put(key, probeImpl);
        }
        return probeImpl;
    }

    long generateProbeId() {
        return this.probeIdCount.incrementAndGet();
    }

    public void addActiveProbesforListener(ProbeListener listener, Collection<ProbeImpl> probes) {
        this.addProbesByListener(listener, probes);
        for (ProbeImpl probe : probes) {
            this.addListenerByProbe(probe, listener);
        }
    }

    void addListenerByProbe(ProbeImpl probe, ProbeListener listener) {
        Set<ProbeListener> listeners = (CopyOnWriteArraySet<ProbeListener>)this.listenersByProbe.get(probe);
        if (listeners == null) {
            listeners = new CopyOnWriteArraySet<ProbeListener>();
            this.listenersByProbe.putIfAbsent(probe, listeners);
            listeners = (Set)this.listenersByProbe.get(probe);
        }
        listeners.add(listener);
    }

    boolean removeListenerByProbe(ProbeImpl probe, ProbeListener listener) {
        boolean deactivatedProbe = false;
        Set listeners = (Set)this.listenersByProbe.get(probe);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.deactivateProbe(probe);
                deactivatedProbe = true;
            }
        }
        return deactivatedProbe;
    }

    synchronized void deactivateProbe(ProbeImpl probe) {
        this.listenersByProbe.remove(probe);
        this.activeProbesById.remove(probe.getIdentifier());
        Class<?> clazz = probe.getSourceClass();
        Map<String, ProbeImpl> classProbesByKey = this.probesByKey.get(clazz);
        classProbesByKey.remove(probe.getName());
        if (classProbesByKey.isEmpty()) {
            this.probesByKey.remove(clazz);
        }
    }

    synchronized void addProbesByListener(ProbeListener listener, Collection<ProbeImpl> probes) {
        Set<ProbeImpl> listenerProbes = this.probesByListener.get(listener);
        if (listenerProbes == null) {
            listenerProbes = new HashSet<ProbeImpl>();
            this.probesByListener.put(listener, listenerProbes);
        }
        listenerProbes.addAll(probes);
    }

    synchronized Collection<ProbeImpl> removeProbesByListener(ProbeListener listener) {
        Set<ProbeImpl> listenerProbes = this.probesByListener.remove(listener);
        if (listenerProbes == null) {
            listenerProbes = Collections.emptySet();
        }
        return listenerProbes;
    }

    public boolean isExcludedClass(String className) {
        if (className.startsWith("java/lang/reflect")) {
            return true;
        }
        if (className.startsWith("sun/misc")) {
            return true;
        }
        if (className.startsWith("sun/reflect")) {
            return true;
        }
        if (className.startsWith("com/ibm/oti/")) {
            return true;
        }
        if (className.startsWith("com/ibm/ws/monitor/internal")) {
            return true;
        }
        if (className.startsWith("com/ibm/websphere/monitor")) {
            return true;
        }
        if (className.startsWith("com/ibm/ws/boot/delegated/monitoring")) {
            return true;
        }
        if (className.startsWith("com/ibm/ws/pmi") || className.startsWith("com/ibm/websphere/pmi") || className.startsWith("com/ibm/wsspi/pmi")) {
            return true;
        }
        return !this.probeMonitorSet.contains(className.replace("/", "."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMonitorable(Class<?> clazz) {
        if (this.notMonitorable.contains(clazz)) {
            return false;
        }
        if (this.monitorable.contains(clazz)) {
            return true;
        }
        boolean isMonitorable = true;
        if (!this.instrumentation.isModifiableClass(clazz)) {
            isMonitorable = false;
        } else if (clazz.isInterface()) {
            isMonitorable = false;
        } else if (clazz.isArray()) {
            isMonitorable = false;
        } else if (Proxy.isProxyClass(clazz)) {
            isMonitorable = false;
        } else if (clazz.isPrimitive()) {
            isMonitorable = false;
        } else if (this.isExcludedClass(Type.getInternalName(clazz))) {
            isMonitorable = false;
        } else if (!this.includeBootstrap && clazz.getClassLoader() == null) {
            isMonitorable = false;
        }
        if (!isMonitorable) {
            Set<Class<?>> set = this.notMonitorable;
            synchronized (set) {
                this.notMonitorable.add(clazz);
            }
        } else {
            this.monitorable.add(clazz);
        }
        return isMonitorable;
    }

    public boolean isProbeCandidate(String classInternalName) {
        return !this.isExcludedClass(classInternalName);
    }

    void checkFireProbePermission(ProbeImpl probe) {
    }

    final void fireProbe(long probeId, @Sensitive Object instance, @Sensitive Object target, @Sensitive Object payload) {
        try {
            ProbeImpl probe = this.activeProbesById.get(probeId);
            ConcurrentMap<ProbeImpl, Set<ProbeListener>> listenersByProbe = this.listenersByProbe;
            if (this.shuttingDown || listenersByProbe == null || probe == null) {
                return;
            }
            Set listeners = (Set)listenersByProbe.get(probe);
            if (listeners == null) {
                return;
            }
            for (ProbeListener listener : listeners) {
                try {
                    Method method = listener.getTargetMethod();
                    Class<?>[] parameterTypes = listener.getParameterTypes();
                    Object[] args = listener.getdefaultvalues();
                    if (args != null) {
                        args = Arrays.copyOf(args, args.length);
                    }
                    boolean validated = listener.isValidated();
                    ArrayList<Integer> annList = listener.getAnnotationsList();
                    block16: for (int i = 0; i < parameterTypes.length; ++i) {
                        switch (annList.get(i)) {
                            case 0: {
                                if (!validated && !parameterTypes[i].isInstance(instance)) continue block16;
                                args[i] = instance;
                                continue block16;
                            }
                            case 1: {
                                if (!validated && !Object[].class.isInstance(payload)) continue block16;
                                args[i] = payload;
                                continue block16;
                            }
                            case 2: {
                                continue block16;
                            }
                            case 3: {
                                if (!validated && !parameterTypes[i].isInstance(payload)) continue block16;
                                args[i] = payload;
                                continue block16;
                            }
                            case 4: {
                                if (!parameterTypes[i].isInstance(payload)) continue block16;
                                args[i] = payload;
                                continue block16;
                            }
                            case 5: {
                                if (!parameterTypes[i].isInstance(target)) continue block16;
                                args[i] = target;
                                continue block16;
                            }
                            case 6: {
                                continue block16;
                            }
                            case 7: {
                                if (!Throwable.class.isInstance(payload) || !parameterTypes[i].isInstance(payload)) continue block16;
                                args[i] = payload;
                                continue block16;
                            }
                            case 8: {
                                continue block16;
                            }
                        }
                    }
                    listener.setValidated(true);
                    method.invoke(listener.getProbeTarget(), args);
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)t.getMessage(), (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"PMI9999E", (Object[])new Object[]{t.toString()});
        }
    }

    @Override
    public void updateNonExcludedClassesSet(String className) {
        if (this.probeMonitorSet != null) {
            this.probeMonitorSet.add(className);
        }
    }
}

