/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.heartbeat.HeartBeatSender;
import com.ibm.ws.collective.member.heartbeat.RepositoryMemberHeartBeat;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HeartBeatSender.class, ServerQuiesceListener.class}, property={"service.vendor=IBM"})
public class HeartBeatSenderImpl
implements HeartBeatSender,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(HeartBeatSenderImpl.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    private ScheduledExecutorService executor;
    private final Map<RepositoryMemberHeartBeat, ScheduledFuture<?>> futures = new HashMap();
    private int heartBeatInterval;
    private long lastHeartBeat = 0L;
    private EventAdmin eventAdmin;
    static final long serialVersionUID = -2919974097847788305L;

    @Reference(service=ScheduledExecutorService.class)
    protected void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    protected void unsetExecutor(ScheduledExecutorService executor) {
        if (this.executor == executor) {
            this.executor = null;
        }
    }

    @Reference(service=EventAdmin.class)
    protected void setEventAdminService(EventAdmin ea) {
        this.eventAdmin = ea;
    }

    protected void unsetEventAdminService(EventAdmin ea) {
        if (this.eventAdmin == ea) {
            this.eventAdmin = null;
        }
    }

    @Activate
    protected void activate() {
    }

    @Deactivate
    protected void deactivate() {
        this.cancelAllHeartBeats();
    }

    private void cancelAllHeartBeats() {
        for (RepositoryMemberHeartBeat repoMember : this.futures.keySet()) {
            this.cancelHeartBeat(repoMember);
        }
    }

    public boolean cancelHeartBeat(RepositoryMemberHeartBeat repositoryMember) {
        boolean retMe = false;
        ScheduledFuture<?> future = this.futures.remove(repositoryMember);
        if (future != null) {
            retMe = future.cancel(true);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Canceled heartbeat", (Object[])new Object[0]);
            }
        }
        return retMe;
    }

    public void startHeartBeat(RepositoryMemberHeartBeat repositoryMember, int heartBeatInterval) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Starting heartbeat for member on internal " + heartBeatInterval), (Object[])new Object[0]);
        }
        this.cancelHeartBeat(repositoryMember);
        HeartbeatSender task = new HeartbeatSender(repositoryMember);
        this.setHeartBeatInterval(heartBeatInterval);
        this.setLastHeartBeat();
        ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(task, heartBeatInterval, heartBeatInterval, TimeUnit.SECONDS);
        this.futures.put(repositoryMember, future);
    }

    void setHeartBeatInterval(int interval) {
        this.heartBeatInterval = interval;
    }

    void setLastHeartBeat() {
        this.lastHeartBeat = System.currentTimeMillis() / 1000L;
    }

    void setLastHeartBeat(long seconds) {
        this.lastHeartBeat = seconds;
    }

    private void markHeartBeat() {
        long currentSeconds = System.currentTimeMillis() / 1000L;
        if (!this.withinTolerance(currentSeconds)) {
            this.sendEvent();
        }
        this.setLastHeartBeat(currentSeconds);
    }

    private boolean withinTolerance(long currentSeconds) {
        boolean result = true;
        long limit = this.lastHeartBeat + (long)(this.heartBeatInterval * 3);
        if (currentSeconds >= limit) {
            result = false;
        }
        if (tc.isDebugEnabled()) {
            long deltaT = currentSeconds - (this.lastHeartBeat + (long)this.heartBeatInterval);
            Tr.debug((TraceComponent)tc, (String)("Heart beat difference from scheduled time: " + String.valueOf(deltaT)), (Object[])new Object[0]);
        }
        return result;
    }

    private void sendEvent() {
        HashMap eventProps = new HashMap();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Sending a republish event", (Object[])new Object[0]);
        }
        this.eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/republish", eventProps));
    }

    public void serverStopping() {
        this.cancelAllHeartBeats();
    }

    class HeartbeatSender
    implements Runnable {
        private final TraceComponent tc = Tr.register(HeartbeatSender.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        private final RepositoryMemberHeartBeat repositoryMember;
        private boolean needsToReregister = false;

        HeartbeatSender(RepositoryMemberHeartBeat repositoryMember) {
            this.repositoryMember = repositoryMember;
        }

        @FFDCIgnore(value={IOException.class, IllegalArgumentException.class, IllegalStateException.class})
        private boolean sendHeartBeat() {
            block11: {
                try {
                    this.repositoryMember.sendHeartBeat();
                    HeartBeatSenderImpl.this.markHeartBeat();
                }
                catch (IOException e) {
                    if (this.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)this.tc, (String)"IOException while sending heart beat, this can happen if we have lost our connection to the controller", (Object[])new Object[]{e});
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)this.tc, (String)"IllegalArgumentException while sending heart beat, this can happen if our heart beats got interupted and we were marked dead. Time to re-register!", (Object[])new Object[]{e});
                    }
                    if (e.getMessage().contains("CWWKX9002E")) {
                        return true;
                    }
                }
                catch (IllegalStateException e) {
                    if (FrameworkState.isStopping()) {
                        if (this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)this.tc, (String)"Ignoring IllegalStateException because server is stopping.", (Object[])new Object[0]);
                        }
                    } else {
                        FFDCFilter.processException((Throwable)e, (String)"HeartBeatSenderImpl.sendHeartBeat", (String)"225", (Object)this);
                    }
                }
                catch (Exception e) {
                    if (!this.tc.isEventEnabled()) break block11;
                    Tr.event((TraceComponent)this.tc, (String)"Unexpected Exception while sending heart beat", (Object[])new Object[]{e});
                }
            }
            return false;
        }

        @FFDCIgnore(value={IOException.class})
        private boolean reregisterWithRepository() {
            block5: {
                if (this.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)this.tc, (String)"Re-registering as a member", (Object[])new Object[0]);
                }
                try {
                    this.repositoryMember.deregisterMember();
                    this.repositoryMember.registerMember();
                    return false;
                }
                catch (IOException e) {
                    if (this.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)this.tc, (String)"IOException while attempting to re-register, this can happen if we have lost our connection to the controller", (Object[])new Object[]{e});
                    }
                }
                catch (Exception e) {
                    if (!this.tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)this.tc, (String)"Unexpected Exception while sending heart beat", (Object[])new Object[]{e});
                }
            }
            return true;
        }

        @Override
        public void run() {
            if (this.tc.isEventEnabled()) {
                Tr.event((TraceComponent)this.tc, (String)"Sending heart beat", (Object[])new Object[0]);
            }
            if (!this.needsToReregister) {
                this.needsToReregister = this.sendHeartBeat();
            }
            if (this.needsToReregister) {
                this.needsToReregister = this.reregisterWithRepository();
            }
        }
    }
}

