/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.HelpActions;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.ReturnCode;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class HelpCommand {
    private final HelpActions actionHelper;
    private final ResourceBundle options;

    public HelpCommand(HelpActions actions) {
        this.actionHelper = actions;
        this.options = this.actionHelper.getResourceBundle();
    }

    public ReturnCode showHelp(LaunchArguments launchArgs) {
        String script = launchArgs.getScript();
        Object action = this.actionHelper.toAction(launchArgs.getAction());
        Object actionHelp = this.actionHelper.toAction(launchArgs.getProcessName());
        if (this.actionHelper.isHelpAction(action)) {
            Object insert = actionHelp == null ? this.actionHelper.allActions() : actionHelp;
            System.out.println();
            if (script == null) {
                System.out.println(MessageFormat.format(this.options.getString("briefUsage"), insert));
            } else {
                System.out.println(MessageFormat.format(this.options.getString("scriptUsage"), script, insert));
            }
        }
        if (this.actionHelper.isHelpAction(action)) {
            if (actionHelp == null) {
                this.showHelp();
            } else {
                this.showHelp(actionHelp);
            }
        }
        if (script == null) {
            System.out.println();
            System.out.println(this.options.getString("use.jvmarg"));
            System.out.println();
            System.out.println(this.options.getString("javaAgent.key"));
            System.out.println(this.options.getString("javaAgent.desc"));
            System.out.println();
        }
        return ReturnCode.OK;
    }

    private void showHelp() {
        System.out.println();
        System.out.println(this.options.getString("processName.key"));
        System.out.println(this.options.getString("processName.desc"));
        System.out.println();
        System.out.println(this.options.getString("use.actions"));
        System.out.println();
        for (Object c : this.actionHelper.getCategories()) {
            System.out.println(this.options.getString("category-key." + c));
            System.out.println();
            for (Object cmd : this.actionHelper.geActionsForCategories(c)) {
                System.out.print("    ");
                System.out.println(cmd);
                System.out.println(this.options.getString("action-desc." + cmd));
            }
            System.out.println();
        }
        System.out.println(this.options.getString("use.options"));
        System.out.println(this.options.getString("use.options.gen.desc"));
    }

    private void showHelp(Object command) {
        System.out.println();
        System.out.println(this.options.getString("action-desc." + command));
        System.out.println();
        System.out.println(this.options.getString("use.options"));
        System.out.println();
        for (String option : this.actionHelper.options(command)) {
            String nlsText = this.options.containsKey("option-desc." + command + '.' + option) ? this.options.getString("option-desc." + command + '.' + option) : (this.options.containsKey("option-desc." + option) ? this.options.getString("option-desc." + option) : null);
            if (nlsText == null) continue;
            System.out.println(this.options.getString("option-key." + option));
            System.out.println(nlsText);
        }
    }
}

