/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.util.Map;
import java.util.Properties;

public class TrustManagerData {
    private static final TraceComponent tc = Tr.register(TrustManagerData.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private String tmName;
    private String tmProvider;
    private String tmAlgorithm;
    private String tmCustomClass;
    private Properties tmCustomProps;

    public TrustManagerData(String _name, Map<String, String> properties) {
        this.tmName = _name;
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            String key = prop.getKey();
            String value = prop.getValue();
            if (key.equalsIgnoreCase("algorithm")) {
                this.tmAlgorithm = value;
                continue;
            }
            if (key.equalsIgnoreCase("provider")) {
                this.tmProvider = value;
                continue;
            }
            if (key.equalsIgnoreCase("trustManagerClass")) {
                this.tmCustomClass = value;
                continue;
            }
            if (null == this.tmCustomProps) {
                this.tmCustomProps = new Properties();
            }
            this.tmCustomProps.setProperty(key, value);
        }
    }

    public TrustManagerData(String name, String provider, String algorithm, String customClass, Properties customAttributes) {
        this.tmName = name;
        this.tmProvider = provider;
        this.tmAlgorithm = algorithm;
        this.tmCustomClass = customClass;
        this.tmCustomProps = customAttributes;
    }

    public String getName() {
        return this.tmName;
    }

    public void setName(String s) {
        this.tmName = s;
    }

    public String getProvider() {
        return this.tmProvider;
    }

    public void setProvider(String s) {
        this.tmProvider = s;
    }

    public String getAlgorithm() {
        return this.tmAlgorithm;
    }

    public void setAlgorithm(String s) {
        this.tmAlgorithm = s;
    }

    public String getTrustManagerClass() {
        return this.tmCustomClass;
    }

    public void setTrustManagerClass(String s) {
        this.tmCustomClass = s;
    }

    public Properties getAdditionalTrustManagerAttrs() {
        return this.tmCustomProps;
    }

    public void setAdditionalTrustManagerAttrs(Map<String, String> attributes) {
        if (null == this.tmCustomProps) {
            this.tmCustomProps = new Properties();
        }
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            this.tmCustomProps.setProperty(attr.getKey(), attr.getValue());
        }
    }

    public String getTrustManagerString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTrustManagerString", (Object[])new Object[0]);
        }
        String rc = null;
        rc = this.tmCustomClass != null ? this.tmCustomClass : (this.tmAlgorithm != null && this.tmProvider != null ? this.tmAlgorithm + "|" + this.tmProvider : (this.tmAlgorithm != null ? this.tmAlgorithm : JSSEProviderFactory.getTrustManagerFactoryAlgorithm()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTrustManagerString -> " + rc));
        }
        return rc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("TrustManagerData: name=").append(this.tmName);
        sb.append(", algorithm=").append(this.tmAlgorithm);
        sb.append(", provider=").append(this.tmProvider);
        sb.append(", customClass=").append(this.tmCustomClass);
        return sb.toString();
    }
}

