/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.RepositoryConfig;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.platform.InstallPlatformUtils;
import com.ibm.ws.install.repository.internal.RepositoryUtils;
import com.ibm.ws.install.utility.cmdline.ReturnCode;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.repository.common.enums.ReadMode;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.ZipRepositoryConnection;
import com.ibm.ws.repository.connections.liberty.MainRepository;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryHttpException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.platform.Platform;

public class CmdUtils {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private static Locale locale;
    private static ResourceBundle installUtilityMessages;
    private static ResourceBundle installUtilitySampleConfigurations;
    private static List<RepositoryConnection> invalidRepoList;
    private static List<RepositoryConnection> repoAuthenticationList;
    private static int defaultRepoStatus;

    public static synchronized String getMessage(String key, Object ... args) {
        if (installUtilityMessages == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            installUtilityMessages = ResourceBundle.getBundle("com.ibm.ws.install.utility.internal.resources.InstallUtilityMessages", locale);
        }
        String message = installUtilityMessages.getString(key);
        if (args.length == 0) {
            return message;
        }
        MessageFormat messageFormat = new MessageFormat(message, locale);
        return messageFormat.format(args);
    }

    public static synchronized String getSampleConfig() {
        if (installUtilitySampleConfigurations == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            installUtilitySampleConfigurations = ResourceBundle.getBundle("com.ibm.ws.install.utility.internal.resources.InstallUtilitySampleConfiguration", locale);
        }
        String message = installUtilitySampleConfigurations.getString("SAMPLE_CONFIG");
        File path = new File(InstallUtils.isWindows ? "C:\\IBM\\LibertyRepository" : "/usr/LibertyRepository");
        String url = null;
        try {
            url = path.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            url = InstallUtils.isWindows ? "file:/C:/IBM/LibertyRepository" : "file:///usr/LibertyRepository";
        }
        String featureRepo = null;
        try {
            ProductInfo product = (ProductInfo)ProductInfo.getAllProductInfo().get("com.ibm.websphere.appserver");
            featureRepo = product == null ? "wlp-featureRepo.zip" : "wlp-featureRepo-" + product.getVersion() + ".zip";
        }
        catch (Exception e) {
            featureRepo = "wlp-featureRepo.zip";
        }
        File zipRepoPath = new File(InstallUtils.isWindows ? "C:\\IBM" : "/usr", featureRepo);
        MessageFormat messageFormat = new MessageFormat(message, locale);
        return messageFormat.format(new Object[]{path.getAbsolutePath() + "1", zipRepoPath, url + "3"});
    }

    public static String padRight(String input) {
        return CmdUtils.padRight(input, 35);
    }

    public static String padRight(String input, int length) {
        return String.format("%1$-" + length + "s", input);
    }

    public static boolean isFileProtocol(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return url.getProtocol().equalsIgnoreCase("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isValidURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            String protocol = url.getProtocol();
            return protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static RepositoryConnectionList getDirectoryRepoLoginInfo(String fromDir) throws InstallException {
        try {
            File repoDir = new File(fromDir);
            ArrayList<Object> loginEntries = new ArrayList<Object>();
            if (repoDir.exists()) {
                if (repoDir.isDirectory()) {
                    if (!CmdUtils.isValidDirectoryRepo(repoDir)) {
                        throw new InstallException(CmdUtils.getMessage("ERROR_REPO_IS_INVALID", fromDir));
                    }
                    DirectoryRepositoryConnection lie = new DirectoryRepositoryConnection(repoDir, ReadMode.ASSUME_UNCHANGED);
                    loginEntries.add(lie);
                    RepositoryConnectionList loginInfo = new RepositoryConnectionList(loginEntries);
                    return loginInfo;
                }
                if (!CmdUtils.isValidZipBasedRepo(repoDir)) {
                    throw new InstallException(CmdUtils.getMessage("ERROR_REPO_IS_INVALID", fromDir));
                }
                ZipRepositoryConnection lie = new ZipRepositoryConnection(repoDir);
                loginEntries.add(lie);
                RepositoryConnectionList loginInfo = new RepositoryConnectionList(loginEntries);
                return loginInfo;
            }
            throw new InstallException(RepositoryUtils.getMessage((String)"ERROR_FILEPATH_NOT_EXISTS", (Object[])new Object[]{fromDir}));
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException(RepositoryUtils.getMessage((String)"ERROR_FILEPATH_NOT_EXISTS", (Object[])new Object[]{fromDir}));
        }
    }

    public static boolean isValidDirectoryRepo(File dir) {
        File repoFile;
        return dir != null & dir.exists() && (repoFile = new File(dir, "repository.config")).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidZipBasedRepo(File zip) {
        boolean bl;
        if (zip == null) return false;
        if (!zip.exists()) return false;
        if (!zip.isFile()) return false;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equalsIgnoreCase("repository.config")) continue;
                bl = true;
            }
        }
        catch (ZipException e) {
            boolean bl2 = false;
            {
                catch (Throwable throwable) {
                    InstallUtils.close(zipFile);
                    throw throwable;
                }
            }
            InstallUtils.close((ZipFile)zipFile);
            return bl2;
            catch (IOException e2) {
                boolean bl3 = false;
                InstallUtils.close((ZipFile)zipFile);
                return bl3;
            }
        }
        InstallUtils.close((ZipFile)zipFile);
        return false;
        InstallUtils.close((ZipFile)zipFile);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int testConnectionToDefaultRepo(RestRepositoryConnectionProxy proxy) {
        try {
            RestRepositoryConnection lie = MainRepository.createConnection((RestRepositoryConnectionProxy)proxy);
            return CmdUtils.checkUserCredentials(lie);
        }
        catch (RepositoryBackendIOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            if (sw.toString().contains("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
                logger.log(Level.FINEST, CmdUtils.getStackTrace((Exception)((Object)e)), e);
                return -3;
            }
            if (e instanceof RepositoryHttpException) {
                if (((RepositoryHttpException)e).get_httpRespCode() == 407) {
                    return ((RepositoryHttpException)e).get_httpRespCode();
                }
                Class<CheckRepositoryStatusRunnable> clazz = CheckRepositoryStatusRunnable.class;
                synchronized (CheckRepositoryStatusRunnable.class) {
                    logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0])).trim());
                    logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("FIELD_REPO_REASON", CmdUtils.getMessage("LOG_REPO_CONNECTION_EXCEPTION", "default", ((Object)((Object)e)).getClass().getSimpleName() + ": " + CmdUtils.getMessage("LOG_HTTP_SERVER_RESPONSE_CODE", ((RepositoryHttpException)e).get_httpRespCode(), CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0])))), "    "));
                    logger.log(Level.FINEST, CmdUtils.getStackTrace((Exception)((Object)e)), e);
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return ((RepositoryHttpException)e).get_httpRespCode();
                }
            }
            Class<CheckRepositoryStatusRunnable> clazz = CheckRepositoryStatusRunnable.class;
            synchronized (CheckRepositoryStatusRunnable.class) {
                logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0])).trim());
                logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("FIELD_REPO_REASON", CmdUtils.getMessage("LOG_REPO_CONNECTION_EXCEPTION", "default", ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage())), "    "));
                logger.log(Level.FINEST, CmdUtils.getStackTrace((Exception)((Object)e)), e);
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return 500;
            }
        }
    }

    public static ReturnCode checkRepositoryStatus(InstallKernelInteractive installKernel, Properties repoProperties, String actionName, String fromDir) throws InstallException {
        if (fromDir != null) {
            RepositoryConnectionList dirLoginInfo = CmdUtils.getDirectoryRepoLoginInfo(fromDir);
            installKernel.setLoginInfo(dirLoginInfo);
            logger.log(Level.INFO, CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]) + InstallUtils.NEWLINE);
            return ReturnCode.OK;
        }
        List validationResults = RepositoryConfigUtils.validateRepositoryPropertiesFile((Properties)repoProperties);
        if (validationResults.size() == 0) {
            logger.log(Level.FINE, CmdUtils.getMessage("MSG_VALIDATION_SUCCESSFUL", new Object[0]));
        } else {
            logger.log(Level.FINE, CmdUtils.getMessage("LOG_VALIDATION_FAILED", new Object[0]) + InstallUtils.NEWLINE);
        }
        RestRepositoryConnectionProxy proxy = RepositoryConfigUtils.getProxyInfo((Properties)repoProperties);
        if (repoProperties != null && RepositoryConfigUtils.getProxyUser((Properties)repoProperties) != null && RepositoryConfigUtils.getProxyPwd((Properties)repoProperties) != null) {
            RepositoryConfigUtils.setProxyAuthenticator((String)proxy.getProxyURL().getHost(), (String)String.valueOf(proxy.getProxyURL().getPort()), (String)RepositoryConfigUtils.getProxyUser((Properties)repoProperties), (String)RepositoryConfigUtils.getProxyPwd((Properties)repoProperties));
        }
        RepositoryConnectionList loginInfo = CmdUtils.getLoginInfo(installKernel, repoProperties, proxy);
        boolean isWlpRepoEnabled = RepositoryConfigUtils.isWlpRepoEnabled((Properties)repoProperties);
        int numOfRepos = isWlpRepoEnabled ? (loginInfo != null ? loginInfo.size() + 1 : 1) : loginInfo.size();
        invalidRepoList = Collections.synchronizedList(new ArrayList(numOfRepos));
        repoAuthenticationList = Collections.synchronizedList(new ArrayList(numOfRepos));
        logger.log(Level.INFO, CmdUtils.getMessage("MSG_CONNECTING", new Object[0]));
        if (loginInfo != null) {
            ExecutorService executor = Executors.newFixedThreadPool(numOfRepos);
            for (Object rc : loginInfo) {
                if (rc instanceof DirectoryRepositoryConnection || rc instanceof ZipRepositoryConnection) {
                    logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc) + " (" + rc.getRepositoryLocation() + ")"));
                    continue;
                }
                if (!CmdUtils.isValidURL(((RestRepositoryConnection)rc).getRepositoryUrl())) {
                    logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc) + " (" + ((RestRepositoryConnection)rc).getRepositoryUrl() + ")").trim());
                    logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("FIELD_REPO_REASON", CmdUtils.getMessage("ERROR_REPO_UNSUPPORT_PROTOCOL", ((RestRepositoryConnection)rc).getRepositoryUrl())).replace("CWWKF1416E: ", ""), "    "));
                    invalidRepoList.add((RepositoryConnection)rc);
                    continue;
                }
                CheckRepositoryStatusRunnable worker = new CheckRepositoryStatusRunnable((RepositoryConnection)rc, repoProperties, proxy, false);
                executor.execute(worker);
            }
            if (isWlpRepoEnabled) {
                CheckRepositoryStatusRunnable worker = new CheckRepositoryStatusRunnable(null, repoProperties, proxy, true);
                executor.execute(worker);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
        } else if (isWlpRepoEnabled) {
            defaultRepoStatus = CmdUtils.testConnectionToDefaultRepo(proxy);
            ReturnCode rc = CmdUtils.checkDefaultRepoStatus(proxy, repoProperties, defaultRepoStatus, actionName);
            if (rc == ReturnCode.OK) {
                RestRepositoryConnection lie = null;
                try {
                    lie = MainRepository.createConnection((RestRepositoryConnectionProxy)proxy);
                }
                catch (RepositoryBackendIOException e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    if (sw.toString().contains("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT_JDK_WRONG", new Object[0]), (Throwable)e, 33);
                    }
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT", new Object[0]), (Throwable)e, 33);
                }
                if (lie != null) {
                    lie.setUserAgent("installUtility");
                    loginInfo = new RepositoryConnectionList((RepositoryConnection)lie);
                    logger.log(Level.INFO, CmdUtils.getMessage("MSG_CONNECT_ALL_REPO_SUCCESS", new Object[0]));
                    installKernel.setLoginInfo(loginInfo);
                }
            }
            return rc;
        }
        int connectionStatus = 200;
        if (repoAuthenticationList != null && !repoAuthenticationList.isEmpty()) {
            for (Object rc : loginInfo) {
                if (!repoAuthenticationList.contains(rc)) continue;
                connectionStatus = CmdUtils.credentialsPrompt((RestRepositoryConnection)rc, repoProperties, actionName);
                if (connectionStatus == -1) {
                    return ReturnCode.USER_ABORT;
                }
                if (connectionStatus == 407) {
                    invalidRepoList.addAll(repoAuthenticationList);
                    break;
                }
                if (connectionStatus == 200) continue;
                invalidRepoList.add((RepositoryConnection)rc);
            }
        }
        boolean isDefaultRepoConnected = false;
        if (isWlpRepoEnabled && connectionStatus != 407) {
            try {
                Object rc;
                rc = CmdUtils.checkDefaultRepoStatus(proxy, repoProperties, defaultRepoStatus, actionName);
                if (rc != ReturnCode.OK) {
                    return rc;
                }
                isDefaultRepoConnected = true;
                RestRepositoryConnection lie = null;
                try {
                    lie = MainRepository.createConnection((RestRepositoryConnectionProxy)proxy);
                }
                catch (RepositoryBackendIOException e) {
                    isDefaultRepoConnected = false;
                }
                if (lie != null) {
                    lie.setUserAgent("installUtility");
                    loginInfo.add((RepositoryConnection)lie);
                }
            }
            catch (InstallException ie) {
                isDefaultRepoConnected = false;
            }
        }
        if (invalidRepoList != null && !invalidRepoList.isEmpty() || isWlpRepoEnabled && !isDefaultRepoConnected) {
            if (connectionStatus == 407 && invalidRepoList.size() == loginInfo.size() && invalidRepoList.containsAll((Collection<?>)loginInfo)) {
                throw new InstallException(CmdUtils.getMessage("ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 33);
            }
            if (invalidRepoList.containsAll((Collection<?>)loginInfo) && invalidRepoList.size() == loginInfo.size()) {
                throw new InstallException(CmdUtils.getMessage("ERROR_ALL_CONFIG_REPOS_FAIL", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 33);
            }
            StringBuffer sb = new StringBuffer();
            String delimitChar = "";
            for (RepositoryConnection rc : loginInfo) {
                if (!invalidRepoList.contains(rc)) continue;
                sb.append(delimitChar).append(RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc));
                delimitChar = ", ";
            }
            if (isWlpRepoEnabled && !isDefaultRepoConnected) {
                sb.append(delimitChar).append(CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0]));
            }
            logger.log(Level.WARNING, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_WARNING_SKIPPED_REPOS", sb.toString())));
            logger.log(Level.WARNING, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_VERIFY_REPO_CONNECTION", actionName)));
            loginInfo.removeAll(invalidRepoList);
            installKernel.setLoginInfo(loginInfo);
            return ReturnCode.BAD_CONNECTION_FOUND;
        }
        logger.log(Level.INFO, CmdUtils.getMessage("MSG_CONNECT_ALL_REPO_SUCCESS", new Object[0]));
        installKernel.setLoginInfo(loginInfo);
        return ReturnCode.OK;
    }

    private static ReturnCode checkDefaultRepoStatus(RestRepositoryConnectionProxy proxy, Properties repoProperties, int status, String actionName) throws InstallException {
        if (status == 407) {
            status = CmdUtils.promptProxyDefaultRepo(proxy, repoProperties, actionName);
            if (status == -1) {
                return ReturnCode.USER_ABORT;
            }
            if (status == 407) {
                throw new InstallException(CmdUtils.getMessage("ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 33);
            }
        }
        if (status == -2) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT_CAUSED_BY_CERT", new Object[0]), 33);
        }
        if (status == -3) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT_JDK_WRONG", new Object[0]), 33);
        }
        if (status != 200) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT", new Object[0]), 33);
        }
        logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0])));
        return ReturnCode.OK;
    }

    private static RepositoryConnectionList getLoginInfo(InstallKernelInteractive installKernel, Properties repoProperties, RestRepositoryConnectionProxy proxy) throws InstallException {
        RepositoryConnectionList loginInfo = null;
        List repositoryConfigs = RepositoryConfigUtils.getRepositoryConfigs((Properties)repoProperties);
        ArrayList<RestRepositoryConnection> loginEntries = new ArrayList<RestRepositoryConnection>(repositoryConfigs.size());
        ArrayList<String> notEncodedRepos = new ArrayList<String>();
        for (RepositoryConfig rc : repositoryConfigs) {
            RestRepositoryConnection lie = null;
            String url = rc.getUrl();
            if (url != null && url.toLowerCase().startsWith("file:")) {
                try {
                    URL urlProcessed = new URL(url);
                    File repoDir = new File(urlProcessed.getPath());
                    if (repoDir.exists()) {
                        if (repoDir.isDirectory()) {
                            if (!CmdUtils.isValidDirectoryRepo(repoDir)) {
                                throw new InstallException(CmdUtils.getMessage("ERROR_REPO_IS_INVALID", url));
                            }
                            lie = new DirectoryRepositoryConnection(repoDir, ReadMode.ASSUME_UNCHANGED);
                            loginEntries.add(lie);
                            continue;
                        }
                        if (!CmdUtils.isValidZipBasedRepo(repoDir)) {
                            throw new InstallException(CmdUtils.getMessage("ERROR_REPO_IS_INVALID", url));
                        }
                        lie = new ZipRepositoryConnection(repoDir);
                        loginEntries.add(lie);
                        continue;
                    }
                    throw new InstallException(RepositoryUtils.getMessage((String)"ERROR_FILEPATH_NOT_EXISTS", (Object[])new Object[]{url}));
                }
                catch (InstallException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InstallException(RepositoryUtils.getMessage((String)"ERROR_FILEPATH_NOT_EXISTS", (Object[])new Object[]{url}));
                }
            }
            if (!rc.isLibertyRepository()) {
                String decodedPwd = rc.getUserPwd();
                if (decodedPwd != null && !decodedPwd.isEmpty()) {
                    try {
                        decodedPwd = PasswordUtil.decode((String)rc.getUserPwd());
                    }
                    catch (InvalidPasswordDecodingException ipde) {
                        decodedPwd = rc.getUserPwd();
                        notEncodedRepos.add(rc.getId());
                    }
                    catch (UnsupportedCryptoAlgorithmException ucae) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_CRYPTO_UNSUPPORTED", new Object[0]), (Throwable)ucae, 33);
                    }
                }
                lie = new RestRepositoryConnection(rc.getUser(), decodedPwd, rc.getApiKey(), rc.getUrl().toString());
                lie.setProxy(proxy);
            }
            if (lie == null) continue;
            ((RestRepositoryConnection)lie).setUserAgent("installUtility");
            loginEntries.add(lie);
        }
        if (!notEncodedRepos.isEmpty()) {
            String notEncodedReposString = InstallUtils.getFeatureListOutput(notEncodedRepos);
            logger.log(Level.FINE, CmdUtils.getMessage("LOG_PASSWORD_NOT_ENCODED", notEncodedReposString) + InstallUtils.NEWLINE);
        }
        installKernel.setProxy(proxy);
        if (loginEntries != null && !loginEntries.isEmpty()) {
            loginInfo = new RepositoryConnectionList(loginEntries);
        }
        return loginInfo;
    }

    public static int promptProxyDefaultRepo(RestRepositoryConnectionProxy proxy, Properties repoProperties, String actionName) throws InstallException {
        int responseCode;
        int proxyRetries = 3;
        String inputUser = null;
        String inputPwd = null;
        String proxyUser = RepositoryConfigUtils.getProxyUser((Properties)repoProperties);
        String proxyPwd = RepositoryConfigUtils.getProxyPwd((Properties)repoProperties);
        while ((responseCode = CmdUtils.testConnectionToDefaultRepo(proxy)) != 200) {
            if (responseCode == 407) {
                if (proxyRetries == 0) {
                    logger.log(Level.INFO, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_PROXY_AUTHENTICATION_FAIL", proxy.getProxyURL().toString())));
                    logger.log(Level.INFO, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_REACHED_MAX_PROXY_RETRIES", actionName, RepositoryConfigUtils.getRepoPropertiesFileLocation())));
                    boolean actionContinue = SelfExtract.getResponse((String)CmdUtils.getMessage("TOOL_PROMPT_CONTINUE_OR_QUIT", actionName), (String)"", (String)"Xx");
                    logger.log(Level.INFO, "");
                    return !actionContinue ? -1 : responseCode;
                }
                if (proxyUser != null && !proxyUser.isEmpty() && proxyPwd != null && !proxyPwd.isEmpty()) {
                    RepositoryConfigUtils.setProxyAuthenticator((String)proxy.getProxyURL().getHost(), (String)String.valueOf(proxy.getProxyURL().getPort()), (String)proxyUser, (String)proxyPwd);
                    return responseCode;
                }
                logger.log(Level.INFO, proxyRetries == 3 ? CmdUtils.getMessage("MSG_AUTHENTICATION_PROMPT", new Object[0]) : CmdUtils.getMessage("MSG_AUTHENTICATION_RETRY", proxyRetries));
                logger.log(Level.INFO, CmdUtils.getMessage("FIELD_PROXY", proxy.getProxyURL().toString()));
                if (proxyUser != null && !proxyUser.isEmpty() && proxyRetries == 3) {
                    inputUser = proxyUser;
                    logger.log(Level.INFO, CmdUtils.getMessage("TOOL_PROMPT_USERNAME", new Object[0]) + " " + inputUser);
                    inputPwd = CmdUtils.getPromptPassword();
                } else {
                    inputUser = CmdUtils.getPromptUsername();
                    inputPwd = CmdUtils.getPromptPassword();
                }
                --proxyRetries;
                if (inputUser != null && inputPwd != null) {
                    RepositoryConfigUtils.setProxyAuthenticator((String)proxy.getProxyURL().getHost(), (String)String.valueOf(proxy.getProxyURL().getPort()), (String)inputUser, (String)inputPwd);
                }
                logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_PROXY_AUTHENTICATION", new Object[0]));
                continue;
            }
            if (proxyRetries < 3) {
                proxyRetries = 3;
                logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_PROXY_SUCCESS", proxy.getProxyURL().toString()));
            }
            return responseCode;
        }
        if (proxyRetries < 3) {
            logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_PROXY_SUCCESS", proxy.getProxyURL().toString()));
        }
        return responseCode;
    }

    public static int credentialsPrompt(RestRepositoryConnection lie, Properties repoProperties, String actionName) throws InstallException {
        int responseCode;
        int proxyRetries = 3;
        int repoRetries = 3;
        String inputUser = null;
        String inputPwd = null;
        String repoUser = lie.getUserId();
        String repoPwd = lie.getPassword();
        String proxyUser = RepositoryConfigUtils.getProxyUser((Properties)repoProperties);
        String proxyPwd = RepositoryConfigUtils.getProxyPwd((Properties)repoProperties);
        while ((responseCode = CmdUtils.checkUserCredentials(lie)) != 200) {
            if (responseCode == 407) {
                if (proxyRetries == 0) {
                    logger.log(Level.INFO, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_PROXY_AUTHENTICATION_FAIL", lie.getProxy().getProxyURL().toString())));
                    logger.log(Level.INFO, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_REACHED_MAX_PROXY_RETRIES", actionName, RepositoryConfigUtils.getRepoPropertiesFileLocation())));
                    boolean actionContinue = SelfExtract.getResponse((String)CmdUtils.getMessage("TOOL_PROMPT_CONTINUE_OR_QUIT", actionName), (String)"", (String)"Xx");
                    logger.log(Level.INFO, "");
                    return !actionContinue ? -1 : responseCode;
                }
                if (proxyUser != null && !proxyUser.isEmpty() && proxyPwd != null && !proxyPwd.isEmpty()) {
                    return responseCode;
                }
                logger.log(Level.INFO, proxyRetries == 3 ? CmdUtils.getMessage("MSG_AUTHENTICATION_PROMPT", new Object[0]) : CmdUtils.getMessage("MSG_AUTHENTICATION_RETRY", proxyRetries));
                logger.log(Level.INFO, CmdUtils.getMessage("FIELD_PROXY", lie.getProxy().getProxyURL().toString()));
                if (proxyUser != null && !proxyUser.isEmpty() && proxyRetries == 3) {
                    inputUser = proxyUser;
                    logger.log(Level.INFO, CmdUtils.getMessage("TOOL_PROMPT_USERNAME", new Object[0]) + " " + inputUser);
                    inputPwd = CmdUtils.getPromptPassword();
                } else {
                    inputUser = CmdUtils.getPromptUsername();
                    inputPwd = CmdUtils.getPromptPassword();
                }
                --proxyRetries;
                if (inputUser != null && inputPwd != null) {
                    RepositoryConfigUtils.setProxyAuthenticator((String)lie.getProxy().getProxyURL().getHost(), (String)String.valueOf(lie.getProxy().getProxyURL().getPort()), (String)inputUser, (String)inputPwd);
                }
                logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_PROXY_AUTHENTICATION", new Object[0]));
                continue;
            }
            if (proxyRetries < 3) {
                proxyRetries = 3;
                logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_PROXY_SUCCESS", lie.getProxy().getProxyURL().toString()));
            }
            if (responseCode == 401) {
                if (repoRetries == 0) {
                    logger.log(Level.INFO, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_AUTHENTICATION_FAIL", RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)lie))));
                    logger.log(Level.INFO, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_REACHED_MAX_RETRIES", actionName)));
                    boolean actionContinue = SelfExtract.getResponse((String)CmdUtils.getMessage("TOOL_PROMPT_CONTINUE_OR_QUIT", actionName), (String)"", (String)"Xx");
                    logger.log(Level.INFO, "");
                    return !actionContinue ? -1 : responseCode;
                }
                if (repoUser != null && !repoUser.isEmpty() && repoPwd != null && !repoPwd.isEmpty()) {
                    return responseCode;
                }
                logger.log(Level.INFO, repoRetries == 3 ? CmdUtils.getMessage("MSG_AUTHENTICATION_PROMPT", new Object[0]) : CmdUtils.getMessage("MSG_AUTHENTICATION_RETRY", repoRetries));
                logger.log(Level.INFO, CmdUtils.getMessage("FIELD_REPO", RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)lie), lie.getRepositoryUrl()));
                if (repoUser != null && !repoUser.isEmpty() && repoRetries == 3) {
                    inputUser = repoUser;
                    logger.log(Level.INFO, CmdUtils.getMessage("TOOL_PROMPT_USERNAME", new Object[0]) + " " + inputUser);
                    inputPwd = CmdUtils.getPromptPassword();
                } else {
                    inputUser = CmdUtils.getPromptUsername();
                    inputPwd = CmdUtils.getPromptPassword();
                }
                --repoRetries;
                if (inputUser != null && inputPwd != null) {
                    lie.setUserId(inputUser);
                    lie.setPassword(inputPwd);
                }
                logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_REPO_AUTHENTICATION", RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)lie)));
                continue;
            }
            logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)lie) + " (" + lie.getRepositoryUrl() + ")"));
            return responseCode;
        }
        if (repoRetries < 3) {
            logger.log(Level.FINE, CmdUtils.getMessage("LOG_PROMPT_REPO_SUCCESS", RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)lie)));
        }
        logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + (RepositoryConfigUtils.isLibertyRepository((RestRepositoryConnection)lie, (Properties)repoProperties) ? CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0]) : RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)lie) + " (" + lie.getRepositoryUrl() + ")")));
        return responseCode;
    }

    private static String getPromptUsername() {
        return SelfExtract.getResponse((String)(CmdUtils.getMessage("TOOL_PROMPT_USERNAME", new Object[0]) + " "));
    }

    private static String getPromptPassword() {
        char[] promptPwd;
        String pwdStr = "";
        System.out.print(CmdUtils.getMessage("TOOL_PROMPT_PASSWORD", new Object[0]) + " ");
        Console console = System.console();
        if (console != null && (promptPwd = console.readPassword()) != null) {
            pwdStr = new String(promptPwd);
            if (Platform.isZOS() && Charset.isSupported(InstallPlatformUtils.getEBCIDICSystemCharSet()) && !CmdUtils.isStringASCII(pwdStr)) {
                pwdStr = new String(pwdStr.getBytes(Charset.defaultCharset()), Charset.forName(InstallPlatformUtils.getEBCIDICSystemCharSet())).trim();
            }
        }
        logger.log(Level.INFO, "");
        return pwdStr;
    }

    private static boolean isStringASCII(String str) {
        try {
            String asciiEncoded = new String(str.getBytes(Charset.defaultCharset()), Charset.forName(InstallPlatformUtils.getASCIISystemCharSet())).trim();
            if (str.equals(asciiEncoded)) {
                logger.log(Level.FINEST, "com.ibm.ws.install.utility.internal.cmdline.CmdUtils - isStringASCII(): String is ASCII encoded.");
                return true;
            }
        }
        catch (UnsupportedCharsetException uce) {
            logger.log(Level.FINEST, "com.ibm.ws.install.utility.internal.cmdline.CmdUtils - isStringASCII(): System does not support ASCII encoding.");
            return false;
        }
        logger.log(Level.FINEST, "com.ibm.ws.install.utility.internal.cmdline.CmdUtils - isStringASCII(): String is not ASCII encoded.");
        return false;
    }

    private static int checkUserCredentials(RestRepositoryConnection lie) {
        try {
            lie.checkRepositoryStatus();
        }
        catch (IOException ioe) {
            logger.log(Level.FINEST, "Exception Thrown for: " + lie.getRepositoryLocation() + InstallUtils.NEWLINE + CmdUtils.getStackTrace(ioe), ioe);
            if (ExceptionUtils.isCertPathBuilderException((Throwable)ioe.getCause())) {
                return -2;
            }
            return 500;
        }
        catch (RequestFailureException rfe) {
            if (rfe.getResponseCode() != 401 && rfe.getResponseCode() != 407) {
                logger.log(Level.FINEST, CmdUtils.getStackTrace((Exception)((Object)rfe)), rfe);
            }
            return rfe.getResponseCode();
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkInvalidRepository(RepositoryConnection rc, Properties repoProperties) throws InstallException {
        boolean isLibertyRepo = RepositoryConfigUtils.isLibertyRepository((RestRepositoryConnection)((RestRepositoryConnection)rc), (Properties)repoProperties);
        try {
            rc.checkRepositoryStatus();
            logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + (isLibertyRepo ? CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0]) : RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc) + " (" + ((RestRepositoryConnection)rc).getRepositoryUrl() + ")")));
            return;
        }
        catch (IOException ioe) {
            invalidRepoList.add(rc);
            Class<CheckRepositoryStatusRunnable> clazz = CheckRepositoryStatusRunnable.class;
            synchronized (CheckRepositoryStatusRunnable.class) {
                logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + (isLibertyRepo ? CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0]) : RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc) + " (" + ((RestRepositoryConnection)rc).getRepositoryUrl() + ")")).trim());
                logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("FIELD_REPO_REASON", CmdUtils.getMessage("LOG_REPO_CONNECTION_EXCEPTION", RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc), ioe.getClass().getSimpleName() + ": " + ioe.getMessage())), "    "));
                logger.log(Level.FINEST, CmdUtils.getStackTrace(ioe), ioe);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
        }
        catch (RequestFailureException rfe) {
            if (rfe.getResponseCode() == 401 || rfe.getResponseCode() == 407) {
                repoAuthenticationList.add(rc);
                return;
            }
            invalidRepoList.add(rc);
            Class<CheckRepositoryStatusRunnable> clazz = CheckRepositoryStatusRunnable.class;
            synchronized (CheckRepositoryStatusRunnable.class) {
                logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]).replace(".", ": ") + InstallUtils.NEWLINE + (isLibertyRepo ? CmdUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0]) : RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc) + " (" + ((RestRepositoryConnection)rc).getRepositoryUrl() + ")")).trim());
                logger.log(Level.FINE, CmdUtils.getWordWrappedMsg(CmdUtils.getMessage("FIELD_REPO_REASON", CmdUtils.getMessage("LOG_REPO_CONNECTION_EXCEPTION", RepositoryConfigUtils.getRepoName((Properties)repoProperties, (RepositoryConnection)rc), ((Object)((Object)rfe)).getClass().getSimpleName() + ": " + CmdUtils.getMessage("LOG_HTTP_SERVER_RESPONSE_CODE", rfe.getResponseCode(), ((RestRepositoryConnection)rc).getRepositoryUrl()))), "    "));
                logger.log(Level.FINEST, CmdUtils.getStackTrace((Exception)((Object)rfe)), rfe);
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return;
            }
        }
    }

    public static String getWordWrappedMsg(String message) {
        return CmdUtils.getWordWrappedMsg(message, "");
    }

    public static String getWordWrappedMsg(String message, String indentStr) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new StringReader(message));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                InstallUtils.wordWrap((StringBuffer)sb, (String)line, (String)indentStr);
            }
            return sb.toString();
        }
        catch (IOException e) {
            sb = new StringBuffer();
            InstallUtils.wordWrap((StringBuffer)sb, (String)message, (String)indentStr);
            return sb.toString();
        }
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static InstallException convertToBadConnectionError(InstallException e, boolean isBadConnectionFound) {
        if (isBadConnectionFound) {
            List data = e.getData();
            if (e.getMessage().contains("CWWKF1259E")) {
                return new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_RESOLVE_ASSETS_BAD_CONNECTION", new Object[]{data.get(0)}), e.getCause(), e.getRc());
            }
            if (e.getMessage().contains("CWWKF1258E")) {
                return new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_ASSET_MISSING_DEPENDENT_BAD_CONNECTION", new Object[]{data.get(0), data.get(1)}), e.getCause(), e.getRc());
            }
        }
        return e;
    }

    private static class CheckRepositoryStatusRunnable
    implements Runnable {
        private final RepositoryConnection repositoryConnection;
        private final Properties repoProperties;
        private final RestRepositoryConnectionProxy proxy;
        private final boolean testDefaultRepo;

        CheckRepositoryStatusRunnable(RepositoryConnection rc, Properties repoProperties, RestRepositoryConnectionProxy proxy, boolean testDefaultRepo) {
            this.repositoryConnection = rc;
            this.repoProperties = repoProperties;
            this.proxy = proxy;
            this.testDefaultRepo = testDefaultRepo;
        }

        @Override
        public void run() {
            try {
                if (this.repositoryConnection != null && !this.testDefaultRepo) {
                    CmdUtils.checkInvalidRepository(this.repositoryConnection, this.repoProperties);
                } else {
                    defaultRepoStatus = CmdUtils.testConnectionToDefaultRepo(this.proxy);
                }
            }
            catch (InstallException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

