/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.ws.ras.instrument.internal.introspect.TraceConfigPackageVisitor;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class AbstractInstrumentation {
    protected List<File> classFiles = new ArrayList<File>();
    protected List<File> jarFiles = new ArrayList<File>();
    protected List<Throwable> errors = new ArrayList<Throwable>();
    protected boolean debug = false;
    protected Map<String, PackageInfo> packageInfoMap = new HashMap<String, PackageInfo>();

    public List<File> getClassFiles() {
        return this.classFiles;
    }

    public void setClassFiles(List<File> fileList) {
        this.classFiles = fileList;
    }

    public List<File> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(List<File> fileList) {
        this.jarFiles = fileList;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    protected List<File> getClassFiles(File root, File parent) {
        if (root == null || !root.isDirectory()) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = root.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDirectory()) {
                List<File> subdirFiles = this.getClassFiles(files[i], parent);
                if (subdirFiles == null) continue;
                fileList.addAll(subdirFiles);
                continue;
            }
            if (!files[i].getName().endsWith(".class")) continue;
            fileList.add(files[i]);
        }
        return fileList;
    }

    protected List<File> getJarFiles(File root, File parent) {
        if (root == null || !root.isDirectory()) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = root.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDirectory()) {
                List<File> subdirFiles = this.getJarFiles(files[i], parent);
                if (subdirFiles == null) continue;
                fileList.addAll(subdirFiles);
                continue;
            }
            if (files[i].getName().endsWith(".jar")) {
                fileList.add(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(".zip")) continue;
            fileList.add(files[i]);
        }
        return fileList;
    }

    protected Map<String, PackageInfo> getPackageInfoMap() {
        return this.packageInfoMap;
    }

    protected void addPackageInfo(PackageInfo packageInfo) {
        if (packageInfo != null) {
            this.packageInfoMap.put(packageInfo.getInternalPackageName(), packageInfo);
        }
    }

    public abstract void processArguments(String[] var1) throws IOException;

    protected PackageInfo getPackageInfo(String packageName) {
        return this.packageInfoMap.get(packageName);
    }

    public void executeInstrumentation() throws IOException {
        this.errors.clear();
        for (File f : this.classFiles) {
            try {
                if (!f.canRead() || !f.canWrite()) {
                    throw new IOException(f + " can not be replaced");
                }
                this.instrumentClassFile(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errors.add(e);
            }
        }
        for (File f : this.jarFiles) {
            try {
                this.instrumentZipFile(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errors.add(e);
            }
        }
        if (!this.errors.isEmpty()) {
            Throwable t = this.errors.get(0);
            IOException ioe = new IOException(this.errors.size() + " errors occurred");
            ioe.initCause(t);
            throw ioe;
        }
    }

    protected InputStream getClassInputStream(String classInternalName) {
        if (classInternalName == null || "".equals(classInternalName)) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        try {
            for (File jarFile : this.jarFiles) {
                ZipFile zipFile = new ZipFile(jarFile);
                ZipEntry zipEntry = zipFile.getEntry(classInternalName + ".class");
                if (zipEntry != null) {
                    InputStream zis = zipFile.getInputStream(zipEntry);
                    byte[] bytecode = this.toByteArray(zis);
                    if (this.isStreamForClass(new ByteArrayInputStream(bytecode), classInternalName)) {
                        inputStream = new ByteArrayInputStream(bytecode);
                    }
                    zis.close();
                }
                zipFile.close();
                if (inputStream == null) continue;
                return inputStream;
            }
            String fileName = classInternalName + ".class";
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            for (File classFile : this.classFiles) {
                if (classFile.getName().equals(fileName)) {
                    FileInputStream fis = new FileInputStream(classFile);
                    byte[] bytecode = this.toByteArray(fis);
                    if (this.isStreamForClass(new ByteArrayInputStream(bytecode), classInternalName)) {
                        inputStream = new ByteArrayInputStream(bytecode);
                    }
                    fis.close();
                }
                if (inputStream == null) continue;
                return inputStream;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStreamForClass(InputStream inputStream, String classInternalName) throws IOException {
        boolean streamForClass = false;
        try {
            ClassReader reader = new ClassReader(this.toByteArray(inputStream));
            streamForClass = reader.getClassName().equals(classInternalName);
        }
        finally {
            inputStream.reset();
        }
        return streamForClass;
    }

    public void instrumentClassFile(File classfile) throws IOException {
        FileInputStream fis = new FileInputStream(classfile);
        byte[] bytes = this.transform(classfile.getPath(), fis);
        fis.close();
        fis = null;
        if (bytes != null) {
            FileOutputStream fos = new FileOutputStream(classfile);
            fos.write(bytes);
            fos.close();
        }
    }

    public void instrumentZipFile(File zf) throws IOException {
        if (!zf.canRead() || !zf.canWrite()) {
            throw new IOException(zf + " can not be replaced");
        }
        File tempFile = File.createTempFile(zf.getName(), null, zf.getParentFile());
        if (tempFile.exists() && !tempFile.delete()) {
            throw new IOException("Unable to delete existing temp file " + tempFile.getName());
        }
        if (!zf.renameTo(tempFile)) {
            throw new IOException("Unable to rename existing jar " + zf);
        }
        ZipFile zipFile = new ZipFile(tempFile);
        FileOutputStream fos = new FileOutputStream(zf);
        ZipOutputStream zos = new ZipOutputStream(fos);
        boolean restoreZipFile = false;
        try {
            byte[] buffer = new byte[8192];
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry oldEntry = e.nextElement();
                InputStream zis = zipFile.getInputStream(oldEntry);
                byte[] transformedClass = null;
                if (oldEntry.getName().endsWith(".class") && (transformedClass = this.transform(oldEntry.getName(), zis)) == null) {
                    zis = zipFile.getInputStream(oldEntry);
                }
                ZipEntry newEntry = new ZipEntry(oldEntry.getName());
                newEntry.setTime(transformedClass == null ? oldEntry.getTime() : System.currentTimeMillis());
                newEntry.setComment(oldEntry.getComment());
                newEntry.setExtra(oldEntry.getExtra());
                newEntry.setSize(transformedClass == null ? oldEntry.getSize() : (long)transformedClass.length);
                if (newEntry.getSize() > Integer.MAX_VALUE) {
                    throw new IOException("ZipEntry too large: " + newEntry.getSize());
                }
                int entrySize = (int)newEntry.getSize();
                if (entrySize > buffer.length) {
                    buffer = new byte[entrySize];
                }
                if (transformedClass != null) {
                    System.arraycopy(transformedClass, 0, buffer, 0, entrySize);
                } else {
                    int bytesRead;
                    for (int totalBytesRead = 0; totalBytesRead < entrySize; totalBytesRead += bytesRead) {
                        bytesRead = zis.read(buffer, totalBytesRead, entrySize - totalBytesRead);
                        if (bytesRead != -1) continue;
                        throw new IOException("End of file encountered");
                    }
                }
                zos.putNextEntry(newEntry);
                zos.write(buffer, 0, entrySize);
            }
        }
        catch (IOException ioe) {
            restoreZipFile = true;
            throw ioe;
        }
        catch (Throwable t) {
            restoreZipFile = true;
            IOException ioe = new IOException("Unexpected exception encountered during instrumentation");
            ioe.initCause(t);
            throw ioe;
        }
        finally {
            zos.close();
            fos.close();
            zipFile.close();
            if (restoreZipFile) {
                zf.delete();
                tempFile.renameTo(zf);
            } else {
                tempFile.delete();
            }
        }
    }

    public void processPackageInfo() throws IOException {
        for (File classFile : this.classFiles) {
            if (!classFile.getName().equals("package-info.class")) continue;
            FileInputStream fis = new FileInputStream(classFile);
            this.addPackageInfo(this.processPackageInfo(fis));
            fis.close();
        }
        for (File jarFile : this.jarFiles) {
            ZipFile zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (!zipEntry.getName().endsWith("/package-info.class")) continue;
                InputStream zis = zipFile.getInputStream(zipEntry);
                this.addPackageInfo(this.processPackageInfo(zis));
            }
            zipFile.close();
        }
    }

    protected PackageInfo processPackageInfo(InputStream packageInfoResource) {
        if (packageInfoResource == null) {
            return null;
        }
        PackageInfo packageInfo = null;
        try {
            ClassReader cr = new ClassReader(packageInfoResource);
            TraceConfigPackageVisitor packageVisitor = new TraceConfigPackageVisitor();
            cr.accept((ClassVisitor)packageVisitor, 7);
            packageInfo = packageVisitor.getPackageInfo();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return packageInfo;
    }

    protected abstract byte[] transform(String var1, InputStream var2) throws IOException;
}

