/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin;

import com.ibm.websphere.ras.annotation.Trivial;
import java.io.Serializable;

@Trivial
public class ConfigID
implements Serializable {
    private static final long serialVersionUID = -7188381474767207297L;
    private final String pid;
    private final String id;
    private final ConfigID parent;
    private final String childAttribute;

    public ConfigID(String pid) {
        this(null, pid, null, null);
    }

    public ConfigID(String pid, String id) {
        this(null, pid, id, null);
    }

    public ConfigID(ConfigID parent, String nodeName, String id2) {
        this(parent, nodeName, id2, null);
    }

    public ConfigID(ConfigID parent, String nodeName, String id, String childAttribute) {
        this.pid = nodeName;
        this.id = id;
        this.parent = parent;
        this.childAttribute = childAttribute;
    }

    public String getPid() {
        return this.pid;
    }

    public String getId() {
        return this.id;
    }

    public static ConfigID fromProperty(String property) {
        String[] parents = property.split("//");
        ConfigID id = null;
        for (String parentString : parents) {
            id = ConfigID.constructId(id, parentString);
        }
        return id;
    }

    private static ConfigID constructId(ConfigID parent2, String parentString) {
        String childAttribute = ConfigID.parseChildAttribute(parentString);
        String pid = ConfigID.parsePid(parentString);
        String id = ConfigID.parseId(parentString);
        return new ConfigID(parent2, pid, id, childAttribute);
    }

    private static String parseId(String parentString) {
        int idx = parentString.indexOf(91);
        if (idx == -1) {
            return null;
        }
        return parentString.substring(idx + 1, parentString.indexOf(93));
    }

    private static String parsePid(String parentString) {
        int idx = parentString.indexOf(40);
        if (idx == -1) {
            idx = parentString.indexOf(91);
        }
        if (idx == -1) {
            return parentString;
        }
        return parentString.substring(0, idx);
    }

    private static String parseChildAttribute(String parentString) {
        int idx = parentString.indexOf(40);
        if (idx != -1) {
            return parentString.substring(idx + 1, parentString.indexOf(41));
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.childAttribute == null ? 0 : this.childAttribute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigID)) {
            return false;
        }
        ConfigID other = (ConfigID)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.childAttribute == null ? other.childAttribute != null : !this.childAttribute.equals(other.childAttribute));
    }

    @Trivial
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.toString());
            buffer.append("//");
        }
        buffer.append(this.pid);
        if (this.childAttribute != null) {
            buffer.append('(').append(this.childAttribute).append(')');
        }
        if (this.id != null) {
            buffer.append('[').append(this.id).append(']');
        }
        return buffer.toString();
    }

    public ConfigID getParent() {
        return this.parent;
    }

    public String getChildAttribute() {
        return this.childAttribute;
    }
}

