/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.utils;

import com.ibm.ws.security.utility.utils.CommandUtils;
import java.io.Console;
import java.io.IOError;
import java.io.PrintStream;

public class ConsoleWrapper {
    private final Console console;
    private final PrintStream stderr;

    public ConsoleWrapper(Console console, PrintStream stderr) {
        this.console = console;
        this.stderr = stderr;
    }

    public boolean isInputStreamAvailable() {
        return this.console != null;
    }

    public String readMaskedText(String prompt) {
        if (!this.isInputStreamAvailable()) {
            this.stderr.println(CommandUtils.getMessage("error.inputConsoleNotAvailable", new Object[0]));
            return null;
        }
        try {
            char[] in = this.console.readPassword(prompt, new Object[0]);
            if (in == null) {
                return null;
            }
            return String.valueOf(in);
        }
        catch (IOError e) {
            this.stderr.println("Exception while reading stdin: " + e.getMessage());
            e.printStackTrace(this.stderr);
            return null;
        }
    }
}

