/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.ws.security.utility.IFileUtility;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.tasks.BaseCommandTask;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.PrintStream;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.FilenameUtils;

public class TLSProfilerTask
extends BaseCommandTask {
    private static final String ARG_HOST = "--host";
    private static final String ARG_PORT = "--port";
    private static final String ARG_V = "--v";
    private static final String ARG_VERBOSE = "--verbose";
    private static final String ARG_FILE = "--file";
    private static final List<String> ARG_TABLE = Arrays.asList("--host", "--port", "--v", "--verbose", "--file");
    private static List<String> resultLabel = new ArrayList<String>();
    private final IFileUtility fileUtility;

    public TLSProfilerTask(IFileUtility fileUtil, String scriptName) {
        super(scriptName);
        this.fileUtility = fileUtil;
    }

    @Override
    public String getTaskName() {
        return "tlsProfiler";
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("tlsProfiler.desc", "tlsProfiler.usage.options", "tlsProfiler.required-key.", "tlsProfiler.required-desc.", "tlsProfiler.option-key.", "tlsProfiler.option-desc.", null, null, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("tlsProfiler.desc", true, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SecurityUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        void var16_26;
        String resultString;
        this.validateArgumentList(args, Arrays.asList(ARG_V, ARG_VERBOSE));
        boolean verbose = this.checkVerboseArgs(args);
        String host = this.getArgumentValue(ARG_HOST, args, null);
        String fileArg = this.getArgumentValue(ARG_FILE, args, null);
        int port = Integer.parseInt(this.getArgumentValue(ARG_PORT, args, null));
        File file = this.generateConfigFileName(this.fileUtility.getServersDirectory(), fileArg);
        List<Object> disabledList = new ArrayList();
        if (Security.getProperty("jdk.tls.disabledAlgorithms") != null) {
            disabledList = Arrays.asList(Security.getProperty("jdk.tls.disabledAlgorithms").split(","));
        }
        Security.setProperty("jdk.tls.disabledAlgorithms", "");
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
        ArrayList<TlsProfilerResult> results = new ArrayList<TlsProfilerResult>();
        ArrayList<String> safeProtocols = new ArrayList<String>();
        ArrayList<String> unsafeProtocols = new ArrayList<String>();
        ArrayList<String> protocols = new ArrayList<String>();
        for (String string : Arrays.asList(SSLContext.getDefault().getDefaultSSLParameters().getProtocols())) {
            if (!string.contains("SSLv3") && !string.contains("TLS")) continue;
            protocols.add(string);
        }
        for (String string : protocols) {
            SSLContext sSLContext = SSLContext.getInstance(string);
            sSLContext.init(null, null, null);
            String[] ciphersuites = sSLContext.getSupportedSSLParameters().getCipherSuites();
            for (String ciphersuite : ciphersuites) {
                TlsProfilerResult result = new TlsProfilerResult();
                for (String string2 : disabledList) {
                    if (!string.contains(string2)) continue;
                    result.setVulnerable(true);
                }
                if (result.isVulnerable() && !unsafeProtocols.contains(string)) {
                    unsafeProtocols.add(string);
                } else if (!result.isVulnerable() && !safeProtocols.contains(string)) {
                    safeProtocols.add(string);
                }
                result.setProtocol(string);
                result.setCiphersuite(ciphersuite);
                for (String string3 : disabledList) {
                    if (!ciphersuite.contains(string3)) continue;
                    result.setVulnerable(true);
                }
                SSLParameters sp = sSLContext.getDefaultSSLParameters();
                sp.setCipherSuites(new String[]{ciphersuite});
                SSLSocket sSLSocket = (SSLSocket)sSLContext.getSocketFactory().createSocket(host, port);
                sSLSocket.setSSLParameters(sp);
                try {
                    sSLSocket.startHandshake();
                    if (string.equals(sSLSocket.getSession().getProtocol()) && ciphersuite.equals(sSLSocket.getSession().getCipherSuite())) {
                        result.setSuccessful(true);
                        results.add(result);
                    } else {
                        results.add(result);
                    }
                }
                catch (Exception e) {
                    results.add(result);
                }
                sSLSocket.close();
            }
        }
        boolean headerPrinted = false;
        for (String string : safeProtocols) {
            resultString = new String();
            for (TlsProfilerResult result : results) {
                if (!result.getProtocol().equals(string) || !result.isSuccessful()) continue;
                resultString = resultString + result.getCiphersuite() + " ";
            }
            if (resultString.isEmpty()) continue;
            if (!headerPrinted) {
                resultLabel.add("Successful handshakes to the target host and port were made with the following recommended protocol and cipher suites:\n");
            }
            headerPrinted = true;
            resultLabel.add(string + ": " + resultString + "\n");
        }
        if (verbose) {
            headerPrinted = false;
            for (String string : safeProtocols) {
                resultString = new String();
                for (TlsProfilerResult result : results) {
                    if (!result.getProtocol().equals(string) || result.isSuccessful()) continue;
                    resultString = resultString + result.getCiphersuite() + " ";
                }
                if (resultString.isEmpty()) continue;
                if (!headerPrinted) {
                    resultLabel.add("Unsuccessful handshakes to the target host and port were made with the following protocol and cipher suites:\n");
                }
                headerPrinted = true;
                resultLabel.add(string + ": " + resultString + "\n");
            }
            headerPrinted = false;
            for (String string : unsafeProtocols) {
                resultString = new String();
                for (TlsProfilerResult result : results) {
                    if (!result.getProtocol().equals(string) || !result.isSuccessful()) continue;
                    resultString = resultString + result.getCiphersuite() + " ";
                }
                if (resultString.isEmpty()) continue;
                if (!headerPrinted) {
                    resultLabel.add("\nWARNING: The following output was generated using protocols and cipher suites which have known security vulnerabilities.\nThis diagnostic tool's runtime does not expose any data, and this result does not indicate a problem.\nThe target host and port supports the following protocols and cipher suites with known security vulnerabilities.\nEnabling any of the following protocols and cipher suites to connect to the target host and port can result in a breach of security.\n");
                }
                headerPrinted = true;
                resultLabel.add(string + ": " + resultString + "\n");
            }
            headerPrinted = false;
            for (String string : unsafeProtocols) {
                resultString = new String();
                for (TlsProfilerResult result : results) {
                    if (!result.getProtocol().equals(string) || result.isSuccessful()) continue;
                    resultString = resultString + result.getCiphersuite() + " ";
                }
                if (resultString.isEmpty()) continue;
                if (!headerPrinted) {
                    resultLabel.add("\nWARNING: The following output was generated using protocols and/or cipher suites which have known security vulnerabilities.\nThis diagnostic tool's runtime does not expose any data, and this result does not indicate a problem.\nHowever, it should be noted that the target host and port does not support the following protocols and cipher suites which have known security vulnerabilites.\nEnabling any of the following protocols and cipher suites in order to connect to the target host and port could result in a breach of security.\n");
                }
                headerPrinted = true;
                resultLabel.add(string + ": " + resultString + "\n");
            }
        }
        String string = "";
        for (String line : resultLabel) {
            String string4 = (String)var16_26 + line + "\n";
        }
        if (file != null) {
            stdout.println("Writing file to: " + file.getAbsolutePath());
            this.fileUtility.createParentDirectory(stdout, file);
            this.fileUtility.writeToFile(stderr, (String)var16_26, file);
        } else {
            stdout.println((String)var16_26);
        }
        return SecurityUtilityReturnCodes.OK;
    }

    protected File generateConfigFileName(String serverDir, String targetFilepath) {
        if (targetFilepath == null || targetFilepath.equals("")) {
            return null;
        }
        File outputFile = new File(targetFilepath);
        if (!outputFile.isAbsolute()) {
            outputFile = new File(serverDir + targetFilepath);
        }
        if (this.fileUtility.isDirectory(outputFile)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
            Date date = new Date();
            outputFile = new File(outputFile, "tlsProfiler-" + dateFormat.format(date) + ".txt");
        }
        if (this.fileUtility.exists(outputFile)) {
            String filePath = FilenameUtils.removeExtension((String)outputFile.getPath());
            String fileExt = FilenameUtils.getExtension((String)outputFile.getPath());
            int counter = 1;
            do {
                outputFile = new File(filePath + counter + "." + fileExt);
                ++counter;
            } while (this.fileUtility.exists(outputFile));
        }
        return outputFile;
    }

    private boolean checkVerboseArgs(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(ARG_V) && !arg.equalsIgnoreCase(ARG_VERBOSE)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isKnownArgument(String arg) {
        boolean value = false;
        if (arg != null) {
            value = ARG_TABLE.contains(arg);
        }
        return value;
    }

    @Override
    void checkRequiredArguments(String[] args) {
        String message = "";
        if (args.length < 2) {
            message = this.getMessage("insufficientArgs", new Object[0]);
        }
        boolean portFound = false;
        boolean hostFound = false;
        for (String arg : args) {
            if (arg.startsWith(ARG_PORT)) {
                portFound = true;
            }
            if (!arg.startsWith(ARG_HOST)) continue;
            hostFound = true;
        }
        if (!hostFound) {
            message = message + " " + this.getMessage("missingArg", ARG_HOST);
        }
        if (!portFound) {
            message = message + " " + this.getMessage("missingArg", ARG_PORT);
        }
        if (!message.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    protected String getArgumentValue(String arg, String[] args, String defalt) {
        for (int i = 1; i < args.length; ++i) {
            String key = args[i].split("=")[0];
            if (!key.equals(arg)) continue;
            return this.getValue(args[i]);
        }
        return defalt;
    }

    private class TlsProfilerResult {
        private String protocol;
        private String ciphersuite;
        private boolean isVulnerable;
        private boolean isSuccessful;

        public TlsProfilerResult() {
            this.setProtocol(new String());
            this.setCiphersuite(new String());
            this.setVulnerable(false);
            this.setSuccessful(false);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getCiphersuite() {
            return this.ciphersuite;
        }

        public void setCiphersuite(String ciphersuite) {
            this.ciphersuite = ciphersuite;
        }

        public boolean isVulnerable() {
            return this.isVulnerable;
        }

        public void setVulnerable(boolean isVulnerable) {
            this.isVulnerable = isVulnerable;
        }

        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        public void setSuccessful(boolean isSuccessful) {
            this.isSuccessful = isSuccessful;
        }
    }
}

