/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.SSLAlpnNegotiator;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import javax.net.ssl.SSLEngine;

public class AlpnSupportUtils {
    private static final TraceComponent tc = Tr.register(AlpnSupportUtils.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private static SSLAlpnNegotiator alpnNegotiator = new SSLAlpnNegotiator();

    protected static void registerAlpnSupport(SSLConnectionLink connLink, SSLEngine engine) {
        SSLAlpnNegotiator.ThirdPartyAlpnNegotiator negotiator = null;
        boolean useAlpn = AlpnSupportUtils.isH2Active(connLink);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registerAlpnSupportDuringHandshake, h2 protocol enabled: " + useAlpn), (Object[])new Object[0]);
        }
        negotiator = alpnNegotiator.tryToRegisterAlpnNegotiator(engine, connLink, useAlpn);
        connLink.setAlpnNegotiator(negotiator);
    }

    protected static void getAlpnResult(SSLEngine engine, SSLConnectionLink link) {
        alpnNegotiator.tryToRemoveAlpnNegotiator(link.getAlpnNegotiator(), engine, link);
    }

    private static boolean isH2Active(SSLConnectionLink connLink) {
        boolean useAlpn = connLink.isAlpnEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isH2Active, h2 protocol enabled: " + useAlpn), (Object[])new Object[0]);
        }
        return useAlpn;
    }
}

