/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;

public class BundleManifest {
    private final Set<String> privatePackages = new HashSet<String>();
    private final Set<String> exportedPackages = new HashSet<String>();
    private final Dictionary<String, String> headers;
    private final String vendor;
    private final String distributor;

    public BundleManifest(Bundle bundle) {
        this.headers = bundle.getHeaders("");
        this.vendor = this.headers.get("Bundle-Vendor");
        this.distributor = this.headers.get("Bundle-Distributor");
    }

    public Set<String> getPrivatePackages() {
        if (this.privatePackages.isEmpty()) {
            String privatePackagesHeader = this.headers.get("Private-Package");
            this.parseHeader(privatePackagesHeader, this.privatePackages);
        }
        return this.privatePackages;
    }

    public Set<String> getExportedPackages() {
        if (this.exportedPackages.isEmpty()) {
            String exportedPackagesHeader = this.headers.get("Export-Package");
            this.parseHeader(exportedPackagesHeader, this.exportedPackages);
        }
        return this.exportedPackages;
    }

    void parseHeader(String header, Set<String> packages) {
        if (header != null && header.length() > 0) {
            ArrayList<String> splitPackages = new ArrayList<String>();
            int lastIndex = 0;
            boolean inQuotedSection = false;
            int i = 0;
            for (i = 0; i < header.length(); ++i) {
                if (header.charAt(i) == ',' && !inQuotedSection) {
                    String packagePlusAttributesAndDirectives = header.substring(lastIndex, i);
                    lastIndex = i + 1;
                    splitPackages.add(packagePlusAttributesAndDirectives);
                    continue;
                }
                if (header.charAt(i) != '\"') continue;
                inQuotedSection = !inQuotedSection;
            }
            splitPackages.add(header.substring(lastIndex, i));
            for (String packagePlusAttributesAndDirectives : splitPackages) {
                String[] bits = packagePlusAttributesAndDirectives.split(";");
                packages.add(bits[0]);
            }
        }
    }

    public String getBundleVendor() {
        return this.vendor;
    }

    public Object getBundleDistributor() {
        return this.distributor;
    }
}

