/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.manager.buffer;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collector.manager.buffer.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Trivial
public class Buffer<T> {
    private final int capacity;
    private final ArrayList<Event<T>> ringBuffer;
    private long currentSeqNum;
    private long earliestSeqNum;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock r = this.rwl.readLock();
    private final Condition condition = this.w.newCondition();

    public Buffer(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Buffer capacity has to be >= 1");
        }
        this.ringBuffer = new ArrayList<Event<Object>>(Collections.nCopies(capacity, new Event<Object>(-1L, null)));
        this.capacity = capacity;
        this.earliestSeqNum = 1L;
        this.currentSeqNum = 1L;
    }

    public void add(T event) {
        this.w.lock();
        try {
            int index;
            if (this.currentSeqNum > (long)this.capacity) {
                ++this.earliestSeqNum;
            }
            if (this.ringBuffer.get(index = (int)((this.currentSeqNum - 1L) % (long)this.capacity)).getEvent() == null) {
                this.ringBuffer.set(index, new Event<T>(this.currentSeqNum, event));
            } else {
                this.ringBuffer.get(index).setSeqNum(this.currentSeqNum);
                this.ringBuffer.get(index).setEvent(event);
            }
            ++this.currentSeqNum;
            this.condition.signalAll();
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event<T> get(long seqNum) throws InterruptedException {
        this.r.lock();
        while (seqNum >= this.currentSeqNum || this.currentSeqNum == this.earliestSeqNum) {
            this.r.unlock();
            this.w.lock();
            try {
                if (seqNum >= this.currentSeqNum || this.currentSeqNum == this.earliestSeqNum) {
                    this.condition.await();
                }
                this.r.lock();
            }
            finally {
                this.w.unlock();
            }
        }
        try {
            if (seqNum < this.earliestSeqNum) {
                seqNum = this.earliestSeqNum;
            }
            int index = (int)((seqNum - 1L) % (long)this.capacity);
            Event<T> event = new Event<T>(this.ringBuffer.get(index));
            return event;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Event<T>> get(long seqNum, int noOfEvents) throws InterruptedException {
        this.r.lock();
        while (seqNum >= this.currentSeqNum || this.currentSeqNum == this.earliestSeqNum) {
            this.r.unlock();
            this.w.lock();
            try {
                if (seqNum >= this.currentSeqNum || this.currentSeqNum == this.earliestSeqNum) {
                    this.condition.await();
                }
                this.r.lock();
            }
            finally {
                this.w.unlock();
            }
        }
        try {
            int noOfAvailableEvents;
            if (seqNum < this.earliestSeqNum) {
                seqNum = this.earliestSeqNum;
            }
            if ((noOfAvailableEvents = (int)(this.currentSeqNum - seqNum)) < noOfEvents) {
                noOfEvents = noOfAvailableEvents;
            }
            ArrayList<Event<T>> arrayList = this.copyEvents(seqNum, noOfEvents);
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    private ArrayList<Event<T>> copyEvents(long seqNum, int noOfEvents) {
        int index;
        ArrayList<Event<T>> events = new ArrayList<Event<T>>(noOfEvents);
        int i = index = (int)((seqNum - 1L) % (long)this.capacity);
        for (int j = 0; j < noOfEvents; ++j) {
            events.add(new Event<T>(this.ringBuffer.get(i)));
            i = (i + 1) % this.capacity;
        }
        return events;
    }
}

