/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.location.internal.InternalWsResource;
import com.ibm.ws.kernel.service.location.internal.SymbolicRootResource;
import com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemoteResource
implements InternalWsResource {
    private static final TraceComponent tc = Tr.register(RemoteResource.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
    private static final String CACHED_RESOURCE_FILE_NAME_PREFIX = "resCache_";
    private final WsResource.Type type;
    private final URL url;
    private long lastModified;
    private WsResource cachedResource;
    private String stringValue = null;
    static final long serialVersionUID = 3363448193111830812L;

    public RemoteResource(URL url) {
        this.url = url;
        this.type = WsResource.Type.REMOTE;
        this.cacheResource();
    }

    @Override
    public boolean create() {
        throw new UnsupportedOperationException("Not valid for a remote resource");
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException("Not valid for a remote resource");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists() {
        if (this.cachedResource != null) {
            return true;
        }
        try {
            InputStream is = this.get();
            if (is != null) {
                is.close();
                return true;
            }
            return false;
        }
        catch (IOException is) {
            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.kernel.service.location.internal.RemoteResource", (String)"81", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void ex;
                Tr.debug((TraceComponent)tc, (String)"IOException while checking existence of resource", (Object[])new Object[]{ex});
            }
            return false;
        }
    }

    @Override
    public InputStream get() throws IOException {
        return this.url.openStream();
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        return Channels.newChannel(this.get());
    }

    @Override
    public WsResource getChild(String name) {
        throw new UnsupportedOperationException("Not valid for a remote resource");
    }

    @Override
    public Iterator<String> getChildren() {
        throw new UnsupportedOperationException("Not valid for a remote resource");
    }

    @Override
    public Iterator<String> getChildren(String resourceRegex) {
        throw new UnsupportedOperationException("Not valid for a remote resource");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLastModified() {
        long value = 0L;
        try {
            value = this.url.openConnection().getLastModified();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.location.internal.RemoteResource", (String)"124", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getLastModified - caught IOException", (Object[])new Object[]{e});
            }
            value = -1L;
        }
        if (value == -1L) {
            value = 0L;
        } else if (value == 0L) {
            if (this.isUpdated()) {
                value = System.currentTimeMillis();
                this.setLastModified(value);
            }
        } else {
            this.setLastModified(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUpdated() {
        if (this.cachedResource == null) {
            return true;
        }
        currentChannel = null;
        cachedChannel = null;
        try {
            currentChannel = this.getChannel();
            cachedChannel = this.cachedResource.getChannel();
            currentBuffer = ByteBuffer.allocateDirect(1024);
            cachedBuffer = ByteBuffer.allocateDirect(1024);
            currentBuffer.flip();
            cachedBuffer.flip();
            while (true) {
                currentByte = RemoteResource.readFromChannel(currentChannel, currentBuffer);
                cachedByte = RemoteResource.readFromChannel(cachedChannel, cachedBuffer);
                if (currentByte != -1) continue;
                if (cachedByte == -1) {
                    var7_9 = false;
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException currentBuffer) {
            FFDCFilter.processException((Throwable)currentBuffer, (String)"com.ibm.ws.kernel.service.location.internal.RemoteResource", (String)"178", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && RemoteResource.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)RemoteResource.tc, (String)"IOException while comparing resources", (Object[])new Object[]{e});
            }
            var4_6 = true;
            RemoteResource.tryToClose(currentChannel);
            RemoteResource.tryToClose(cachedChannel);
            return var4_6;
        }
        catch (Throwable var8_12) {
            RemoteResource.tryToClose(currentChannel);
            RemoteResource.tryToClose(cachedChannel);
            throw var8_12;
        }
        RemoteResource.tryToClose(currentChannel);
        RemoteResource.tryToClose(cachedChannel);
        return var7_9;
lbl-1000:
        // 1 sources

        {
            var7_10 = true;
        }
        RemoteResource.tryToClose(currentChannel);
        RemoteResource.tryToClose(cachedChannel);
        return var7_10;
        {
            if (currentByte == cachedByte) ** continue;
            var7_11 = true;
        }
        RemoteResource.tryToClose(currentChannel);
        RemoteResource.tryToClose(cachedChannel);
        return var7_11;
    }

    private static int readFromChannel(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (!buffer.hasRemaining()) {
            buffer.clear();
            int read = channel.read(buffer);
            if (read == -1) {
                return -1;
            }
            if (read == 0) continue;
            buffer.flip();
            break;
        }
        return buffer.get() & 0xFF;
    }

    @FFDCIgnore(value={IOException.class})
    private static void tryToClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return this.url.getPath();
    }

    @Override
    public WsResource getParent() {
        throw new UnsupportedOperationException("Not valid for a remote resource");
    }

    @Override
    public WsResource.Type getType() {
        return this.type;
    }

    @Override
    public boolean isType(WsResource.Type resourceType) {
        return this.type == resourceType;
    }

    @Override
    public long length() {
        if (this.cachedResource == null) {
            return 0L;
        }
        return this.cachedResource.length();
    }

    /*
     * WARNING - void declaration
     */
    private void cacheResource() {
        block2: {
            WsLocationAdminImpl locSvc = WsLocationAdminImpl.getInstance();
            File tempFile = locSvc.getBundleFile(this, CACHED_RESOURCE_FILE_NAME_PREFIX + this.url.toString().hashCode());
            WsResource resource = locSvc.asResource(tempFile, true);
            try {
                this.moveTo(resource);
                this.cachedResource = resource;
                this.setLastModified(System.currentTimeMillis());
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.location.internal.RemoteResource", (String)"264", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"IOException while attempting to cache resource", (Object[])new Object[]{e});
            }
        }
    }

    @Override
    public boolean moveTo(WsResource target) throws IOException {
        if (target == null) {
            throw new NullPointerException("Can not move to a null resource");
        }
        if (target.equals(this)) {
            throw new IllegalArgumentException("Can not move a target to itself");
        }
        if (target.getType() == WsResource.Type.FILE) {
            InputStream is = this.get();
            if (is == null) {
                return false;
            }
            try {
                target.put(is);
            }
            finally {
                is.close();
            }
            return true;
        }
        return false;
    }

    @Override
    public void put(InputStream source) throws IOException {
        throw new UnsupportedOperationException("Can not replace remote resource");
    }

    @Override
    public void put(ReadableByteChannel source) throws IOException {
        throw new UnsupportedOperationException("Can not replace remote resource");
    }

    @Override
    public OutputStream putStream() throws IOException {
        throw new UnsupportedOperationException("Can not replace remote resource");
    }

    @Override
    public WritableByteChannel putChannel() throws IOException {
        throw new UnsupportedOperationException("Can not replace remote resource");
    }

    @Override
    public WsResource resolveRelative(String relativeResourceURI) {
        return null;
    }

    @Override
    public boolean setLastModified(long lastModified) {
        if (this.lastModified == lastModified) {
            return false;
        }
        this.lastModified = lastModified;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URI toExternalURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.kernel.service.location.internal.RemoteResource", (String)"340", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
    }

    @Override
    public File asFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toRepositoryPath() {
        return null;
    }

    @Override
    public String getNormalizedPath() {
        return null;
    }

    @Override
    public String getRawRepositoryPath() {
        return null;
    }

    @Override
    public SymbolicRootResource getSymbolicRoot() {
        return null;
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        String result = this.stringValue;
        if (result == null) {
            StringBuilder str = new StringBuilder();
            str.append(simpleName).append("[").append((Object)this.type).append(";").append("@").append(System.identityHashCode(this)).append(";").append(this.url).append("]");
            this.stringValue = result = str.toString();
        }
        return result;
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }
}

