/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InternalInjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.Reference;

public class InjectionScopeData {
    private static final String CLASS_NAME = InjectionScopeData.class.getName();
    private static final TraceComponent tc = Tr.register(InjectionScopeData.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    protected final J2EEName ivJ2EEName;
    String ivLogicalAppName;
    private boolean ivDestroyed;
    private Map<String, InjectionBinding<?>> ivInjectableEnvEntries;
    private Map<String, Reference> ivDefinitionReferences;
    public ReferenceContext ivReferenceContext;

    public InjectionScopeData(J2EEName j2eeName) {
        this.ivJ2EEName = j2eeName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + this), (Object[])new Object[0]);
        }
    }

    public String toString() {
        return super.toString() + '[' + (this.ivJ2EEName != null ? this.ivJ2EEName : "(global)") + ']';
    }

    public synchronized void destroy() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroy: " + this), (Object[])new Object[0]);
        }
        if (this.ivDefinitionReferences != null) {
            for (Map.Entry<String, Reference> entry : this.ivDefinitionReferences.entrySet()) {
                this.destroyDefinitionReference(entry.getKey(), entry.getValue());
            }
        }
        this.ivDestroyed = true;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    private void destroyDefinitionReference(String jndiName, Reference ref) {
        block3: {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroying definition reference " + jndiName), (Object[])new Object[0]);
            }
            try {
                InternalInjectionEngineAccessor.getInstance().destroyDefinitionReference(ref);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".destroyDefinitionReference"), (String)"253", (Object)this, (Object[])new Object[]{jndiName, ref});
                if (!isTraceOn || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"failed to destroy definition reference", (Object[])new Object[]{ex});
            }
        }
    }

    public synchronized InjectionBinding<?> getInjectableEnvEntry(String jndiName) {
        InjectionBinding<?> binding;
        InjectionBinding<?> injectionBinding = binding = this.ivInjectableEnvEntries == null ? null : this.ivInjectableEnvEntries.get(jndiName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInjectableEnvEntry: " + jndiName + " = " + binding), (Object[])new Object[0]);
        }
        return binding;
    }

    public synchronized void addInjectableEnvEntry(InjectionBinding<?> binding) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addInjectableEnvEntry: " + this + ", name=" + binding.getJndiName()), (Object[])new Object[0]);
        }
        if (this.ivInjectableEnvEntries == null) {
            this.ivInjectableEnvEntries = new HashMap();
        }
        this.ivInjectableEnvEntries.put(binding.getJndiName(), binding);
    }

    public synchronized void removeInjectableEnvEntry(String jndiName) {
        if (this.ivInjectableEnvEntries == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeInjectableEnvEntry: (empty)", (Object[])new Object[0]);
            }
        } else {
            this.ivInjectableEnvEntries.remove(jndiName);
        }
    }

    public synchronized void addDefinitionReference(String jndiName, Reference ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addDefinitionReference: " + this + ", name=" + jndiName), (Object[])new Object[0]);
        }
        if (this.ivDestroyed) {
            this.destroyDefinitionReference(jndiName, ref);
        } else {
            if (this.ivDefinitionReferences == null) {
                this.ivDefinitionReferences = new LinkedHashMap<String, Reference>();
            }
            this.ivDefinitionReferences.put(jndiName, ref);
        }
    }

    public synchronized void removeDefinitionReference(String jndiName) {
        if (this.ivDefinitionReferences == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeDefinitionReference: (empty)", (Object[])new Object[0]);
            }
        } else {
            Reference ref = this.ivDefinitionReferences.get(jndiName);
            if (ref == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removeDefinitionReference: " + jndiName + " (unknown)"), (Object[])new Object[0]);
                }
            } else {
                this.destroyDefinitionReference(jndiName, ref);
            }
        }
    }
}

