/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.utils.CollectiveUtilityTraceFormatter;
import com.ibm.ws.collective.utility.utils.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Trlog {
    private static final String className = Trlog.class.getName();
    static Logger tr = Logger.getLogger(className);
    private static int classNameLen = 50;

    public static void setup(String className, IFileUtility fileUtility) {
        try {
            if (fileUtility == null) {
                fileUtility = new FileUtility(System.getenv("WLP_INSTALL_DIR"), System.getenv("WLP_USER_DIR"), System.getenv("WLP_OUTPUT_DIR"));
            }
            FileHandler fileHandler = new FileHandler(fileUtility.getOutputDirectory() + File.separator + "collective.trace.log", true);
            CollectiveUtilityTraceFormatter traceFormatter = new CollectiveUtilityTraceFormatter();
            fileHandler.setFormatter(traceFormatter);
            tr.addHandler(fileHandler);
            fileHandler.setLevel(Level.FINE);
            tr.setLevel(Level.FINE);
            tr.config("\n\n===== Collective Utility Trace setup for " + className + " is done. =====\n");
        }
        catch (IOException ioe) {
            tr.log(Level.SEVERE, "Error occur in FileHandler.", ioe);
        }
        catch (SecurityException se) {
            tr.log(Level.SEVERE, "Error occur in FileHandler.", se);
        }
    }

    public static void enter(String className, String methodName) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " > " + methodName + " ENTRY");
        }
    }

    public static void enter(String className, String methodName, Object param) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " > " + methodName + " ENTRY ", param);
        }
    }

    public static void enter(String className, String methodName, Object[] params) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " > " + methodName + " ENTRY", Trlog.pack(params));
        }
    }

    public static void exit(String className, String methodName) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " < " + methodName + " EXIT");
        }
    }

    public static void exit(String className, String methodName, Object param) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " < " + methodName + " EXIT ", param);
        }
    }

    public static void exit(String className, String methodName, Object[] params) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " < " + methodName + " EXIT", Trlog.pack(params));
        }
    }

    public static void debug(String className, String methodName, String message) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " 3 " + methodName, message);
        }
    }

    public static void debug(String className, String methodName, String message, Object param) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " 3 " + methodName, param);
        }
    }

    public static void debug(String className, String methodName, String message, Object[] params) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " 3 " + methodName, Trlog.pack(params));
        }
    }

    public static void debug(String className, String methodName, String message, Throwable thrown) {
        if (tr.isLoggable(Level.FINE)) {
            tr.log(Level.FINE, Trlog.fixedLenString(className) + " 3 " + methodName + ": " + message, thrown);
        }
    }

    private static String fixedLenString(String str) {
        String fixedLenStr = str;
        int len = str.length();
        if (len > classNameLen) {
            fixedLenStr = str.substring(len - classNameLen, len);
        }
        return String.format("%1$-" + classNameLen + "s", fixedLenStr);
    }

    private static Object[] pack(Object ... params) {
        return params;
    }
}

