/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.filemgr;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.DiskCacheSizeInfo;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.persistent.filemgr.Constants;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.Instrumentation;
import com.ibm.ws.cache.persistent.filemgr.PhysicalFileInterface;
import com.ibm.ws.cache.persistent.util.ProfTimer;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;

public class MultivolumeRAFWrapper
implements PhysicalFileInterface,
Constants,
Instrumentation {
    private static TraceComponent tc = Tr.register(MultivolumeRAFWrapper.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private final Vector physical = new Vector();
    private final FileManager logical;
    String base_filename;
    String mode;
    long seek;
    long volume;
    long offset;
    int type;
    DiskCacheSizeInfo diskCacheSizeInfo;
    static ProfTimer proftimer = new ProfTimer();

    public MultivolumeRAFWrapper(String filename, String mode, FileManager logical, DiskCacheSizeInfo diskCacheSizeInfo) throws IOException {
        this.logical = logical;
        this.base_filename = filename;
        this.mode = mode;
        this.diskCacheSizeInfo = diskCacheSizeInfo;
        this.type = 1;
        String suffix = HTODDynacache.object_suffix;
        if (filename.indexOf(HTODDynacache.dependency_suffix) > 0) {
            this.type = 2;
            suffix = HTODDynacache.dependency_suffix;
        } else if (filename.indexOf(HTODDynacache.template_suffix) > 0) {
            this.type = 3;
            suffix = HTODDynacache.template_suffix;
        }
        boolean vol = false;
        boolean done = false;
        File file = new File(this.base_filename).getAbsoluteFile();
        this.base_filename = file.toString();
        File parent = file.getParentFile();
        File[] files = parent.listFiles();
        int len = files.length;
        for (int i = 0; i < len; ++i) {
            String next;
            if (files[i].isDirectory() || (next = files[i].getPath()).indexOf(suffix) <= 0) continue;
            int ndx = next.lastIndexOf(".");
            String extension = next.substring(ndx + 1);
            try {
                int nextvol = Integer.parseInt(extension);
                this.getVolume(nextvol);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.physical.size() == 0) {
            this.getVolume(0L);
        }
    }

    @Override
    public String filename() {
        return this.base_filename;
    }

    public long cachesize() {
        return 0L;
    }

    public boolean multivolume() {
        return true;
    }

    public int pagesize() {
        return 0;
    }

    public int num_volumes() {
        return this.physical.size();
    }

    public boolean exists(String name) {
        File checkfile = new File(name);
        return checkfile.exists();
    }

    public void setCachePolicy(int policy) throws IOException {
    }

    @Override
    public void update_read_time(long msec) {
        this.logical.update_read_time(msec);
    }

    @Override
    public void update_write_time(long msec) {
        this.logical.update_write_time(msec);
    }

    @Override
    public void increment_read_count() {
        this.logical.increment_read_count();
    }

    @Override
    public void increment_write_count() {
        this.logical.increment_write_count();
    }

    @Override
    public long length() throws IOException {
        int len = this.physical.size();
        int answer = 0;
        for (int i = 0; i < len; ++i) {
            RandomAccessFile raf = (RandomAccessFile)this.physical.get(i);
            if (raf == null) continue;
            answer = (int)((long)answer + raf.length());
        }
        return answer;
    }

    @Override
    public void close() throws IOException {
        int len = this.physical.size();
        boolean answer = false;
        for (int i = 0; i < len; ++i) {
            RandomAccessFile raf = (RandomAccessFile)this.physical.get(i);
            if (raf == null) continue;
            raf.close();
            this.physical.set(i, null);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void seek(long loc) throws IOException {
        if (this.seek != loc) {
            MultivolumeRAFWrapper mrw;
            this.seek = loc;
            this.volume = this.seek / 0x40000000L;
            this.offset = this.seek % 0x40000000L;
            final RandomAccessFile raf = this.getVolume(this.volume);
            IOException ie = (IOException)AccessController.doPrivileged(new PrivilegedAction(){
                final /* synthetic */ MultivolumeRAFWrapper val$mrw;
                {
                    this.val$mrw = multivolumeRAFWrapper;
                }

                public Object run() {
                    try {
                        raf.seek(MultivolumeRAFWrapper.this.offset);
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", (String)"234", (Object)this.val$mrw);
                        return ioe;
                    }
                    return null;
                }
            });
            if (ie != null) {
                throw ie;
            }
        }
    }

    private void incrementSeekBy(long val) throws IOException {
        long newoffset = this.offset + val;
        if (newoffset >= 0x40000000L) {
            this.seek(this.seek + val);
        } else {
            this.offset = newoffset;
            this.seek = this.volume * 0x40000000L + this.offset;
        }
    }

    void makeVolume(long vol) throws IOException {
        String fn = this.base_filename + "." + vol;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("makeVolume(): fileName=" + fn), (Object[])new Object[0]);
        }
        File file = new File(fn);
        RandomAccessFile raf = new RandomAccessFile(fn, this.mode);
        if ((long)this.physical.size() < vol + 1L) {
            this.physical.setSize((int)vol + 1);
        }
        this.physical.set((int)vol, raf);
    }

    RandomAccessFile getVolume(long vol) throws IOException {
        RandomAccessFile answer;
        if ((long)this.physical.size() <= vol) {
            this.makeVolume(vol);
        }
        if ((answer = (RandomAccessFile)this.physical.get((int)vol)) == null) {
            this.makeVolume(vol);
            answer = (RandomAccessFile)this.physical.get((int)vol);
        }
        return answer;
    }

    @Override
    public int read() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int answer = this.getVolume(this.volume).read();
        this.incrementSeekBy(1L);
        this.update_read_time(proftimer.elapsed());
        return answer;
    }

    @Override
    public int read(byte[] v) throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int answer = this.internalRead(v, 0, v.length);
        this.update_read_time(proftimer.elapsed());
        return answer;
    }

    @Override
    public int read(byte[] v, int off, int len) throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int answer = this.internalRead(v, off, len);
        this.update_read_time(proftimer.elapsed());
        return answer;
    }

    protected int internalRead(byte[] v, int off, int len) throws IOException {
        int start = off;
        long spaceavailable = 0x40000000L - this.offset;
        int current = (int)Math.min(spaceavailable, (long)len);
        int answer = 0;
        while (current > 0) {
            answer += this.getVolume(this.volume).read(v, start, current);
            start += current;
            this.incrementSeekBy(current);
            spaceavailable = 0x40000000L - this.offset;
            current = (int)Math.min(spaceavailable, (long)(len -= current));
        }
        return answer;
    }

    @Override
    public int readInt() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int len = 4;
        int answer = 0;
        if (this.offset + (long)len <= 0x40000000L) {
            answer = this.getVolume(this.volume).readInt();
            this.incrementSeekBy(len);
        } else {
            answer = (int)this.readIntOverVolume(len);
        }
        this.update_read_time(proftimer.elapsed());
        return answer;
    }

    @Override
    public long readLong() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int len = 8;
        long answer = 0L;
        if (this.offset + (long)len <= 0x40000000L) {
            answer = this.getVolume(this.volume).readLong();
            this.incrementSeekBy(len);
        } else {
            answer = this.readIntOverVolume(len);
        }
        this.update_read_time(proftimer.elapsed());
        return answer;
    }

    @Override
    public short readShort() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int len = 2;
        short answer = 0;
        if (this.offset + (long)len <= 0x40000000L) {
            answer = this.getVolume(this.volume).readShort();
            this.incrementSeekBy(len);
        } else {
            answer = (short)this.readIntOverVolume(len);
        }
        this.update_read_time(proftimer.elapsed());
        return answer;
    }

    protected long readIntOverVolume(int numbytes) throws IOException {
        long answer = 0L;
        long count = 0x40000000L - this.offset;
        byte[] buf = new byte[numbytes];
        this.internalRead(buf, 0, numbytes);
        int shf = (numbytes - 1) * 8;
        for (int i = 0; i < numbytes; ++i) {
            answer |= (long)(buf[i] << shf);
            ++shf;
        }
        return answer;
    }

    @Override
    public void write(byte[] v) throws IOException {
        proftimer.reset();
        this.internalWrite(v, 0, v.length);
        this.increment_write_count();
        this.update_write_time(proftimer.elapsed());
    }

    @Override
    public void write(byte[] v, int off, int len) throws IOException {
        proftimer.reset();
        this.internalWrite(v, 0, len);
        this.increment_write_count();
        this.update_write_time(proftimer.elapsed());
    }

    protected void internalWrite(byte[] v, int off, int len) throws IOException {
        int start = off;
        long spaceavailable = 0x40000000L - this.offset;
        int current = (int)Math.min(spaceavailable, (long)len);
        while (current > 0) {
            final MultivolumeRAFWrapper mrw = this;
            final byte[] fv = v;
            final int fstart = start;
            final int fcurrent = current;
            IOException ie = (IOException)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        mrw.getVolume(MultivolumeRAFWrapper.this.volume).write(fv, fstart, fcurrent);
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", (String)"463", (Object)mrw);
                        return ioe;
                    }
                    return null;
                }
            });
            if (ie != null) {
                throw ie;
            }
            start += current;
            this.incrementSeekBy(current);
            spaceavailable = 0x40000000L - this.offset;
            current = (int)Math.min(spaceavailable, (long)(len -= current));
        }
    }

    @Override
    public void write(int v) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        final MultivolumeRAFWrapper mrw = this;
        final int fv = v;
        IOException ie = (IOException)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    mrw.getVolume(mrw.volume).write(fv);
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", (String)"499", (Object)mrw);
                    return ioe;
                }
                return null;
            }
        });
        if (ie != null) {
            throw ie;
        }
        this.incrementSeekBy(1L);
        this.update_write_time(proftimer.elapsed());
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        int len = 4;
        if (this.offset + (long)len <= 0x40000000L) {
            final MultivolumeRAFWrapper mrw = this;
            final int fv = v;
            IOException ie = (IOException)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        mrw.getVolume(mrw.volume).writeInt(fv);
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", (String)"499", (Object)mrw);
                        return ioe;
                    }
                    return null;
                }
            });
            this.incrementSeekBy(len);
        } else {
            this.writeIntOverVolume(v, len);
        }
        this.update_write_time(proftimer.elapsed());
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        int len = 8;
        if (this.offset + (long)len <= 0x40000000L) {
            final MultivolumeRAFWrapper mrw = this;
            final long fv = v;
            IOException ie = (IOException)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        mrw.getVolume(mrw.volume).writeLong(fv);
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", (String)"545", (Object)mrw);
                        return ioe;
                    }
                    return null;
                }
            });
            if (ie != null) {
                throw ie;
            }
            this.incrementSeekBy(len);
        } else {
            this.writeIntOverVolume(v, len);
        }
        this.update_write_time(proftimer.elapsed());
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        int len = 2;
        if (this.offset + (long)len <= 0x40000000L) {
            final MultivolumeRAFWrapper mrw = this;
            final short fv = v;
            IOException ie = (IOException)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        mrw.getVolume(mrw.volume).writeShort(fv);
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", (String)"545", (Object)mrw);
                        return ioe;
                    }
                    return null;
                }
            });
            if (ie != null) {
                throw ie;
            }
            this.incrementSeekBy(len);
        } else {
            this.writeIntOverVolume(v, len);
        }
        this.update_write_time(proftimer.elapsed());
    }

    protected void writeIntOverVolume(long v, int numbytes) throws IOException {
        byte[] bytes = new byte[numbytes];
        int shift = (numbytes - 1) * 8;
        for (int i = 0; i < numbytes; ++i) {
            bytes[i] = (byte)((v & (long)(255 << shift)) >> shift);
            shift -= 8;
        }
        this.internalWrite(bytes, 0, numbytes);
    }
}

