/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annotations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annotations.ModuleAnnotations;
import com.ibm.ws.container.service.annotations.SpecificAnnotations;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_Factory;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.anno.classsource.ClassSource_Options;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.InfoStoreException;
import com.ibm.wsspi.anno.info.InfoStoreFactory;
import com.ibm.wsspi.anno.service.AnnotationService_Service;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Factory;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModuleAnnotationsImpl
implements ModuleAnnotations {
    private static final TraceComponent tc = Tr.register(ModuleAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    private final AnnotationService_Service annotationService;
    private final Container rootContainer;
    private final OverlayContainer rootOverlayContainer;
    private final ArtifactContainer rootArtifactContainer;
    private final ModuleInfo moduleInfo;
    private ClassLoader moduleClassLoader = null;
    private ClassSource_Aggregate moduleClassSource = null;
    private AnnotationTargets_Targets moduleAnnotationTargets = null;
    private InfoStore moduleInfoStore = null;
    private String containerName = null;
    static final long serialVersionUID = 3628438709209650432L;

    public ModuleAnnotationsImpl(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt, AnnotationService_Service annotationService) {
        this.annotationService = annotationService;
        this.rootContainer = root;
        this.rootOverlayContainer = rootOverlay;
        this.rootArtifactContainer = artifactContainer;
        this.moduleInfo = this.retrieveFromOverlay(ModuleInfo.class);
        this.moduleClassLoader = this.moduleInfo.getClassLoader();
    }

    private AnnotationService_Service getAnnotationService() {
        return this.annotationService;
    }

    private ClassSource_Factory getClassSourceFactory() {
        return this.getAnnotationService().getClassSourceFactory();
    }

    private AnnotationTargets_Factory getAnnotationTargetsFactory() {
        return this.getAnnotationService().getAnnotationTargetsFactory();
    }

    private InfoStoreFactory getInfoStoreFactory() {
        return this.getAnnotationService().getInfoStoreFactory();
    }

    protected Container getRootContainer() {
        return this.rootContainer;
    }

    private OverlayContainer getRootOverlayContainer() {
        return this.rootOverlayContainer;
    }

    private <T> T retrieveFromOverlay(Class<T> targetClass) {
        Object retrievedInfo = this.getRootOverlayContainer().getFromNonPersistentCache(this.getRootArtifactPath(), targetClass);
        return (T)retrievedInfo;
    }

    private <T> void addToOverlay(Class<T> targetClass, T targetObject) {
        this.getRootOverlayContainer().addToNonPersistentCache(this.getRootArtifactPath(), targetClass, targetObject);
    }

    private ArtifactContainer getRootArtifactContainer() {
        return this.rootArtifactContainer;
    }

    private String getRootArtifactPath() {
        return this.getRootArtifactContainer().getPath();
    }

    private ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    @Override
    public ClassInfo getClassInfo(String className) throws UnableToAdaptException {
        return this.getInfoStore().getDelayableClassInfo(className);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAppClassLoader(ClassLoader appClassLoader) {
        ClassSource_Factory classSourceFactory = this.annotationService.getClassSourceFactory();
        try {
            ApplicationInfo applicationInfo = this.moduleInfo.getApplicationInfo();
            ClassSource_Options options = this.getClassSourceFactory().createOptions();
            options.setUseJandex(applicationInfo.getUseJandex());
            ClassSource_ClassLoader clClassSource = classSourceFactory.createClassLoaderClassSource(this.getClassSource().getInternMap(), this.containerName + " parent classloader", options, appClassLoader);
            this.getClassSource().addClassSource((ClassSource)clClassSource, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
        }
        catch (ClassSource_Exception applicationInfo) {
            void e;
            FFDCFilter.processException((Throwable)applicationInfo, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"219", (Object)this, (Object[])new Object[]{appClassLoader});
            e.getCause();
        }
        catch (UnableToAdaptException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"222", (Object)this, (Object[])new Object[]{appClassLoader});
            e.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassSource_Aggregate getClassSource() throws UnableToAdaptException {
        ClassSource_Aggregate useClassSource;
        if (this.moduleClassSource != null) {
            return this.moduleClassSource;
        }
        this.moduleClassSource = this.retrieveFromOverlay(ClassSource_Aggregate.class);
        if (this.moduleClassSource != null) {
            return this.moduleClassSource;
        }
        this.containerName = this.rootContainer.getName();
        ApplicationInfo applicationInfo = this.moduleInfo.getApplicationInfo();
        ClassSource_Options options = this.getClassSourceFactory().createOptions();
        options.setUseJandex(applicationInfo.getUseJandex());
        try {
            useClassSource = this.getClassSourceFactory().createAggregateClassSource(this.containerName, options);
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"249", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.create.module.class.source.CWWKM0454E", (Object[])new Object[]{"Failed to create module class source", this.containerName, e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        try {
            ModuleClassesContainerInfo moduleClassesContainerInfo = this.getModuleClassesContainerInfo();
            if (moduleClassesContainerInfo == null) {
                String containerClassSourceName = this.containerName + " container";
                ClassSource_MappedContainer containerClassSource = this.getClassSourceFactory().createContainerClassSource(useClassSource.getInternMap(), containerClassSourceName, options, this.moduleInfo.getContainer());
                useClassSource.addClassSource((ClassSource)containerClassSource, ClassSource_Aggregate.ScanPolicy.SEED);
            } else {
                for (ContainerInfo containerInfo : moduleClassesContainerInfo.getClassesContainerInfo()) {
                    if (containerInfo.getType() == ContainerInfo.Type.MANIFEST_CLASSPATH) continue;
                    String name = containerInfo.getName() + " container";
                    ClassSource_MappedContainer containerSource = this.getClassSourceFactory().createContainerClassSource(useClassSource.getInternMap(), name, options, containerInfo.getContainer());
                    useClassSource.addClassSource((ClassSource)containerSource, ClassSource_Aggregate.ScanPolicy.SEED);
                }
            }
            if (this.getModuleClassLoader() != null) {
                ClassSource_ClassLoader clSource = this.getClassSourceFactory().createClassLoaderClassSource(useClassSource.getInternMap(), this.containerName + " parent classloader", options, this.getModuleClassLoader());
                useClassSource.addClassSource((ClassSource)clSource, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
        catch (ClassSource_Exception moduleClassesContainerInfo) {
            void e;
            FFDCFilter.processException((Throwable)moduleClassesContainerInfo, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"288", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.create.module.class.source.CWWKM0455E", (Object[])new Object[]{"Failed to create module class source", this.containerName, e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        this.moduleClassSource = useClassSource;
        this.addToOverlay(ClassSource_Aggregate.class, this.moduleClassSource);
        return this.moduleClassSource;
    }

    /*
     * WARNING - void declaration
     */
    private ModuleClassesContainerInfo getModuleClassesContainerInfo() {
        NonPersistentCache cache;
        Container container = this.moduleInfo.getApplicationInfo().getContainer();
        try {
            cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"304", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
        ApplicationClassesContainerInfo applicationClassesContainerInfo = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
        for (ModuleClassesContainerInfo moduleClassesContainerInfo : applicationClassesContainerInfo.getModuleClassesContainerInfo()) {
            for (ContainerInfo containerInfo : moduleClassesContainerInfo.getClassesContainerInfo()) {
                if (containerInfo.getType() == ContainerInfo.Type.MANIFEST_CLASSPATH || !containerInfo.getContainer().equals(this.rootContainer)) continue;
                return moduleClassesContainerInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AnnotationTargets_Targets getAnnotationTargets() throws UnableToAdaptException {
        AnnotationTargets_Targets useTargets;
        if (this.moduleAnnotationTargets != null) {
            return this.moduleAnnotationTargets;
        }
        this.moduleAnnotationTargets = this.retrieveFromOverlay(AnnotationTargets_Targets.class);
        if (this.moduleAnnotationTargets != null) {
            return this.moduleAnnotationTargets;
        }
        long startTime = this.reportScanStart();
        ClassSource_Aggregate useClassSource = this.getClassSource();
        AnnotationTargets_Factory useTargetsFactory = this.getAnnotationTargetsFactory();
        try {
            useTargets = useTargetsFactory.createTargets();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"344", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0456E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        try {
            useTargets.scan(useClassSource);
        }
        catch (AnnotationTargets_Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"357", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0457E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        this.reportScanEnd(startTime, useTargets);
        this.moduleAnnotationTargets = useTargets;
        this.addToOverlay(AnnotationTargets_Targets.class, this.moduleAnnotationTargets);
        return this.moduleAnnotationTargets;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InfoStore getInfoStore() throws UnableToAdaptException {
        if (this.moduleInfoStore != null) {
            return this.moduleInfoStore;
        }
        this.moduleInfoStore = this.retrieveFromOverlay(InfoStore.class);
        if (this.moduleInfoStore != null) {
            return this.moduleInfoStore;
        }
        ClassSource_Aggregate useClassSource = this.getClassSource();
        try {
            this.moduleInfoStore = this.getInfoStoreFactory().createInfoStore(useClassSource);
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"385", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.info.store.CWWKM0458E", (Object[])new Object[]{"Failed to obtain module info store", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        this.addToOverlay(InfoStore.class, this.moduleInfoStore);
        return this.moduleInfoStore;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpecificAnnotations getSpecificAnnotations(Set<String> specificClassNames) throws UnableToAdaptException {
        AnnotationTargets_Targets specificTargets;
        long startTime = this.reportScanStart();
        ClassSource_Aggregate useClassSource = this.getClassSource();
        AnnotationTargets_Factory useTargetsFactory = this.getAnnotationTargetsFactory();
        try {
            specificTargets = useTargetsFactory.createTargets();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"421", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0459E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        try {
            specificTargets.scan(useClassSource, specificClassNames);
        }
        catch (AnnotationTargets_Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"434", (Object)this, (Object[])new Object[]{specificClassNames});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.obtain.module.annotation.targets.CWWKM0460E", (Object[])new Object[]{"Failed to obtain module annotation targets", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
        this.reportScanEnd(startTime, specificTargets);
        return new SpecificAnnotationsImpl(specificTargets);
    }

    private long reportScanStart() {
        long startTime = this.getTimeInMillis();
        return startTime;
    }

    private void reportScanEnd(long startTime, AnnotationTargets_Targets targetsTable) {
    }

    private long getTimeInMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openInfoStore() throws UnableToAdaptException {
        try {
            this.getInfoStore().open();
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"576", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.open.web.module.info.store.CWWKM0461E", (Object[])new Object[]{"Failed to open web module info store", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeInfoStore() throws UnableToAdaptException {
        try {
            this.getInfoStore().close();
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl", (String)"587", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"failed.to.close.web.module.info.store.CWWKM0462E", (Object[])new Object[]{"Failed to close web module info store", e});
            throw new UnableToAdaptException(msg, (Throwable)e);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SpecificAnnotationsImpl
    implements SpecificAnnotations {
        private final AnnotationTargets_Targets specificTargets;
        static final long serialVersionUID = -506130951976806458L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SpecificAnnotationsImpl(AnnotationTargets_Targets specificTargets) {
            this.specificTargets = specificTargets;
        }

        @Override
        public Set<String> selectAnnotatedClasses(Class<?> annotationClass) throws UnableToAdaptException {
            String annotationClassName = annotationClass.getName();
            Set selectedClassNames = this.specificTargets.getAnnotatedClasses(annotationClassName, AnnotationTargets_Targets.POLICY_SEED);
            return selectedClassNames;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annotations.internal.ModuleAnnotationsImpl$SpecificAnnotationsImpl", SpecificAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }
}

