/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.cm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.PropertyData;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.service.cm.ConfigurationAdminMBean;
import org.osgi.service.cm.Configuration;

public class ConfigurationAdmin
implements ConfigurationAdminMBean {
    private org.osgi.service.cm.ConfigurationAdmin configurationAdmin;

    public ConfigurationAdmin(org.osgi.service.cm.ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public String createFactoryConfiguration(String factoryPid) throws IOException {
        return this.createFactoryConfigurationForLocation(factoryPid, null);
    }

    public String createFactoryConfigurationForLocation(String factoryPid, String location) throws IOException {
        if (factoryPid == null || factoryPid.length() < 1) {
            throw new IOException("Argument factoryPid cannot be null or empty");
        }
        Configuration config = this.configurationAdmin.createFactoryConfiguration(factoryPid);
        config.setBundleLocation(location);
        return config.getPid();
    }

    public void delete(String pid) throws IOException {
        this.deleteForLocation(pid, null);
    }

    public void deleteForLocation(String pid, String location) throws IOException {
        if (pid == null || pid.length() < 1) {
            throw new IOException("Argument pid cannot be null or empty");
        }
        Configuration config = this.configurationAdmin.getConfiguration(pid, location);
        config.delete();
    }

    public void deleteConfigurations(String filter) throws IOException {
        if (filter == null || filter.length() < 1) {
            throw new IOException("Argument filter cannot be null or empty");
        }
        Configuration[] configuations = null;
        try {
            configuations = this.configurationAdmin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter [" + filter + "] : " + (Object)((Object)e));
        }
        if (configuations != null) {
            for (Configuration config : configuations) {
                config.delete();
            }
        }
    }

    public String getBundleLocation(String pid) throws IOException {
        if (pid == null || pid.length() < 1) {
            throw new IOException("Argument pid cannot be null or empty");
        }
        Configuration config = this.configurationAdmin.getConfiguration(pid, null);
        String bundleLocation = config.getBundleLocation() == null ? "Configuration is not yet bound to a bundle location" : config.getBundleLocation();
        return bundleLocation;
    }

    public String[][] getConfigurations(String filter) throws IOException {
        if (filter == null || filter.length() < 1) {
            throw new IOException("Argument filter cannot be null or empty");
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        Configuration[] configurations = null;
        try {
            configurations = this.configurationAdmin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter [" + filter + "] : " + (Object)((Object)e));
        }
        if (configurations != null) {
            for (Configuration config : configurations) {
                result.add(new String[]{config.getPid(), config.getBundleLocation()});
            }
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    public String getFactoryPid(String pid) throws IOException {
        return this.getFactoryPidForLocation(pid, null);
    }

    public String getFactoryPidForLocation(String pid, String location) throws IOException {
        if (pid == null || pid.length() < 1) {
            throw new IOException("Argument pid cannot be null or empty");
        }
        Configuration config = this.configurationAdmin.getConfiguration(pid, location);
        return config.getFactoryPid();
    }

    public TabularData getProperties(String pid) throws IOException {
        return this.getPropertiesForLocation(pid, null);
    }

    public TabularData getPropertiesForLocation(String pid, String location) throws IOException {
        if (pid == null || pid.length() < 1) {
            throw new IOException("Argument pid cannot be null or empty");
        }
        TabularDataSupport propertiesTable = null;
        Configuration config = this.configurationAdmin.getConfiguration(pid, location);
        Dictionary properties = config.getProperties();
        if (properties != null) {
            propertiesTable = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                propertiesTable.put(PropertyData.newInstance(key, properties.get(key)).toCompositeData());
            }
        }
        return propertiesTable;
    }

    public void setBundleLocation(String pid, String location) throws IOException {
        if (pid == null || pid.length() < 1) {
            throw new IOException("Argument factoryPid cannot be null or empty");
        }
        Configuration config = this.configurationAdmin.getConfiguration(pid, null);
        config.setBundleLocation(location);
    }

    public void update(String pid, TabularData configurationTable) throws IOException {
        this.updateForLocation(pid, null, configurationTable);
    }

    public void updateForLocation(String pid, String location, TabularData configurationTable) throws IOException {
        if (pid == null || pid.length() < 1) {
            throw new IOException("Argument pid cannot be null or empty");
        }
        if (configurationTable == null) {
            throw new IOException("Argument configurationTable cannot be null");
        }
        if (!JmxConstants.PROPERTIES_TYPE.equals(configurationTable.getTabularType())) {
            throw new IOException("Invalid TabularType [" + configurationTable.getTabularType() + "]");
        }
        Hashtable configurationProperties = new Hashtable();
        Collection<?> compositeData = configurationTable.values();
        for (CompositeData row : compositeData) {
            PropertyData propertyData = PropertyData.from(row);
            ((Dictionary)configurationProperties).put(propertyData.getKey(), propertyData.getValue());
        }
        Configuration config = this.configurationAdmin.getConfiguration(pid, location);
        config.update(configurationProperties);
    }
}

