/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install;

public class Version {
    private final int major;
    private final int minor;
    private final int micro;
    private String qualifier = "";
    private int hashCode = 0;

    public Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        if (qualifier != null) {
            this.qualifier = qualifier;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return this.major == v.major && this.minor == v.minor && this.micro == v.micro && this.qualifier.equals(v.qualifier);
    }

    public int compareTo(Version v) {
        if (this == v) {
            return 0;
        }
        int diff = this.major - v.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - v.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.micro - v.micro;
        if (diff != 0) {
            return diff;
        }
        return this.qualifier.compareTo(v.qualifier);
    }

    public static Version createVersion(String vStr) {
        if (vStr == null || vStr.isEmpty()) {
            return null;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        String[] v = vStr.split("\\.", 4);
        try {
            if (v.length > 0) {
                major = Integer.valueOf(v[0]);
            }
            if (v.length > 1) {
                minor = Integer.valueOf(v[1]);
            }
            if (v.length > 2) {
                micro = Integer.valueOf(v[2]);
            }
            if (v.length > 3) {
                qualifier = v[3];
            }
            return new Version(major, minor, micro, qualifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = ((this.major * 100 + this.minor) * 100 + this.micro) * 100;
            if (this.qualifier != null) {
                this.hashCode += this.qualifier.hashCode() % 100;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro + (this.qualifier.isEmpty() ? "" : "." + this.qualifier);
    }
}

