/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigParser {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private final Path serverXML;
    private final Map<String, String> varMap;
    private final String wlpDir = Utils.getInstallDir().toString();
    private final String wlpUsrDir = this.wlpDir + "/usr";
    private final String userExtensionDir = this.wlpUsrDir + "/extension";
    private final String sharedAppDir = this.wlpUsrDir + "/shared/apps";
    private final String sharedConfigDir = this.wlpUsrDir + "/shared/config";
    private final String sharedResourceDir = this.wlpUsrDir + "/shared/resources";
    private final String sharedStackGroupsDir = this.wlpUsrDir + "/shared/stackGroups";

    public ConfigParser(Path serverXML, Map<String, String> varMap) throws IOException {
        this.serverXML = serverXML;
        this.varMap = this.populateMap(serverXML, varMap);
    }

    private Map<String, String> populateMap(Path serverXML, Map<String, String> vmap) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String serverName = serverXML.getParent().getFileName().toString();
        result.putAll(System.getenv());
        result.putAll(this.generateWlpBasedMap(serverName));
        result.putAll(this.parseBootstrapProps(serverName));
        result.putAll(vmap);
        return result;
    }

    private Map<String, String> parseBootstrapProps(String serverName) throws IOException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String bootstrapProps = this.wlpUsrDir + "/servers/" + serverName + "/bootstrap.properties";
        File bootstrapPropsFile = new File(bootstrapProps);
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(bootstrapPropsFile);){
            properties.load(input);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.FINE, "file not found for bootstrap.properties under server: " + serverName);
        }
        Set<Object> keys = properties.keySet();
        for (Object k : keys) {
            String kstr = (String)k;
            resultMap.put(kstr, properties.getProperty(kstr));
        }
        return resultMap;
    }

    private Map<String, String> generateWlpBasedMap(String serverName) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("wlp.install.dir", this.wlpDir);
        resultMap.put("wlp.user.dir", this.wlpUsrDir);
        resultMap.put("usr.extension.dir", this.userExtensionDir);
        resultMap.put("shared.app.dir", this.sharedAppDir);
        resultMap.put("shared.config.dir", this.sharedConfigDir);
        resultMap.put("shared.resource.dir", this.sharedResourceDir);
        resultMap.put("shared.stackgroup.dir", this.sharedStackGroupsDir);
        resultMap.put("server.config.dir", this.wlpUsrDir + "/servers/" + serverName);
        resultMap.put("server.output.dir", this.wlpUsrDir + "/servers/" + serverName);
        return resultMap;
    }

    public String resolvePath(String path) {
        String[] splitPath;
        String result = "/";
        for (String s : splitPath = path.split("/")) {
            String accumulator = "";
            if (s.startsWith("$")) {
                if ((s = s.replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\\$", "")).contains("+")) {
                    String[] splitOnAddition;
                    for (String t : splitOnAddition = s.split("\\+")) {
                        accumulator = t.contains("env.") ? accumulator + System.getenv().get(t.replace("env.", "")) + "/" : accumulator + this.varMap.get(t) + "/";
                    }
                } else {
                    accumulator = s.contains("env.") ? accumulator + System.getenv().get(s.replace("env.", "")) + "/" : accumulator + this.varMap.get(s) + "/";
                }
            } else {
                accumulator = s.contains(".xml") ? accumulator + s : accumulator + s + "/";
            }
            result = result + accumulator;
        }
        if (result.startsWith("//")) {
            result.replaceFirst("/", "");
        }
        if (result.contains("${")) {
            result = this.resolvePath(result);
        }
        return result;
    }
}

