/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public abstract class ServerCommand {
    protected static final String STATUS_START_COMMAND = "status:start";
    protected static final String STOP_COMMAND = "stop";
    protected static final String FORCE_STOP_COMMAND = "forceStop";
    protected static final String INTROSPECT_COMMAND = "introspect";
    protected static final String INTROSPECT_JAVADUMP_COMMAND = "introspectJavadump";
    protected static final String JAVADUMP_COMMAND = "javadump";
    protected static final String PAUSE_COMMAND = "pause";
    protected static final String RESUME_COMMAND = "resume";
    protected static final Charset charset = Charset.forName("ISO-8859-1");
    private final CharsetDecoder decoder = charset.newDecoder();
    private final CharsetEncoder encoder = charset.newEncoder();
    private final ByteBuffer buffer = ByteBuffer.allocate(256);
    private final CharBuffer charBuffer = CharBuffer.allocate(256);
    protected String serverUUID;
    protected final File commandFile;
    protected final File commandAuthDir;

    public ServerCommand(BootstrapConfig bootProps) {
        this.commandFile = bootProps.getWorkareaFile(".sCommand");
        this.commandAuthDir = bootProps.getWorkareaFile(".sCommandAuth");
    }

    protected String read(SocketChannel sc) throws IOException {
        sc.read(this.buffer);
        this.buffer.flip();
        this.decoder.decode(this.buffer, this.charBuffer, true);
        this.charBuffer.flip();
        String result = this.charBuffer.toString();
        this.buffer.clear();
        this.charBuffer.clear();
        this.decoder.reset();
        return result;
    }

    protected void write(SocketChannel sc, String s) throws IOException {
        sc.write(this.encoder.encode(CharBuffer.wrap(s)));
    }

    public class ServerCommandID {
        private static final char OPERATION_DELIMITER = ',';
        private static final char PORT_DELIMITER = ':';
        private String uuid = null;
        private int port;
        private String operation;

        public ServerCommandID(String uuidAndPort, String operation) {
            int idx = uuidAndPort.indexOf(58);
            if (idx == -1) {
                return;
            }
            this.uuid = uuidAndPort.substring(0, idx);
            this.port = Integer.valueOf(uuidAndPort.substring(idx + 1));
            this.operation = operation;
        }

        public ServerCommandID(String uuidAndCommand) {
            int idx = uuidAndCommand.indexOf(44);
            if (idx == -1) {
                return;
            }
            this.uuid = uuidAndCommand.substring(0, idx);
            this.operation = uuidAndCommand.substring(idx + 1);
        }

        public ServerCommandID(int port, String uuid) {
            this.port = port;
            this.uuid = uuid;
        }

        public String getCommandString() {
            return this.uuid + ',' + this.operation;
        }

        public String getIDString() {
            return this.uuid + ':' + this.port;
        }

        public int getPort() {
            return this.port;
        }

        public String getOperation() {
            return this.operation;
        }

        public boolean validate() {
            return ServerCommand.this.serverUUID.equals(this.uuid);
        }

        public boolean validateTarget(String targetServerUUID) {
            return targetServerUUID.equals(this.uuid);
        }

        public String getUUID() {
            return this.uuid;
        }
    }
}

