/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.ScheduledExecutorImpl;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class SchedulingRunnableFixedHelper<V>
implements ScheduledFuture<Object>,
Runnable {
    ScheduledExecutorImpl m_scheduledExecutor;
    protected Runnable m_runnable;
    volatile boolean m_isDone = false;
    volatile boolean m_cancelResult = false;
    ScheduledFuture<?> m_schedFuture;
    CountDownLatch m_coordinationLatch;
    Exception m_pendingException = null;
    private final long m_periodInterval;
    private final boolean m_scheduledWithDelay;
    private long m_myNextExecutionTime;
    static final long serialVersionUID = -1123135557715303315L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SchedulingRunnableFixedHelper(boolean scheduledWithDelay, Runnable inRunnable, ScheduledExecutorImpl inExecutor, long initialDelay, long period, TimeUnit unit) {
        this.m_scheduledExecutor = inExecutor;
        this.m_runnable = inRunnable;
        this.m_coordinationLatch = new CountDownLatch(1);
        this.m_schedFuture = null;
        this.m_pendingException = null;
        this.m_scheduledWithDelay = scheduledWithDelay;
        this.m_periodInterval = TimeUnit.NANOSECONDS.convert(period, unit);
        if (!this.m_scheduledWithDelay) {
            long currentTime = System.nanoTime();
            this.m_myNextExecutionTime = currentTime + TimeUnit.NANOSECONDS.convert(initialDelay, unit);
        }
    }

    protected void setScheduledFuture(ScheduledFuture<?> schedFuture) {
        this.m_schedFuture = schedFuture;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SchedulingRunnableFixedHelper: ");
        sb.append("m_runnable: " + (this.m_runnable != null ? this.m_runnable.toString() : "null"));
        sb.append(", m_isDone: " + this.m_isDone);
        sb.append(", m_cancelResult: " + this.m_cancelResult);
        sb.append(", m_coordinationLatch: " + (this.m_coordinationLatch != null ? this.m_coordinationLatch.toString() : "null"));
        sb.append(", m_pendingException: " + this.m_pendingException);
        sb.append(", m_periodInterval(ns): " + this.m_periodInterval);
        sb.append(", m_scheduledWithDelay: " + this.m_scheduledWithDelay);
        sb.append(", m_myNextExecutionTime(ns): " + this.m_myNextExecutionTime + " (" + (this.m_myNextExecutionTime != 0L ? new Date((this.m_myNextExecutionTime + 999999L) / 1000000L) : "NA") + ")");
        return sb.toString();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.m_isDone) {
            return false;
        }
        this.m_isDone = true;
        try {
            this.m_cancelResult = this.m_schedFuture.cancel(mayInterruptIfRunning);
            this.m_pendingException = new CancellationException();
        }
        finally {
            this.m_coordinationLatch.countDown();
        }
        return this.m_cancelResult;
    }

    @Override
    public boolean isDone() {
        return this.m_isDone || this.m_pendingException != null;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.m_coordinationLatch.await();
        if (this.m_pendingException != null) {
            if (this.m_pendingException instanceof ExecutionException) {
                throw (ExecutionException)this.m_pendingException;
            }
            throw (RuntimeException)this.m_pendingException;
        }
        throw new CancellationException();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.m_coordinationLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.m_pendingException != null) {
            if (this.m_pendingException instanceof ExecutionException) {
                throw (ExecutionException)this.m_pendingException;
            }
            throw (RuntimeException)this.m_pendingException;
        }
        throw new CancellationException();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.m_schedFuture.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.m_schedFuture.compareTo(o);
    }

    public boolean equals(Object o) {
        return this.m_schedFuture.equals(o);
    }

    public int hashCode() {
        return this.m_schedFuture.hashCode();
    }

    @Override
    public boolean isCancelled() {
        return this.m_cancelResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.m_pendingException != null) {
            return;
        }
        try {
            this.m_runnable.run();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.threading.internal.SchedulingRunnableFixedHelper", (String)"273", (Object)this, (Object[])new Object[0]);
            this.m_pendingException = new ExecutionException((Throwable)e);
            this.m_coordinationLatch.countDown();
            return;
        }
        try {
            long scheduleTime = this.m_periodInterval;
            if (!this.m_scheduledWithDelay) {
                this.m_myNextExecutionTime += this.m_periodInterval;
                long currentTime = System.nanoTime();
                scheduleTime = this.m_myNextExecutionTime > currentTime ? this.m_myNextExecutionTime - currentTime : 0L;
            }
            this.m_schedFuture = this.m_scheduledExecutor.schedule(this, scheduleTime, TimeUnit.NANOSECONDS);
        }
        catch (Exception scheduleTime) {
            void e;
            FFDCFilter.processException((Throwable)scheduleTime, (String)"com.ibm.ws.threading.internal.SchedulingRunnableFixedHelper", (String)"289", (Object)this, (Object[])new Object[0]);
            this.m_pendingException = e;
            this.m_coordinationLatch.countDown();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.SchedulingRunnableFixedHelper", SchedulingRunnableFixedHelper.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    }
}

