/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.StringValueFactory;
import org.apache.yoko.orb.CORBA.WStringValueFactory;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.util.cmsf.RepIds;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.ValueFactory;

public final class ValueFactoryManager {
    static final Logger logger = Logger.getLogger(ValueFactoryManager.class.getName());
    private Hashtable factories_ = new Hashtable(1023);
    private Hashtable classFactories_ = new Hashtable(1023);
    private boolean destroy_;

    protected void finalize() throws Throwable {
        Assert.ensure(this.destroy_);
        super.finalize();
    }

    synchronized void destroy() {
        Assert.ensure(!this.destroy_);
        this.factories_ = null;
    }

    public ValueFactoryManager() {
        this.registerValueFactory(StringValueHelper.id(), new StringValueFactory());
        this.registerValueFactory(WStringValueHelper.id(), new WStringValueFactory());
    }

    public synchronized ValueFactory registerValueFactory(String id, ValueFactory factory) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert.ensure(id != null && factory != null);
        ValueFactory old = (ValueFactory)this.factories_.get(id);
        this.factories_.put(id, factory);
        return old;
    }

    public synchronized void unregisterValueFactory(String id) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert.ensure(id != null);
        if (this.factories_.remove(id) == null) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446337) + ": " + id, 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized ValueFactory lookupValueFactory(String id) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert.ensure(id != null);
        return (ValueFactory)this.factories_.get(id);
    }

    public ValueFactory lookupValueFactoryWithClass(String id) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert.ensure(id != null);
        logger.fine("Looking up value factory for class " + id);
        ValueFactory result = (ValueFactory)this.factories_.get(id);
        if (result != null) {
            logger.finer("Returning registered value factory " + result.getClass().getName());
            return result;
        }
        result = (ValueFactory)this.classFactories_.get(id);
        if (result != null) {
            logger.finer("Returning cached value factory " + result.getClass().getName());
            return result;
        }
        Class c = RepIds.query((String)id).suffix("DefaultFactory").toClass();
        if (c != null) {
            try {
                logger.finer("Attempting to create value factory from class " + c.getName());
                result = (ValueFactory)c.newInstance();
                this.classFactories_.put(id, result);
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }
}

