/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.impl;

import com.ibm.xml.xlxp2.jaxb.marshal.MarshallerImpl;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.AbstractGeneratedSerializationStubFactory;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.BufferedOutput;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.NSContext;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationStub;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationStubFactory;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.ValueWriter;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SerializationContext {
    private static final byte[] XSI_NIL_FRAGMENT;
    private static final byte[] XMLNS_FRAGMENT;
    public final MarshallerImpl marshaller;
    public final JAXBModel model;
    public final SerializationStubFactory stubFactory;
    public final SerializationStub rootStub;
    public final AbstractGeneratedSerializationStubFactory.XSITypeStub xsiTypeStub;
    public final SerializationStub[] stubs;
    public final ValueClass[] valueClasses;
    public final boolean[] substitutions;
    public final BufferedOutput output;
    private DOMImplementationLS domImplLS;
    private LSSerializer domSerializer;
    public boolean needToCheckIsXOPPackage;
    private boolean isXOPPackage;
    private String currentElementNamespaceURI = "";
    private String currentElementLocalName = "";

    public SerializationContext(JAXBModel jAXBModel, SerializationStubFactory serializationStubFactory, MarshallerImpl marshallerImpl) {
        this.model = jAXBModel;
        this.stubFactory = serializationStubFactory;
        this.marshaller = marshallerImpl;
        this.rootStub = serializationStubFactory.createRootStub(jAXBModel);
        this.rootStub.setContext(this);
        this.xsiTypeStub = new AbstractGeneratedSerializationStubFactory.XSITypeStub();
        this.xsiTypeStub.setContext(this);
        this.stubs = ArrayAllocator.newObjectArray(SerializationStub.class, jAXBModel.valueClassCount);
        this.valueClasses = jAXBModel.valueClasses;
        this.substitutions = jAXBModel.substitutions;
        this.output = new BufferedOutput(new NSContext(jAXBModel.nsContext));
    }

    public SerializationStub getSerializationStub(int n) {
        SerializationStub serializationStub = this.stubs[n];
        if (serializationStub != null) {
            return serializationStub;
        }
        serializationStub = this.stubFactory.createStub(this.valueClasses[n], this.model);
        serializationStub.setContext(this);
        this.stubs[n] = serializationStub;
        return serializationStub;
    }

    public SerializationStub getSerializationStub(int n, Object object) {
        if (this.substitutions == null || !this.substitutions[n]) {
            return this.getSerializationStub(n);
        }
        return this.getSerializationStub0(n, object);
    }

    private SerializationStub getSerializationStub0(int n, Object object) {
        int n2 = this.getClassIdentifier(object);
        if (n2 >= 0) {
            SerializationStub serializationStub = this.getSerializationStub(n2);
            if (n != n2) {
                this.xsiTypeStub.setDelegate(serializationStub);
                serializationStub = this.xsiTypeStub;
            }
            return serializationStub;
        }
        return this.getSerializationStub(n);
    }

    public int getElementDeclarationIndex(Object object) {
        return this.getObjectIndex(object, this.model.rootType2GlobalElementMap);
    }

    public int getClassIdentifier(Object object) {
        return this.getObjectIndex0(object, this.model.type2IDMap);
    }

    public int getObjectIndex(Object object, Map<Class<?>, Integer> map) {
        Class<?> clazz = object != null ? object.getClass() : null;
        Integer n = map.get(clazz);
        if (n != null) {
            return n;
        }
        return this.getObjectIndex(clazz, map);
    }

    private int getObjectIndex(Class<?> clazz, Map<Class<?>, Integer> map) {
        int n = -1;
        if (clazz != null) {
            for (Map.Entry<Class<?>, Integer> entry : map.entrySet()) {
                Class<?> clazz2 = entry.getKey();
                if (clazz2 == null || !clazz2.isAssignableFrom(clazz)) continue;
                n = entry.getValue();
                if (clazz2 == Object.class) continue;
                return n;
            }
        }
        return n;
    }

    private int getObjectIndex0(Object object, Map<Class<?>, Integer> map) {
        Class<?> clazz = object.getClass();
        Integer n = map.get(clazz);
        if (n != null) {
            return n;
        }
        return this.getObjectIndex0(clazz, map);
    }

    private int getObjectIndex0(Class<?> clazz, Map<Class<?>, Integer> map) {
        for (Map.Entry<Class<?>, Integer> entry : map.entrySet()) {
            Class<?> clazz2 = entry.getKey();
            if (!clazz2.isAssignableFrom(clazz) || clazz2 == Object.class) continue;
            return entry.getValue();
        }
        return -1;
    }

    public int getRootQNameIndex(JAXBElement<?> jAXBElement) {
        return this.getQNameIndex(jAXBElement, this.model.qName2GlobalElementMap);
    }

    public int getQNameIndex(JAXBElement<?> jAXBElement, Map<QName, Integer> map) {
        QName qName = jAXBElement.getName();
        Integer n = map.get(qName);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public QName getSchemaTypeName(Object object) {
        Class<?> clazz = object.getClass();
        QName qName = this.model.globalType2NameMap.get(clazz);
        if (qName != null) {
            return qName;
        }
        if (object instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)object).getXMLSchemaType();
        }
        return this.getSchemaTypeName(clazz);
    }

    private QName getSchemaTypeName(Class<?> clazz) {
        for (Map.Entry<Class<?>, QName> entry : this.model.globalType2NameMap.entrySet()) {
            Class<?> clazz2 = entry.getKey();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    public final void pushNSContext() {
        this.output.nsContext.push();
    }

    public final void popNSContext() {
        this.output.nsContext.pop();
    }

    public int getPrefixAndDeclareNS(QName qName) throws IOException {
        return this.getPrefixAndDeclareNS(qName, true);
    }

    public int getPrefixAndDeclareNS(QName qName, boolean bl) throws IOException {
        NSContext nSContext = this.output.nsContext;
        String string = qName.getNamespaceURI();
        if (string.length() == 0) {
            return -2;
        }
        int n = nSContext.getPrefix(string, bl);
        if (n != -1) {
            return n;
        }
        n = nSContext.addPrefix(string);
        this.writeNSDeclaration(string, n);
        return n;
    }

    public int[] getPrefixesAndDeclareNS(Collection<QName> collection) throws IOException {
        int n = collection.size();
        int[] nArray = new int[n];
        int n2 = 0;
        for (QName qName : collection) {
            nArray[n2++] = qName != null ? this.getPrefixAndDeclareNS(qName) : -1;
        }
        return nArray;
    }

    public int[] getPrefixesAndDeclareNS(List<QName> list) throws IOException {
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            QName qName = list.get(i);
            nArray[i] = qName != null ? this.getPrefixAndDeclareNS(qName) : -1;
        }
        return nArray;
    }

    public int getPrefixDeclareNSAndWriteQName(QName qName) throws IOException {
        NSContext nSContext = this.output.nsContext;
        String string = qName.getNamespaceURI();
        if (string.length() == 0) {
            this.writeQNameAttributeValue(qName, -2);
            return -2;
        }
        int n = nSContext.getPrefix(string, true);
        if (n != -1) {
            this.writeQNameAttributeValue(qName, n);
            return n;
        }
        n = nSContext.addPrefix(string);
        this.writeQNameAttributeValue(qName, n);
        this.writeNSDeclaration(string, n);
        return n;
    }

    private void writeNSDeclaration(String string, int n) throws IOException {
        NSContext nSContext = this.output.nsContext;
        this.writeRawBytes(XMLNS_FRAGMENT);
        if (n < 0) {
            this.writeRawByte((byte)(-n));
        } else {
            this.writeRawBytes(nSContext.getPrefix(n));
        }
        this.writeRawByte((byte)61);
        this.writeRawByte((byte)34);
        this.writeStringAttributeValue(string);
        this.writeRawByte((byte)34);
    }

    public final void writeRawByte(byte by) throws IOException {
        this.output.write(by);
    }

    public final void writeRawBytes(byte[] byArray) throws IOException {
        this.output.write(byArray);
    }

    public final void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        this.output.write(byArray, n, n2);
    }

    public final void writeRawBytesMinusOne(byte[] byArray) throws IOException {
        this.output.write(byArray, 0, byArray.length - 1);
    }

    public final void writeXSINilFragment() throws IOException {
        this.output.write(XSI_NIL_FRAGMENT);
    }

    public final void writeXSINilFragmentMinusTwo() throws IOException {
        this.output.write(XSI_NIL_FRAGMENT, 0, XSI_NIL_FRAGMENT.length - 2);
    }

    public final void writeStringAttributeValue(String string) throws IOException {
        ValueWriter.writeStringAttr(this.output, string);
    }

    public final void writeStringAttributeListValue(List<String> list) throws IOException {
        ValueWriter.writeStringAttrList(this.output, list);
    }

    public final void writeStringAttributeCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringAttrCollection(this.output, collection);
    }

    public final void writeNormalizedStringAttributeValue(String string) throws IOException {
        ValueWriter.writeStringAttr(this.output, string);
    }

    public final void writeNormalizedStringAttributeListValue(List<String> list) throws IOException {
        ValueWriter.writeStringAttrList(this.output, list);
    }

    public final void writeNormalizedStringAttributeCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringAttrCollection(this.output, collection);
    }

    public final void writeTokenAttributeValue(String string) throws IOException {
        ValueWriter.writeStringAttr(this.output, string);
    }

    public final void writeTokenAttributeListValue(List<String> list) throws IOException {
        ValueWriter.writeStringAttrList(this.output, list);
    }

    public final void writeTokenAttributeCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringAttrCollection(this.output, collection);
    }

    public final void writeStringElementValue(String string) throws IOException {
        ValueWriter.writeStringElem(this.output, string);
    }

    public final void writeStringElementListValue(List<String> list) throws IOException {
        ValueWriter.writeStringElemList(this.output, list);
    }

    public final void writeStringElementCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringElemCollection(this.output, collection);
    }

    public final void writeNormalizedStringElementValue(String string) throws IOException {
        ValueWriter.writeStringElem(this.output, string);
    }

    public final void writeNormalizedStringElementListValue(List<String> list) throws IOException {
        ValueWriter.writeStringElemList(this.output, list);
    }

    public final void writeNormalizedStringElementCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringElemCollection(this.output, collection);
    }

    public final void writeTokenElementValue(String string) throws IOException {
        ValueWriter.writeStringElem(this.output, string);
    }

    public final void writeTokenElementListValue(List<String> list) throws IOException {
        ValueWriter.writeStringElemList(this.output, list);
    }

    public final void writeTokenElementCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringElemCollection(this.output, collection);
    }

    public final void writeIDAttributeValue(String string) throws IOException {
        ValueWriter.writeStringAttr(this.output, string);
    }

    public final void writeIDAttributeListValue(List<String> list) throws IOException {
        ValueWriter.writeStringAttrList(this.output, list);
    }

    public final void writeIDAttributeCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringAttrCollection(this.output, collection);
    }

    public final void writeIDElementValue(String string) throws IOException {
        ValueWriter.writeStringElem(this.output, string);
    }

    public final void writeIDElementListValue(List<String> list) throws IOException {
        ValueWriter.writeStringElemList(this.output, list);
    }

    public final void writeIDElementCollectionValue(Collection<String> collection) throws IOException {
        ValueWriter.writeStringElemCollection(this.output, collection);
    }

    public final void writeBooleanValue(boolean bl) throws IOException {
        ValueWriter.writeBooleanElem(this.output, bl);
    }

    public final void writeBooleanObjectValue(Boolean bl) throws IOException {
        ValueWriter.writeBooleanElem(this.output, bl);
    }

    public final void writeBooleanObjectListValue(List<Boolean> list) throws IOException {
        ValueWriter.writeBooleanElemList(this.output, list);
    }

    public final void writeBooleanObjectCollectionValue(Collection<Boolean> collection) throws IOException {
        ValueWriter.writeBooleanElemCollection(this.output, collection);
    }

    public final void writeBigDecimalValue(BigDecimal bigDecimal) throws IOException {
        ValueWriter.writeBigDecimalElem(this.output, bigDecimal);
    }

    public final void writeBigDecimalListValue(List<BigDecimal> list) throws IOException {
        ValueWriter.writeBigDecimalElemList(this.output, list);
    }

    public final void writeBigDecimalCollectionValue(Collection<BigDecimal> collection) throws IOException {
        ValueWriter.writeBigDecimalElemCollection(this.output, collection);
    }

    public final void writeBigIntegerValue(BigInteger bigInteger) throws IOException {
        ValueWriter.writeBigIntegerElem(this.output, bigInteger);
    }

    public final void writeBigIntegerListValue(List<BigInteger> list) throws IOException {
        ValueWriter.writeBigIntegerElemList(this.output, list);
    }

    public final void writeBigIntegerCollectionValue(Collection<BigInteger> collection) throws IOException {
        ValueWriter.writeBigIntegerElemCollection(this.output, collection);
    }

    public final void writeLongValue(long l) throws IOException {
        ValueWriter.writeLongElem(this.output, l);
    }

    public final void writeLongObjectValue(Long l) throws IOException {
        ValueWriter.writeLongElem(this.output, l);
    }

    public final void writeLongObjectListValue(List<Long> list) throws IOException {
        ValueWriter.writeLongElemList(this.output, list);
    }

    public final void writeLongObjectCollectionValue(Collection<Long> collection) throws IOException {
        ValueWriter.writeLongElemCollection(this.output, collection);
    }

    public final void writeIntValue(int n) throws IOException {
        ValueWriter.writeIntElem(this.output, n);
    }

    public final void writeIntegerObjectValue(Integer n) throws IOException {
        ValueWriter.writeIntegerElem(this.output, n);
    }

    public final void writeIntegerObjectListValue(List<Integer> list) throws IOException {
        ValueWriter.writeIntegerElemList(this.output, list);
    }

    public final void writeIntegerObjectCollectionValue(Collection<Integer> collection) throws IOException {
        ValueWriter.writeIntegerElemCollection(this.output, collection);
    }

    public final void writeShortValue(short s) throws IOException {
        ValueWriter.writeShortElem(this.output, s);
    }

    public final void writeShortObjectValue(Short s) throws IOException {
        ValueWriter.writeShortElem(this.output, s);
    }

    public final void writeShortObjectListValue(List<Short> list) throws IOException {
        ValueWriter.writeShortElemList(this.output, list);
    }

    public final void writeShortObjectCollectionValue(Collection<Short> collection) throws IOException {
        ValueWriter.writeShortElemCollection(this.output, collection);
    }

    public final void writeByteValue(byte by) throws IOException {
        ValueWriter.writeByteElem(this.output, by);
    }

    public final void writeByteObjectValue(Byte by) throws IOException {
        ValueWriter.writeByteElem(this.output, by);
    }

    public final void writeByteObjectListValue(List<Byte> list) throws IOException {
        ValueWriter.writeByteElemList(this.output, list);
    }

    public final void writeByteObjectCollectionValue(Collection<Byte> collection) throws IOException {
        ValueWriter.writeByteElemCollection(this.output, collection);
    }

    public final void writeFloatValue(float f) throws IOException {
        ValueWriter.writeFloatElem(this.output, f);
    }

    public final void writeFloatObjectValue(Float f) throws IOException {
        ValueWriter.writeFloatElem(this.output, f);
    }

    public final void writeFloatObjectListValue(List<Float> list) throws IOException {
        ValueWriter.writeFloatElemList(this.output, list);
    }

    public final void writeFloatObjectCollectionValue(Collection<Float> collection) throws IOException {
        ValueWriter.writeFloatElemCollection(this.output, collection);
    }

    public final void writeDoubleValue(double d) throws IOException {
        ValueWriter.writeDoubleElem(this.output, d);
    }

    public final void writeDoubleObjectValue(Double d) throws IOException {
        ValueWriter.writeDoubleElem(this.output, d);
    }

    public final void writeDoubleObjectListValue(List<Double> list) throws IOException {
        ValueWriter.writeDoubleElemList(this.output, list);
    }

    public final void writeDoubleObjectCollectionValue(Collection<Double> collection) throws IOException {
        ValueWriter.writeDoubleElemCollection(this.output, collection);
    }

    public final void writeDurationValue(Duration duration) throws IOException {
        ValueWriter.writeDurationElem(this.output, duration);
    }

    public final void writeDurationListValue(List<Duration> list) throws IOException {
        ValueWriter.writeDurationElemList(this.output, list);
    }

    public final void writeDurationCollectionValue(Collection<Duration> collection) throws IOException {
        ValueWriter.writeDurationElemCollection(this.output, collection);
    }

    public final void writeCalendarValue(Calendar calendar) throws IOException {
        ValueWriter.writeCalendarElem(this.output, calendar);
    }

    public final void writeCalendarListValue(List<Calendar> list) throws IOException {
        ValueWriter.writeCalendarElemList(this.output, list);
    }

    public final void writeCalendarCollectionValue(Collection<Calendar> collection) throws IOException {
        ValueWriter.writeCalendarElemCollection(this.output, collection);
    }

    public final void writeDateValue(Date date) throws IOException {
        ValueWriter.writeDateElem(this.output, date);
    }

    public final void writeDateListValue(List<Date> list) throws IOException {
        ValueWriter.writeDateElemList(this.output, list);
    }

    public final void writeDateCollectionValue(Collection<Date> collection) throws IOException {
        ValueWriter.writeDateElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCalendarElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCalendarElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCalendarElemCollection(this.output, collection);
    }

    public final void writeHexBinaryValue(byte[] byArray) throws IOException {
        ValueWriter.writeHexBinaryElem(this.output, byArray);
    }

    public final void writeHexBinaryListValue(List<byte[]> list) throws IOException {
        ValueWriter.writeHexBinaryElemList(this.output, list);
    }

    public final void writeHexBinaryCollectionValue(Collection<byte[]> collection) throws IOException {
        ValueWriter.writeHexBinaryElemCollection(this.output, collection);
    }

    public final void writeBase64BinaryAttributeValue(byte[] byArray) throws IOException {
        ValueWriter.writeBase64BinaryElem(this.output, byArray);
    }

    public final void writeBase64BinaryAttributeListValue(List<byte[]> list) throws IOException {
        ValueWriter.writeBase64BinaryElemList(this.output, list);
    }

    public final void writeBase64BinaryAttributeCollectionValue(Collection<byte[]> collection) throws IOException {
        ValueWriter.writeBase64BinaryElemCollection(this.output, collection);
    }

    public final void writeBase64BinaryInlinedElementValue(byte[] byArray) throws IOException {
        ValueWriter.writeBase64BinaryElem(this.output, byArray);
    }

    public final void writeBase64BinaryElementValue(byte[] byArray, String string) throws IOException {
        this.writeBase64BinaryElementValue(byArray, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeBase64BinaryElementValue(byte[] byArray, String string, String string2, String string3) throws IOException {
        AttachmentMarshaller attachmentMarshaller = this.marshaller.getAttachmentMarshaller();
        if (this.isXOPPackage(attachmentMarshaller)) {
            ValueWriter.writeBase64BinaryMtomAttachmentElem(this.output, byArray, attachmentMarshaller, string, string2, string3);
        } else {
            ValueWriter.writeBase64BinaryElem(this.output, byArray);
        }
    }

    public final void writeBase64BinaryInlinedElementListValue(List<byte[]> list) throws IOException {
        ValueWriter.writeBase64BinaryElemList(this.output, list);
    }

    public final void writeBase64BinaryElementListValue(List<byte[]> list, String string) throws IOException {
        this.writeBase64BinaryElementListValue(list, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeBase64BinaryElementListValue(List<byte[]> list, String string, String string2, String string3) throws IOException {
        ValueWriter.writeBase64BinaryElemList(this.output, list);
    }

    public final void writeBase64BinaryInlinedElementCollectionValue(Collection<byte[]> collection) throws IOException {
        ValueWriter.writeBase64BinaryElemCollection(this.output, collection);
    }

    public final void writeBase64BinaryElementCollectionValue(Collection<byte[]> collection, String string) throws IOException {
        this.writeBase64BinaryElementCollectionValue(collection, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeBase64BinaryElementCollectionValue(Collection<byte[]> collection, String string, String string2, String string3) throws IOException {
        ValueWriter.writeBase64BinaryElemCollection(this.output, collection);
    }

    public final void writeQNameAttributeValue(QName qName, int n) throws IOException {
        ValueWriter.writeQNameAttr(this.output, qName, n);
    }

    public final void writeQNameAttributeListValue(List<QName> list, int[] nArray) throws IOException {
        ValueWriter.writeQNameAttrList(this.output, list, nArray);
    }

    public final void writeQNameAttributeCollectionValue(Collection<QName> collection, int[] nArray) throws IOException {
        ValueWriter.writeQNameAttrCollection(this.output, collection, nArray);
    }

    public final void writeURIAttributeValue(URI uRI) throws IOException {
        ValueWriter.writeURIAttr(this.output, uRI);
    }

    public final void writeURIAttributeListValue(List<URI> list) throws IOException {
        ValueWriter.writeURIAttrList(this.output, list);
    }

    public final void writeURIAttributeCollectionValue(Collection<URI> collection) throws IOException {
        ValueWriter.writeURIAttrCollection(this.output, collection);
    }

    public final void writeQNameElementValue(QName qName, int n) throws IOException {
        ValueWriter.writeQNameElem(this.output, qName, n);
    }

    public final void writeQNameElementListValue(List<QName> list, int[] nArray) throws IOException {
        ValueWriter.writeQNameElemList(this.output, list, nArray);
    }

    public final void writeQNameElementCollectionValue(Collection<QName> collection, int[] nArray) throws IOException {
        ValueWriter.writeQNameElemCollection(this.output, collection, nArray);
    }

    public final void writeURIElementValue(URI uRI) throws IOException {
        ValueWriter.writeURIElem(this.output, uRI);
    }

    public final void writeURIElementListValue(List<URI> list) throws IOException {
        ValueWriter.writeURIElemList(this.output, list);
    }

    public final void writeURIElementCollectionValue(Collection<URI> collection) throws IOException {
        ValueWriter.writeURIElemCollection(this.output, collection);
    }

    public final void writeImageAttributeValue(Image image, String string) throws IOException {
        ValueWriter.writeImageAttr(this.output, image, string);
    }

    public final void writeImageAttributeListValue(List<Image> list, String string) throws IOException {
        ValueWriter.writeImageAttrList(this.output, list, string);
    }

    public final void writeImageAttributeCollectionValue(Collection<Image> collection, String string) throws IOException {
        ValueWriter.writeImageAttrCollection(this.output, collection, string);
    }

    public final void writeImageInlinedElementValue(Image image, String string) throws IOException {
        ValueWriter.writeImageElem(this.output, image, string);
    }

    public final void writeImageElementValue(Image image, String string) throws IOException {
        this.writeImageElementValue(image, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeImageElementValue(Image image, String string, String string2, String string3) throws IOException {
        AttachmentMarshaller attachmentMarshaller = this.marshaller.getAttachmentMarshaller();
        if (this.isXOPPackage(attachmentMarshaller)) {
            ValueWriter.writeImageMtomAttachmentElem(this.output, image, attachmentMarshaller, string, string2, string3);
        } else {
            ValueWriter.writeImageElem(this.output, image, string);
        }
    }

    public final void writeImageInlinedElementListValue(List<Image> list, String string) throws IOException {
        ValueWriter.writeImageElemList(this.output, list, string);
    }

    public final void writeImageElementListValue(List<Image> list, String string) throws IOException {
        this.writeImageElementListValue(list, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeImageElementListValue(List<Image> list, String string, String string2, String string3) throws IOException {
        ValueWriter.writeImageElemList(this.output, list, string);
    }

    public final void writeImageInlinedElementCollectionValue(Collection<Image> collection, String string) throws IOException {
        ValueWriter.writeImageElemCollection(this.output, collection, string);
    }

    public final void writeImageElementCollectionValue(Collection<Image> collection, String string) throws IOException {
        this.writeImageElementCollectionValue(collection, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeImageElementCollectionValue(Collection<Image> collection, String string, String string2, String string3) throws IOException {
        ValueWriter.writeImageElemCollection(this.output, collection, string);
    }

    public final void writeAttachmentValue(DataHandler dataHandler) throws IOException {
        ValueWriter.writeDataHandlerSwaRefAttachmentElem(this.output, dataHandler, this.marshaller.getAttachmentMarshaller());
    }

    public final void writeAttachmentListValue(List<DataHandler> list) throws IOException {
        ValueWriter.writeDataHandlerSwaRefAttachmentElemList(this.output, list, this.marshaller.getAttachmentMarshaller());
    }

    public final void writeAttachmentCollectionValue(Collection<DataHandler> collection) throws IOException {
        ValueWriter.writeDataHandlerSwaRefAttachmentElemCollection(this.output, collection, this.marshaller.getAttachmentMarshaller());
    }

    public final void writeDataHandlerAttributeValue(DataHandler dataHandler) throws IOException {
        ValueWriter.writeDataHandlerAttr(this.output, dataHandler);
    }

    public final void writeDataHandlerAttributeListValue(List<DataHandler> list) throws IOException {
        ValueWriter.writeDataHandlerAttrList(this.output, list);
    }

    public final void writeDataHandlerAttributeCollectionValue(Collection<DataHandler> collection) throws IOException {
        ValueWriter.writeDataHandlerAttrCollection(this.output, collection);
    }

    public final void writeDataHandlerInlinedElementValue(DataHandler dataHandler) throws IOException {
        ValueWriter.writeDataHandlerElem(this.output, dataHandler);
    }

    public final void writeDataHandlerElementValue(DataHandler dataHandler) throws IOException {
        this.writeDataHandlerElementValue(dataHandler, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeDataHandlerElementValue(DataHandler dataHandler, String string, String string2) throws IOException {
        AttachmentMarshaller attachmentMarshaller = this.marshaller.getAttachmentMarshaller();
        if (this.isXOPPackage(attachmentMarshaller)) {
            ValueWriter.writeDataHandlerMtomAttachmentElem(this.output, dataHandler, attachmentMarshaller, string, string2);
        } else {
            ValueWriter.writeDataHandlerElem(this.output, dataHandler);
        }
    }

    public final void writeDataHandlerInlinedElementListValue(List<DataHandler> list) throws IOException {
        ValueWriter.writeDataHandlerElemList(this.output, list);
    }

    public final void writeDataHandlerElementListValue(List<DataHandler> list) throws IOException {
        this.writeDataHandlerElementListValue(list, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeDataHandlerElementListValue(List<DataHandler> list, String string, String string2) throws IOException {
        ValueWriter.writeDataHandlerElemList(this.output, list);
    }

    public final void writeDataHandlerInlinedElementCollectionValue(Collection<DataHandler> collection) throws IOException {
        ValueWriter.writeDataHandlerElemCollection(this.output, collection);
    }

    public final void writeDataHandlerElementCollectionValue(Collection<DataHandler> collection) throws IOException {
        this.writeDataHandlerElementCollectionValue(collection, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeDataHandlerElementCollectionValue(Collection<DataHandler> collection, String string, String string2) throws IOException {
        ValueWriter.writeDataHandlerElemCollection(this.output, collection);
    }

    public final void writeSourceAttributeValue(Source source) throws IOException {
        ValueWriter.writeSourceAttr(this.output, source);
    }

    public final void writeSourceAttributeListValue(List<Source> list) throws IOException {
        ValueWriter.writeSourceAttrList(this.output, list);
    }

    public final void writeSourceAttributeCollectionValue(Collection<Source> collection) throws IOException {
        ValueWriter.writeSourceAttrCollection(this.output, collection);
    }

    public final void writeSourceInlinedElementValue(Source source) throws IOException {
        ValueWriter.writeSourceElem(this.output, source);
    }

    public final void writeSourceElementValue(Source source, String string) throws IOException {
        this.writeSourceElementValue(source, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeSourceElementValue(Source source, String string, String string2, String string3) throws IOException {
        AttachmentMarshaller attachmentMarshaller = this.marshaller.getAttachmentMarshaller();
        if (this.isXOPPackage(attachmentMarshaller)) {
            ValueWriter.writeSourceMtomAttachmentElem(this.output, source, attachmentMarshaller, string, string2, string3);
        } else {
            ValueWriter.writeSourceElem(this.output, source);
        }
    }

    public final void writeSourceInlinedElementListValue(List<Source> list) throws IOException {
        ValueWriter.writeSourceElemList(this.output, list);
    }

    public final void writeSourceElementListValue(List<Source> list, String string) throws IOException {
        this.writeSourceElementListValue(list, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeSourceElementListValue(List<Source> list, String string, String string2, String string3) throws IOException {
        ValueWriter.writeSourceElemList(this.output, list);
    }

    public final void writeSourceInlinedElementCollectionValue(Collection<Source> collection) throws IOException {
        ValueWriter.writeSourceElemCollection(this.output, collection);
    }

    public final void writeSourceElementCollectionValue(Collection<Source> collection, String string) throws IOException {
        this.writeSourceElementCollectionValue(collection, string, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeSourceElementCollectionValue(Collection<Source> collection, String string, String string2, String string3) throws IOException {
        ValueWriter.writeSourceElemCollection(this.output, collection);
    }

    public final void writeUUIDValue(UUID uUID) throws IOException {
        ValueWriter.writeUUIDElem(this.output, uUID);
    }

    public final void writeUUIDListValue(List<UUID> list) throws IOException {
        ValueWriter.writeUUIDElemList(this.output, list);
    }

    public final void writeUUIDCollectionValue(Collection<UUID> collection) throws IOException {
        ValueWriter.writeUUIDElemCollection(this.output, collection);
    }

    public final void writeCharValue(char c) throws IOException {
        ValueWriter.writeCharElem(this.output, c);
    }

    public final void writeCharObjectValue(Character c) throws IOException {
        ValueWriter.writeCharacterElem(this.output, c);
    }

    public final void writeCharObjectListValue(List<Character> list) throws IOException {
        ValueWriter.writeCharacterElemList(this.output, list);
    }

    public final void writeCharObjectCollectionValue(Collection<Character> collection) throws IOException {
        ValueWriter.writeCharacterElemCollection(this.output, collection);
    }

    public final void writeGregorianCalendarValue(GregorianCalendar gregorianCalendar) throws IOException {
        ValueWriter.writeGCalendarElem(this.output, gregorianCalendar);
    }

    public final void writeGregorianCalendarListValue(List<GregorianCalendar> list) throws IOException {
        ValueWriter.writeGCalendarElemList(this.output, list);
    }

    public final void writeGregorianCalendarCollectionValue(Collection<GregorianCalendar> collection) throws IOException {
        ValueWriter.writeGCalendarElemCollection(this.output, collection);
    }

    public final void writeFileAttributeValue(File file) throws IOException {
        ValueWriter.writeFileAttr(this.output, file);
    }

    public final void writeFileAttributeListValue(List<File> list) throws IOException {
        ValueWriter.writeFileAttrList(this.output, list);
    }

    public final void writeFileAttributeCollectionValue(Collection<File> collection) throws IOException {
        ValueWriter.writeFileAttrCollection(this.output, collection);
    }

    public final void writeURLAttributeValue(URL uRL) throws IOException {
        ValueWriter.writeURLAttr(this.output, uRL);
    }

    public final void writeURLAttributeListValue(List<URL> list) throws IOException {
        ValueWriter.writeURLAttrList(this.output, list);
    }

    public final void writeURLAttributeCollectionValue(Collection<URL> collection) throws IOException {
        ValueWriter.writeURLAttrCollection(this.output, collection);
    }

    public final void writeFileElementValue(File file) throws IOException {
        ValueWriter.writeFileElem(this.output, file);
    }

    public final void writeFileElementListValue(List<File> list) throws IOException {
        ValueWriter.writeFileElemList(this.output, list);
    }

    public final void writeFileElementCollectionValue(Collection<File> collection) throws IOException {
        ValueWriter.writeFileElemCollection(this.output, collection);
    }

    public final void writeURLElementValue(URL uRL) throws IOException {
        ValueWriter.writeURLElem(this.output, uRL);
    }

    public final void writeURLElementListValue(List<URL> list) throws IOException {
        ValueWriter.writeURLElemList(this.output, list);
    }

    public final void writeURLElementCollectionValue(Collection<URL> collection) throws IOException {
        ValueWriter.writeURLElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarDateTimeValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCDateTimeElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarDateTimeListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCDateTimeElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarDateTimeCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCDateTimeElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarDateValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCDateElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarDateListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCDateElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarDateCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCDateElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarTimeValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCTimeElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarTimeListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCTimeElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarTimeCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCTimeElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarGYearValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGYearElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarGYearListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGYearElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarGYearCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGYearElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarGMonthValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGMonthElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarGMonthListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGMonthElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarGMonthCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGMonthElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarGDayValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGDayElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarGDayListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGDayElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarGDayCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGDayElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarGYearMonthValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGYearMonthElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarGYearMonthListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGYearMonthElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarGYearMonthCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGYearMonthElemCollection(this.output, collection);
    }

    public final void writeXMLGregorianCalendarGMonthDayValue(XMLGregorianCalendar xMLGregorianCalendar) throws IOException {
        ValueWriter.writeXGCGMonthDayElem(this.output, xMLGregorianCalendar);
    }

    public final void writeXMLGregorianCalendarGMonthDayListValue(List<XMLGregorianCalendar> list) throws IOException {
        ValueWriter.writeXGCGMonthDayElemList(this.output, list);
    }

    public final void writeXMLGregorianCalendarGMonthDayCollectionValue(Collection<XMLGregorianCalendar> collection) throws IOException {
        ValueWriter.writeXGCGMonthDayElemCollection(this.output, collection);
    }

    public final void writeIDREFAttributeValue(Object object) throws IOException {
        SerializationStub serializationStub;
        String string;
        int n = this.getClassIdentifier(object);
        if (n >= 0 && (string = (serializationStub = this.getSerializationStub(n)).readIDValue(object)) != null) {
            ValueWriter.writeStringAttr(this.output, string);
        }
    }

    public final void writeIDREFAttributeListValue(List<Object> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            if (object == null) continue;
            if (bl) {
                bl = false;
            } else {
                this.output.write((byte)32);
            }
            this.writeIDREFAttributeValue(object);
        }
    }

    public final void writeIDREFAttributeCollectionValue(Collection<Object> collection) throws IOException {
        Iterator<Object> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            if (bl) {
                bl = false;
            } else {
                this.output.write((byte)32);
            }
            this.writeIDREFAttributeValue(object);
        }
    }

    public final void writeIDREFElementValue(Object object) throws IOException {
        SerializationStub serializationStub;
        String string;
        int n = this.getClassIdentifier(object);
        if (n >= 0 && (string = (serializationStub = this.getSerializationStub(n)).readIDValue(object)) != null) {
            ValueWriter.writeStringElem(this.output, string);
            return;
        }
        this.reportInvalidIDREFValue(n, object);
    }

    public final void writeIDREFElementListValue(List<Object> list) throws IOException {
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            if (object == null) continue;
            if (bl) {
                bl = false;
            } else {
                this.output.write((byte)32);
            }
            this.writeIDREFElementValue(object);
        }
    }

    public final void writeIDREFElementCollectionValue(Collection<Object> collection) throws IOException {
        Iterator<Object> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            if (bl) {
                bl = false;
            } else {
                this.output.write((byte)32);
            }
            this.writeIDREFElementValue(object);
        }
    }

    public final void writeSimpleContent(Object object, int n, int n2) throws IOException {
        this.writeSimpleContent(object, n, n2, this.currentElementNamespaceURI, this.currentElementLocalName);
    }

    public final void writeSimpleContent(Object object, int n, int n2, String string, String string2) throws IOException {
        switch (n) {
            case 0: {
                this.writeStringElementValue((String)object);
                break;
            }
            case 3: {
                this.writeBooleanObjectValue((Boolean)object);
                break;
            }
            case 4: {
                this.writeBigDecimalValue((BigDecimal)object);
                break;
            }
            case 5: {
                this.writeBigIntegerValue((BigInteger)object);
                break;
            }
            case 6: {
                this.writeLongObjectValue((Long)object);
                break;
            }
            case 7: {
                this.writeIntegerObjectValue((Integer)object);
                break;
            }
            case 8: {
                this.writeShortObjectValue((Short)object);
                break;
            }
            case 9: {
                this.writeByteObjectValue((Byte)object);
                break;
            }
            case 10: {
                this.writeFloatObjectValue((Float)object);
                break;
            }
            case 11: {
                this.writeDoubleObjectValue((Double)object);
                break;
            }
            case 12: {
                this.writeDurationValue((Duration)object);
                break;
            }
            case 13: {
                this.writeCalendarValue((Calendar)object);
                break;
            }
            case 14: {
                this.writeDateValue((Date)object);
                break;
            }
            case 15: {
                this.writeXMLGregorianCalendarValue((XMLGregorianCalendar)object);
                break;
            }
            case 17: {
                this.writeBase64BinaryElementValue((byte[])object, "application/octet-stream", string, string2);
                break;
            }
            case 18: {
                this.writeQNameElementValue((QName)object, n2);
                break;
            }
            case 21: {
                this.writeURIElementValue((URI)object);
                break;
            }
            case 22: {
                this.writeImageElementValue((Image)object, "image/png", string, string2);
                break;
            }
            case 23: {
                this.writeDataHandlerElementValue((DataHandler)object, string, string2);
                break;
            }
            case 24: {
                this.writeSourceElementValue((Source)object, "application/xml; charset=UTF-8", string, string2);
                break;
            }
            case 25: {
                this.writeUUIDValue((UUID)object);
                break;
            }
            case 26: {
                this.writeCharObjectValue((Character)object);
                break;
            }
            case 27: {
                this.writeGregorianCalendarValue((GregorianCalendar)object);
                break;
            }
            case 28: {
                this.writeFileElementValue((File)object);
                break;
            }
            case 29: {
                this.writeURLElementValue((URL)object);
            }
        }
    }

    public final void writeElement(Element element) throws IOException {
        Object object;
        if (this.domSerializer == null) {
            object = null;
            try {
                object = DOMImplementationRegistry.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.domImplLS = (DOMImplementationLS)((Object)((DOMImplementationRegistry)object).getDOMImplementation("LS"));
            this.domSerializer = this.domImplLS.createLSSerializer();
            DOMConfiguration dOMConfiguration = this.domSerializer.getDomConfig();
            dOMConfiguration.setParameter("xml-declaration", Boolean.FALSE);
        }
        object = this.domImplLS.createLSOutput();
        object.setByteStream(this.output.output);
        object.setEncoding("UTF-8");
        this.output.writePending();
        this.domSerializer.write(element, (LSOutput)object);
    }

    public final void setCurrentElementQName(String string, String string2) {
        this.currentElementNamespaceURI = string;
        this.currentElementLocalName = string2;
    }

    private boolean isXOPPackage(AttachmentMarshaller attachmentMarshaller) {
        if (this.needToCheckIsXOPPackage) {
            this.isXOPPackage = attachmentMarshaller != null ? attachmentMarshaller.isXOPPackage() : false;
            this.needToCheckIsXOPPackage = false;
        }
        return this.isXOPPackage;
    }

    public final void reportInvalidRoot(Object object) {
        Class<?> clazz = object.getClass();
        int n = clazz != Object.class && this.getClassIdentifier(object) != -1 ? 26 : 27;
        JAXBMessageProvider.throwMarshalExceptionWrapper(JAXBMessageProvider.createMessage(null, n, clazz.getName()));
    }

    public final void reportInvalidIDREFValue(int n, Object object) {
        Object object2;
        if (n >= 0) {
            object2 = this.valueClasses[n];
            if (((ValueClass)object2).idProperty != null) {
                return;
            }
        }
        if (n != -1) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(object.getClass().getName().toString());
            ((StringBuilder)object2).append('@');
            ((StringBuilder)object2).append(Integer.toHexString(System.identityHashCode(object)));
            JAXBMessageProvider.throwMarshalExceptionWrapper(JAXBMessageProvider.createMessage(null, 29, ((StringBuilder)object2).toString()));
        } else {
            JAXBMessageProvider.throwMarshalExceptionWrapper(JAXBMessageProvider.createMessage(null, 27, object.getClass().getName()));
        }
    }

    static {
        byte[] byArray = null;
        try {
            byArray = " xmlns:si=\"http://www.w3.org/2001/XMLSchema-instance\" si:nil=\"true\"/>".getBytes("UTF-8");
        }
        catch (Exception exception) {
            byArray = new byte[]{};
        }
        XSI_NIL_FRAGMENT = byArray;
        byArray = null;
        try {
            byArray = " xmlns:".getBytes("UTF-8");
        }
        catch (Exception exception) {
            byArray = new byte[]{};
        }
        XMLNS_FRAGMENT = byArray;
    }
}

