/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.grammar;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class NamedDeclaration {
    public final String nsURI;
    public final String localName;
    private static final int CHOICES_THRESHOLD = 8;

    private NamedDeclaration() {
        this.nsURI = null;
        this.localName = null;
    }

    public NamedDeclaration(String string, String string2) {
        assert (string == null || string == string.intern());
        assert (string2 == null || string2 == string2.intern());
        this.nsURI = string;
        this.localName = string2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" :: ");
        if (this.nsURI != null && this.nsURI.length() > 0) {
            stringBuilder.append('{').append(this.nsURI).append('}');
        }
        if (this.localName != null && this.localName.length() > 0) {
            stringBuilder.append(this.localName);
        } else {
            stringBuilder.append("##ANONYMOUS");
        }
        return stringBuilder.toString();
    }

    public static Entry[] createMap(NamedDeclaration[] namedDeclarationArray) {
        return NamedDeclaration.createMap(namedDeclarationArray, false);
    }

    public static Entry[] createMap(NamedDeclaration[] namedDeclarationArray, boolean bl) {
        if (namedDeclarationArray != null && namedDeclarationArray.length > 8) {
            int n;
            int n2 = namedDeclarationArray.length;
            int n3 = n2 * 4 / 3;
            for (n = 1; n <= n3 && n != 0x40000000; n <<= 1) {
            }
            Entry[] entryArray = ArrayAllocator.newObjectArray(Entry.class, n);
            if (bl) {
                for (int i = n2 - 1; i >= 0; --i) {
                    NamedDeclaration namedDeclaration = namedDeclarationArray[i];
                    int n4 = namedDeclaration.localName.hashCode() & entryArray.length - 1;
                    entryArray[n4] = new Entry(namedDeclaration, i, entryArray[n4]);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    NamedDeclaration namedDeclaration = namedDeclarationArray[i];
                    int n5 = namedDeclaration.localName.hashCode() & entryArray.length - 1;
                    entryArray[n5] = new Entry(namedDeclaration, i, entryArray[n5]);
                }
            }
            return entryArray;
        }
        return null;
    }

    public static int searchMap(String string, String string2, Entry[] entryArray) {
        int n = string2.hashCode() & entryArray.length - 1;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (string2 == entry.localName && string == entry.nsURI) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class Entry {
        final String localName;
        final String nsURI;
        final int value;
        final Entry next;

        public Entry(NamedDeclaration namedDeclaration, int n, Entry entry) {
            this.localName = namedDeclaration.localName;
            this.nsURI = namedDeclaration.nsURI;
            this.value = n;
            this.next = entry;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
            stringBuilder.append(" :: ");
            if (this.nsURI != null && this.nsURI.length() > 0) {
                stringBuilder.append('{').append(this.nsURI).append('}');
            }
            if (this.localName != null && this.localName.length() > 0) {
                stringBuilder.append(this.localName);
            }
            if (this.next != null) {
                stringBuilder.append(" --> ");
                stringBuilder.append(this.next.toString());
            }
            return stringBuilder.toString();
        }
    }
}

