/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.api.jms.JmsTemporaryDestinationInternal;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

public class JmsTemporaryQueueImpl
extends JmsQueueImpl
implements TemporaryQueue,
JmsTemporaryDestinationInternal {
    private static final long serialVersionUID = 8936845633815526385L;
    private static TraceComponent tc = SibTr.register(JmsTemporaryQueueImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    JmsSessionImpl session;
    boolean deleted = false;

    public JmsTemporaryQueueImpl(SIDestinationAddress destAddr, JmsSessionImpl sess) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{destAddr, sess});
        }
        this.setDestName(destAddr.getDestinationName());
        this.setBusName(destAddr.getBusName());
        this.session = sess;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void delete() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"delete");
        }
        if (!this.deleted) {
            this.session.deleteTemporaryDestination(this.getConsumerSIDestinationAddress());
            this.deleted = true;
            ((JmsConnectionImpl)this.session.getConnection()).removeTemporaryDestination(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"delete");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeObject", (Object)out);
        }
        throw new NotSerializableException("TemporaryQueue");
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

