/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.concurrent.internal.ContextualBiConsumer;
import com.ibm.ws.concurrent.internal.ContextualBiFunction;
import com.ibm.ws.concurrent.internal.ContextualCallable;
import com.ibm.ws.concurrent.internal.ContextualConsumer;
import com.ibm.ws.concurrent.internal.ContextualDefaultExecutor;
import com.ibm.ws.concurrent.internal.ContextualExecutor;
import com.ibm.ws.concurrent.internal.ContextualFunction;
import com.ibm.ws.concurrent.internal.ContextualRunnable;
import com.ibm.ws.concurrent.internal.ContextualSupplier;
import com.ibm.ws.concurrent.internal.MPContextPropagationVersion;
import com.ibm.ws.concurrent.internal.ManagedCompletableFuture;
import com.ibm.ws.concurrent.internal.ManagedCompletionStage;
import com.ibm.ws.concurrent.internal.UnusableExecutor;
import com.ibm.ws.concurrent.mp.spi.ThreadContextConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThreadContextImpl
implements ThreadContext,
WSContextService {
    private static final TraceComponent tc = Tr.register(ThreadContextImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final ThreadContextConfig config;
    private final int hash;
    ManagedExecutor managedExecutor;
    private final String name;
    static final long serialVersionUID = -6722113679548961125L;

    public ThreadContextImpl(String name, int hash, ThreadContextConfig config) {
        this.config = config;
        this.name = name;
        this.hash = hash;
    }

    public final ThreadContextDescriptor captureThreadContext(Map<String, String> executionProperties, Map<String, ?> ... additionalThreadContextConfig) {
        return this.config.captureThreadContext();
    }

    public final <R> Callable<R> contextualCallable(Callable<R> callable) {
        if (callable instanceof ContextualCallable) {
            throw new IllegalArgumentException(ContextualCallable.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualCallable<R>(contextDescriptor, callable);
    }

    public final <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> consumer) {
        if (consumer instanceof ContextualBiConsumer) {
            throw new IllegalArgumentException(ContextualBiConsumer.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualBiConsumer<T, U>(contextDescriptor, consumer);
    }

    public final <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        if (consumer instanceof ContextualConsumer) {
            throw new IllegalArgumentException(ContextualConsumer.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualConsumer<T>(contextDescriptor, consumer);
    }

    public final <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> function) {
        if (function instanceof ContextualBiFunction) {
            throw new IllegalArgumentException(ContextualBiFunction.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualBiFunction<T, U, R>(contextDescriptor, function);
    }

    public final <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        if (function instanceof ContextualFunction) {
            throw new IllegalArgumentException(ContextualFunction.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualFunction<T, R>(contextDescriptor, function);
    }

    public final Runnable contextualRunnable(Runnable runnable) {
        if (runnable instanceof ContextualRunnable) {
            throw new IllegalArgumentException(ContextualRunnable.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualRunnable(contextDescriptor, runnable);
    }

    public final <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        if (supplier instanceof ContextualSupplier) {
            throw new IllegalArgumentException(ContextualSupplier.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualSupplier<R>(contextDescriptor, supplier);
    }

    public final <T> T createContextualProxy(ThreadContextDescriptor threadContextDescriptor, T instance, Class<T> intf) {
        throw new UnsupportedOperationException();
    }

    public final Executor currentContextExecutor() {
        ThreadContextDescriptor contextDescriptor = this.config.captureThreadContext();
        return new ContextualExecutor(contextDescriptor);
    }

    @Trivial
    public final int hashCode() {
        return this.hash;
    }

    @Trivial
    public final String toString() {
        return this.name;
    }

    public final <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> stage) {
        WSManagedExecutorService executor = MPContextPropagationVersion.atLeast(MPContextPropagationVersion.V1_1) ? (this.managedExecutor == null ? new ContextualDefaultExecutor(this) : this.managedExecutor) : new UnusableExecutor(this);
        ManagedCompletableFuture newCompletableFuture = ManagedCompletableFuture.JAVA8 ? new ManagedCompletableFuture(new CompletableFuture(), (Executor)((Object)executor), null) : new ManagedCompletableFuture((Executor)((Object)executor), null);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newCompletableFuture.complete(result);
            } else {
                newCompletableFuture.completeExceptionally((Throwable)failure);
            }
        });
        return newCompletableFuture;
    }

    public final <T> CompletionStage<T> withContextCapture(CompletionStage<T> stage) {
        WSManagedExecutorService executor = MPContextPropagationVersion.atLeast(MPContextPropagationVersion.V1_1) ? (this.managedExecutor == null ? new ContextualDefaultExecutor(this) : this.managedExecutor) : new UnusableExecutor(this);
        ManagedCompletionStage newStage = ManagedCompletableFuture.JAVA8 ? new ManagedCompletionStage(new CompletableFuture(), (Executor)((Object)executor), null) : new ManagedCompletionStage((Executor)((Object)executor));
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newStage.super_complete(result);
            } else {
                newStage.super_completeExceptionally((Throwable)failure);
            }
        });
        return newStage;
    }
}

