/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.props;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.RepositoryConfigValidationResult;
import com.ibm.ws.install.featureUtility.props.FeatureUtilityProperties;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertiesUtils {
    private static Locale locale;
    private static ResourceBundle featureUtilityMessages;
    private static ResourceBundle featureUtilitySampleConfigurations;
    public static final String WLP_REPO = "default";
    public static final String USE_WLP_REPO = "useDefaultRepository";
    public static final String URL_SUFFIX = ".url";
    public static final String USER_SUFFIX = ".user";
    public static final String PWD_SUFFIX = ".password";
    public static final String COMMENT_PREFIX = "#";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USER = "proxyUser";
    public static final String PROXY_PASSWORD = "proxyPassword";
    public static final String FEATURE_LOCAL_REPO = "featureLocalRepo";
    public static final String EQUALS = "=";
    private static final String[] SUPPORTED_KEYS;
    private static final Logger logger;

    public static synchronized String getMessage(String key, Object ... args) {
        if (featureUtilityMessages == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            featureUtilityMessages = ResourceBundle.getBundle("com.ibm.ws.install.featureUtility.internal.resources.FeatureUtilityMessages", locale);
        }
        String message = featureUtilityMessages.getString(key);
        if (args.length == 0) {
            return message;
        }
        MessageFormat messageFormat = new MessageFormat(message, locale);
        return messageFormat.format(args);
    }

    public static synchronized String getSampleConfig() {
        if (featureUtilitySampleConfigurations == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            featureUtilitySampleConfigurations = ResourceBundle.getBundle("com.ibm.ws.install.featureUtility.internal.resources.FeatureUtilitySampleConfiguration", locale);
        }
        String message = featureUtilitySampleConfigurations.getString("SAMPLE_CONFIG");
        return message;
    }

    public static boolean isFileProtocol(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return url.getProtocol().equalsIgnoreCase("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static List<RepositoryConfigValidationResult> validateRepositoryPropertiesFile(Properties repoProperties) throws InstallException {
        ArrayList<RepositoryConfigValidationResult> validationResults = new ArrayList<RepositoryConfigValidationResult>();
        File repoPropertiesFile = FeatureUtilityProperties.getRepoPropertiesFile();
        HashMap<String, String> configMap = new HashMap<String, String>();
        HashMap<String, Integer> lineMap = new HashMap<String, Integer>();
        if (repoPropertiesFile.exists() && repoPropertiesFile.isFile()) {
            BufferedReader repoPropertiesReader;
            FileInputStream repoPropertiesInput;
            block13: {
                logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VALIDATING", new Object[]{repoPropertiesFile.getPath()}));
                repoPropertiesInput = null;
                repoPropertiesReader = null;
                try {
                    String line;
                    repoPropertiesInput = new FileInputStream(repoPropertiesFile);
                    repoPropertiesReader = new BufferedReader(new InputStreamReader(repoPropertiesInput));
                    int lineNum = 0;
                    while ((line = repoPropertiesReader.readLine()) != null) {
                        PropertiesUtils.validateRepositoryPropertiesLine(repoProperties, line, ++lineNum, configMap, lineMap, validationResults);
                    }
                    if (configMap.containsKey(PROXY_HOST)) {
                        int ln = (Integer)lineMap.get(PROXY_HOST);
                        if (!configMap.containsKey(PROXY_PORT)) {
                            validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.MISSING_PORT, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_MISSING_PORT_VALUE", new Object[]{configMap.get(PROXY_HOST)})));
                            break block13;
                        }
                        String proxyHost = repoProperties.getProperty(PROXY_HOST);
                        String proxyPort = repoProperties.getProperty(PROXY_PORT);
                        try {
                            proxyHost = proxyHost.trim();
                            proxyPort = proxyPort.trim();
                            URL proxyUrl = null;
                            if (proxyHost.toLowerCase().contains("://")) {
                                proxyUrl = new URL(proxyHost + ":" + proxyPort);
                                if (!proxyUrl.getProtocol().toLowerCase().equals("http")) {
                                    validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_HOST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_HOST", new Object[]{configMap.get(PROXY_HOST)})));
                                }
                                break block13;
                            }
                            new URL("http://" + proxyHost + ":" + proxyPort);
                        }
                        catch (MalformedURLException e) {
                            validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_HOST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_HOST", new Object[]{configMap.get(PROXY_HOST)})));
                        }
                        break block13;
                    }
                    if (configMap.containsKey(PROXY_PORT) || configMap.containsKey(PROXY_USER) || configMap.containsKey(PROXY_PASSWORD)) {
                        int ln = 0;
                        ln = lineMap.containsKey(PROXY_PORT) ? (Integer)lineMap.get(PROXY_PORT) : (lineMap.containsKey(PROXY_USER) ? ((Integer)lineMap.get(PROXY_USER)).intValue() : ((Integer)lineMap.get(PROXY_PASSWORD)).intValue());
                        validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.MISSING_HOST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_MISSING_HOST", new Object[0])));
                    }
                }
                catch (IOException e) {
                    try {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_REPOSITORY_PROPS_NOT_LOADED", new Object[]{repoPropertiesFile.getPath()}), 25);
                    }
                    catch (Throwable throwable) {
                        InstallUtils.close(repoPropertiesInput);
                        InstallUtils.close(repoPropertiesReader);
                        throw throwable;
                    }
                }
            }
            InstallUtils.close((Closeable)repoPropertiesInput);
            InstallUtils.close((Closeable)repoPropertiesReader);
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VALIDATION_DONE", new Object[0]));
        }
        return validationResults;
    }

    private static boolean isKeySupported(String key) {
        if (Arrays.asList(SUPPORTED_KEYS).contains(key)) {
            return true;
        }
        return key.endsWith(URL_SUFFIX) || key.endsWith(USER_SUFFIX) || key.endsWith(PWD_SUFFIX);
    }

    private static void validateRepositoryPropertiesLine(Properties repoProperties, String line, int lineNum, Map<String, String> configMap, Map<String, Integer> lineMap, List<RepositoryConfigValidationResult> validationResults) {
        if (!(line = line.trim()).isEmpty() && !line.startsWith(COMMENT_PREFIX)) {
            String[] keyValue = line.split(EQUALS);
            String key = null;
            String value = null;
            if (keyValue.length >= 2) {
                key = keyValue[0];
                value = keyValue[1];
            } else if (keyValue.length == 1) {
                key = keyValue[0];
            }
            if (key == null || key.isEmpty()) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.EMPTY_KEY, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_EMPTY_KEY", new Object[0])));
                return;
            }
            if (!PropertiesUtils.isKeySupported(key)) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_KEY, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_KEY", new Object[]{key})));
                return;
            }
            if (key.endsWith(URL_SUFFIX) || key.endsWith(PWD_SUFFIX) || key.endsWith(USER_SUFFIX)) {
                int suffixIndex = key.lastIndexOf(".");
                String suffix = key.substring(suffixIndex);
                String repoName = keyValue[0].substring(0, keyValue[0].length() - suffix.length()).trim();
                if (repoName.isEmpty()) {
                    validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.MISSING_REPONAME, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_EMPTY_REPONAME", new Object[0])));
                    return;
                }
            }
            if (configMap.containsKey(key)) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.DUPLICATE_KEY, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_DUPLICATE_KEY", new Object[]{key, lineMap.get(key)})));
                return;
            }
            configMap.put(key, value);
            lineMap.put(key, lineNum);
            if (value == null || value.isEmpty()) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.EMPTY_VALUE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_EMPTY_VALUE", new Object[]{key})));
                return;
            }
            if (key.equals(USE_WLP_REPO) && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_VALUE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_DEFAULTREPO_VALUE", new Object[]{value})));
                return;
            }
            if (key.endsWith(URL_SUFFIX)) {
                String url = value;
                url = repoProperties.getProperty(key);
                try {
                    URL repoUrl;
                    String protocol;
                    url = url.trim();
                    if (InstallUtils.isURL((String)url) && !(protocol = (repoUrl = new URL(url)).getProtocol()).equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https") && !protocol.equalsIgnoreCase("file")) {
                        validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.UNSUPPORTED_PROTOCOL, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_UNSUPPORT_PROTOCOL", new Object[]{value})));
                        return;
                    }
                }
                catch (MalformedURLException e) {
                    validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_URL, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_URL", new Object[]{value})));
                    return;
                }
            }
            if (key.equals(PROXY_PORT)) {
                try {
                    int port = Integer.parseInt(value);
                    if (port <= 0 || port > 65535) {
                        validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_PORT, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_PORT_VALUE", new Object[]{value})));
                        return;
                    }
                }
                catch (Exception e) {
                    validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_PORT, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_PORT_VALUE", new Object[]{value})));
                    return;
                }
            }
        }
    }

    static {
        SUPPORTED_KEYS = new String[]{USE_WLP_REPO, PROXY_HOST, PROXY_PORT, PROXY_USER, PROXY_PASSWORD, FEATURE_LOCAL_REPO};
        logger = Logger.getLogger("com.ibm.ws.install");
    }

    public class CmdlineConstants {
        public static final String DASHES = "----------------------------------------------------------------------";
        public static final String HIDDEN_PASSWORD = "********";
    }
}

