/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.Stack;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RLSUtils {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private static final String _digits = "0123456789abcdef";
    public static final int MAX_DISPLAY_BYTES = 32;
    protected static final int BOOLEAN_SIZE = 1;
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final int LONG_SIZE = 8;
    protected static final String UNC_HEADER;
    private static Object _directoryCreationLock;
    static final long serialVersionUID = 4174386059576264543L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String toHexString(byte[] byteSource) {
        if (byteSource == null) {
            return "null";
        }
        return RLSUtils.toHexString(byteSource, byteSource.length);
    }

    public static String toHexString(byte[] byteSource, int bytes) {
        StringBuffer result = null;
        boolean truncated = false;
        if (byteSource != null) {
            if (bytes > byteSource.length) {
                bytes = byteSource.length;
            } else if (bytes < byteSource.length) {
                truncated = true;
            }
            result = new StringBuffer(bytes * 2);
            for (int i = 0; i < bytes; ++i) {
                result.append(_digits.charAt(byteSource[i] >> 4 & 0xF));
                result.append(_digits.charAt(byteSource[i] & 0xF));
            }
            if (truncated) {
                result.append("... (" + bytes + "/" + byteSource.length + ")");
            } else {
                result.append("(" + bytes + ")");
            }
        } else {
            result = new StringBuffer("null");
        }
        return result.toString();
    }

    public static String FQHAMCompatibleServerName(String cell, String node, String server) {
        return cell + "\\" + node + "\\" + server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDirectoryTree(String requiredDirectoryTree) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"createDirectoryTree", (Object)requiredDirectoryTree);
        }
        boolean exists = true;
        Object object = _directoryCreationLock;
        synchronized (object) {
            File target = new File(requiredDirectoryTree);
            if (!target.exists()) {
                if (tc.isEventEnabled()) {
                    Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Creating directory tree", (Object)requiredDirectoryTree);
                }
                Stack<File> pathStack = new Stack<File>();
                while (target != null) {
                    pathStack.push(target);
                    target = target.getParentFile();
                }
                while (!pathStack.empty() && exists) {
                    target = (File)pathStack.pop();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Checking path to " + target.getAbsolutePath()));
                    }
                    if (!target.exists()) {
                        boolean created;
                        if (target.getAbsolutePath().equals(UNC_HEADER)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Ignoring " + target.getAbsolutePath() + " - is " + UNC_HEADER));
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Creating path to " + target.getAbsolutePath()));
                        }
                        if (created = target.mkdirs()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Created path to " + target.getAbsolutePath()));
                            continue;
                        }
                        if (target.getAbsolutePath().startsWith(UNC_HEADER)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Ignoring " + target.getAbsolutePath() + " - starts with " + UNC_HEADER));
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Did not create path to " + target.getAbsolutePath()));
                        }
                        if (!target.exists()) {
                            if (tc.isEventEnabled()) {
                                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Unable to create directory tree");
                            }
                            exists = false;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Path to " + target.getAbsolutePath() + " already exists"));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Path to " + target.getAbsolutePath() + " already exists"));
                }
            }
            if (exists && !target.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Did not create path to " + target.getAbsolutePath()));
                }
                exists = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"createDirectoryTree", (Object)new Boolean(exists));
        }
        return exists;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.RLSUtils", RLSUtils.class, null, null);
        tc = Tr.register(RLSUtils.class, (String)"Transaction", null);
        UNC_HEADER = new String(File.separator + File.separator);
        _directoryCreationLock = new Object();
    }
}

