/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogFileHeader;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSAccessFile;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class LogFileHandle {
    private static final TraceComponent tc = Tr.register(LogFileHandle.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    static final int STATUS_FIELD_FILE_OFFSET = 4 + LogFileHeader.MAGIC_NUMBER.length + 4;
    private ByteBuffer _fileBuffer = null;
    private boolean _isMapped = false;
    private final List _pendingWriteList = new ArrayList();
    private final AtomicInteger _outstandingWritableLogRecords = new AtomicInteger();
    private final Comparator<LogRecord> _recordComparator = new Comparator<LogRecord>(){
        static final long serialVersionUID = -3482322494095146267L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @ManualTrace
        public int compare(LogRecord obj1, LogRecord obj2) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"compare", (Object[])new Object[]{obj1, obj2, this});
            }
            int comparison = obj1.absolutePosition() - obj2.absolutePosition();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"compare", (Object)comparison);
            }
            return comparison;
        }

        @Override
        @ManualTrace
        public boolean equals(Object obj) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"equals", (Object[])new Object[]{obj, this});
                Tr.exit((TraceComponent)tc, (String)"equals", (Object)Boolean.FALSE);
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.LogFileHandle$1", 1.class, null, null);
        }
    };
    private RandomAccessFile _file;
    private FileChannel _fileChannel;
    private LogFileHeader _logFileHeader;
    private String _logDirectory;
    private String _fileName;
    private String _serverName;
    private String _serviceName;
    private final int _serviceVersion;
    private String _logName;
    private int _fileSize;
    FailureScope _failureScope;
    private volatile boolean _exceptionInForce;
    private boolean _headerFlushedFollowingRestart;
    static final long serialVersionUID = 4678519668098604646L;

    @ManualTrace
    protected LogFileHandle(String logDirectory, String fileName, String serverName, String serviceName, int serviceVersion, String logName, int fileSize, FailureScope fs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogFileHandle", (Object[])new Object[]{logDirectory, fileName, serverName, serviceName, serviceVersion, logName, fileSize, fs});
        }
        this._logDirectory = logDirectory;
        this._fileName = fileName;
        this._serverName = serverName;
        this._serviceName = serviceName;
        this._serviceVersion = serviceVersion;
        this._logName = logName;
        this._fileSize = fileSize;
        this._failureScope = fs;
        this._logFileHeader = new LogFileHeader(this._serverName, this._serviceName, this._serviceVersion, this._logName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogFileHandle", (Object)this);
        }
    }

    @ManualTrace
    protected ReadableLogRecord getReadableLogRecord(long expectedSequenceNumber) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReadableLogRecord", (Object[])new Object[]{this, expectedSequenceNumber});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating readable log record to read from file " + this._fileName), (Object[])new Object[0]);
        }
        ReadableLogRecord readableLogRecord = ReadableLogRecord.read(this._fileBuffer, expectedSequenceNumber, !this._logFileHeader.wasShutdownClean());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getReadableLogRecord", (Object)readableLogRecord);
        }
        return readableLogRecord;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected void fileOpen() throws InternalLogException, LogAllocationException, LogIncompatibleException {
        boolean fileColdStarting;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileOpen", (Object[])new Object[]{this});
        }
        try {
            try {
                final File pFile = new File(this._logDirectory, this._fileName);
                boolean bl = fileColdStarting = !pFile.exists() || pFile.length() == 0L;
                if (fileColdStarting) {
                    Tr.info((TraceComponent)tc, (String)"CWRLS0006_RECOVERY_LOG_CREATE", (Object[])new Object[]{this._logDirectory + File.separator + this._fileName});
                }
                this._fileBuffer = (MappedByteBuffer)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                    static final long serialVersionUID = -6816517615408106930L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @ManualTrace
                    public Object run() throws Exception {
                        String propertyValue;
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"run", (Object[])new Object[]{this});
                        }
                        LogFileHandle.this._file = RLSAccessFile.getRLSAccessFile(pFile);
                        LogFileHandle.this._fileChannel = LogFileHandle.this._file.getChannel();
                        int fileLength = (int)LogFileHandle.this._file.length();
                        int fileSizeBytes = LogFileHandle.this._fileSize * 1024;
                        int sizeToMap = fileLength > fileSizeBytes ? fileLength : fileSizeBytes;
                        String osName = System.getProperty("os.name");
                        if (osName != null) {
                            osName = osName.toLowerCase();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Working on operating system " + osName), (Object[])new Object[0]);
                        }
                        boolean noMemoryMappedFiles = Boolean.getBoolean("com.ibm.ws.recoverylog.spi.NoMemoryMappedFiles");
                        if (osName != null && (Configuration.HAEnabled() && osName.startsWith("windows") || osName.startsWith("z/os") || osName.startsWith("os/390")) && ((propertyValue = System.getProperty("com.ibm.ws.recoverylog.spi.NoMemoryMappedFiles")) == null || !propertyValue.equalsIgnoreCase("false"))) {
                            noMemoryMappedFiles = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("NoMemoryMappedFiles flag is " + noMemoryMappedFiles), (Object[])new Object[0]);
                        }
                        ByteBuffer fileBuffer = null;
                        if (!noMemoryMappedFiles) {
                            try {
                                fileBuffer = LogFileHandle.this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, sizeToMap);
                                LogFileHandle.this._isMapped = true;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle$2", (String)"324", (Object)this, (Object[])new Object[0]);
                                if (tc.isEventEnabled()) {
                                    void t;
                                    Tr.event((TraceComponent)tc, (String)"Mapping of recovery log file failed. Using non-mapped file.", (Object[])new Object[]{t});
                                }
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Resetting file Channel position to '0' from :", (Object[])new Object[]{LogFileHandle.this._fileChannel.position()});
                                }
                                LogFileHandle.this._fileChannel.position(0L);
                            }
                        } else if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Recovery log has been instructed not to use a mapped-file model.", (Object[])new Object[0]);
                        }
                        if (fileBuffer == null) {
                            ByteBuffer directByteBuffer = ByteBuffer.allocateDirect(sizeToMap);
                            if (fileColdStarting) {
                                LogFileHandle.this._fileChannel.write(directByteBuffer, 0L);
                                LogFileHandle.this._fileChannel.force(true);
                            }
                            LogFileHandle.this._fileChannel.read(directByteBuffer);
                            directByteBuffer.rewind();
                            LogFileHandle.this._isMapped = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"A direct byte buffer has been allocated successfully.", (Object[])new Object[0]);
                            }
                            fileBuffer = directByteBuffer;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"run", (Object)fileBuffer);
                        }
                        return fileBuffer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.LogFileHandle$2", 2.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException pFile) {
                void exc;
                FFDCFilter.processException((Throwable)pFile, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"365", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"338", (Object)this);
                throw new LogAllocationException((Throwable)exc);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"368", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"343", (Object)this);
                throw new InternalLogException(exc);
            }
        }
        catch (LogAllocationException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"372", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"351", (Object)this);
            this._fileBuffer = null;
            if (this._file != null) {
                this.fileClose();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"380", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"359", (Object)this);
            this._fileBuffer = null;
            if (this._file != null) {
                this.fileClose();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (fileColdStarting) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Log File " + this._fileName + " is cold starting"), (Object[])new Object[0]);
            }
            try {
                this.writeFileHeader(false);
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"400", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"388", (Object)this);
                this.fileClose();
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)exc);
                }
                throw exc;
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"409", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"396", (Object)this);
                this.fileClose();
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Log File " + this._fileName + " is warm starting"), (Object[])new Object[0]);
            }
            this.readFileHeader();
        }
        if (!this._logFileHeader.valid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Log File " + this._fileName + " is not valid"), (Object[])new Object[0]);
            }
            try {
                this._file.close();
            }
            catch (IOException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"436", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"423", (Object)this);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"440", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"429", (Object)this);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
            this._logFileHeader = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)"InternalLogException");
            }
            throw new InternalLogException();
        }
        if (!this._logFileHeader.compatible()) {
            try {
                this._file.close();
            }
            catch (IOException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"462", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"423", (Object)this);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"466", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"429", (Object)this);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
            this._logFileHeader = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (!this.serviceCompatible()) {
            try {
                this._file.close();
            }
            catch (IOException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"487", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"423", (Object)this);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"491", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"429", (Object)this);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
            this._logFileHeader = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileOpen");
        }
    }

    @ManualTrace
    protected boolean fileExists() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileExists", (Object[])new Object[]{this});
        }
        boolean fileAlreadyExists = true;
        File file = new File(this._logDirectory, this._fileName);
        boolean bl = fileAlreadyExists = file.exists() && file.length() > 0L;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileExists", (Object)new Boolean(fileAlreadyExists));
        }
        return fileAlreadyExists;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void fileClose() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileClose", (Object[])new Object[]{this});
        }
        if (this._fileChannel != null) {
            try {
                if (this._outstandingWritableLogRecords.get() == 0 && !this._exceptionInForce) {
                    this.force();
                    this._logFileHeader.setCleanShutdown();
                    this.writeFileHeader(false);
                    this.force();
                }
                this._file.close();
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"561", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileClose", (String)"541", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileClose", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)e);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileClose");
        }
    }

    @ManualTrace
    public WriteableLogRecord getWriteableLogRecord(int recordLength, long sequenceNumber) throws InternalLogException {
        if (!this._headerFlushedFollowingRestart) {
            this.writeFileHeader(true);
            this._headerFlushedFollowingRestart = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWriteableLogRecord", (Object[])new Object[]{new Integer(recordLength), new Long(sequenceNumber), this});
        }
        ByteBuffer viewBuffer = (ByteBuffer)this._fileBuffer.slice().limit(recordLength + WriteableLogRecord.HEADER_SIZE);
        WriteableLogRecord writeableLogRecord = new WriteableLogRecord(viewBuffer, sequenceNumber, recordLength, this._fileBuffer.position());
        this._fileBuffer.position(this._fileBuffer.position() + recordLength + WriteableLogRecord.HEADER_SIZE);
        this._outstandingWritableLogRecords.incrementAndGet();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)writeableLogRecord);
        }
        return writeableLogRecord;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void writeFileHeader(boolean maintainPosition) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeFileHeader", (Object[])new Object[]{this, maintainPosition});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing header for log file " + this._fileName), (Object[])new Object[0]);
            }
            this._logFileHeader.write(this._fileBuffer, maintainPosition);
            this.force();
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"642", (Object)this, (Object[])new Object[]{maintainPosition});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", (String)"706", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileHeader", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"647", (Object)this, (Object[])new Object[]{maintainPosition});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", (String)"712", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileHeader", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeFileHeader");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void writeFileStatus(boolean maintainPosition) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeFileStatus", (Object[])new Object[]{this, maintainPosition});
        }
        if (this._logFileHeader.status() == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileStatus", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            int currentFilePointer = 0;
            if (maintainPosition) {
                currentFilePointer = this._fileBuffer.position();
            }
            this._fileBuffer.position(STATUS_FIELD_FILE_OFFSET);
            this._fileBuffer.putInt(this._logFileHeader.status());
            this.force();
            if (maintainPosition) {
                this._fileBuffer.position(currentFilePointer);
            }
        }
        catch (Throwable currentFilePointer) {
            void exc;
            FFDCFilter.processException((Throwable)currentFilePointer, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"702", (Object)this, (Object[])new Object[]{maintainPosition});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileStatus", (String)"797", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileStatus", (Object)"WriteOperationFailedException");
            }
            throw new WriteOperationFailedException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeFileStatus");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void readFileHeader() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"readFileHeader", (Object[])new Object[]{this});
            }
            this._logFileHeader.reset();
            try {
                if (this._fileBuffer.capacity() >= 4) {
                    this._logFileHeader.read(this._fileBuffer);
                }
            }
            catch (Throwable throwable) {
                void exc;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"740", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.readFileHeader", (String)"863", (Object)this);
                if (!tc.isEventEnabled()) break block5;
                Tr.event((TraceComponent)tc, (String)"The log header could not be read from the disk due to an unexpected exception", (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readFileHeader");
        }
    }

    @ManualTrace
    private boolean serviceCompatible() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceCompatible", (Object[])new Object[0]);
        }
        boolean serviceCompatible = false;
        String serviceNameFromFile = this._logFileHeader.serviceName();
        int serviceVersionFromFile = this._logFileHeader.serviceVersion();
        String logNameFromFile = this._logFileHeader.logName();
        if (serviceVersionFromFile > this._serviceVersion || serviceNameFromFile == null || logNameFromFile == null || !serviceNameFromFile.equals(this._serviceName) || !logNameFromFile.equals(this._logName)) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Client service and recovery log are not compatible", (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Current service name is " + this._serviceName), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Service name from file is " + serviceNameFromFile), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Current log name is " + this._logName), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Log name from file is " + logNameFromFile), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Client version number is " + this._serviceVersion), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Version number from file is " + serviceVersionFromFile), (Object[])new Object[0]);
            }
        } else {
            serviceCompatible = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceCompatible", (Object)serviceCompatible);
        }
        return serviceCompatible;
    }

    @ManualTrace
    protected LogFileHeader logFileHeader() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logFileHeader", (Object[])new Object[]{this});
            Tr.exit((TraceComponent)tc, (String)"logFileHeader", (Object)this._logFileHeader);
        }
        return this._logFileHeader;
    }

    @ManualTrace
    public byte[] getServiceData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceData", (Object[])new Object[]{this});
        }
        byte[] serviceData = null;
        if (this._logFileHeader != null) {
            serviceData = this._logFileHeader.getServiceData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)RLSUtils.toHexString(serviceData, 32));
        }
        return serviceData;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public int freeBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"freeBytes", (Object[])new Object[]{this});
        }
        int freeBytes = 0;
        try {
            int currentCursorPosition = this._fileBuffer.position();
            int fileLength = this._fileBuffer.capacity();
            freeBytes = fileLength - currentCursorPosition;
            if (freeBytes < 0) {
                freeBytes = 0;
            }
        }
        catch (Throwable currentCursorPosition) {
            void exc;
            FFDCFilter.processException((Throwable)currentCursorPosition, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"860", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.freeBytes", (String)"956", (Object)this);
            freeBytes = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"freeBytes", (Object)new Integer(freeBytes));
        }
        return freeBytes;
    }

    @ManualTrace
    public void setServiceData(byte[] serviceData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object[])new Object[]{RLSUtils.toHexString(serviceData, 32), this});
        }
        this._logFileHeader.setServiceData(serviceData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServiceData");
        }
    }

    @ManualTrace
    public String fileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileName", (Object[])new Object[]{this});
            Tr.exit((TraceComponent)tc, (String)"fileName", (Object)this._fileName);
        }
        return this._fileName;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void keypointStarting(long nextRecordSequenceNumber) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object[])new Object[]{new Long(nextRecordSequenceNumber), this});
        }
        this._logFileHeader.keypointStarting(nextRecordSequenceNumber);
        try {
            this.writeFileHeader(false);
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"931", (Object)this, (Object[])new Object[]{nextRecordSequenceNumber});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", (String)"1073", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"936", (Object)this, (Object[])new Object[]{nextRecordSequenceNumber});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", (String)"1079", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void keypointComplete() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointComplete", (Object[])new Object[]{this});
        }
        this._logFileHeader.keypointComplete();
        try {
            this.writeFileStatus(true);
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"964", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", (String)"1117", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointComplete", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"969", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", (String)"1123", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointComplete", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointComplete");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void becomeInactive() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"becomeInactive", (Object[])new Object[]{this});
        }
        this._logFileHeader.changeStatus(2);
        try {
            this.writeFileStatus(false);
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"997", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", (String)"1161", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"becomeInactive", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"1002", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", (String)"1167", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"becomeInactive", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"becomeInactive", (Object)this);
        }
    }

    @ManualTrace
    void becomeActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"becomeActive", (Object[])new Object[]{this});
        }
        this._logFileHeader.changeStatus(4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"becomeActive");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void fileExtend(int newFileSize) throws LogAllocationException {
        int fileLength;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileExtend", (Object[])new Object[]{new Integer(newFileSize), this});
        }
        if ((fileLength = this._fileBuffer.capacity()) < newFileSize) {
            try {
                int originalPosition = this._fileBuffer.position();
                Tr.event((TraceComponent)tc, (String)("Expanding log file to size of " + newFileSize + " bytes."), (Object[])new Object[0]);
                if (this._isMapped) {
                    this._fileBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, newFileSize);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"File is NOT mapped.  Allocating new DirectByteBuffer", (Object[])new Object[0]);
                    }
                    this._fileBuffer.position(0);
                    ByteBuffer newByteBuffer = ByteBuffer.allocateDirect(newFileSize);
                    newByteBuffer.put(this._fileBuffer);
                    newByteBuffer.position(0);
                    this._fileChannel.write(newByteBuffer, 0L);
                    this._fileBuffer = newByteBuffer;
                }
                this._fileBuffer.position(originalPosition);
                this._fileSize = newFileSize;
            }
            catch (Exception originalPosition) {
                void exc;
                FFDCFilter.processException((Throwable)originalPosition, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"1083", (Object)this, (Object[])new Object[]{newFileSize});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileExtend", (String)"1266", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to extend file " + this._fileName + " to " + newFileSize + " bytes"), (Object[])new Object[0]);
                    Tr.exit((TraceComponent)tc, (String)"fileExtend", (Object)"LogAllocationException");
                }
                throw new LogAllocationException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileExtend");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force", (Object[])new Object[]{this});
        }
        try {
            if (this._isMapped) {
                ((MappedByteBuffer)this._fileBuffer).force();
            } else {
                this.writePendingToFile();
                this._fileChannel.force(false);
            }
        }
        catch (IOException iOException) {
            void ioe;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"1118", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.force", (String)"1049", (Object)this);
            this._exceptionInForce = true;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unable to force file " + this._fileName), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)ioe);
        }
        catch (InternalLogException ioe) {
            void exc;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"1129", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.force", (String)"1056", (Object)this);
            this._exceptionInForce = true;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unable to force file " + this._fileName), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)"InternalLogException");
            }
            throw exc;
        }
        catch (LogIncompatibleException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle", (String)"1137", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.force", (String)"1096", (Object)this);
            this._exceptionInForce = true;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unable to force file " + this._fileName), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"force");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void writeLogRecord(LogRecord logRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeLogRecord", (Object[])new Object[]{logRecord});
        }
        if (!this._isMapped) {
            List list = this._pendingWriteList;
            synchronized (list) {
                this._pendingWriteList.add(logRecord);
            }
        }
        this._outstandingWritableLogRecords.decrementAndGet();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeLogRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private void writePendingToFile() throws IOException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writePendingToFile", (Object[])new Object[0]);
        }
        List list = this._pendingWriteList;
        synchronized (list) {
            LogRecord[] records = this._pendingWriteList.toArray(new LogRecord[0]);
            if (!Boolean.getBoolean("com.ibm.ws.recoverylog.spi.UseVectoredIO")) {
                ByteBuffer header = (ByteBuffer)this._fileBuffer.duplicate().position(0).limit(this._logFileHeader.length());
                this._fileChannel.write(header, 0L);
                for (int i = 0; i < records.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Performing write at position " + records[i].absolutePosition()), (Object[])new Object[0]);
                    }
                    this._fileChannel.write((ByteBuffer)records[i]._buffer.flip(), records[i].absolutePosition());
                }
            } else {
                Arrays.sort(records, this._recordComparator);
                ByteBuffer[] buffers = new ByteBuffer[records.length + 1];
                int[] positions = new int[records.length + 1];
                for (int i = 0; i < records.length; ++i) {
                    buffers[i + 1] = (ByteBuffer)records[i]._buffer.flip();
                    positions[i + 1] = records[i].absolutePosition();
                }
                buffers[0] = (ByteBuffer)this._fileBuffer.duplicate().position(0).limit(this._logFileHeader.length());
                positions[0] = 0;
                int idx = 0;
                while (idx < buffers.length) {
                    int min = idx;
                    int max = idx;
                    while (max <= buffers.length - 2) {
                        if (positions[max + 1] != positions[max] + buffers[max].remaining()) continue;
                        ++max;
                    }
                    this._fileChannel.position(positions[min]);
                    this._fileChannel.write(buffers, min, max - min + 1);
                    idx = max + 1;
                }
            }
            this._pendingWriteList.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writePendingToFile");
        }
    }

    @ManualTrace
    public void resetHeader(LogFileHandle validFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetHeader", (Object[])new Object[0]);
        }
        this._logFileHeader.resetHeader(validFile.logFileHeader());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetHeader");
        }
    }

    public String toString() {
        return "LogFileHandle: " + this._serviceName + " " + this._logName;
    }
}

