/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPATokenizer {
    private static final TraceComponent tc = Tr.register(LTPATokenizer.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    private static final char TOKEN_DELIM = '%';
    private static final char USER_DATA_DELIM = '$';
    private static final char USER_ATTRIB_DELIM = ':';
    private static final String STRING_ATTRIB_DELIM = "|";
    static final long serialVersionUID = 414514185382254398L;

    public static String createUserData(Map<String, ArrayList<String>> attributes) {
        String userData = "";
        StringBuilder sb = new StringBuilder();
        if (attributes.size() > 1) {
            TreeSet<String> elementTreeSet = new TreeSet<String>(attributes.keySet());
            Iterator iterator = elementTreeSet.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                ArrayList<String> list = attributes.get(key);
                String value = LTPATokenizer.convertArrayListToString(list);
                if (value == null) continue;
                sb.append(key).append(':').append(value).append('$');
            }
        } else {
            for (Map.Entry entry : attributes.entrySet()) {
                String value = LTPATokenizer.convertArrayListToString((ArrayList)entry.getValue());
                sb.append((String)entry.getKey()).append(':').append(value).append('$');
            }
        }
        userData = sb.toString();
        String ret = userData.substring(0, userData.length() - 1);
        return ret;
    }

    @FFDCIgnore(value={Exception.class})
    protected static final String[] parseToken(String tokenStr) throws InvalidTokenException {
        String[] fields = new String[3];
        int tokenLen = tokenStr.length();
        int signBegin = -1;
        int expireBegin = -1;
        try {
            for (int i = tokenLen - 1; i > -1; --i) {
                char c = tokenStr.charAt(i);
                if (c != '%' || tokenStr.charAt(i - 1) == '\\') continue;
                if (signBegin == -1) {
                    signBegin = i + 1;
                    continue;
                }
                expireBegin = i + 1;
                break;
            }
            if (expireBegin == -1) {
                expireBegin = signBegin;
                fields[0] = tokenStr.substring(0, expireBegin - 1);
                fields[1] = tokenStr.substring(expireBegin, tokenLen);
            } else {
                fields[0] = tokenStr.substring(0, expireBegin - 1);
                fields[1] = tokenStr.substring(expireBegin, signBegin - 1);
                fields[2] = tokenStr.substring(signBegin, tokenLen);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error parsing token; " + e), (Object[])new Object[0]);
            }
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
        return fields;
    }

    private static void addAttributes(String data, Map<String, ArrayList<String>> attribs) {
        int keyIndex = 0;
        int dataLen = data.length();
        for (keyIndex = 0; keyIndex < dataLen; ++keyIndex) {
            if (data.charAt(keyIndex) != ':' || data.charAt(keyIndex - 1) == '\\') continue;
            String key = data.substring(0, keyIndex);
            String value = data.substring(keyIndex + 1, dataLen);
            ArrayList<String> list = LTPATokenizer.convertStringToArrayList(value);
            if (list == null) continue;
            attribs.put(key, list);
        }
    }

    protected static final Map<String, ArrayList<String>> parseUserData(String userData) {
        String data;
        int tokenLen = userData.length();
        int numOfAttribs = 1;
        int lastDelim = 0;
        int i = 0;
        HashMap<String, ArrayList<String>> attribs = new HashMap<String, ArrayList<String>>();
        for (i = 0; i < tokenLen; ++i) {
            if (userData.charAt(i) != '$' || userData.charAt(i - 1) == '\\') continue;
            ++numOfAttribs;
            data = userData.substring(lastDelim, i);
            lastDelim = i + 1;
            LTPATokenizer.addAttributes(data, attribs);
        }
        data = userData.substring(lastDelim, tokenLen);
        LTPATokenizer.addAttributes(data, attribs);
        return attribs;
    }

    private static final String convertArrayListToString(ArrayList<String> input) {
        if (input != null && input.size() > 0) {
            StringBuilder result = new StringBuilder();
            String[] type = input.toArray(new String[input.size()]);
            for (int i = 0; i < type.length; ++i) {
                if (i != 0) {
                    result.append(STRING_ATTRIB_DELIM);
                }
                result.append(LTPATokenizer.escape(type[i]));
            }
            return result.toString();
        }
        return null;
    }

    private static final ArrayList<String> convertStringToArrayList(String value) {
        if (value != null && value.length() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(value, STRING_ATTRIB_DELIM);
            while (st.hasMoreTokens()) {
                String nextString = LTPATokenizer.unescape(st.nextToken());
                if (nextString == null) continue;
                result.add(nextString);
            }
            return result;
        }
        return null;
    }

    private static final String escape(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length() * 2);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '$': 
                case '%': 
                case ':': {
                    sb.append('\\');
                    break;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final String unescape(String str) {
        StringBuilder sb = new StringBuilder(str.length() * 2);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && i < len - 1) {
                char d = str.charAt(i + 1);
                if (d == '$' || d == ':' || d == '%') continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

