/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.BaseLocalizationDefinition;
import com.ibm.ws.sib.admin.ControllableRegistrationService;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.DestinationForeignDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MQLinkDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.comms.mq.MQLinkManager;
import com.ibm.ws.sib.comms.mq.MQLinkObject;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MQLinkLocalization;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationCorruptException;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPMQLinkCorruptException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPNullParameterException;
import com.ibm.ws.sib.processor.exceptions.SIMPResourceException;
import com.ibm.ws.sib.processor.exceptions.SIMPTemporaryDestinationNotFoundException;
import com.ibm.ws.sib.processor.impl.AliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.AsynchDeletionThread;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.DeletePubSubMsgsThread;
import com.ibm.ws.sib.processor.impl.DestinationListenerDataObject;
import com.ibm.ws.sib.processor.impl.DestinationNamePattern;
import com.ibm.ws.sib.processor.impl.ForeignDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusIndex;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkIndex;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.statemodel.State;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.MessageProcessorStore;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.AliasChainValidator;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.LinkSelection;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DestinationManager
extends SIMPItemStream {
    private static final TraceComponent tc = SibTr.register(DestinationManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc_cwsik = SibTr.register(new Object(){}.getClass(), (String)"SIBProcessor", (String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private SIMPTransactionManager txManager;
    private MessageProcessor messageProcessor;
    private DestinationIndex destinationIndex;
    private ForeignBusIndex foreignBusIndex;
    private LinkIndex linkIndex;
    private HashMap durableSubscriptions;
    private ConcurrentHashMap<String, Object> nondurableSharedSubscriptions;
    private boolean reconciling = false;
    protected Object deletionThreadLock = new Object();
    private AsynchDeletionThread asynchDeletionThread = null;
    private AsyncUpdateThread asyncUpdateThread = null;
    private AsyncUpdateThread persistLockThread = null;
    private final List<DestinationListenerDataObject> destinationListeners = new LinkedList<DestinationListenerDataObject>();
    private final List<SubscriptionItemStream> deletableSubscriptions = new ArrayList<SubscriptionItemStream>();
    private MQLinkManager _mqlinkManager = null;
    private ThreadPoolExecutor _reconstituteThreadpool = null;
    private volatile boolean _isAsyncDeletionThreadStartable = false;

    public DestinationManager() {
    }

    protected DestinationManager(MessageProcessor messageProcessor, MessageProcessorStore parentItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationManager", (Object)new Object[]{messageProcessor, parentItemStream});
        }
        LocalTransaction transaction = messageProcessor.getTXManager().createLocalTransaction(true);
        try {
            parentItemStream.addItemStream(this, (Transaction)transaction);
            this.initializeNonPersistent(messageProcessor);
            transaction.commit();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.DestinationManager", (String)"1:336:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            this.handleRollback(transaction);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"DestinationManager", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)e);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.DestinationManager", (String)"1:354:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            this.handleRollback(transaction);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"DestinationManager", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationManager", (Object)((Object)this));
        }
    }

    private void handleRollback(LocalTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)transaction);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.handleRollback", (String)"1:394:1.508.1.7", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    protected void initializeNonPersistent(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)messageProcessor);
        }
        this.messageProcessor = messageProcessor;
        this.txManager = messageProcessor.getTXManager();
        this.destinationIndex = new DestinationIndex(messageProcessor.getMessagingEngineBus());
        this.foreignBusIndex = new ForeignBusIndex();
        this.linkIndex = new LinkIndex();
        this.durableSubscriptions = new HashMap();
        this.nondurableSharedSubscriptions = new ConcurrentHashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public ConcurrentHashMap<String, Object> getNondurableSharedSubscriptions() {
        return this.nondurableSharedSubscriptions;
    }

    private void putDestinationIntoIndoubtState(SIBUuid12 destDefUUID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putDestinationIntoIndoubtState");
        }
        DestinationHandler destHand = this.destinationIndex.findByUuid(destDefUUID, null);
        this.destinationIndex.putInDoubt(destHand);
        destHand.setIndoubt(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putDestinationIntoIndoubtState");
        }
    }

    private void putLinkIntoIndoubtState(String linkName) {
        DestinationHandler destHand;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putLinkIntoIndoubtState", (Object)linkName);
        }
        if ((destHand = this.linkIndex.findByName(linkName, null)) != null) {
            this.linkIndex.putInDoubt(destHand);
            destHand.setIndoubt(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putLinkIntoIndoubtState");
        }
    }

    public void moveAllInDoubtToUnreconciled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveAllInDoubtToUnreconciled");
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        filter.INDOUBT = Boolean.TRUE;
        SIMPIterator itr = this.destinationIndex.iterator(filter);
        while (itr.hasNext()) {
            BaseDestinationHandler destHand = (BaseDestinationHandler)itr.next();
            this.destinationIndex.putUnreconciled(destHand);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveAllInDoubtToUnreconciled");
        }
    }

    public void validateUnreconciled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"validateUnreconciled");
        }
        JsMessagingEngine engine = this.messageProcessor.getMessagingEngine();
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        filter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator itr = this.destinationIndex.iterator(filter);
        while (itr.hasNext()) {
            BaseDestinationHandler bdh = (BaseDestinationHandler)itr.next();
            try {
                BaseDestinationDefinition baseDestDef = engine.getSIBDestination(engine.getBusName(), bdh.getName());
                if (!baseDestDef.getUUID().equals((Object)bdh.getUuid())) continue;
                Set localitySet = engine.getSIBDestinationLocalitySet(engine.getBusName(), baseDestDef.getUUID().toString());
                boolean qLocalisation = localitySet.contains(engine.getUuid().toString());
                DestinationDefinition destDef = (DestinationDefinition)baseDestDef;
                SIBUuid12 destUUID = destDef.getUUID();
                if (qLocalisation) {
                    try {
                        this.putDestinationIntoIndoubtState(destUUID);
                        SibTr.error((TraceComponent)tc, (String)"DESTINATION_INDOUBT_ERROR_CWSIP0062", (Object)new Object[]{destDef.getName(), destUUID});
                        throw new SIErrorException(nls.getFormattedMessage("DESTINATION_INDOUBT_ERROR_CWSIP0062", new Object[]{destDef.getName(), destUUID}, null));
                    }
                    catch (SIErrorException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.validateUnreconciled", (String)"1:582:1.508.1.7", (Object)((Object)this));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        continue;
                    }
                }
                try {
                    this.deleteDestinationLocalization(bdh.getDefinition().getUUID().toString(), destDef, localitySet);
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.validateUnreconciled", (String)"1:607:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)exception));
                    this.putDestinationIntoIndoubtState(destUUID);
                }
            }
            catch (SIBExceptionDestinationNotFound e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIBExceptionBase base) {
                FFDCFilter.processException((Throwable)base, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.validateUnreconciled", (String)"1:634:1.508.1.7", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)base));
                this.putDestinationIntoIndoubtState(bdh.getUuid());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"validateUnreconciled");
        }
    }

    private void startNewReconstituteThread(Runnable runnable) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewReconstituteThread");
        }
        if (this._reconstituteThreadpool == null) {
            this.createReconstituteThreadPool();
        }
        this._reconstituteThreadpool.execute(runnable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewReconstituteThread");
        }
    }

    private synchronized void createReconstituteThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createReconstituteThreadPool");
        }
        if (this._reconstituteThreadpool == null) {
            int maxThreadPoolSize;
            if (this.messageProcessor.getMessagingEngine().datastoreExists()) {
                maxThreadPoolSize = this.messageProcessor.getCustomProperties().get_max_reconstitute_threadpool_size();
                int noOfCores = CpuInfo.getAvailableProcessors();
                if (maxThreadPoolSize <= 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.info((TraceComponent)tc, (String)"INVALID_RECONSTITUTE_THREADPOOL_SIZE_CWSIP0068", (Object)new Object[]{maxThreadPoolSize});
                    }
                    maxThreadPoolSize = noOfCores;
                }
                if (maxThreadPoolSize > noOfCores) {
                    SibTr.warning((TraceComponent)tc, (String)"INVALID_RECONSTITUTE_THREADPOOL_SIZE_CWSIP0069");
                }
            } else {
                maxThreadPoolSize = 1;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.info((TraceComponent)tc, (String)"MAX_RECONSTITUTE_THREADPOOL_SIZE_CWSIP0070", (Object)new Object[]{maxThreadPoolSize});
            }
            this._reconstituteThreadpool = new ThreadPoolExecutor(maxThreadPoolSize, maxThreadPoolSize, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createReconstituteThreadPool");
        }
    }

    protected void reconstitute(final int startMode) throws MessageStoreException {
        LinkHandler linkHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Integer(startMode));
        }
        NonLockingCursor cursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(BaseDestinationHandler.class));
        AbstractItem item = null;
        if ((startMode & 1) == 1 && (startMode & 2) == 0) {
            SibTr.info((TraceComponent)tc, (String)"FLUSH_REQUESTED_MESSAGE_CWSIP0780", (Object)this.messageProcessor.getMessagingEngineName());
        }
        while (null != (item = cursor.next())) {
            final BaseDestinationHandler dh = (BaseDestinationHandler)item;
            if (dh.isToBeIgnored()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Ignoring old corrupt destination " + dh.getName()));
                continue;
            }
            if (dh.isTemporary()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Deleting temporary destination " + dh.getName()));
                }
                try {
                    dh.deleteDirtyTemporary(this.messageProcessor, this.durableSubscriptions);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:788:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:799:1.508.1.7", SIMPUtils.getStackTrace(e), dh.getName()});
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Deleted temporary destination " + dh.getName()));
                continue;
            }
            try {
                this.startNewReconstituteThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            dh.reconstitute(DestinationManager.this.messageProcessor, DestinationManager.this.durableSubscriptions, startMode);
                        }
                        catch (SIResourceException mse) {
                            FFDCFilter.processException((Throwable)mse, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:826:1.508.1.7", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0051", (Object)new Object[]{dh.getName(), SIMPUtils.getStackTrace(mse)});
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)mse));
                            if (mse.getCause() instanceof SevereMessageStoreException) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    SibTr.event((TraceComponent)tc, (String)"Datasource has thrown a severe error!", (Object)((Object)mse));
                                }
                                DestinationManager.this.messageProcessor.getMessageStore().reportLocalError();
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:846:1.508.1.7", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0051", (Object)new Object[]{dh.getName(), SIMPUtils.getStackTrace(e)});
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                        }
                        DestinationIndex.Type type = new DestinationIndex.Type();
                        if (dh.isCorruptOrIndoubt()) {
                            type.state = State.CORRUPT;
                        } else if (dh.isSystem()) {
                            type.state = State.ACTIVE;
                            SIBUuid8 parsedME = SIMPUtils.parseME(dh.getName());
                            HashSet<String> queuePointLocalizingMEs = new HashSet<String>();
                            queuePointLocalizingMEs.add(parsedME.toString());
                            try {
                                dh.updateLocalizationSet(queuePointLocalizingMEs);
                            }
                            catch (SIResourceException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:890:1.508.1.7", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                        } else {
                            type.state = State.UNRECONCILED;
                        }
                        type.alias = new Boolean(dh.isAlias());
                        type.foreignDestination = new Boolean(dh.isForeign());
                        type.queue = new Boolean(!dh.isPubSub());
                        type.local = new Boolean(dh.hasLocal());
                        type.remote = new Boolean(dh.hasRemote());
                        DestinationManager.this.destinationIndex.put(dh, type);
                        dh.registerControlAdapters();
                        Object[] uuids = dh.getPostReconstitutePseudoIds();
                        if (uuids != null) {
                            for (int i = 0; i < uuids.length; ++i) {
                                SIBUuid12 pseudoUuid = (SIBUuid12)uuids[i];
                                DestinationManager.this.destinationIndex.addPseudoUuid(dh, pseudoUuid);
                            }
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:926:1.508.1.7", (Object)((Object)this));
            }
        }
        if (this._reconstituteThreadpool != null) {
            this.waitUntilReconstitutionIsCompleted();
        }
        cursor.finished();
        cursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(LinkHandler.class));
        item = null;
        while (null != (item = cursor.next())) {
            linkHandler = (LinkHandler)item;
            if (linkHandler.isToBeIgnored()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Ignoring old corrupt link " + linkHandler.getName()));
                continue;
            }
            try {
                this.startNewReconstituteThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            linkHandler.reconstitute(DestinationManager.this.messageProcessor, DestinationManager.this.durableSubscriptions, startMode);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:984:1.508.1.7", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_WARM_START_ERROR_CWSIP0056", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:999:1.508.1.7", SIMPUtils.getStackTrace(e)});
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                        }
                        LinkIndex.Type type = new LinkIndex.Type();
                        type.state = linkHandler.isCorruptOrIndoubt() ? State.CORRUPT : (linkHandler.isSystem() ? State.ACTIVE : State.UNRECONCILED);
                        type.mqLink = Boolean.FALSE;
                        type.local = new Boolean(linkHandler.hasLocal());
                        type.remote = new Boolean(!linkHandler.hasLocal());
                        DestinationManager.this.linkIndex.put(linkHandler, type);
                        linkHandler.registerControlAdapters();
                    }
                });
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:1023:1.508.1.7", (Object)((Object)this));
            }
        }
        if (this._reconstituteThreadpool != null) {
            this.waitUntilReconstitutionIsCompleted();
        }
        cursor.finished();
        cursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(MQLinkHandler.class));
        item = null;
        while (null != (item = cursor.next())) {
            linkHandler = (MQLinkHandler)item;
            if (linkHandler.isToBeIgnored()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Ignoring old corrupt MQlink " + linkHandler.getName()));
                continue;
            }
            try {
                this.startNewReconstituteThread(new Runnable((MQLinkHandler)linkHandler, startMode){
                    final /* synthetic */ MQLinkHandler val$linkHandler;
                    final /* synthetic */ int val$startMode;
                    {
                        this.val$linkHandler = mQLinkHandler;
                        this.val$startMode = n;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$linkHandler.reconstitute(DestinationManager.this.messageProcessor, DestinationManager.this.durableSubscriptions, this.val$startMode);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:1082:1.508.1.7", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_WARM_START_ERROR_CWSIP0056", (Object)new Object[]{this.val$linkHandler.getName(), this.val$linkHandler.getUuid(), SIMPUtils.getStackTrace(e)});
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                        }
                        LinkIndex.Type type = new LinkIndex.Type();
                        type.state = this.val$linkHandler.isCorruptOrIndoubt() ? State.CORRUPT : (this.val$linkHandler.isSystem() ? State.ACTIVE : State.UNRECONCILED);
                        type.mqLink = Boolean.TRUE;
                        type.local = Boolean.TRUE;
                        type.remote = Boolean.FALSE;
                        DestinationManager.this.linkIndex.put(this.val$linkHandler, type);
                        this.val$linkHandler.registerControlAdapters();
                    }
                });
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:1120:1.508.1.7", (Object)((Object)this));
            }
        }
        if (this._reconstituteThreadpool != null) {
            this.waitUntilReconstitutionIsCompleted();
        }
        cursor.finished();
        if ((startMode & 1) == 1 && (startMode & 2) == 0) {
            SibTr.info((TraceComponent)tc, (String)"FLUSH_COMPLETED_MESSAGE_CWSIP0783", (Object)this.messageProcessor.getMessagingEngineName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    private void waitUntilReconstitutionIsCompleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitUntilReconstitutionISCompleted");
        }
        this._reconstituteThreadpool.shutdown();
        try {
            this._reconstituteThreadpool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        this._reconstituteThreadpool = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitUntilReconstitutionISCompleted");
        }
    }

    public final LinkHandler getLink(String linkName) {
        LinkTypeFilter filter = new LinkTypeFilter();
        return (LinkHandler)this.linkIndex.findByName(linkName, filter);
    }

    public DestinationHandler getDestination(JsDestinationAddress destinationAddr, boolean includeInvisible) throws SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        return this.getDestination(destinationAddr.getDestinationName(), destinationAddr.getBusName(), includeInvisible, false);
    }

    public DestinationHandler getDestination(JsDestinationAddress destinationAddr, boolean includeInvisible, boolean createRemoteDest) throws SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        return this.getDestination(destinationAddr.getDestinationName(), destinationAddr.getBusName(), includeInvisible, createRemoteDest);
    }

    public DestinationHandler getDestination(String destinationName, boolean includeInvisible) throws SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        return this.getDestination(destinationName, null, includeInvisible, false);
    }

    public DestinationHandler getDestination(String destinationName, String busName, boolean includeInvisible) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        return this.getDestination(destinationName, busName, includeInvisible, false);
    }

    public DestinationHandler getDestination(String destinationName, String busName, boolean includeInvisible, boolean createRemoteDest) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination", (Object)new Object[]{destinationName, busName, new Boolean(includeInvisible), new Boolean(createRemoteDest)});
        }
        try {
            dh = this.getDestinationInternal(destinationName, busName, null, includeInvisible, createRemoteDest);
        }
        catch (SIIncorrectCallException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.getDestination", (String)"1:1103:1.487", (Object)((Object)this));
            SIMPErrorException ee = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1092:1.487"}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1109:1.487"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)ee);
            }
            throw ee;
        }
        this.checkDestinationHandlerExists(dh != null, destinationName, this.messageProcessor.getMessagingEngineName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)dh);
        }
        return dh;
    }

    private DestinationHandler getDestinationInternal(String destinationName, String busName, AliasChainValidator validator, boolean includeInvisible, boolean create) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        boolean temporary;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationInternal", (Object)new Object[]{destinationName, busName, validator, new Boolean(includeInvisible)});
        }
        this.checkDestinationHandlerExists(destinationName != null, destinationName, this.messageProcessor.getMessagingEngineName());
        boolean remoteTemporaryOrSystem = false;
        boolean system = false;
        boolean bl = temporary = destinationName.startsWith("_Q") || destinationName.startsWith("_T");
        if (!temporary) {
            system = destinationName.startsWith("_P");
        }
        SIBUuid8 parsedME = null;
        DestinationHandler destination = null;
        if ((temporary || system) && (busName == null || busName.equals(this.messageProcessor.getMessagingEngineBus()))) {
            parsedME = SIMPUtils.parseME(destinationName);
            if (parsedME != null) {
                boolean bl2 = remoteTemporaryOrSystem = !parsedME.equals((Object)this.messageProcessor.getMessagingEngineUuid());
                if (remoteTemporaryOrSystem && temporary) {
                    JsDestinationAddress actualDestinationAddr = SIMPUtils.createJsSystemDestinationAddress("SIMP.TDRECEIVER", parsedME);
                    destinationName = actualDestinationAddr.getDestinationName();
                    busName = actualDestinationAddr.getBusName();
                }
            } else {
                SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1092:1.487"}, null));
                e.setExceptionReason(900);
                e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1097:1.487"});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.getDestinationInternal", (String)"1:1103:1.487", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1109:1.487"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)e);
                }
                throw e;
            }
        }
        if (busName == null || busName.equals("")) {
            busName = this.messageProcessor.getMessagingEngineBus();
        }
        if ((destination = this.getDestinationInternal(destinationName, busName, includeInvisible)) == null && !temporary && !system) {
            destination = this.loadDestination(destinationName, busName, validator, true);
        }
        if (destination == null && !busName.equals(this.messageProcessor.getMessagingEngineBus())) {
            destination = this.findBus(busName);
        } else if (destination == null && remoteTemporaryOrSystem && create) {
            destination = this.createRemoteSystemDestination(destinationName, parsedME);
        }
        if (destination != null && destination.isCorruptOrIndoubt()) {
            String message = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_27", new Object[]{destinationName}, null);
            SIMPDestinationCorruptException e = new SIMPDestinationCorruptException(message);
            e.setExceptionReason(27);
            e.setExceptionInserts(new String[]{destinationName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)destination);
        }
        return destination;
    }

    private DestinationHandler loadDestination(String destinationId, String busName, AliasChainValidator validator, boolean findByName) throws SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        DestinationHandler destinationHandler;
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"loadDestination", (Object)new Object[]{destinationId, busName, validator, findByName});
            }
            destinationHandler = null;
            try {
                BaseDestinationDefinition bdd = null;
                bdd = findByName ? this.messageProcessor.getMessagingEngine().getSIBDestination(busName, destinationId) : this.messageProcessor.getMessagingEngine().getSIBDestinationByUuid(busName, destinationId);
                if (bdd.isAlias()) {
                    DestinationAliasDefinition add = (DestinationAliasDefinition)bdd;
                    destinationHandler = this.createAliasDestination(add, validator, null);
                    break block14;
                }
                if (bdd.isForeign()) {
                    DestinationForeignDefinition dfd = (DestinationForeignDefinition)bdd;
                    destinationHandler = this.createForeignDestination(dfd, busName);
                    break block14;
                }
                try {
                    DestinationDefinition dDef = (DestinationDefinition)bdd;
                    Set queuePointLocalitySet = this.messageProcessor.getSIBDestinationLocalitySet(busName, dDef.getUUID().toString(), false);
                    if (queuePointLocalitySet.contains(this.messageProcessor.getMessagingEngineUuid().toString()) || dDef.getDestinationType() == DestinationType.QUEUE && queuePointLocalitySet.size() == 0 || dDef.getDestinationType() == DestinationType.PORT && queuePointLocalitySet.size() == 0) {
                        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestintionManager", "1:1597:1.508.1.7", dDef.getName()}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.loadDestination", (String)"1:1602:1.508.1.7", (Object)((Object)this));
                        break block14;
                    }
                    destinationHandler = this.createRemoteDestination(dDef, queuePointLocalitySet);
                }
                catch (SIException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
            catch (SIBExceptionDestinationNotFound e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIBExceptionBase e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIResourceException e) {
                if (!(e instanceof SIMPResourceException)) {
                    SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                    ee.setExceptionReason(901);
                    ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager.loadDestination", "1:1650:1.508.1.7", SIMPUtils.getStackTrace(e)});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"loadDestination", (Object)ee);
                    }
                    throw ee;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"loadDestination", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadDestination", destinationHandler);
        }
        return destinationHandler;
    }

    public final DestinationHandler getDestinationInternal(String destinationName, String busName, boolean includeInvisible) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationInternal", (Object)new Object[]{destinationName, busName, new Boolean(includeInvisible)});
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        if (!includeInvisible) {
            destFilter.VISIBLE = Boolean.TRUE;
        }
        DestinationHandler dh = this.destinationIndex.findByName(destinationName, busName, destFilter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)dh);
        }
        return dh;
    }

    public final DestinationHandler getDestinationInternal(SIBUuid12 destinationUuid, boolean includeInvisible) {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationInternal", (Object)new Object[]{destinationUuid, new Boolean(includeInvisible)});
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        if (!includeInvisible) {
            destFilter.VISIBLE = Boolean.TRUE;
        }
        if ((dh = this.destinationIndex.findByUuid(destinationUuid, destFilter)) == null) {
            LinkTypeFilter linkFilter = new LinkTypeFilter();
            if (!includeInvisible) {
                linkFilter.VISIBLE = Boolean.TRUE;
            }
            dh = this.linkIndex.findByUuid(destinationUuid, linkFilter);
        }
        if (dh == null) {
            ForeignBusTypeFilter busFilter = new ForeignBusTypeFilter();
            if (!includeInvisible) {
                busFilter.VISIBLE = Boolean.TRUE;
            }
            dh = this.foreignBusIndex.findByUuid(destinationUuid, busFilter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)dh);
        }
        return dh;
    }

    public final void addPseudoDestination(SIBUuid12 destinationUuid, BaseDestinationHandler handler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPseudoDestination", (Object)new Object[]{destinationUuid, handler});
        }
        this.destinationIndex.addPseudoUuid(handler, destinationUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPseudoDestination");
        }
    }

    public final void removePseudoDestination(SIBUuid12 destinationUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removePseudoDestination", (Object)destinationUuid);
        }
        this.destinationIndex.removePseudoUuid(destinationUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removePseudoDestination");
        }
    }

    public void resetDestination(String destName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDestination", (Object)destName);
        }
        try {
            DestinationHandler dh = this.destinationIndex.findByName(destName, this.messageProcessor.getMessagingEngineBus(), null);
            this.checkDestinationHandlerExists(dh != null, destName, this.messageProcessor.getMessagingEngineBus());
            if (dh instanceof BaseDestinationHandler) {
                BaseDestinationHandler bdh = (BaseDestinationHandler)dh;
                LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                bdh.reset();
                this.destinationIndex.reset(dh);
                bdh.requestUpdate((Transaction)siTran);
                siTran.commit();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Have reset destination " + bdh.getName()));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Not a BDH, cannot reset destination " + dh.getName()));
            }
        }
        catch (MessageStoreException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDestination");
        }
    }

    public void resetLink(String linkName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetLink", (Object)linkName);
        }
        try {
            DestinationHandler link = this.linkIndex.findByName(linkName, null);
            this.checkDestinationHandlerExists(link != null, linkName, this.messageProcessor.getMessagingEngineBus());
            if (link instanceof LinkHandler) {
                LinkHandler linkhandler = (LinkHandler)link;
                LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                linkhandler.reset();
                this.linkIndex.reset(link);
                linkhandler.requestUpdate((Transaction)siTran);
                siTran.commit();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Have reset link " + linkhandler.getName()));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Not a LinkHandler, cannot reset handler for " + link.getName()));
            }
        }
        catch (MessageStoreException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetLink");
        }
    }

    public VirtualLinkDefinition getLinkDefinition(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkDefinition", (Object)busName);
        }
        ForeignBusDefinition foreignBus = this.messageProcessor.getForeignBus(busName);
        VirtualLinkDefinition link = null;
        if (foreignBus != null && foreignBus.hasLink()) {
            try {
                link = foreignBus.getLink();
            }
            catch (SIBExceptionNoLinkExists e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.getLinkDefinition", (String)"1:1951:1.508.1.7", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkDefinition", (Object)link);
        }
        return link;
    }

    public String getTopicSpaceMapping(String busName, SIBUuid12 topicSpace) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceMapping", (Object)new Object[]{busName, topicSpace});
        }
        VirtualLinkDefinition linkDef = this.getLinkDefinition(busName);
        String topicSpaceName = this.getDestinationInternal(topicSpace, true).getName();
        String mapping = null;
        mapping = linkDef != null && linkDef.getTopicSpaceMappings() != null ? (String)linkDef.getTopicSpaceMappings().get(topicSpaceName) : topicSpaceName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceMapping", (Object)mapping);
        }
        return mapping;
    }

    public HashMap getDurableSubscriptionsTable() {
        return this.durableSubscriptions;
    }

    public boolean destinationExists(JsDestinationAddress addr) throws SIMPNullParameterException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationExists", (Object)new Object[]{addr});
        }
        boolean exists = this.destinationExists(addr.getDestinationName(), addr.getBusName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)new Boolean(exists));
        }
        return exists;
    }

    public boolean destinationExists(String destinationName, String busName) throws SIMPNullParameterException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationExists", (Object)new Object[]{destinationName, busName});
        }
        if (destinationName == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)"Destination name null");
            }
            throw new SIMPNullParameterException(nls_cwsik.getFormattedMessage("MISSING_PARAM_ERROR_CWSIP0044", new Object[]{this.messageProcessor.getMessagingEngineName()}, null));
        }
        boolean exists = this.destinationIndex.containsKey(busName, destinationName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)new Boolean(exists));
        }
        return exists;
    }

    protected SIDestinationAddress createTemporaryDestination(Distribution distribution, String destinationPrefix) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createTemporaryDestination", (Object)new Object[]{destinationPrefix, distribution});
        }
        String name = this.createNewTemporaryDestinationName(destinationPrefix, this.messageProcessor.getMessagingEngineUuid(), distribution);
        DestinationType destinationType = DestinationType.QUEUE;
        if (distribution == Distribution.ALL) {
            destinationType = DestinationType.TOPICSPACE;
        }
        DestinationDefinition tempDestDefinition = this.messageProcessor.createDestinationDefinition(destinationType, name);
        tempDestDefinition.setMaxReliability(Reliability.RELIABLE_NONPERSISTENT);
        tempDestDefinition.setDefaultReliability(Reliability.RELIABLE_NONPERSISTENT);
        tempDestDefinition.setUUID(new SIBUuid12());
        if (this.destinationExists(name, this.messageProcessor.getMessagingEngineBus())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createTemporaryDestination", (Object)("Destination with name " + name + " already exists"));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:2120:1.508.1.7"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:2125:1.508.1.7"}, null));
        }
        SIDestinationAddress address = ((SIDestinationAddressFactory)MessageProcessor.getSingletonInstance("SIDestinationAddressFactory")).createSIDestinationAddress(name, true);
        ((JsDestinationAddress)address).setBusName(this.messageProcessor.getMessagingEngineBus());
        ((JsDestinationAddress)address).setME(this.messageProcessor.getMessagingEngineUuid());
        HashSet<String> destinationLocalizingSet = new HashSet<String>();
        destinationLocalizingSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
        LocalizationDefinition localizationDefinition = this.messageProcessor.createLocalizationDefinition(tempDestDefinition.getName());
        localizationDefinition.setDestinationHighMsgs(this.messageProcessor.getHighMessageThreshold());
        this.createDestinationLocalization(tempDestDefinition, localizationDefinition, destinationLocalizingSet, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTemporaryDestination", (Object)address);
        }
        return address;
    }

    String createNewTemporaryDestinationName(String destinationPrefix, SIBUuid8 meUuid, Distribution distribution) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewTemporaryDestinationName", (Object)new Object[]{destinationPrefix, meUuid, distribution});
        }
        if (destinationPrefix != null) {
            if (destinationPrefix.length() > 12) {
                destinationPrefix = destinationPrefix.substring(0, 12);
            }
        } else {
            destinationPrefix = "";
        }
        long count = this.messageProcessor.nextTick();
        StringBuffer sb = new StringBuffer("0000000000000000" + Long.toHexString(count).toUpperCase());
        String uniqueSuffix = sb.substring(sb.length() - 16).toString();
        String tempPrefix = null;
        tempPrefix = distribution == Distribution.ONE ? "_Q" : "_T";
        String name = tempPrefix + destinationPrefix + '_' + meUuid + uniqueSuffix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewTemporaryDestinationName", (Object)name);
        }
        return name;
    }

    protected void deleteTemporaryDestination(JsDestinationAddress destAddr) throws SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException {
        DestinationHandler destinationHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)destAddr);
        }
        try {
            destinationHandler = this.getDestination(destAddr, false);
        }
        catch (SINotPossibleInCurrentConfigurationException e1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)"SITemporaryDestinationNotFoundException");
            }
            throw new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{destAddr.getDestinationName()}, null));
        }
        if (destinationHandler.isTemporary()) {
            if (destinationHandler.isPubSub()) {
                if (destinationHandler.getSubscriptionIndex().getNonDurableSubscriptions() > 0) {
                    SIDestinationLockedException e = new SIDestinationLockedException(nls.getFormattedMessage("TEMPORARY_DESTINATION_IN_USE_ERROR_CWSIP0052", new Object[]{destAddr.getDestinationName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)((Object)e));
                    }
                    throw e;
                }
            } else {
                LocalizationPoint mis = destinationHandler.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
                ConsumerDispatcher cd = (ConsumerDispatcher)mis.getOutputHandler();
                if (cd.hasConsumersAttached()) {
                    SIDestinationLockedException e = new SIDestinationLockedException(nls.getFormattedMessage("TEMPORARY_DESTINATION_IN_USE_ERROR_CWSIP0052", new Object[]{destAddr.getDestinationName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)((Object)e));
                    }
                    throw e;
                }
            }
        }
        try {
            this.deleteDestinationLocalization(destinationHandler.getUuid().toString(), null, null);
        }
        catch (SINotPossibleInCurrentConfigurationException e1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)"SITemporaryDestinationNotFoundException");
            }
            throw new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{destAddr}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination");
        }
    }

    protected void removeDestination(DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDestination", (Object)dh);
        }
        if (dh.isLink()) {
            if (this.linkIndex.containsKey(dh)) {
                this.linkIndex.remove(dh);
            }
        } else if (this.destinationIndex.containsKey(dh)) {
            this.destinationIndex.remove(dh);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDestination");
        }
    }

    protected void createTransmissionDestination(SIBUuid8 remoteMEUuid) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createTransmissionDestination", (Object)remoteMEUuid);
        }
        String destinationName = remoteMEUuid.toString();
        DestinationDefinition destinationDefinition = this.messageProcessor.createDestinationDefinition(DestinationType.QUEUE, destinationName);
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        HashSet<String> destinationLocalizingSet = new HashSet<String>();
        destinationLocalizingSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
        this.createDestinationLocalization(destinationDefinition, this.messageProcessor.createLocalizationDefinition(destinationDefinition.getName()), destinationLocalizingSet, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTransmissionDestination");
        }
    }

    public MessageProcessor getLocalME() {
        return this.messageProcessor;
    }

    public void prepareToReconcile() {
        this.moveAllInDoubtToUnreconciled();
        this.reconciling = true;
    }

    public void reconcileLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileLocal");
        }
        this.reconciling = false;
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        filter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator itr = this.destinationIndex.iterator(filter);
        while (itr.hasNext()) {
            BaseDestinationHandler dh = (BaseDestinationHandler)itr.next();
            try {
                LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                dh.setToBeDeleted(true);
                this.destinationIndex.delete(dh);
                dh.requestUpdate((Transaction)siTran);
                siTran.commit();
                if (dh.isTemporary() || dh.isSystem()) continue;
                SibTr.info((TraceComponent)tc, (String)"LOCAL_DEST_DELETE_INFO_CWSIP00217", (Object)new Object[]{dh.getName()});
            }
            catch (MessageStoreException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileLocal");
        }
    }

    public void reconcileMQLinks() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileMQLinks");
        }
        this.reconciling = false;
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.TRUE;
        filter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator itr = this.linkIndex.iterator(filter);
        MQLinkManager mqlinkManager = this.getMQLinkManager();
        while (itr.hasNext()) {
            MQLinkHandler dh = (MQLinkHandler)itr.next();
            String mqLinkUuid = dh.getMqLinkUuid().toString();
            MQLinkObject mqlinkObj = null;
            try {
                mqlinkObj = mqlinkManager.create(this.messageProcessor.createMQLinkDefinition(mqLinkUuid), (MQLinkLocalization)dh, (ControllableRegistrationService)this.messageProcessor.getMEInstance("JsMBeanFactory"), true);
            }
            catch (SIResourceException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            dh.setMQLinkObject(mqlinkObj);
            this.linkIndex.cleanup(dh);
            this.linkIndex.defer(dh);
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileMQLinks");
        }
    }

    public void reconcileLocalLinks() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileLocalLinks");
        }
        this.reconciling = false;
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        filter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator itr = this.linkIndex.iterator(filter);
        while (itr.hasNext()) {
            LinkHandler dh = (LinkHandler)itr.next();
            try {
                LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                dh.setToBeDeleted(true);
                this.linkIndex.delete(dh);
                dh.requestUpdate((Transaction)siTran);
                siTran.commit();
                SibTr.info((TraceComponent)tc, (String)"LOCAL_LINK_DELETE_INFO_CWSIP0065", (Object)new Object[]{dh.getName(), dh.getUuid()});
            }
            catch (MessageStoreException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileLocalLinks");
        }
    }

    public void reconcileRemote() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileRemote");
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator itr = this.destinationIndex.iterator(filter);
        while (itr.hasNext()) {
            BaseDestinationHandler dh = (BaseDestinationHandler)itr.next();
            if (!dh.isToBeDeleted()) {
                LocalTransaction siTran;
                String destName = dh.getName();
                SIBUuid12 destUuid = dh.getUuid();
                try {
                    BaseDestinationDefinition dDef = this.messageProcessor.getMessagingEngine().getSIBDestination(null, destName);
                    if (!dDef.getUUID().equals((Object)dh.getUuid())) {
                        try {
                            siTran = this.txManager.createLocalTransaction(true);
                            dh.setToBeDeleted(true);
                            this.destinationIndex.delete(dh);
                            dh.requestUpdate((Transaction)siTran);
                            siTran.commit();
                            SibTr.info((TraceComponent)tc, (String)"REMOTE_DEST_DELETE_INFO_CWSIP0066", (Object)new Object[]{dh.getName(), dh.getUuid()});
                        }
                        catch (MessageStoreException me) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)me));
                        }
                        catch (SIException ce) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)ce));
                        }
                        continue;
                    }
                    Set queuePointLocalisationSet = this.messageProcessor.getMessagingEngine().getSIBDestinationLocalitySet(null, destUuid.toString());
                    dh.updateDefinition(dDef);
                    dh.updateLocalizationSet(queuePointLocalisationSet);
                    this.destinationIndex.setLocalizationFlags(dh);
                    this.destinationIndex.create(dh);
                    if (!dh.getHasReconciledStreamsToBeDeleted()) continue;
                    this.destinationIndex.cleanup(dh);
                }
                catch (SIBExceptionDestinationNotFound e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    try {
                        siTran = this.txManager.createLocalTransaction(true);
                        dh.setToBeDeleted(true);
                        this.destinationIndex.delete(dh);
                        dh.requestUpdate((Transaction)siTran);
                        siTran.commit();
                        SibTr.info((TraceComponent)tc, (String)"REMOTE_DEST_DELETE_INFO_CWSIP0066", (Object)new Object[]{dh.getName(), dh.getUuid()});
                    }
                    catch (MessageStoreException me) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    catch (SIException ce) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                }
                catch (SIBExceptionBase e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                catch (SIException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                continue;
            }
            this.destinationIndex.delete(dh);
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileRemote");
        }
    }

    public void reconcileRemoteTemporary() {
    }

    public void reconcileRemoteLinks() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileRemoteLinks");
        }
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.REMOTE = Boolean.TRUE;
        filter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator itr = this.linkIndex.iterator(filter);
        while (itr.hasNext()) {
            ForeignBusDefinition foreignBusDefinition;
            LinkHandler linkHandler = (LinkHandler)itr.next();
            SIBUuid12 linkUuid = linkHandler.getUuid();
            try {
                JsBus jsBus = (JsBus)this.messageProcessor.getMessagingEngine().getBus();
                foreignBusDefinition = jsBus.getForeignBusForLink(linkUuid.toString());
                if (foreignBusDefinition != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Retrieved foreignBusDefinition " + foreignBusDefinition.getName()));
                    }
                    VirtualLinkDefinition vld = foreignBusDefinition.getLinkForNextHop();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Retrieved link for next hop " + vld.getName()));
                    }
                }
            }
            catch (SIBExceptionNoLinkExists e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                foreignBusDefinition = null;
            }
            catch (SIBExceptionBusNotFound e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                foreignBusDefinition = null;
            }
            if (foreignBusDefinition == null) {
                LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                try {
                    linkHandler.setToBeDeleted(true);
                    linkHandler.requestUpdate((Transaction)siTran);
                    siTran.commit();
                    SibTr.info((TraceComponent)tc, (String)"REMOTE_LINK_DELETE_INFO_CWSIP0067", (Object)new Object[]{linkHandler.getName(), linkHandler.getUuid()});
                    this.linkIndex.delete(linkHandler);
                }
                catch (MessageStoreException me) {
                    FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconcileRemoteLinks", (String)"1:2839:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)me));
                }
                catch (SIException ce) {
                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconcileRemoteLinks", (String)"1:2849:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)ce));
                    this.handleRollback(siTran);
                }
                continue;
            }
            try {
                LinkSelection s = null;
                LinkManager linkManager = this.messageProcessor.getLinkManager();
                try {
                    s = linkManager.select(linkHandler.getUuid());
                }
                catch (LinkException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    throw new SIResourceException((Throwable)e);
                }
                SIBUuid8 localisingME = null;
                SIBUuid8 routingME = null;
                if (s != null) {
                    localisingME = s.getInboundMeUuid();
                    routingME = s.getOutboundMeUuid();
                    if (localisingME == null) {
                        localisingME = routingME;
                    }
                } else {
                    localisingME = new SIBUuid8("0000000000000001");
                    routingME = null;
                }
                linkHandler.updateLocalisationSet(localisingME, routingME);
                this.linkIndex.create(linkHandler);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconcileRemoteLinks", (String)"1:2909:1.508.1.7", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                this.linkIndex.corrupt(linkHandler);
            }
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileRemoteLinks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDestinationLocalization(String destinationUuid, DestinationDefinition destinationDefinition, Set<String> queuePointLocalizingMEs) throws SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIResourceException {
        boolean isDeletingEntireDestination;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)new Object[]{destinationUuid, destinationDefinition, queuePointLocalizingMEs});
        }
        BaseDestinationHandler destinationHandler = null;
        String messagingEngineName = this.messageProcessor.getMessagingEngineName();
        SIBUuid12 destUuid = new SIBUuid12(destinationUuid);
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.ALIAS = Boolean.FALSE;
        filter.FOREIGN_DESTINATION = Boolean.FALSE;
        DestinationHandler dh = this.destinationIndex.findByUuid(destUuid, filter);
        this.checkDestinationHandlerExists(dh != null, destinationUuid, this.messageProcessor.getMessagingEngineName());
        destinationHandler = (BaseDestinationHandler)dh;
        destinationHandler.getControlAdapter().deregisterControlAdapterMBean();
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            Object object = destinationHandler.getMediationConsumerLockObject();
            synchronized (object) {
                LockManager reallocationLock = destinationHandler.getReallocationLockManager();
                if (!destinationHandler.isPubSub()) {
                    reallocationLock.lockExclusive();
                }
                try {
                    BaseDestinationHandler baseDestinationHandler = destinationHandler;
                    synchronized (baseDestinationHandler) {
                        this.checkDestinationHandlerExists(!destinationHandler.isToBeDeleted() && !destinationHandler.isSystem(), destinationHandler.getName(), this.messageProcessor.getMessagingEngineName());
                        boolean destinationDefiniedLocally = destinationHandler.hasLocal();
                        if (!destinationDefiniedLocally && destinationHandler.getDestinationType() != DestinationType.SERVICE) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)("Destination not known " + destinationHandler.getName()));
                            }
                            if (destinationHandler.isTemporary()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)"SITemporaryDestinationNotFoundException");
                                }
                                throw new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("DESTINATION_INSTANCE_NOT_FOUND_ERROR_CWSIP0042", new Object[]{destinationHandler.getName(), messagingEngineName}, null));
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)"SINotPossibleInCurrentConfigurationException");
                            }
                            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_INSTANCE_NOT_FOUND_ERROR_CWSIP0042", new Object[]{destinationHandler.getName(), messagingEngineName}, null));
                        }
                        boolean bl = isDeletingEntireDestination = destinationDefinition == null || queuePointLocalizingMEs == null || queuePointLocalizingMEs.size() == 0;
                        if (isDeletingEntireDestination) {
                            destinationHandler.setDeleteInProgress(true);
                            destinationHandler.setToBeDeleted(true);
                        }
                    }
                }
                finally {
                    if (!destinationHandler.isPubSub()) {
                        reallocationLock.unlockExclusive();
                    }
                }
            }
        }
        if (isDeletingEntireDestination) {
            destinationHandler.closeProducers();
            destinationHandler.closeConsumers();
        }
        destinationManager = this;
        synchronized (destinationManager) {
            LockManager reallocationLock = destinationHandler.getReallocationLockManager();
            if (!destinationHandler.isPubSub()) {
                reallocationLock.lockExclusive();
            }
            try {
                BaseDestinationHandler baseDestinationHandler = destinationHandler;
                synchronized (baseDestinationHandler) {
                    if (isDeletingEntireDestination) {
                        ExternalAutoCommitTransaction transaction = this.txManager.createAutoCommitTransaction();
                        if (!dh.isTemporary() && !dh.isSystem()) {
                            SibTr.info((TraceComponent)tc, (String)"LOCAL_DEST_DELETE_INFO_CWSIP00217", (Object)new Object[]{dh.getName()});
                        }
                        this.destinationIndex.delete(destinationHandler);
                        try {
                            destinationHandler.requestUpdate((Transaction)transaction);
                        }
                        catch (MessageStoreException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteDestinationLocalization", (String)"1:3152:1.508.1.7", (Object)((Object)this));
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)"SIResourceException");
                            }
                            throw new SIResourceException((Throwable)e);
                        }
                        destinationHandler.addAllLocalisationsForCleanUp();
                        destinationHandler.clearLocalisingUuidsSet();
                        destinationHandler.deleteTargettingAliases();
                    } else {
                        destinationHandler.updateLocalizationSet(queuePointLocalizingMEs);
                        this.destinationIndex.setLocalizationFlags(destinationHandler);
                        destinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                        this.destinationIndex.cleanup(destinationHandler);
                    }
                    destinationHandler.deregisterDestination();
                }
            }
            finally {
                if (!destinationHandler.isPubSub()) {
                    reallocationLock.unlockExclusive();
                }
            }
        }
        if (isDeletingEntireDestination) {
            destinationHandler.setDeleteInProgress(false);
            this.startAsynchDeletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLinkLocalization(SIBUuid12 linkUuid) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteLinkLocalization", (Object)new Object[]{linkUuid});
        }
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.FALSE;
        LinkHandler linkHandler = (LinkHandler)this.linkIndex.findByUuid(linkUuid, filter);
        this.checkLinkExists(linkHandler != null, linkUuid.toString());
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            LinkHandler linkHandler2 = linkHandler;
            synchronized (linkHandler2) {
                try {
                    LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                    linkHandler.setToBeDeleted(true);
                    this.linkIndex.delete(linkHandler);
                    linkHandler.requestUpdate((Transaction)siTran);
                    siTran.commit();
                    SibTr.info((TraceComponent)tc, (String)"LOCAL_LINK_DELETE_INFO_CWSIP0065", (Object)new Object[]{linkHandler.getName(), linkHandler.getUuid()});
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteLinkLocalization", (String)"1:3285:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteLinkLocalization", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
                catch (SIException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                linkHandler.addAllLocalisationsForCleanUp();
                linkHandler.clearLocalisingUuidsSet();
            }
            this.startAsynchDeletion();
            linkHandler.closeProducers();
            linkHandler.closeConsumers();
            linkHandler.deleteTargettingAliases();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterLinkLocalization(VirtualLinkDefinition vld, SIBUuid12 linkUuid) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SIConnectionLostException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterLinkLocalization", (Object)new Object[]{vld, linkUuid});
        }
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.FALSE;
        LinkHandler linkHandler = (LinkHandler)this.linkIndex.findByUuid(linkUuid, filter);
        this.checkLinkExists(linkHandler != null, vld.getName());
        LinkHandler linkHandler2 = linkHandler;
        synchronized (linkHandler2) {
            LocalTransaction transaction = this.txManager.createLocalTransaction(true);
            try {
                linkHandler.updateLinkDefinition(vld, transaction);
                this.linkIndex.create(linkHandler);
                transaction.commit();
            }
            catch (SIResourceException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alterLinkLocalization", (Object)((Object)e));
                }
                this.handleRollback(transaction);
                throw e;
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.alterLinkLocalization", (String)"1:3407:1.508.1.7", (Object)((Object)this));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    SibTr.exit((TraceComponent)tc, (String)"alterLinkLocalization", (Object)e);
                }
                this.handleRollback(transaction);
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMQLinkLocalization(SIBUuid8 mqLinkUuid) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteMQLinkLocalization", (Object)new Object[]{mqLinkUuid});
        }
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.TRUE;
        MQLinkHandler mqLinkHandler = (MQLinkHandler)this.linkIndex.findByMQLinkUuid(mqLinkUuid, filter);
        this.checkMQLinkExists(mqLinkHandler != null, mqLinkUuid.toString());
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            MQLinkHandler mQLinkHandler = mqLinkHandler;
            synchronized (mQLinkHandler) {
                MQLinkManager mqlinkManager = this.getMQLinkManager();
                this.linkIndex.cleanup(mqLinkHandler);
                this.linkIndex.defer(mqLinkHandler);
                try {
                    mqlinkManager.delete(mqLinkHandler.getMQLinkObject());
                }
                catch (SIResourceException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                catch (SIException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                mqLinkHandler.addAllLocalisationsForCleanUp();
                mqLinkHandler.clearLocalisingUuidsSet();
                mqLinkHandler.deregisterLink();
            }
            mqLinkHandler.closeProducers();
            mqLinkHandler.closeConsumers();
            mqLinkHandler.deleteTargettingAliases();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteMQLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterMQLinkLocalization(MQLinkDefinition mqld, LocalizationDefinition ld, VirtualLinkDefinition vld) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SIConnectionLostException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterMQLinkLocalization", (Object)new Object[]{vld, mqld, ld});
        }
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.TRUE;
        MQLinkHandler mqLinkHandler = (MQLinkHandler)this.linkIndex.findByMQLinkUuid(mqld.getUuid(), filter);
        this.checkMQLinkExists(mqLinkHandler != null, vld.getName());
        MQLinkHandler mQLinkHandler = mqLinkHandler;
        synchronized (mQLinkHandler) {
            MQLinkObject mqlinkObject = mqLinkHandler.getMQLinkObject();
            mqlinkObject.update(mqld);
            LocalTransaction transaction = this.txManager.createLocalTransaction(true);
            try {
                mqLinkHandler.updateLinkDefinition(vld, transaction);
                if (ld != null) {
                    mqLinkHandler.updateLocalizationDefinition((BaseLocalizationDefinition)ld, (TransactionCommon)transaction);
                }
                this.linkIndex.create(mqLinkHandler);
                transaction.commit();
            }
            catch (SIResourceException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alterMQLinkLocalization", (Object)((Object)e));
                }
                this.handleRollback(transaction);
                throw e;
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.alterMQLinkLocalization", (String)"1:3611:1.508.1.7", (Object)((Object)this));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    SibTr.exit((TraceComponent)tc, (String)"alterMQLinkLocalization", (Object)e);
                }
                this.handleRollback(transaction);
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterMQLinkLocalization");
        }
    }

    public void createDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition, Set<String> destinationLocalizingMEs, boolean isTemporary) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)new Object[]{destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs, new Boolean(isTemporary)});
        }
        LocalTransaction transaction = this.txManager.createLocalTransaction(true);
        try {
            this.createDestinationLocalization(destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs, isTemporary, transaction);
            transaction.commit();
            this.callDestinationListener(destinationDefinition.getName());
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)((Object)e));
            }
            this.handleRollback(transaction);
            throw new SIResourceException((Throwable)e);
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createDestinationLocalization", (String)"1:3733:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)e);
            }
            this.handleRollback(transaction);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition, Set<String> destinationLocalizingMEs, boolean isTemporary, LocalTransaction transaction) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        boolean destinationHandlerCreated = false;
        BaseDestinationHandler destinationHandler = null;
        SIBUuid8 messagingEngineUuid = this.messageProcessor.getMessagingEngineUuid();
        this.checkValidLocalizationConfig(destinationDefinition, messagingEngineUuid, destinationLocalizationDefinition, destinationLocalizingMEs);
        SIMPItemStream sIMPItemStream = this;
        synchronized (sIMPItemStream) {
            DestinationTypeFilter filter = new DestinationTypeFilter();
            DestinationHandler dh = this.destinationIndex.findByName(destinationDefinition.getName(), this.messageProcessor.getMessagingEngineBus(), filter);
            if (dh != null && dh.isToBeDeleted()) {
                Object object = this.deletionThreadLock;
                synchronized (object) {
                    try {
                        if (this.asynchDeletionThread != null && this.asynchDeletionThread.isRunning()) {
                            this.deletionThreadLock.wait(5000L);
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        SibTr.debug((TraceComponent)tc, (String)"Wait for deletion thread to complete interrupted. Continuing without further waiting");
                    }
                }
                dh = this.destinationIndex.findByName(destinationDefinition.getName(), this.messageProcessor.getMessagingEngineBus(), filter);
            }
            if (dh == null) {
                destinationHandler = new BaseDestinationHandler(destinationDefinition, this.messageProcessor, this, (TransactionCommon)transaction, this.durableSubscriptions, this.messageProcessor.getMessagingEngineBus());
                destinationHandlerCreated = true;
                DestinationIndex.Type type = new DestinationIndex.Type();
                type.alias = new Boolean(destinationHandler.isAlias());
                type.foreignDestination = new Boolean(destinationHandler.isForeign());
                type.local = new Boolean(destinationHandler.hasLocal());
                type.queue = new Boolean(!destinationHandler.isPubSub());
                type.remote = new Boolean(destinationHandler.hasRemote());
                type.state = State.CREATE_IN_PROGRESS;
                destinationDefinition.setUUID(new SIBUuid12());
                destinationLocalizationDefinition.setUUID(new SIBUuid8());
                this.destinationIndex.put(destinationHandler, type);
            } else if (dh instanceof BaseDestinationHandler) {
                destinationHandler = (BaseDestinationHandler)dh;
                destinationDefinition.setUUID(dh.getDefinition().getUUID());
                destinationLocalizationDefinition.setUUID(new SIBUuid8());
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                }
                SIMPDestinationAlreadyExistsException e = new SIMPDestinationAlreadyExistsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                e.setExceptionReason(31);
                e.setExceptionInserts(new String[]{destinationDefinition.getName()});
                throw e;
            }
        }
        sIMPItemStream = destinationHandler;
        synchronized (sIMPItemStream) {
            if (!destinationHandlerCreated) {
                if (destinationHandler.isReconciled() && (destinationHandler.hasLocal() || destinationLocalizationDefinition == null)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                    }
                    SIMPDestinationAlreadyExistsException e = new SIMPDestinationAlreadyExistsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                    e.setExceptionReason(31);
                    e.setExceptionInserts(new String[]{destinationDefinition.getName()});
                    throw e;
                }
                if (!destinationHandler.isCorruptOrIndoubt()) {
                    if (this.isQueue(destinationHandler.getDestinationType())) {
                        if (destinationLocalizationDefinition != null) {
                            destinationHandler.updateLocalizationDefinition((BaseLocalizationDefinition)destinationLocalizationDefinition, (TransactionCommon)transaction);
                        }
                    } else if (destinationHandler.getDestinationType() == DestinationType.TOPICSPACE) {
                        destinationHandler.updateLocalizationDefinition((BaseLocalizationDefinition)destinationLocalizationDefinition, (TransactionCommon)transaction);
                    }
                    destinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                    destinationHandler.updateLocalizationSet(destinationLocalizingMEs);
                    DestinationIndex.Type type = new DestinationIndex.Type();
                    type.alias = new Boolean(destinationHandler.isAlias());
                    type.foreignDestination = new Boolean(destinationHandler.isForeign());
                    type.local = new Boolean(destinationHandler.hasLocal());
                    type.queue = new Boolean(!destinationHandler.isPubSub());
                    type.remote = new Boolean(destinationHandler.hasRemote());
                    type.state = this.destinationIndex.getState(destinationHandler);
                    this.destinationIndex.setType(destinationHandler, (Index.Type)type);
                    this.destinationIndex.create(destinationHandler);
                    destinationHandler.setReconciled();
                    if (destinationHandler.getHasReconciledStreamsToBeDeleted()) {
                        this.destinationIndex.cleanup(destinationHandler);
                    }
                }
            } else {
                if (this.isQueue(destinationHandler.getDestinationType())) {
                    if (destinationLocalizationDefinition != null) {
                        destinationHandler.addNewPtoPLocalization(false, (TransactionCommon)transaction, messagingEngineUuid, destinationLocalizationDefinition, true);
                    }
                } else if (destinationHandler.getDestinationType() == DestinationType.TOPICSPACE) {
                    destinationHandler.addPubSubLocalisation(destinationLocalizationDefinition);
                }
                destinationHandler.updateLocalizationSet(destinationLocalizingMEs);
                this.destinationIndex.setLocalizationFlags(destinationHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    private void checkValidLocalizationConfig(DestinationDefinition destinationDefinition, SIBUuid8 messagingEngineUuid, LocalizationDefinition destinationLocalizationDefinition, Set<String> queuePointLocalizingMEs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidLocalizationConfig", (Object)new Object[]{destinationDefinition, messagingEngineUuid, destinationLocalizationDefinition, queuePointLocalizingMEs});
        }
        this.checkQueuePointContainsLocalME(queuePointLocalizingMEs, messagingEngineUuid, destinationDefinition, destinationLocalizationDefinition);
        this.checkQueuePointLocalizationExists(destinationDefinition, queuePointLocalizingMEs, destinationLocalizationDefinition, messagingEngineUuid);
        this.checkQueuePointLocalizingSize(queuePointLocalizingMEs, destinationDefinition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidLocalizationConfig");
        }
    }

    private boolean isQueue(DestinationType type) {
        boolean isQueue = false;
        if (type == DestinationType.QUEUE || type == DestinationType.PORT) {
            isQueue = true;
        }
        return isQueue;
    }

    public void alterDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition, Set<String> destinationLocalizingMEs) throws SIResourceException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)new Object[]{destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs});
        }
        LocalTransaction transaction = this.txManager.createLocalTransaction(true);
        try {
            this.alterDestinationLocalization(destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs, transaction);
            transaction.commit();
        }
        catch (SIResourceException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)((Object)e));
            }
            this.handleRollback(transaction);
            throw e;
        }
        catch (SITemporaryDestinationNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)((Object)e));
            }
            this.handleRollback(transaction);
            throw new SIErrorException((Throwable)e);
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.alterDestinationLocalization", (String)"1:4353:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)e);
            }
            this.handleRollback(transaction);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition, Set<String> destinationLocalizingMEs, LocalTransaction transaction) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)new Object[]{destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs, transaction});
        }
        BaseDestinationHandler destinationHandler = null;
        SIBUuid8 messagingEngineUuid = this.messageProcessor.getMessagingEngineUuid();
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.VISIBLE = Boolean.TRUE;
        filter.ALIAS = Boolean.FALSE;
        filter.FOREIGN_DESTINATION = Boolean.FALSE;
        DestinationHandler dh = this.destinationIndex.findByUuid(destinationDefinition.getUUID(), filter);
        this.checkDestinationHandlerExists(dh != null, destinationDefinition.getName(), this.messageProcessor.getMessagingEngineName());
        destinationHandler = (BaseDestinationHandler)dh;
        if (!destinationHandler.isPubSub()) {
            boolean validAlteration = false;
            validAlteration = destinationHandler.hasLocal();
            boolean bl = validAlteration = validAlteration && !dh.isTemporary() && !dh.isSystem();
            if (!validAlteration) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)"Invalid destination alteration");
                }
                SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INVALID_DEST_ALTER_ERROR_CWSIP0045", new Object[]{destinationDefinition.getName(), this.messageProcessor.getMessagingEngineName()}, null));
                throw e;
            }
        }
        this.checkValidLocalizationConfig(destinationDefinition, messagingEngineUuid, destinationLocalizationDefinition, destinationLocalizingMEs);
        BaseDestinationHandler baseDestinationHandler = destinationHandler;
        synchronized (baseDestinationHandler) {
            this.checkDestinationHandlerExists(!destinationHandler.isToBeDeleted(), destinationDefinition.getName(), this.messageProcessor.getMessagingEngineName());
            if (destinationHandler.getDestinationType() != destinationDefinition.getDestinationType()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{this.messageProcessor.getMessagingEngineBus(), "1:4483:1.508.1.7", destinationHandler.getName()}, null));
            }
            if (!destinationHandler.isCorruptOrIndoubt()) {
                if (this.isQueue(destinationHandler.getDestinationType())) {
                    if (destinationLocalizationDefinition != null) {
                        destinationHandler.updateLocalizationDefinition((BaseLocalizationDefinition)destinationLocalizationDefinition, (TransactionCommon)transaction);
                    }
                } else if (destinationHandler.getDestinationType() == DestinationType.TOPICSPACE) {
                    destinationHandler.updateLocalizationDefinition((BaseLocalizationDefinition)destinationLocalizationDefinition, (TransactionCommon)transaction);
                }
                destinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                destinationHandler.updateLocalizationSet(destinationLocalizingMEs);
                this.destinationIndex.setLocalizationFlags(destinationHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization");
        }
    }

    private void checkQueuePointLocalizationExists(DestinationDefinition destinationDefinition, Set<String> queuePointLocalizingMEs, LocalizationDefinition destinationLocalizationDefinition, SIBUuid8 messagingEngineUuid) {
        if (this.isQueue(destinationDefinition.getDestinationType()) && queuePointLocalizingMEs != null && queuePointLocalizingMEs.contains(messagingEngineUuid.toString()) && destinationLocalizationDefinition == null) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:4565:1.508.1.7", destinationDefinition.getName()}, null));
        }
    }

    private void checkDestinationHandlerExists(boolean condition, String destName, String engineName) throws SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationHandlerExists", (Object)new Object[]{new Boolean(condition), destName, engineName});
        }
        if (!condition) {
            if (destName.startsWith("_Q") || destName.startsWith("_T")) {
                SIMPTemporaryDestinationNotFoundException e = new SIMPTemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{destName}, null));
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkDestinationHandlerExists", (Object)e);
                }
                throw e;
            }
            SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{destName, engineName}, null));
            e.setExceptionReason(15);
            e.setExceptionInserts(new String[]{destName, engineName});
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.warning((TraceComponent)tc_cwsik, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"DELIVERY_ERROR_SIRC_15", (Object)new Object[]{destName, engineName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationHandlerExists", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationHandlerExists");
        }
    }

    private void checkBusExists(boolean condition, String foreignBusName, boolean linkError, Throwable cause) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBusExists", (Object)new Object[]{new Boolean(condition), foreignBusName, linkError, cause});
        }
        if (!condition) {
            String errorMsg = "DELIVERY_ERROR_SIRC_38";
            int reason = 38;
            if (linkError && cause != null) {
                reason = 41;
                errorMsg = "DELIVERY_ERROR_SIRC_41";
            } else if (cause != null) {
                reason = 39;
                errorMsg = "DELIVERY_ERROR_SIRC_39";
            }
            SIMPNotPossibleInCurrentConfigurationException e = null;
            if (cause == null) {
                e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage(errorMsg, new Object[]{foreignBusName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()}, null));
                e.setExceptionInserts(new String[]{foreignBusName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()});
                e.setExceptionReason(reason);
            } else {
                e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage(errorMsg, new Object[]{foreignBusName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus(), SIMPUtils.getStackTrace(cause)}, null));
                e.setExceptionInserts(new String[]{foreignBusName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus(), SIMPUtils.getStackTrace(cause)});
                e.setExceptionReason(reason);
            }
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkBusExists", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBusExists");
        }
    }

    private void checkMQLinkExists(boolean condition, String mqlinkName) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkMQLinkExists", (Object)new Object[]{new Boolean(condition), mqlinkName});
        }
        if (!condition) {
            SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_42", new Object[]{mqlinkName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()}, null));
            e.setExceptionInserts(new String[]{mqlinkName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()});
            e.setExceptionReason(42);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkMQLinkExists", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkMQLinkExists");
        }
    }

    private void checkLinkExists(boolean condition, String linkName) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkLinkExists", (Object)new Object[]{new Boolean(condition), linkName});
        }
        if (!condition) {
            SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_40", new Object[]{linkName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()}, null));
            e.setExceptionInserts(new String[]{linkName, this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()});
            e.setExceptionReason(40);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkLinkExists", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkLinkExists");
        }
    }

    private void checkQueuePointContainsLocalME(Set<String> queuePointLocalizingMEs, SIBUuid8 messagingEngineUuid, DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition) {
        if (this.isQueue(destinationDefinition.getDestinationType()) && destinationLocalizationDefinition != null && (queuePointLocalizingMEs == null || !queuePointLocalizingMEs.contains(messagingEngineUuid.toString()))) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:4845:1.508.1.7", destinationDefinition.getName()}, null));
        }
    }

    private void checkQueuePointLocalizingSize(Set<String> queuePointLocalizingMEs, DestinationDefinition destinationDefinition) {
        if (destinationDefinition.getDestinationType() != DestinationType.SERVICE && queuePointLocalizingMEs.size() == 0 || destinationDefinition.getDestinationType() == DestinationType.SERVICE && queuePointLocalizingMEs.size() != 0) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:4867:1.508.1.7", destinationDefinition.getName()}, null));
        }
    }

    public void createDestination(DestinationDefinition destinationDefinition, Set<String> queuePointLocalizingMEs) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestination", (Object)new Object[]{destinationDefinition, queuePointLocalizingMEs});
        }
        try {
            this.createRemoteDestination(destinationDefinition, queuePointLocalizingMEs);
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createDestination", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createDestination", (String)"1:4910:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"createDestination", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationHandler createRemoteDestination(DestinationDefinition destinationDefinition, Set<String> queuePointLocalizingMEs) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteDestination", (Object)new Object[]{destinationDefinition, queuePointLocalizingMEs});
        }
        BaseDestinationHandler destinationHandler = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            DestinationTypeFilter filter = new DestinationTypeFilter();
            filter.VISIBLE = Boolean.TRUE;
            DestinationHandler dh = this.destinationIndex.findByName(destinationDefinition.getName(), this.messageProcessor.getMessagingEngineBus(), filter);
            if (dh != null) {
                destinationHandler = (BaseDestinationHandler)dh;
            } else {
                LocalTransaction siTran = this.txManager.createLocalTransaction(false);
                destinationHandler = new BaseDestinationHandler(destinationDefinition, this.messageProcessor, this, (TransactionCommon)siTran, this.durableSubscriptions, this.messageProcessor.getMessagingEngineBus());
                destinationHandler.updateLocalizationSet(queuePointLocalizingMEs);
                DestinationIndex.Type type = new DestinationIndex.Type();
                type.alias = new Boolean(destinationHandler.isAlias());
                type.foreignDestination = new Boolean(destinationHandler.isForeign());
                type.local = new Boolean(destinationHandler.hasLocal());
                type.queue = new Boolean(!destinationHandler.isPubSub());
                type.remote = new Boolean(destinationHandler.hasRemote());
                type.state = State.CREATE_IN_PROGRESS;
                this.destinationIndex.put(destinationHandler, type);
                siTran.commit();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public void markDestinationAsCleanUpPending(DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markDestinationAsCleanUpPending", (Object)dh);
        }
        if (dh.isLink()) {
            this.linkIndex.cleanup(dh);
        } else {
            this.destinationIndex.cleanup(dh);
        }
        this.startAsynchDeletion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markDestinationAsCleanUpPending");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsynchDeletion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startAsynchDeletion");
        }
        Object object = this.deletionThreadLock;
        synchronized (object) {
            if (this.asynchDeletionThread == null) {
                this.asynchDeletionThread = new AsynchDeletionThread(this.messageProcessor);
            }
            if (this._isAsyncDeletionThreadStartable && !this.asynchDeletionThread.isRunning() && !this.asynchDeletionThread.isStopping()) {
                try {
                    this.messageProcessor.startNewSystemThread(this.asynchDeletionThread);
                    this.asynchDeletionThread.setRunning(true);
                }
                catch (InterruptedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.startAsynchDeletion", (String)"1:5073:1.508.1.7", (Object)((Object)this));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"startAsynchDeletion", (Object)e);
                    }
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    throw new WsRuntimeException((Throwable)e);
                }
            } else {
                this.asynchDeletionThread.rerun();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startAsynchDeletion");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int mode) {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.setIsAsyncDeletionThreadStartable(false);
        Object object = this.deletionThreadLock;
        synchronized (object) {
            if (this.asynchDeletionThread != null) {
                this.asynchDeletionThread.stopThread(this.messageProcessor.getStoppableThreadCache());
            }
        }
        this.asynchDeletionThread = null;
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        destFilter.LOCAL = Boolean.TRUE;
        SIMPIterator itr = this.destinationIndex.iterator(destFilter);
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.stop(mode);
        }
        itr.finished();
        itr = this.foreignBusIndex.iterator();
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.stop(mode);
        }
        itr.finished();
        LinkTypeFilter linkFilter = new LinkTypeFilter();
        linkFilter.LOCAL = Boolean.TRUE;
        itr = this.linkIndex.iterator(linkFilter);
        while (itr.hasNext()) {
            DestinationHandler dh2 = (DestinationHandler)itr.next();
            dh2.stop(mode);
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void start() {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        destFilter.LOCAL = Boolean.TRUE;
        SIMPIterator itr = this.destinationIndex.iterator(destFilter);
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.start();
        }
        itr.finished();
        itr = this.foreignBusIndex.iterator();
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.start();
        }
        itr.finished();
        LinkTypeFilter linkFilter = new LinkTypeFilter();
        linkFilter.LOCAL = Boolean.TRUE;
        itr = this.linkIndex.iterator(linkFilter);
        while (itr.hasNext()) {
            DestinationHandler dh2 = (DestinationHandler)itr.next();
            dh2.start();
        }
        itr.finished();
        this.startAsynchDeletion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        LinkTypeFilter mqLinkFilter = new LinkTypeFilter();
        mqLinkFilter.MQLINK = Boolean.TRUE;
        SIMPIterator itr = this.linkIndex.iterator(mqLinkFilter);
        while (itr.hasNext()) {
            MQLinkHandler mqLinkHandler = (MQLinkHandler)itr.next();
            try {
                mqLinkHandler.destroy();
            }
            catch (SIResourceException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsAsyncDeletionThreadStartable(boolean isStartable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsAsyncDeletionThreadStartable", (Object)new Boolean(isStartable));
        }
        Object object = this.deletionThreadLock;
        synchronized (object) {
            this._isAsyncDeletionThreadStartable = isStartable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsAsyncDeletionThreadStartable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsynchDeletionEnd(AsynchDeletionThread thread) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyAsynchDeletionEnd", (Object)thread);
        }
        Object object = this.deletionThreadLock;
        synchronized (object) {
            thread.setRunning(false);
            this.deletionThreadLock.notifyAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyAsynchDeletionEnd");
        }
    }

    public JsDestinationAddress createSystemDestination(String prefix) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        return this.createSystemDestination(prefix, Reliability.ASSURED_PERSISTENT);
    }

    public JsDestinationAddress createSystemDestination(String prefix, Reliability reliability) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemDestination", (Object)new Object[]{prefix, reliability});
        }
        if (prefix == null || prefix.length() > 24) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemDestination", (Object)"SIInvalidDestinationPrefixException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5324:1.508.1.7", prefix});
            throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5329:1.508.1.7", prefix}, null));
        }
        JsDestinationAddress destAddr = SIMPUtils.createJsSystemDestinationAddress(prefix, this.messageProcessor.getMessagingEngineUuid());
        destAddr.setBusName(this.messageProcessor.getMessagingEngineBus());
        DestinationHandler handler = this.getDestinationInternal(destAddr.getDestinationName(), destAddr.getBusName(), false);
        if (handler != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemDestination", (Object)destAddr);
            }
            return destAddr;
        }
        DestinationDefinition destDef = this.messageProcessor.createDestinationDefinition(DestinationType.QUEUE, destAddr.getDestinationName());
        destDef.setMaxReliability(reliability);
        destDef.setDefaultReliability(reliability);
        destDef.setUUID(new SIBUuid12());
        HashSet<String> destinationLocalizingSet = new HashSet<String>();
        destinationLocalizingSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
        this.createDestinationLocalization(destDef, this.messageProcessor.createLocalizationDefinition(destDef.getName()), destinationLocalizingSet, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemDestination", (Object)destAddr);
        }
        return destAddr;
    }

    public void deleteSystemDestination(JsDestinationAddress destAddr) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)new Object[]{destAddr});
        }
        BaseDestinationHandler destinationHandler = null;
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.VISIBLE = Boolean.TRUE;
        filter.ALIAS = Boolean.FALSE;
        filter.FOREIGN_DESTINATION = Boolean.FALSE;
        DestinationHandler dh = this.destinationIndex.findByName(destAddr.getDestinationName(), this.messageProcessor.getMessagingEngineBus(), filter);
        try {
            this.checkDestinationHandlerExists(dh != null, destAddr.getDestinationName(), this.messageProcessor.getMessagingEngineName());
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteSystemDestination", (String)"1:5408:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5421:1.508.1.7", e, destAddr.getDestinationName()}, null), (Throwable)e);
        }
        destinationHandler = (BaseDestinationHandler)dh;
        this.deleteSystemDestination(destinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSystemDestination(BaseDestinationHandler destinationHandler) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)new Object[]{destinationHandler});
        }
        BaseDestinationHandler baseDestinationHandler = destinationHandler;
        synchronized (baseDestinationHandler) {
            if (destinationHandler.isToBeDeleted() || !destinationHandler.isSystem()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"Destination not found as destination is to be deleted, or is system");
                }
                throw new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELETE_SYSTEM_DEST_ERROR_CWSIP0046", new Object[]{destinationHandler.getName(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            ExternalAutoCommitTransaction transaction = this.txManager.createAutoCommitTransaction();
            destinationHandler.setToBeDeleted(true);
            this.destinationIndex.delete(destinationHandler);
            try {
                destinationHandler.requestUpdate((Transaction)transaction);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteSystemDestination", (String)"1:5476:1.508.1.7", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)e);
            }
            destinationHandler.closeProducers();
            destinationHandler.closeConsumers();
            destinationHandler.addAllLocalisationsForCleanUp();
            destinationHandler.clearLocalisingUuidsSet();
            this.startAsynchDeletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    public synchronized AsyncUpdateThread getAsyncUpdateThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAsyncUpdateThread");
        }
        if (this.asyncUpdateThread == null) {
            this.asyncUpdateThread = new AsyncUpdateThread(this.messageProcessor, this.messageProcessor.getTXManager(), this.messageProcessor.getCustomProperties().get_anycast_batch_size(), this.messageProcessor.getCustomProperties().get_anycast_batch_timeout());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAsyncUpdateThread", (Object)this.asyncUpdateThread);
        }
        return this.asyncUpdateThread;
    }

    public synchronized AsyncUpdateThread getPersistLockThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistLockThread");
        }
        if (this.persistLockThread == null) {
            this.persistLockThread = new AsyncUpdateThread(this.messageProcessor, this.messageProcessor.getTXManager(), this.messageProcessor.getCustomProperties().get_anycast_lock_batch_size(), this.messageProcessor.getCustomProperties().get_anycast_lock_batch_timeout());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistLockThread", (Object)this.persistLockThread);
        }
        return this.persistLockThread;
    }

    public synchronized AsynchDeletionThread getAsynchDeletionThread() {
        return this.asynchDeletionThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriptionToDelete(SubscriptionItemStream stream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscriptionToDelete", (Object)stream);
        }
        List<SubscriptionItemStream> list = this.deletableSubscriptions;
        synchronized (list) {
            this.deletableSubscriptions.add(stream);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscriptionToDelete");
        }
    }

    public List<SubscriptionItemStream> getSubscriptionsToDelete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionsToDelete");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionsToDelete", this.deletableSubscriptions);
        }
        return this.deletableSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriptionAsDeleted(SubscriptionItemStream stream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeSubscriptionAsDeleted", (Object)stream);
        }
        List<SubscriptionItemStream> list = this.deletableSubscriptions;
        synchronized (list) {
            this.deletableSubscriptions.remove(stream);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeSubscriptionAsDeleted");
        }
    }

    public void addRemoteDestination(String name, Set<String> queuePointLocalizingSet, DestinationDefinition destinationDefinition) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRemoteDestination", (Object)new Object[]{name, destinationDefinition});
        }
        try {
            this.createRemoteDestination(destinationDefinition, queuePointLocalizingSet);
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addRemoteDestination", (Object)((Object)e));
            }
            throw e;
        }
        catch (SIResourceException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addRemoteDestination", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRemoteDestination");
        }
    }

    private DestinationHandler createRemoteSystemDestination(String destinationName, SIBUuid8 localizingME) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteSystemDestination", (Object)new Object[]{destinationName, localizingME});
        }
        DestinationHandler destinationHandler = null;
        DestinationDefinition destinationDefinition = this.messageProcessor.createDestinationDefinition(DestinationType.QUEUE, destinationName);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        HashSet<String> queuePointLocalizingMEs = new HashSet<String>();
        queuePointLocalizingMEs.add(localizingME.toString());
        try {
            destinationHandler = this.createRemoteDestination(destinationDefinition, queuePointLocalizingMEs);
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createRemoteSystemDestination", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteSystemDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public DestinationHandler getDestination(SIBUuid12 destinationUuid, boolean includeInvisible) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationHandler destinationHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination", (Object)destinationUuid);
        }
        this.checkDestinationHandlerExists((destinationHandler = this.getDestinationInternal(destinationUuid, includeInvisible)) != null, destinationUuid.toString(), this.messageProcessor.getMessagingEngineName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public DestinationHandler getDestinationByUuid(SIBUuid12 destinationUuid, boolean includeInvisible) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        DestinationHandler destinationHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationByUuid", (Object)new Object[]{destinationUuid, includeInvisible});
        }
        if ((destinationHandler = this.getDestinationInternal(destinationUuid, includeInvisible)) == null) {
            destinationHandler = this.loadDestination(destinationUuid.toString(), this.messageProcessor.getMessagingEngineBus(), null, false);
        }
        this.checkDestinationHandlerExists(destinationHandler != null, destinationUuid.toString(), this.messageProcessor.getMessagingEngineName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationByUuid", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public MQLinkHandler getMQLinkLocalization(SIBUuid8 mqLinkUuid, boolean includeInvisible) throws SIMPMQLinkCorruptException, SINotPossibleInCurrentConfigurationException {
        MQLinkHandler mqLinkHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)mqLinkUuid);
        }
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.TRUE;
        if (!includeInvisible) {
            filter.VISIBLE = Boolean.TRUE;
        }
        this.checkMQLinkExists((mqLinkHandler = (MQLinkHandler)this.linkIndex.findByMQLinkUuid(mqLinkUuid, filter)) != null, mqLinkUuid.toString());
        if (mqLinkHandler.isCorruptOrIndoubt()) {
            String message = nls.getFormattedMessage("LINK_HANDLER_CORRUPT_ERROR_CWSIP0054", new Object[]{mqLinkHandler.getName(), mqLinkUuid.toString()}, null);
            SIMPMQLinkCorruptException e = new SIMPMQLinkCorruptException(message);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)mqLinkHandler);
        }
        return mqLinkHandler;
    }

    void announceWASOpenForEBusiness() {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceWASOpenForEBusiness");
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        SIMPIterator itr = this.destinationIndex.iterator(destFilter);
        while (itr.hasNext()) {
            DestinationHandler dh2 = (DestinationHandler)itr.next();
            dh2.announceWasOpenForEBusiness();
        }
        itr.finished();
        LinkTypeFilter linkFilter = new LinkTypeFilter();
        linkFilter.LOCAL = Boolean.TRUE;
        itr = this.linkIndex.iterator(linkFilter);
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceWasOpenForEBusiness();
        }
        itr.finished();
        itr = this.foreignBusIndex.iterator();
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceWasOpenForEBusiness();
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceWASOpenForEBusiness");
        }
    }

    void announceWASClosedForEBusiness() {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceWASClosedForEBusiness");
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        SIMPIterator itr = this.destinationIndex.iterator(destFilter);
        while (itr.hasNext()) {
            DestinationHandler dh2 = (DestinationHandler)itr.next();
            dh2.announceWasClosedForEBusiness();
        }
        itr.finished();
        LinkTypeFilter linkFilter = new LinkTypeFilter();
        linkFilter.LOCAL = Boolean.TRUE;
        itr = this.linkIndex.iterator(linkFilter);
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceWasClosedForEBusiness();
        }
        itr.finished();
        itr = this.foreignBusIndex.iterator();
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceWasClosedForEBusiness();
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceWASClosedForEBusiness");
        }
    }

    void announceMPStopping() {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStopping");
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        SIMPIterator itr = this.destinationIndex.iterator(destFilter);
        while (itr.hasNext()) {
            DestinationHandler dh2 = (DestinationHandler)itr.next();
            dh2.announceMPStopping();
        }
        itr.finished();
        LinkTypeFilter linkFilter = new LinkTypeFilter();
        linkFilter.LOCAL = Boolean.TRUE;
        itr = this.linkIndex.iterator(linkFilter);
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceMPStopping();
        }
        itr.finished();
        itr = this.foreignBusIndex.iterator();
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceMPStopping();
        }
        itr.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStopping");
        }
    }

    void announceMPStarted(int startMode) {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStarted");
        }
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        SIMPIterator itr = this.destinationIndex.iterator(destFilter);
        while (itr.hasNext()) {
            DestinationHandler dh2 = (DestinationHandler)itr.next();
            dh2.announceMPStarted();
        }
        itr.finished();
        LinkTypeFilter linkFilter = new LinkTypeFilter();
        linkFilter.LOCAL = Boolean.TRUE;
        itr = this.linkIndex.iterator(linkFilter);
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceMPStarted();
        }
        itr.finished();
        itr = this.foreignBusIndex.iterator();
        while (itr.hasNext()) {
            dh = (DestinationHandler)itr.next();
            dh.announceMPStarted();
        }
        itr.finished();
        LinkTypeFilter mqLinkFilter = new LinkTypeFilter();
        mqLinkFilter.MQLINK = Boolean.TRUE;
        itr = this.linkIndex.iterator(mqLinkFilter);
        while (itr.hasNext()) {
            MQLinkHandler mqLinkHandler = (MQLinkHandler)itr.next();
            try {
                mqLinkHandler.announceMPStarted(startMode, this.messageProcessor.getMessagingEngine());
            }
            catch (SIResourceException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        itr.finished();
        this.setIsAsyncDeletionThreadStartable(true);
        this.startAsynchDeletion();
        this.startDeletePubSubMsgsThread();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStarted");
        }
    }

    private void startDeletePubSubMsgsThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startDeletePubSubMsgsThread");
        }
        Thread delThread = new Thread((Runnable)new DeletePubSubMsgsThread(this.messageProcessor), "startDeletePubSubMsgsThread");
        delThread.setPriority(1);
        delThread.start();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startDeletePubSubMsgsThread");
        }
    }

    public void createLinkLocalization(VirtualLinkDefinition virtualLinkDefinition) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLinkLocalization", (Object)new Object[]{virtualLinkDefinition});
        }
        LocalTransaction transaction = this.txManager.createLocalTransaction(false);
        try {
            this.createLinkLocalization(virtualLinkDefinition, transaction);
            transaction.commit();
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)((Object)e));
            }
            this.handleRollback(transaction);
            throw e;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createLinkLocalization", (String)"1:6049:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)e);
            }
            this.handleRollback(transaction);
            this.putLinkIntoIndoubtState(virtualLinkDefinition.getName());
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkLocalization(VirtualLinkDefinition virtualLinkDefinition, LocalTransaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLinkLocalization", (Object)new Object[]{virtualLinkDefinition, transaction});
        }
        boolean linkCreated = false;
        LinkHandler linkHandler = null;
        LinkTypeFilter filter = new LinkTypeFilter();
        DestinationHandler dh = this.linkIndex.findByName(virtualLinkDefinition.getName(), filter);
        if (dh == null) {
            linkHandler = new LinkHandler(virtualLinkDefinition, this.messageProcessor, this, (TransactionCommon)transaction, this.durableSubscriptions);
            linkCreated = true;
            linkHandler.setLocal();
            LinkIndex.Type type = new LinkIndex.Type();
            type.local = Boolean.TRUE;
            type.mqLink = Boolean.FALSE;
            type.remote = Boolean.FALSE;
            type.state = State.CREATE_IN_PROGRESS;
            this.linkIndex.put(linkHandler, type);
            linkHandler.registerControlAdapters();
        } else {
            linkHandler = (LinkHandler)dh;
        }
        if (!linkHandler.isCorruptOrIndoubt()) {
            LinkHandler linkHandler2 = linkHandler;
            synchronized (linkHandler2) {
                if (!linkCreated) {
                    LinkIndex linkIndex = this.linkIndex;
                    synchronized (linkIndex) {
                        LinkIndex.Type type = null;
                        if (this.linkIndex.get(linkHandler.getUuid()) != null) {
                            type = (LinkIndex.Type)this.linkIndex.getType(linkHandler);
                            this.linkIndex.remove(linkHandler);
                        } else {
                            type = new LinkIndex.Type();
                        }
                        linkHandler.updateUuid(virtualLinkDefinition.getUuid());
                        type.local = Boolean.TRUE;
                        type.remote = Boolean.FALSE;
                        type.mqLink = Boolean.FALSE;
                        type.state = State.ACTIVE;
                        this.linkIndex.put(linkHandler, type);
                        if (linkHandler.isToBeDeleted() || !linkHandler.getUuid().equals((Object)virtualLinkDefinition.getUuid())) {
                            linkHandler.setToBeDeleted(false);
                            this.linkIndex.cleanup(linkHandler);
                        }
                    }
                    linkHandler.updateLinkDefinition(virtualLinkDefinition, transaction);
                }
                LinkSelection s = null;
                LinkManager linkManager = this.messageProcessor.getLinkManager();
                try {
                    s = linkManager.select(linkHandler.getUuid());
                }
                catch (LinkException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createLinkLocalization", (String)"1:6182:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)((Object)e));
                    }
                    throw new SIResourceException((Throwable)e);
                }
                SIBUuid8 localisingME = null;
                SIBUuid8 routingME = null;
                if (s != null) {
                    localisingME = s.getInboundMeUuid();
                    routingME = s.getOutboundMeUuid();
                } else {
                    localisingME = new SIBUuid8("0000000000000001");
                    routingME = null;
                }
                if (linkCreated || !linkHandler.hasRemote()) {
                    linkHandler.addNewPtoPLocalization(true, (TransactionCommon)transaction, localisingME, null, true);
                } else {
                    linkHandler.updateLocalisationSet(localisingME, routingME);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkHandler createRemoteLink(VirtualLinkDefinition virtualLinkDefinition, LocalTransaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteLink", (Object)new Object[]{virtualLinkDefinition, transaction});
        }
        LinkHandler linkHandler = null;
        boolean linkCreated = false;
        Object object = this.linkIndex;
        synchronized (object) {
            DestinationHandler dh = this.linkIndex.findByUuid(virtualLinkDefinition.getUuid(), null);
            if (dh != null) {
                linkHandler = (LinkHandler)dh;
            } else {
                linkHandler = new LinkHandler(virtualLinkDefinition, this.messageProcessor, this, (TransactionCommon)transaction, this.durableSubscriptions);
                LinkIndex.Type type = new LinkIndex.Type();
                type.local = Boolean.FALSE;
                type.mqLink = Boolean.FALSE;
                type.remote = Boolean.TRUE;
                type.state = State.ACTIVE;
                this.linkIndex.put(linkHandler, type);
                linkCreated = true;
            }
        }
        if (linkCreated) {
            object = linkHandler;
            synchronized (object) {
                LinkSelection s = null;
                LinkManager linkManager = this.messageProcessor.getLinkManager();
                try {
                    s = linkManager.select(linkHandler.getUuid());
                }
                catch (LinkException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createRemoteLink", (String)"1:6286:1.508.1.7", (Object)((Object)this));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createRemoteLink", (Object)((Object)e));
                    }
                    throw new SIResourceException((Throwable)e);
                }
                SIBUuid8 localisingME = null;
                if (s != null) {
                    localisingME = s.getInboundMeUuid();
                    if (localisingME == null) {
                        localisingME = s.getOutboundMeUuid();
                    }
                } else {
                    localisingME = new SIBUuid8("0000000000000001");
                }
                linkHandler.addNewPtoPLocalization(true, (TransactionCommon)transaction, localisingME, null, true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteLink", (Object)linkHandler);
        }
        return linkHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusHandler createForeignBus(String linkName, String stringLinkUuid, ForeignBusDefinition foreignBusDefinition) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createForeignBus", (Object)new Object[]{linkName, stringLinkUuid, foreignBusDefinition});
        }
        SIBUuid12 linkUuid = new SIBUuid12(stringLinkUuid);
        BusHandler busHandler = null;
        LinkIndex linkIndex = this.linkIndex;
        synchronized (linkIndex) {
            LinkTypeFilter filter = new LinkTypeFilter();
            filter.VISIBLE = Boolean.TRUE;
            DestinationHandler linkHandler = this.linkIndex.findByUuid(linkUuid, filter);
            if (linkHandler == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createForeignBus", (Object)"Link not found");
                }
                SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_30", new Object[]{linkName, stringLinkUuid, foreignBusDefinition.getName()}, null));
                e.setExceptionReason(30);
                e.setExceptionInserts(new String[]{linkName, stringLinkUuid, foreignBusDefinition.getName()});
                throw e;
            }
            busHandler = new BusHandler(foreignBusDefinition, this.messageProcessor, (SIMPItemStream)this, this.durableSubscriptions, (LinkHandler)linkHandler);
            ForeignBusIndex.Type type = new ForeignBusIndex.Type();
            type.state = State.ACTIVE;
            this.foreignBusIndex.put(busHandler, type);
            busHandler.registerControlAdapters();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createForeignBus", (Object)busHandler);
        }
        return busHandler;
    }

    public BusHandler findBus(String busName) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findBus", (Object)new Object[]{busName});
        }
        ForeignBusTypeFilter filter = new ForeignBusTypeFilter();
        filter.VISIBLE = Boolean.TRUE;
        BusHandler busHandler = (BusHandler)this.foreignBusIndex.findByName(busName, filter);
        if (busHandler == null) {
            busHandler = this.findBusInternal(busName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findBus", (Object)busHandler);
        }
        return busHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusHandler findBusInternal(String busName) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findBusInternal", (Object)new Object[]{busName});
        }
        BusHandler busHandler = null;
        ForeignBusDefinition foreignBusDefinition = this.messageProcessor.getForeignBus(busName);
        this.checkBusExists(foreignBusDefinition != null, busName, false, null);
        VirtualLinkDefinition virtualLinkDefinition = null;
        LinkIndex linkIndex = this.linkIndex;
        synchronized (linkIndex) {
            try {
                virtualLinkDefinition = foreignBusDefinition.getLinkForNextHop();
            }
            catch (SIBExceptionBusNotFound e) {
                this.checkBusExists(false, busName, false, e);
            }
            catch (SIBExceptionNoLinkExists e) {
                this.checkBusExists(false, busName, true, e);
            }
            Set localizingMEs = null;
            if (virtualLinkDefinition != null) {
                localizingMEs = virtualLinkDefinition.getLinkLocalitySet();
            }
            if (localizingMEs == null || localizingMEs.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Empty/null localizing ME set");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)"null");
                }
                return null;
            }
            LinkTypeFilter filter = new LinkTypeFilter();
            filter.VISIBLE = Boolean.TRUE;
            LinkHandler linkHandler = (LinkHandler)this.linkIndex.findByName(virtualLinkDefinition.getName(), filter);
            if (linkHandler == null) {
                LocalTransaction siTran = this.txManager.createLocalTransaction(false);
                try {
                    linkHandler = this.createRemoteLink(virtualLinkDefinition, siTran);
                    siTran.commit();
                }
                catch (SIException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)((Object)e));
                    }
                    this.handleRollback(siTran);
                    SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                    ee.setExceptionReason(901);
                    ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:6515:1.508.1.7", SIMPUtils.getStackTrace(e)});
                    throw ee;
                }
            }
            try {
                busHandler = this.createForeignBus(linkHandler.getName(), linkHandler.getUuid().toString(), foreignBusDefinition);
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)busHandler);
        }
        return busHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationHandler createAliasDestination(DestinationAliasDefinition add, AliasChainValidator validator, DestinationHandler baseDest) throws SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAliasDestination", (Object)new Object[]{add, validator, baseDest});
        }
        String destinationName = add.getName();
        String busName = add.getBus();
        if (busName == null || busName.equals("")) {
            busName = this.messageProcessor.getMessagingEngineBus();
        }
        if (null == validator) {
            validator = new AliasChainValidator();
        }
        validator.validate(destinationName, busName);
        AliasDestinationHandler aliasDestinationHandler = null;
        try {
            Object targetBus;
            boolean aliasChainError = false;
            if (baseDest != null) {
                targetBus = add.getTargetBus();
                if (targetBus == null || ((String)targetBus).equals("")) {
                    targetBus = this.messageProcessor.getMessagingEngineBus();
                }
                if (!(add.getTargetName().equals(baseDest.getName()) && ((String)targetBus).equals(baseDest.getBus()) || (baseDest = this.getAliasDestinationInternal(add.getTargetName(), (String)targetBus, validator, baseDest, false)) != null)) {
                    aliasChainError = true;
                }
            }
            targetBus = this;
            synchronized (targetBus) {
                DestinationHandler targetDH = baseDest;
                if (targetDH == null && !aliasChainError) {
                    targetDH = this.getDestinationInternal(add.getTargetName(), add.getTargetBus(), validator, false, false);
                }
                if (targetDH == null) {
                    String chainText = validator.toStringPlus(add.getTargetName(), busName);
                    String targetName = add.getTargetName();
                    AliasChainValidator.CompoundName firstInChain = validator.getFirstInChain();
                    SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_45", new Object[]{firstInChain.getDestName(), targetName}, null));
                    e.setExceptionReason(28);
                    e.setExceptionInserts(new String[]{firstInChain.getDestName(), targetName});
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)e);
                    }
                    throw e;
                }
                if (targetDH.getDestinationType().equals(DestinationType.SERVICE)) {
                    String chainText = validator.toStringPlus(targetDH.getName(), targetDH.getBus());
                    AliasChainValidator.CompoundName firstInChain = validator.getFirstInChain();
                    String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_29", new Object[]{firstInChain.getDestName(), targetDH.getName(), chainText, busName}, null);
                    SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nlsMessage);
                    e.setExceptionReason(29);
                    e.setExceptionInserts(new String[]{firstInChain.getDestName(), targetDH.getName(), chainText, busName});
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)e);
                    }
                    throw e;
                }
                aliasDestinationHandler = new AliasDestinationHandler(add, this.messageProcessor, this, targetDH, busName);
                DestinationIndex.Type type = new DestinationIndex.Type();
                type.alias = Boolean.TRUE;
                type.foreignDestination = Boolean.FALSE;
                type.local = Boolean.FALSE;
                type.remote = Boolean.FALSE;
                type.queue = new Boolean(!aliasDestinationHandler.isPubSub());
                type.state = State.ACTIVE;
                this.destinationIndex.put(aliasDestinationHandler, type);
            }
        }
        catch (SITemporaryDestinationNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createAliasDestination", (String)"1:6701:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)"SIErrorException");
            }
            SIMPErrorException ee = new SIMPErrorException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_901", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:6710:1.508.1.7", e, destinationName}, null), (Throwable)e);
            ee.setExceptionReason(901);
            ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:6716:1.508.1.7", SIMPUtils.getStackTrace(e)});
            throw ee;
        }
        catch (SIIncorrectCallException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createAliasDestination", (String)"1:6166:1.487", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)"SIErrorException");
            }
            SIMPErrorException ee = new SIMPErrorException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_901", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:6175:1.487", e, destinationName}, null), (Throwable)e);
            ee.setExceptionReason(901);
            ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:6181:1.487", SIMPUtils.getStackTrace(e)});
            throw ee;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)aliasDestinationHandler);
        }
        return aliasDestinationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationHandler createForeignDestination(DestinationForeignDefinition dfd, String busName) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createForeignDestination", (Object)new Object[]{dfd, busName});
        }
        ForeignDestinationHandler fdh = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            fdh = new ForeignDestinationHandler(dfd, this.messageProcessor, this, this.findBus(dfd.getBus()), busName);
            DestinationIndex.Type type = new DestinationIndex.Type();
            type.foreignDestination = Boolean.TRUE;
            type.alias = Boolean.FALSE;
            type.local = Boolean.FALSE;
            type.remote = Boolean.FALSE;
            type.queue = new Boolean(!fdh.isPubSub());
            type.state = State.ACTIVE;
            this.destinationIndex.put(fdh, type);
            fdh.registerControlAdapters();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createForeignDestination", (Object)fdh);
        }
        return fdh;
    }

    protected boolean isReconciling() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReconciling");
            SibTr.exit((TraceComponent)tc, (String)"isReconciling", (Object)new Boolean(this.reconciling));
        }
        return this.reconciling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMQLinkLocalization(MQLinkDefinition mqld, LocalizationDefinition linkLocalizationDefinition, VirtualLinkDefinition virtualLinkDefinition, Set<String> linkLocalizingMEs) throws SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)new Object[]{mqld, linkLocalizationDefinition, virtualLinkDefinition, linkLocalizingMEs});
        }
        boolean linkCreated = false;
        boolean engineResourcesRequired = false;
        MQLinkHandler mqLinkHandler = null;
        LocalTransaction transaction = this.txManager.createLocalTransaction(false);
        try {
            DestinationHandler dh = this.linkIndex.findByName(virtualLinkDefinition.getName(), null);
            if (dh == null) {
                mqLinkHandler = this.createMQLinkHandler(mqld, virtualLinkDefinition, transaction);
                linkCreated = true;
            } else {
                mqLinkHandler = (MQLinkHandler)dh;
            }
            MQLinkHandler mQLinkHandler = mqLinkHandler;
            synchronized (mQLinkHandler) {
                if (!mqLinkHandler.isCorruptOrIndoubt()) {
                    engineResourcesRequired = this.createMQLinkMPResources(mqLinkHandler, mqld, linkLocalizationDefinition, virtualLinkDefinition, linkLocalizingMEs, transaction, linkCreated);
                }
                transaction.commit();
                if (!mqLinkHandler.isCorruptOrIndoubt()) {
                    if (engineResourcesRequired) {
                        this.createMQLinkEngineResources(mqld, mqLinkHandler);
                    }
                    mqLinkHandler.registerLink();
                }
            }
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createMQLinkLocalization", (String)"1:6885:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)e);
            }
            this.handleRollback(transaction);
            this.putLinkIntoIndoubtState(virtualLinkDefinition.getName());
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization");
        }
    }

    private MQLinkHandler createMQLinkHandler(MQLinkDefinition mqld, VirtualLinkDefinition virtualLinkDefinition, LocalTransaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkHandler", (Object)new Object[]{mqld, virtualLinkDefinition, transaction});
        }
        MQLinkHandler mqLinkHandler = null;
        try {
            mqLinkHandler = new MQLinkHandler(mqld, virtualLinkDefinition, this.messageProcessor, this, (TransactionCommon)transaction, this.durableSubscriptions);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createMQLinkHandler", (String)"1:6948:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        mqLinkHandler.setLocal();
        LinkIndex.Type type = new LinkIndex.Type();
        type.local = Boolean.TRUE;
        type.mqLink = Boolean.TRUE;
        type.remote = Boolean.FALSE;
        type.state = State.ACTIVE;
        this.linkIndex.put(mqLinkHandler, type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkHandler", (Object)mqLinkHandler);
        }
        return mqLinkHandler;
    }

    private boolean createMQLinkMPResources(MQLinkHandler mqLinkHandler, MQLinkDefinition mqld, LocalizationDefinition linkLocalizationDefinition, VirtualLinkDefinition virtualLinkDefinition, Set<String> linkLocalizingMEs, LocalTransaction transaction, boolean linkCreated) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkMPResources", (Object)new Object[]{mqLinkHandler, mqld, linkLocalizationDefinition, virtualLinkDefinition, linkLocalizingMEs, transaction, new Boolean(linkCreated)});
        }
        boolean engineResourcesRequired = false;
        linkLocalizationDefinition.setDestinationHighMsgs(this.messageProcessor.getHighMessageThreshold());
        linkLocalizationDefinition.setDestinationLowMsgs(this.messageProcessor.getHighMessageThreshold() * 8L / 10L);
        if (!linkCreated) {
            if (!mqld.getUuid().equals((Object)mqLinkHandler.getMqLinkUuid())) {
                this.deleteRecreateMQLinkHandler(mqld, mqLinkHandler, virtualLinkDefinition, linkLocalizationDefinition, transaction);
            } else {
                mqLinkHandler.updateLinkDefinition(virtualLinkDefinition, transaction);
                engineResourcesRequired = true;
                if (linkLocalizingMEs == null) {
                    linkLocalizingMEs = new HashSet<String>();
                    linkLocalizingMEs.add(this.messageProcessor.getMessagingEngineUuid().toString());
                }
                this.linkIndex.setLocalizationFlags(mqLinkHandler, true, false);
                mqLinkHandler.updateLocalizationDefinition((BaseLocalizationDefinition)linkLocalizationDefinition, (TransactionCommon)transaction);
                this.linkIndex.create(mqLinkHandler);
            }
        } else {
            mqLinkHandler.addNewMQLinkLocalisation((TransactionCommon)transaction, this.messageProcessor.getMessagingEngineUuid(), linkLocalizationDefinition);
            engineResourcesRequired = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkMPResources", (Object)new Boolean(engineResourcesRequired));
        }
        return engineResourcesRequired;
    }

    private void createMQLinkEngineResources(MQLinkDefinition mqld, MQLinkHandler mqLinkHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkEngineResources", (Object)new Object[]{mqld, mqLinkHandler});
        }
        MQLinkManager mqlinkManager = this.getMQLinkManager();
        MQLinkObject mqlinkObj = null;
        try {
            mqlinkObj = mqlinkManager.create(mqld, (MQLinkLocalization)mqLinkHandler, (ControllableRegistrationService)this.messageProcessor.getMEInstance("JsMBeanFactory"), false);
            if (this.messageProcessor.isStarted()) {
                mqlinkObj.mpStarted(0, this.messageProcessor.getMessagingEngine());
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        mqLinkHandler.setMQLinkObject(mqlinkObj);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkEngineResources");
        }
    }

    private void deleteRecreateMQLinkHandler(MQLinkDefinition mqld, LinkHandler oldLinkHandler, VirtualLinkDefinition virtualLinkDefinition, LocalizationDefinition linkLocalizationDefinition, LocalTransaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)new Object[]{mqld, oldLinkHandler, virtualLinkDefinition, linkLocalizationDefinition, transaction});
        }
        MQLinkHandler newLinkHandler = null;
        oldLinkHandler.setToBeDeleted(true);
        this.linkIndex.delete(oldLinkHandler);
        Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction((TransactionCommon)transaction);
        try {
            oldLinkHandler.requestUpdate(msTran);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteRecreateMQLinkHandler", (String)"1:7180:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        try {
            newLinkHandler = new MQLinkHandler(mqld, virtualLinkDefinition, this.messageProcessor, this, (TransactionCommon)transaction, this.durableSubscriptions);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteRecreateMQLinkHandler", (String)"1:7214:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        LinkIndex.Type type = new LinkIndex.Type();
        type.local = Boolean.TRUE;
        type.mqLink = Boolean.TRUE;
        type.remote = Boolean.FALSE;
        type.state = State.ACTIVE;
        this.linkIndex.put(newLinkHandler, type);
        newLinkHandler.addNewMQLinkLocalisation((TransactionCommon)transaction, this.messageProcessor.getMessagingEngineUuid(), linkLocalizationDefinition);
        newLinkHandler.setMQLinkObject(((MQLinkHandler)oldLinkHandler).getMQLinkObject());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)newLinkHandler);
        }
    }

    public DestinationIndex getDestinationIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationIndex");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationIndex");
        }
        return this.destinationIndex;
    }

    public LinkIndex getLinkIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkIndex");
            SibTr.exit((TraceComponent)tc, (String)"getLinkIndex");
        }
        return this.linkIndex;
    }

    public ForeignBusIndex getForeignBusIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusIndex");
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusIndex");
        }
        return this.foreignBusIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIDestinationAddress[] addDestinationListener(String destinationNamePatternString, DestinationListener destinationListener, DestinationType destinationType, DestinationAvailability destinationAvailability, SICoreConnection connection) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationNamePatternString, destinationListener, destinationType, destinationAvailability, connection});
        }
        SIDestinationAddress[] destinationAddresses = null;
        DestinationNamePattern destinationNamePattern = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            if (destinationNamePatternString != null && destinationNamePatternString.trim().length() != 0) {
                destinationNamePattern = new DestinationNamePattern(destinationNamePatternString, this.messageProcessor.getMessageProcessorMatching());
                destinationNamePattern.prepare();
            }
            DestinationListenerDataObject listenerDataObject = new DestinationListenerDataObject(destinationListener, destinationNamePattern, destinationType, destinationAvailability, connection);
            this.destinationListeners.add(listenerDataObject);
            if (destinationType != DestinationType.TOPICSPACE) {
                destinationAddresses = this.getDestinationAddresses(destinationNamePattern, destinationType, destinationAvailability);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationAddresses});
        }
        return destinationAddresses;
    }

    private SIDestinationAddress[] getDestinationAddresses(DestinationNamePattern destinationNamePattern, DestinationType destinationType, DestinationAvailability destinationAvailability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationAddresses", (Object)new Object[]{destinationNamePattern, destinationType, destinationAvailability});
        }
        BaseDestinationHandler destinationHandler = null;
        SIDestinationAddress[] destinationAddresses = null;
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        filter.FOREIGN_DESTINATION = Boolean.FALSE;
        filter.ALIAS = Boolean.FALSE;
        filter.QUEUE = Boolean.TRUE;
        filter.VISIBLE = Boolean.TRUE;
        SIMPIterator iterator = this.destinationIndex.iterator(filter);
        int i = 0;
        Vector<String> addresses = new Vector<String>();
        while (iterator.hasNext()) {
            destinationHandler = (BaseDestinationHandler)iterator.next();
            if (!this.isAvailable(destinationHandler, destinationAvailability) || destinationHandler.isSystem() || destinationHandler.getDestinationType() != destinationType) continue;
            String destinationName = destinationHandler.getName();
            if (destinationNamePattern != null && !destinationNamePattern.match(destinationName)) continue;
            addresses.add(i, destinationName);
            ++i;
        }
        destinationAddresses = new SIDestinationAddress[addresses.size()];
        for (int cursor = 0; cursor < addresses.size(); ++cursor) {
            destinationAddresses[cursor] = ((SIDestinationAddressFactory)MessageProcessor.getSingletonInstance("SIDestinationAddressFactory")).createSIDestinationAddress((String)addresses.get(cursor), true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationAddresses", (Object)new Object[]{destinationAddresses});
        }
        return destinationAddresses;
    }

    private boolean isAvailable(BaseDestinationHandler destinationHandler, DestinationAvailability destinationAvailability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAvailable", (Object)new Object[]{destinationHandler, destinationAvailability});
        }
        boolean sendAvailable = false;
        boolean receiveAvailable = false;
        if (destinationAvailability == DestinationAvailability.SEND || destinationAvailability == DestinationAvailability.SEND_AND_RECEIVE) {
            if (destinationHandler.hasLocal()) {
                sendAvailable = true;
            }
            if (sendAvailable) {
                sendAvailable = destinationHandler.definition.isSendAllowed() && this.isLocalizationAvailable(destinationHandler, destinationAvailability);
            }
        }
        if (destinationAvailability == DestinationAvailability.RECEIVE || destinationAvailability == DestinationAvailability.SEND_AND_RECEIVE) {
            if (destinationHandler.hasLocal()) {
                receiveAvailable = true;
            }
            if (receiveAvailable) {
                receiveAvailable = destinationHandler.definition.isReceiveAllowed() && this.isLocalizationAvailable(destinationHandler, destinationAvailability);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAvailable", (Object)new Object[]{new Boolean(sendAvailable || receiveAvailable)});
        }
        return sendAvailable || receiveAvailable;
    }

    private boolean isLocalizationAvailable(BaseDestinationHandler baseDestinationHandler, DestinationAvailability destinationAvailability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocalizationAvailable", (Object)new Object[]{baseDestinationHandler, destinationAvailability});
        }
        boolean available = false;
        if (baseDestinationHandler.hasLocal()) {
            LocalizationPoint localizationPoint = baseDestinationHandler.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
            available = destinationAvailability == DestinationAvailability.SEND ? localizationPoint.isSendAllowed() : true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocalizationAvailable", (Object)new Object[]{new Boolean(available)});
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDestinationListener(DestinationListener destinationListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDestinationListener", (Object)new Object[]{destinationListener});
        }
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            for (int i = 0; i < this.destinationListeners.size(); ++i) {
                DestinationListenerDataObject listenerDataObject = this.destinationListeners.get(i);
                if (!destinationListener.equals(listenerDataObject.getDestinationLister())) continue;
                this.destinationListeners.remove(listenerDataObject);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDestinationListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDestinationListener(SICoreConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDestinationListener", (Object)new Object[]{connection});
        }
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            for (int i = 0; i < this.destinationListeners.size(); ++i) {
                DestinationListenerDataObject listenerDataObject = this.destinationListeners.get(i);
                if (!connection.equals(listenerDataObject.getConnection())) continue;
                this.destinationListeners.remove(listenerDataObject);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDestinationListener");
        }
    }

    private void callDestinationListener(String destinationName) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"callDestinationListener", (Object)new Object[]{destinationName});
        }
        DestinationListenerDataObject listenerDataObject = null;
        DestinationListener destinationListener = null;
        DestinationAvailability listenersDestinationAvailability = null;
        SICoreConnection listenersConnection = null;
        DestinationNamePattern destinationNamePattern = null;
        BaseDestinationHandler destinationHandler = null;
        try {
            destinationHandler = (BaseDestinationHandler)this.getDestination(destinationName, false);
        }
        catch (SIMPDestinationCorruptException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.callDestinationListener", (String)"1:7589:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"callDestinationListener", (Object)"Destination corrupt");
            }
            return;
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.callDestinationListener", (String)"1:7608:1.508.1.7", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"callDestinationListener", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (destinationHandler.definition.getDestinationType() != DestinationType.TOPICSPACE) {
            for (int i = 0; i < this.destinationListeners.size(); ++i) {
                listenerDataObject = this.destinationListeners.get(i);
                destinationListener = listenerDataObject.getDestinationLister();
                listenersDestinationAvailability = listenerDataObject.getDestinationAvailability();
                listenersConnection = listenerDataObject.getConnection();
                destinationNamePattern = listenerDataObject.getDestinationNamePattern();
                SIDestinationAddress destinationAddress = null;
                if (!this.isAvailable(destinationHandler, listenersDestinationAvailability) || destinationHandler.isSystem() || listenerDataObject.getDestinationType() != destinationHandler.definition.getDestinationType() || destinationNamePattern != null && !destinationNamePattern.match(destinationName)) continue;
                destinationAddress = ((SIDestinationAddressFactory)MessageProcessor.getSingletonInstance("SIDestinationAddressFactory")).createSIDestinationAddress(destinationHandler.getName(), true);
                destinationListener.destinationAvailable(listenersConnection, destinationAddress, listenersDestinationAvailability);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"callDestinationListener");
        }
    }

    public List<JsDestinationAddress> getAllSystemDestinations(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllSystemDestinations", (Object)meUuid);
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.LOCAL = Boolean.FALSE;
        filter.DELETE_PENDING = Boolean.FALSE;
        filter.DELETE_DEFERED = Boolean.FALSE;
        filter.ACTIVE = Boolean.TRUE;
        ArrayList<JsDestinationAddress> destAddresses = new ArrayList<JsDestinationAddress>();
        SIMPIterator itr = this.getDestinationIndex().iterator(filter);
        while (itr.hasNext()) {
            DestinationHandler destinationHandler = (DestinationHandler)itr.next();
            String destinationHandlerName = destinationHandler.getName();
            SIBUuid8 found = SIMPUtils.parseME(destinationHandlerName);
            if (found == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Couldn't parse uuid from " + destinationHandlerName));
            }
            if (found == null || !found.equals((Object)meUuid) || !destinationHandler.isSystem()) continue;
            destAddresses.add(SIMPUtils.createJsDestinationAddress(destinationHandler.getName(), meUuid));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllSystemDestinations", destAddresses);
        }
        return destAddresses;
    }

    protected void activateDestination(DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activateDestination", (Object)dh);
        }
        if (dh.isLink()) {
            this.linkIndex.create(dh);
        } else {
            this.destinationIndex.create(dh);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activateDestination");
        }
    }

    protected void corruptDestination(DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"corruptDestination", (Object)dh);
        }
        if (!dh.isLink() && this.destinationIndex.containsDestination(dh)) {
            this.destinationIndex.corrupt(dh);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"corruptDestination");
        }
    }

    public MQLinkManager getMQLinkManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkManager");
        }
        if (this._mqlinkManager == null) {
            this._mqlinkManager = MQLinkManager.getInstance();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkManager", (Object)this._mqlinkManager);
        }
        return this._mqlinkManager;
    }

    public DestinationHandler getAliasDestination(SIBUuid12 gatheringTargetUuid, DestinationHandler baseDest, boolean includeInvisible) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAliasDestination", (Object)new Object[]{gatheringTargetUuid, baseDest, includeInvisible});
        }
        DestinationHandler destinationHandler = this.getDestinationInternal(gatheringTargetUuid, includeInvisible);
        try {
            BaseDestinationDefinition bdd;
            if (destinationHandler == null && (bdd = this.messageProcessor.getMessagingEngine().getSIBDestinationByUuid(this.messageProcessor.getMessagingEngineBus(), gatheringTargetUuid.toString())).isAlias()) {
                DestinationAliasDefinition add = (DestinationAliasDefinition)bdd;
                destinationHandler = this.createAliasDestination(add, null, baseDest);
            }
        }
        catch (SIBExceptionDestinationNotFound e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIBExceptionBase e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIResourceException e) {
            if (!(e instanceof SIMPResourceException)) {
                SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager.getAliasDestination", "1:8107:1.508.1.7", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getAliasDestination", (Object)ee);
                }
                throw ee;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getAliasDestination", (Object)((Object)e));
            }
            throw e;
        }
        this.checkDestinationHandlerExists(destinationHandler != null, gatheringTargetUuid.toString(), this.messageProcessor.getMessagingEngineName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAliasDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public DestinationHandler getAliasDestinationInternal(String aliasName, String aliasBus, AliasChainValidator validator, DestinationHandler targetDest, boolean includeInvisible) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAliasDestination", (Object)new Object[]{aliasName, aliasName, targetDest, includeInvisible});
        }
        DestinationHandler destinationHandler = this.getDestinationInternal(aliasName, aliasBus, includeInvisible);
        try {
            BaseDestinationDefinition bdd;
            if (destinationHandler == null && (bdd = this.messageProcessor.getMessagingEngine().getSIBDestination(aliasBus, aliasName)).isAlias()) {
                DestinationAliasDefinition add = (DestinationAliasDefinition)bdd;
                destinationHandler = this.createAliasDestination(add, validator, targetDest);
            }
        }
        catch (SIBExceptionDestinationNotFound e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIBExceptionBase e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIResourceException e) {
            if (!(e instanceof SIMPResourceException)) {
                SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager.getAliasDestination", "1:8188:1.508.1.7", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getAliasDestination", (Object)ee);
                }
                throw ee;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getAliasDestination", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAliasDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public void alterDestinationAlias(DestinationAliasDefinition destinationAliasDefinition) throws SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationAlias", (Object)new Object[]{destinationAliasDefinition.getName()});
        }
        LocalTransaction transaction = this.txManager.createLocalTransaction(true);
        try {
            DestinationTypeFilter filter = new DestinationTypeFilter();
            filter.LOCAL = Boolean.TRUE;
            filter.VISIBLE = Boolean.TRUE;
            filter.ALIAS = Boolean.TRUE;
            filter.FOREIGN_DESTINATION = Boolean.FALSE;
            filter.QUEUE = Boolean.FALSE;
            filter.CORRUPT = Boolean.FALSE;
            filter.RESET_ON_RESTART = Boolean.FALSE;
            DestinationHandler dh = this.destinationIndex.findByName(destinationAliasDefinition.getName(), "defaultBus", filter);
            if (dh == null) {
                dh = this.getDestination(destinationAliasDefinition.getName(), "defaultBus", false, false);
            }
            if (!(dh.isSystem() || dh.isTemporary() || dh.isToBeDeleted() || dh.isDeleted())) {
                dh.updateDefinition((BaseDestinationDefinition)destinationAliasDefinition);
            }
            transaction.commit();
        }
        catch (SIResourceException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationAlias", (Object)((Object)e));
            }
            this.handleRollback(transaction);
            throw e;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.alterDestinationAlias", (String)"1:4353:1.508.1.7", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationAlias", (Object)e);
            }
            this.handleRollback(transaction);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationAlias");
        }
    }
}

