/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.BooleanMatcher;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.DifficultMatcher;
import com.ibm.ws.sib.matchspace.impl.EqualityMatcher;
import com.ibm.ws.sib.matchspace.impl.NumericMatcher;
import com.ibm.ws.sib.matchspace.impl.SetValBooleanMatcher;
import com.ibm.ws.sib.matchspace.impl.SetValChildAccessMatcher;
import com.ibm.ws.sib.matchspace.impl.SetValNumericMatcher;
import com.ibm.ws.sib.matchspace.impl.SetValStringMatcher;
import com.ibm.ws.sib.matchspace.impl.SimpleMatcher;
import com.ibm.ws.sib.matchspace.impl.StringMatcher;
import com.ibm.ws.sib.matchspace.selector.impl.ExtendedSimpleTestImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OrdinalPosition;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;

final class Factory {
    private static final Class cclass = Factory.class;
    private static Trace tc = TraceUtils.getTrace(Factory.class, (String)"SIBMatchSpace");

    private Factory() {
    }

    static ContentMatcher createMatcher(OrdinalPosition lastOrdinalPosition, Conjunction selector, ContentMatcher oldMatcher) {
        if (tc.isEntryEnabled()) {
            tc.entry(cclass, "createMatcher", (Object)("lastOrdinalPosition: " + lastOrdinalPosition + ",selector: " + selector + ", oldmatcher: " + oldMatcher));
        }
        if (oldMatcher instanceof DifficultMatcher) {
            if (tc.isDebugEnabled()) {
                tc.debug(cclass, "createMatcher", (Object)("Reusing old DifficultMatcher with position: " + oldMatcher.ordinalPosition + " for position " + lastOrdinalPosition));
            }
            if (tc.isEntryEnabled()) {
                tc.exit(cclass, "createMatcher");
            }
            return oldMatcher;
        }
        if (oldMatcher != null && oldMatcher.ordinalPosition.compareTo(lastOrdinalPosition) < 0) {
            throw new IllegalStateException();
        }
        if (selector != null) {
            for (int i = 0; i < selector.getSimpleTests().length; ++i) {
                OrdinalPosition newPos = (OrdinalPosition)selector.getSimpleTests()[i].getIdentifier().getOrdinalPosition();
                if (oldMatcher != null && newPos.compareTo(oldMatcher.ordinalPosition) >= 0) {
                    if (tc.isDebugEnabled()) {
                        tc.debug(cclass, "createMatcher", (Object)("Reusing " + oldMatcher.getClass().getName() + " for position: " + lastOrdinalPosition + "; next test is at: " + newPos));
                    }
                    if (tc.isEntryEnabled()) {
                        tc.exit(cclass, "createMatcher");
                    }
                    return oldMatcher;
                }
                if (newPos.compareTo(lastOrdinalPosition) <= 0) continue;
                if (tc.isDebugEnabled()) {
                    tc.debug(cclass, "createMatcher", (Object)("Creating new matcher at position " + newPos));
                }
                if (tc.isEntryEnabled()) {
                    tc.exit(cclass, "createMatcher");
                }
                return Factory.createMatcher(selector.getSimpleTests()[i], oldMatcher);
            }
        }
        DifficultMatcher ans = new DifficultMatcher(lastOrdinalPosition);
        if (tc.isDebugEnabled()) {
            if (oldMatcher != null) {
                tc.debug(cclass, "createMatcher", (Object)("New DifficultMatcher at position " + lastOrdinalPosition + " with successor " + oldMatcher.getClass().getName() + " at position " + oldMatcher.ordinalPosition));
            } else {
                tc.debug(cclass, "createMatcher", (Object)("New DifficultMatcher at position " + lastOrdinalPosition + " with null successor."));
            }
        }
        ans.vacantChild = oldMatcher;
        if (tc.isEntryEnabled()) {
            tc.exit(cclass, "createMatcher");
        }
        return ans;
    }

    private static ContentMatcher createMatcher(SimpleTest test, ContentMatcher oldMatcher) {
        SimpleMatcher ans;
        if (tc.isEntryEnabled()) {
            tc.entry(cclass, "createMatcher", (Object)("test: " + test + ", oldmatcher: " + oldMatcher));
        }
        Identifier id = test.getIdentifier();
        boolean isExtended = test instanceof ExtendedSimpleTestImpl;
        switch (id.getType()) {
            case -6: {
                if (!isExtended) {
                    if (tc.isDebugEnabled()) {
                        tc.debug(cclass, "createMatcher", (Object)("New BooleanMatcher for id " + id.getName()));
                    }
                    ans = new BooleanMatcher(id);
                    break;
                }
                if (tc.isDebugEnabled()) {
                    tc.debug(cclass, "createMatcher", (Object)("New SetValBooleanMatcher for id " + id.getName()));
                }
                ans = new SetValBooleanMatcher(id);
                break;
            }
            case -7: 
            case 0: {
                if (tc.isDebugEnabled()) {
                    tc.debug(cclass, "createMatcher", (Object)("New EqualityMatcher for id " + id.getName()));
                }
                ans = new EqualityMatcher(id);
                break;
            }
            case -5: 
            case 3: {
                if (!isExtended) {
                    if (tc.isDebugEnabled()) {
                        tc.debug(cclass, "createMatcher", (Object)("New StringMatcher for id " + id.getName()));
                    }
                    ans = new StringMatcher(id);
                    break;
                }
                if (tc.isDebugEnabled()) {
                    tc.debug(cclass, "createMatcher", (Object)("New SetValStringMatcher for id " + id.getName()));
                }
                ans = new SetValStringMatcher(id);
                break;
            }
            case -8: {
                if (tc.isDebugEnabled()) {
                    tc.debug(cclass, "createMatcher", (Object)("New ExtensionMatcher for id " + id.getName()));
                }
                ans = new SetValChildAccessMatcher(id);
                break;
            }
            default: {
                if (!isExtended) {
                    if (tc.isDebugEnabled()) {
                        tc.debug(cclass, "createMatcher", (Object)("New NumericMatcher for id " + id.getName()));
                    }
                    ans = new NumericMatcher(id);
                    break;
                }
                if (tc.isDebugEnabled()) {
                    tc.debug(cclass, "createMatcher", (Object)("New SetValNumericMatcher for id " + id.getName()));
                }
                ans = new SetValNumericMatcher(id);
            }
        }
        ans.vacantChild = oldMatcher;
        if (tc.isEntryEnabled()) {
            tc.exit(cclass, "createMatcher");
        }
        return ans;
    }

    static SimpleTest findTest(OrdinalPosition ordinalPosition, Conjunction selector) {
        if (selector == null) {
            return null;
        }
        for (int i = 0; i < selector.getSimpleTests().length; ++i) {
            SimpleTest cand = selector.getSimpleTests()[i];
            OrdinalPosition candOrdinalPosition = (OrdinalPosition)cand.getIdentifier().getOrdinalPosition();
            if (!candOrdinalPosition.equals(ordinalPosition)) continue;
            return cand;
        }
        return null;
    }
}

