/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectManager.NonExistentLogFileException;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsHealthState;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsRecoveryMessagingEngine;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.SIBFileStore;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.CacheStatistics;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.MessageStoreUnavailableException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.WASConfiguration;
import com.ibm.ws.sib.msgstore.XidInvalidException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.RootMembership;
import com.ibm.ws.sib.msgstore.cache.ref.ItemStorageManager;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayManager;
import com.ibm.ws.sib.msgstore.expiry.CacheLoader;
import com.ibm.ws.sib.msgstore.expiry.Expirer;
import com.ibm.ws.sib.msgstore.impl.ItemLinkMap;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.msgstore.impl.MessageStoreState;
import com.ibm.ws.sib.msgstore.impl.MultiHashMap;
import com.ibm.ws.sib.msgstore.impl.RawDataDumper;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistenceFactory;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.MSTransactionFactory;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.XidManager;
import com.ibm.ws.sib.processor.ItemInterface;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionFactory;
import com.ibm.ws.sib.utils.Runtime;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public final class MessageStoreImpl
extends MessageStore
implements MessageStoreConstants,
XmlConstants {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final TraceComponent tc = SibTr.register(MessageStoreImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final String XML_CANNOT_BE_WRITTEN = "XML cannot be written as the message store has not started";
    private CacheLoader _cacheLoader = null;
    private long _cacheLoaderInterval = -1L;
    private Configuration _configuration = null;
    private final Hashtable _customProperties = new Hashtable();
    private Expirer _expirer = null;
    private DeliveryDelayManager _deliveryDelayManager = null;
    private final long _expiryInterval = -1L;
    private final long _deliveryDelayScanInterval = -1L;
    private int _spillUpperLimit;
    private int _spillLowerLimit;
    private int _spillUpperSizeLimit;
    private int _spillLowerSizeLimit;
    private JsHealthMonitor _healthMonitor;
    private JsHealthState _healthState;
    private ItemStorageManager _itemStorageManager;
    private final XidManager _manager;
    private MessageStoreState _state = MessageStoreState.STATE_UNINITIALIZED;
    private static final StartLock _startLock = new StartLock();
    private Map _membershipMap = null;
    private JsMessagingEngine _messagingEngine = null;
    private PersistentMessageStore _persistentMessageStore = null;
    private RootMembership _rootMembership;
    private UniqueKeyGenerator _tickCountGenerator;
    private TransactionFactory _transactionFactory;
    private UniqueKeyGenerator _uniqueIdentifierGenerator;
    private UniqueKeyGenerator _uniqueLockIDGenerator;
    private boolean _jdbcSpillSizeMsgRefsByMsgSize;
    private boolean _datastoreLockCanBeDisabled;
    private boolean _restrictLongDBLock = false;
    private long _lastDBLockedTimestamp = 0L;
    public static final AtomicServiceReference<AlarmManager> alarmManagerRef = new AtomicServiceReference("alarmManager");
    public static final AtomicServiceReference<ItemInterface> itemInterfaceRef = new AtomicServiceReference("itemInterface");

    protected void activate(ComponentContext context) {
        alarmManagerRef.activate(context);
        itemInterfaceRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        alarmManagerRef.deactivate(context);
        itemInterfaceRef.deactivate(context);
    }

    protected void setAlarmManager(ServiceReference<AlarmManager> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAlarmManager", ref);
        }
        alarmManagerRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAlarmManager");
        }
    }

    protected void unsetAlarmManager(ServiceReference<AlarmManager> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetAlarmManager", ref);
        }
        alarmManagerRef.unsetReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetAlarmManager");
        }
    }

    protected void setItemInterface(ServiceReference<ItemInterface> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setItemInterface", ref);
        }
        itemInterfaceRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setItemInterface");
        }
    }

    protected void unsetItemInterface(ServiceReference<ItemInterface> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetItemInterface", ref);
        }
        itemInterfaceRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetItemInterface");
        }
    }

    public static AbstractItem getItemStreamInstance(String itemClassName) {
        AbstractItem itemStream = ((ItemInterface)itemInterfaceRef.getService()).getItemStreamInstance(itemClassName);
        return itemStream;
    }

    public MessageStoreImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
        this._manager = new XidManager(this);
        this._expirer = new Expirer(this);
        this._deliveryDelayManager = new DeliveryDelayManager(this);
        this._cacheLoader = new CacheLoader(this);
        this._healthState = JsHealthState.getOK();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message store state is : " + this._state));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public final AbstractItem _findById(long itemID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"_findById", (Object)itemID);
        }
        AbstractItem item = null;
        AbstractItemLink itemLink = this.getLink(itemID);
        if (null != itemLink) {
            item = itemLink.getItem();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"_findById", (Object)item);
        }
        return item;
    }

    public final Expirer _getExpirer() {
        return this._expirer;
    }

    public final DeliveryDelayManager _getDeliveryDelayManager() {
        return this._deliveryDelayManager;
    }

    public final Membership _getMembership(AbstractItem ai) {
        return super._getMembership(ai);
    }

    public final JsMessagingEngine _getMessagingEngine() {
        return this._messagingEngine;
    }

    public final RootMembership _getRootMembership() {
        return this._rootMembership;
    }

    public MessageStoreState _getState() {
        return this._state;
    }

    public final void _setMembership(Membership membership, AbstractItem item) {
        super._setMembership(membership, item);
    }

    private final void _xmlWriteRawOn(FormattedWriter writer, boolean callBackToItem) throws IOException {
        new RawDataDumper(this._persistentMessageStore, writer, callBackToItem).dump();
    }

    public void add(ItemStream itemStream, long lockID, Transaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"add", (Object)new Object[]{itemStream, transaction});
        }
        if (this._rootMembership != null) {
            this._rootMembership.addItemStream(itemStream, lockID, transaction);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"add");
            }
        } else {
            MessageStoreUnavailableException msue;
            if (!this._startupExceptions.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
                }
                msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
                }
                msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"add");
            }
            throw msue;
        }
    }

    public void busReloaded(Object newBus, boolean busChanged, boolean destChg, boolean medChg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"busReloaded");
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void commitPreparedTransaction(String xid) throws TransactionException, PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"commitPreparedTransaction", (Object)xid);
        }
        if (this._manager != null) {
            try {
                PersistentTranId pid = new PersistentTranId(xid);
                this._manager.commit(pid, false);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Invalid XID string", (Object)xid);
                }
                throw new XidInvalidException(nls.getString("INVALID_XID_STRING_SIMS1010"));
            }
            catch (StringIndexOutOfBoundsException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Invalid XID string", (Object)xid);
                }
                throw new XidInvalidException(nls.getString("INVALID_XID_STRING_SIMS1010"));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"commitPreparedTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"destroy");
        }
        StartLock startLock = _startLock;
        synchronized (startLock) {
            if (this._state != MessageStoreState.STATE_STOPPED) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            this._configuration = null;
            this._state = MessageStoreState.STATE_UNINITIALIZED;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"destroy");
        }
    }

    public final void disableDataStoreLock(Long period) {
        if (!this._datastoreLockCanBeDisabled) {
            SibTr.info((TraceComponent)tc, (String)"DATASTORE_LOCK_CANNOT_BE_DISABLED_CWSIS1596");
        }
    }

    public void dump(FormattedWriter fw) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dump");
            }
            try {
                this.xmlRequestWriteOnFile(fw);
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Exception caught writing Mmessage store dump!", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dump");
        }
    }

    public void dump(FormattedWriter fw, String arg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dump", (Object)arg);
        }
        if (arg != null) {
            if (arg.equalsIgnoreCase("raw")) {
                this.dumpRaw(fw);
            } else if (arg.equalsIgnoreCase("all")) {
                this.dumpAll(fw);
            } else {
                this.dump(fw);
            }
        } else {
            this.dump(fw);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dump");
        }
    }

    public void dumpRaw(FormattedWriter fw) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpRaw");
            }
            try {
                this.xmlRequestWriteRawDataOnFile(fw);
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Exception caught writing Mmessage store dump!", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpRaw");
        }
    }

    public void dumpAll(FormattedWriter fw) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpAll");
            }
            try {
                this.xmlRequestWriteOnFile(fw);
                this.xmlWriteRawOn(fw, true);
                fw.flush();
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Exception caught writing Mmessage store dump!", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpAll");
        }
    }

    public void engineReloaded(Object messagingEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"engineReloaded");
        }
        this.initialize((JsMessagingEngine)messagingEngine, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public final void expirerStart() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"expirerStart");
        }
        this._expirer.start(-1L, this._messagingEngine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"expirerStart");
        }
    }

    public final void expirerStop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"expirerStop");
        }
        this._expirer.stop();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"expirerStop");
        }
    }

    public void deliveryDelayManagerStart() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"deliveryDelayManagerStart");
        }
        this._deliveryDelayManager.start(-1L, this._messagingEngine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"deliveryDelayManagerStart");
        }
    }

    public void deliveryDelayManagerStop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"deliveryDelayManagerStop");
        }
        this._deliveryDelayManager.stop();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"deliveryDelayManagerStop");
        }
    }

    public AbstractItem findById(long itemID) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"findById", (Object)itemID);
        }
        AbstractItem item = this._findById(itemID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"findById", (Object)item);
        }
        return item;
    }

    public ItemStream findByStreamId(long itemStreamId) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"findByIdInRoot", (Object)itemStreamId);
        }
        ItemStream item = (ItemStream)this._findById(itemStreamId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"findByIdInRoot", (Object)item);
        }
        return item;
    }

    public ItemStream findFirstMatching(Filter filter) throws MessageStoreException {
        MessageStoreUnavailableException msue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        if (this._rootMembership != null) {
            ItemStream item = this._rootMembership.findFirstMatchingItemStream(filter);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"findFirstMatching", (Object)item);
            }
            return item;
        }
        if (!this._startupExceptions.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"findFirstMatching");
        }
        throw msue;
    }

    public final CacheStatistics getCacheStatistics() {
        return this._itemStorageManager;
    }

    public Configuration getConfig() {
        return this._configuration;
    }

    public final int getExpiryIndexSize() {
        return this._expirer.size();
    }

    public final JsHealthState getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getHealthState");
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getHealthState", (Object)("return=" + this._healthState));
        }
        return this._healthState;
    }

    public final AbstractItemLink getLink(long itemID) {
        return this._membershipMap.get(itemID);
    }

    public final ItemStorageManager getManagedCache() {
        return this._itemStorageManager;
    }

    public Membership getMembership(long id) {
        return this._membershipMap.get(id);
    }

    public CacheStatistics getNonStoredCacheStatistics() {
        return this._itemStorageManager.getNonStoredCacheStatistics();
    }

    public final PersistentMessageStore getPersistentMessageStore() {
        return this._persistentMessageStore;
    }

    public String[] listPreparedTransactions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getPreparedTransactions");
        }
        String[] col = null;
        if (this._manager != null) {
            Xid[] xids = null;
            xids = this._manager.listRemoteInDoubts();
            if (xids != null) {
                col = new String[xids.length];
                for (int i = 0; i < xids.length; ++i) {
                    col[i] = ((PersistentTranId)xids[i]).toString();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("xid " + col[i] + " in-doubt"));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getPreparedTransactions");
        }
        return col;
    }

    public final String getProperty(String key, String defaultValue) {
        String fullKey;
        String value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getProperty", (Object)new Object[]{"Key=" + key, "Default=" + defaultValue});
        }
        if (null == (value = (String)this._customProperties.get(fullKey = "sib.msgstore." + key))) {
            value = System.getProperty(fullKey);
        }
        if (null == value) {
            value = defaultValue;
        } else if (!value.equals(defaultValue)) {
            Runtime.changedPropertyValue((String)fullKey, (String)value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getProperty", (Object)("return=" + value));
        }
        return value;
    }

    public int getSpillLowerLimit() {
        return this._spillLowerLimit;
    }

    public int getSpillUpperLimit() {
        return this._spillUpperLimit;
    }

    public int getSpillLowerSizeLimit() {
        return this._spillLowerSizeLimit;
    }

    public int getSpillUpperSizeLimit() {
        return this._spillUpperSizeLimit;
    }

    public boolean getJdbcSpillSizeMsgRefsByMsgSize() {
        return this._jdbcSpillSizeMsgRefsByMsgSize;
    }

    public CacheStatistics getStoredCacheStatistics() {
        return this._itemStorageManager.getStoredCacheStatistics();
    }

    public TransactionFactory getTransactionFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getTransactionFactory");
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getTransactionFactory", (Object)("return=" + this._transactionFactory));
        }
        return this._transactionFactory;
    }

    public final long getUniqueLockID(int storageStrategy) throws PersistenceException {
        MessageStoreUnavailableException msue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueLockID");
        }
        if (this._uniqueIdentifierGenerator != null && this._uniqueLockIDGenerator != null) {
            long key = -1L;
            key = 1 == storageStrategy ? this._uniqueIdentifierGenerator.getPerInstanceUniqueValue() : this._uniqueLockIDGenerator.getUniqueValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueLockID", (Object)key);
            }
            return key;
        }
        if (!this._startupExceptions.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueLockID");
        }
        throw msue;
    }

    public final long getUniqueTickCount() throws PersistenceException {
        MessageStoreUnavailableException msue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueTickCount");
        }
        if (this._tickCountGenerator != null) {
            long key = -1L;
            key = this._tickCountGenerator.getUniqueValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueTickCount", (Object)key);
            }
            return key;
        }
        if (!this._startupExceptions.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueTickCount");
        }
        throw msue;
    }

    public final long getUniqueValue(int storageStrategy) throws PersistenceException {
        MessageStoreUnavailableException msue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueValue", (Object)storageStrategy);
        }
        if (this._uniqueIdentifierGenerator != null) {
            long key = -1L;
            key = 1 == storageStrategy ? this._uniqueIdentifierGenerator.getPerInstanceUniqueValue() : this._uniqueIdentifierGenerator.getUniqueValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueValue", (Object)key);
            }
            return key;
        }
        if (!this._startupExceptions.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getUniqueValue");
        }
        throw msue;
    }

    public XidManager getXidManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getXidManager");
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getXidManager", (Object)("return=" + this._manager));
        }
        return this._manager;
    }

    public final void initialize(Configuration config) {
        this.initialize(config, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initialize(Configuration config, boolean isReload) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initialize", (Object)new Object[]{"isReload=" + isReload, "Config=" + config});
        }
        StartLock startLock = _startLock;
        synchronized (startLock) {
            if (!isReload) {
                if (this._state != MessageStoreState.STATE_UNINITIALIZED) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initialize");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
                }
                this._state = MessageStoreState.STATE_STOPPED;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message store state is : " + this._state));
                }
            }
            this._configuration = config;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initialize");
        }
    }

    public void initialize(Object engineConfiguration) {
        this.initialize((JsMessagingEngine)engineConfiguration, false);
    }

    public void initialize(JsMessagingEngine engineConfiguration) {
        this.initialize(engineConfiguration, false);
    }

    private void initialize(JsMessagingEngine engineConfiguration, boolean isReload) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initialize", (Object)new Object[]{"isReload=" + isReload, "Config=" + engineConfiguration});
        }
        this._messagingEngine = engineConfiguration;
        WASConfiguration configuration = WASConfiguration.getDefaultWasConfiguration();
        configuration.setCleanPersistenceOnStart(false);
        SIBFileStore fs = (SIBFileStore)this._messagingEngine.getFilestore();
        configuration.setObjectManagerLogDirectory(fs.getPath());
        configuration.setObjectManagerLogSize(fs.getLogFileSize());
        configuration.setObjectManagerPermanentStoreDirectory(fs.getPath());
        configuration.setObjectManagerMinimumPermanentStoreSize(fs.getMinPermanentFileStoreSize());
        configuration.setObjectManagerMaximumPermanentStoreSize(fs.getMaxPermanentFileStoreSize());
        configuration.setObjectManagerPermanentStoreSizeUnlimited(fs.isUnlimitedPermanentStoreSize());
        configuration.setObjectManagerTemporaryStoreDirectory(fs.getPath());
        configuration.setObjectManagerMinimumTemporaryStoreSize(fs.getMinTemporaryFileStoreSize());
        configuration.setObjectManagerMaximumTemporaryStoreSize(fs.getMaxTemporaryFileStoreSize());
        configuration.setObjectManagerTemporaryStoreSizeUnlimited(fs.isUnlimitedTemporaryStoreSize());
        if (engineConfiguration.getMessageStoreType() == 1 && engineConfiguration.datastoreExists()) {
            configuration.setPersistentMessageStoreClassname("com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl");
            if (!isReload) {
                SibTr.info((TraceComponent)tc, (String)"MESSAGING_ENGINE_PERSISTENCE_DATASTORE_SIMS1568", (Object)new Object[]{engineConfiguration.getName()});
            }
        } else if (engineConfiguration.getMessageStoreType() == 0 && engineConfiguration.filestoreExists()) {
            configuration.setPersistentMessageStoreClassname("com.ibm.ws.sib.msgstore.persistence.objectManager.PersistentMessageStoreImpl");
            if (!isReload && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Messaging engine " + engineConfiguration.getName() + " is using a file store."));
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initialize");
            }
            throw new IllegalStateException(nls.getString("MSGSTORE_CONFIGURATION_ERROR_SIMS0503"));
        }
        this.initialize((Configuration)configuration, isReload);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initialize");
        }
    }

    public final boolean itemsCanExpire() {
        boolean reply = false;
        if (this._expirer != null) {
            reply = this._expirer.isRunning();
        }
        return reply;
    }

    public final NonLockingCursor newNonLockingCursor(Filter filter) throws MessageStoreException {
        MessageStoreUnavailableException msue;
        if (this._rootMembership != null) {
            return this._rootMembership.newNonLockingItemStreamCursor(filter);
        }
        if (!this._startupExceptions.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
        }
        throw msue;
    }

    public final void register(AbstractItemLink itemLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"register", (Object)itemLink);
        }
        long id = itemLink.getID();
        this._membershipMap.put(id, itemLink);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"register");
        }
    }

    public final void registerLink(AbstractItemLink newLink, AbstractItem item) {
        this.register(newLink);
        this._setMembership(newLink, item);
    }

    public ItemStream removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        MessageStoreUnavailableException msue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        if (this._rootMembership != null) {
            ItemStream item = this._rootMembership.removeFirstMatchingItemStream(filter, (PersistentTransaction)transaction);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"removeFirstMatching", (Object)("return=" + item));
            }
            return item;
        }
        if (!this._startupExceptions.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore failed to start!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore failed to start!", (Throwable)this._startupExceptions.get(0));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Operation not possible as MessageStore is unavailable!");
            }
            msue = new MessageStoreUnavailableException("Operation not possible as MessageStore is unavailable!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"removeFirstMatching");
        }
        throw msue;
    }

    public final void reportGlobalError() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"reportGlobalError");
        }
        if (this._healthState.couldBeWorse()) {
            this._healthState = JsHealthState.getGlobalError();
        }
        if (this._healthMonitor == null) {
            if (this._messagingEngine != null && this._messagingEngine instanceof JsHealthMonitor) {
                this._healthMonitor = (JsHealthMonitor)this._messagingEngine;
                this._healthMonitor.reportGlobalError();
            }
        } else {
            this._healthMonitor.reportGlobalError();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"reportGlobalError");
        }
    }

    public final void reportLocalError() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"reportLocalError");
        }
        if (this._healthState.isOK()) {
            this._healthState = JsHealthState.getLocalError();
        }
        if (this._healthMonitor == null) {
            if (this._messagingEngine != null && this._messagingEngine instanceof JsHealthMonitor) {
                this._healthMonitor = (JsHealthMonitor)this._messagingEngine;
                this._healthMonitor.reportLocalError();
            }
        } else {
            this._healthMonitor.reportLocalError();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"reportLocalError");
        }
    }

    public void rollbackPreparedTransaction(String xid) throws TransactionException, PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"rollbackPreparedTransaction", (Object)xid);
        }
        if (this._manager != null) {
            try {
                PersistentTranId pid = new PersistentTranId(xid);
                this._manager.rollback(pid);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Invalid XID string", (Object)xid);
                }
                throw new XidInvalidException(nls.getString("INVALID_XID_STRING_SIMS1010"));
            }
            catch (StringIndexOutOfBoundsException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Invalid XID string", (Object)xid);
                }
                throw new XidInvalidException(nls.getString("INVALID_XID_STRING_SIMS1010"));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"rollbackPreparedTransaction");
        }
    }

    public void setConfig(JsEObject config) {
    }

    public void setCacheLoaderInterval(long interval) {
        this._cacheLoaderInterval = interval;
    }

    public void setCustomProperty(String key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"setCustomProperty", (Object)new Object[]{"Key=" + key, "Value=" + value});
        }
        this._customProperties.put(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int arg0) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"start");
        }
        alarmManagerRef.getService();
        this._healthState = JsHealthState.getOK();
        StartLock startLock = _startLock;
        synchronized (startLock) {
            if (this._state != MessageStoreState.STATE_STOPPED) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            this._state = MessageStoreState.STATE_STARTING;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        this._startupExceptions.clear();
        String mapType = this.getProperty("itemMapType", "fastMap");
        String strMapSize = this.getProperty("itemMapSize", "18");
        int mapSize = -1;
        if (null != strMapSize) {
            mapSize = Integer.parseInt(strMapSize);
        }
        if ("fastMap".equals(mapType)) {
            String strMapParallelism = this.getProperty("itemMapParallelism", "7");
            int mapParallelism = -1;
            if (null != strMapParallelism) {
                mapParallelism = Integer.parseInt(strMapParallelism);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("using itemLinkMap(" + mapSize + "/" + mapParallelism + ")"));
            }
            this._membershipMap = new ItemLinkMap(mapSize, mapParallelism);
        } else {
            if (mapSize > 50 || mapSize < 5) {
                mapSize = 20;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("using multiMap(" + mapSize + ")"));
            }
            this._membershipMap = new MultiHashMap(mapSize);
        }
        String propValue = this.getProperty("jdbcSpillSizeMsgRefsByMsgSize", "false");
        this._jdbcSpillSizeMsgRefsByMsgSize = "true".equalsIgnoreCase(propValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Using jdbcSpillSizeMsgRefsByMsgSize=" + this._jdbcSpillSizeMsgRefsByMsgSize));
        }
        try {
            this._itemStorageManager = new ItemStorageManager();
            this._itemStorageManager.initialize(this);
            this._persistentMessageStore = PersistenceFactory.getPersistentMessageStore(this, this._manager, this._configuration);
            this._persistentMessageStore.start();
            try {
                String value = this.getProperty("spillUpperLimit", "20");
                this._spillUpperLimit = Integer.parseInt(value);
                value = this.getProperty("spillLowerLimit", "2");
                this._spillLowerLimit = Integer.parseInt(value);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Using spillUpperLimit=" + this._spillUpperLimit + "; spillLowerLimit=" + this._spillLowerLimit));
                }
                value = this.getProperty("spillUpperSizeLimit", "4000000");
                this._spillUpperSizeLimit = Integer.parseInt(value);
                value = this.getProperty("spillLowerSizeLimit", "400000");
                this._spillLowerSizeLimit = Integer.parseInt(value);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Using spillUpperSizeLimit=" + this._spillUpperSizeLimit + "; spillLowerSizeLimit=" + this._spillLowerSizeLimit));
                }
            }
            catch (NumberFormatException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Exception " + e + " while parsing spill limits"));
                }
                throw e;
            }
            StartLock e = _startLock;
            synchronized (e) {
                if (this._state != MessageStoreState.STATE_STARTING) {
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
                }
                this._manager.restart(this._persistentMessageStore);
                String xmlOn = this.getProperty("dumpDataStoreOnStartup", null);
                if (null != xmlOn) {
                    FileWriter fw = new FileWriter(xmlOn);
                    FormattedWriter writer = new FormattedWriter((Writer)fw);
                    this._xmlWriteRawOn(writer, false);
                    writer.flush();
                    writer.close();
                }
                String strMaxTransactionSize = this.getProperty("transactionSendLimit", "100");
                int maxTransactionSize = Integer.parseInt(strMaxTransactionSize);
                this._transactionFactory = new MSTransactionFactory(this, (PersistenceManager)((Object)this._persistentMessageStore));
                this._transactionFactory.setMaximumTransactionSize(maxTransactionSize);
                Persistable persistable = this._persistentMessageStore.readRootPersistable();
                if (null == persistable) {
                    throw new MessageStoreRuntimeException("ROOT_PERSISTABLE_EXCEPTION_SIMS0504");
                }
                this._uniqueIdentifierGenerator = this._persistentMessageStore.getUniqueKeyGenerator("UniqueIdentifier", 1000000);
                this._uniqueLockIDGenerator = this._persistentMessageStore.getUniqueKeyGenerator("UniqueLockValue", 500000);
                this._tickCountGenerator = this._persistentMessageStore.getUniqueKeyGenerator("UniqueTickCount", 500000);
                this._rootMembership = new RootMembership(this, persistable);
                this._rootMembership.initialize();
                this._cacheLoader.start(this._cacheLoaderInterval, this._messagingEngine);
                this._state = MessageStoreState.STATE_STARTED;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message store state is : " + this._state));
                }
            }
            String strDatastoreLockCanBeDisabled = this.getProperty("jdbcDataStoreLockCanBeDisabled", "false");
            this._datastoreLockCanBeDisabled = Boolean.parseBoolean(strDatastoreLockCanBeDisabled);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("_datastoreLockCanBeDisabled=" + this._datastoreLockCanBeDisabled));
            }
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof NonExistentLogFileException)) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.impl.MessageStoreImpl.start", (String)"755", (Object)((Object)this));
            }
            SibTr.error((TraceComponent)tc, (String)"STARTUP_EXCEPTION_SIMS0002", (Object)new Object[]{e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)((Object)this), (TraceComponent)tc, (String)"Exception: ", (Object)e);
            }
            this.setStartupException(e);
            this.stop(0);
            this.reportLocalError();
            throw new Exception(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(int arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"stop", (Object)arg0);
        }
        StartLock startLock = _startLock;
        synchronized (startLock) {
            if (this._state == MessageStoreState.STATE_UNINITIALIZED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"stop");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_MSGSTORE_STATE_SIMS0505", new Object[]{this._state}, null));
            }
            if (null != this._expirer) {
                this._expirer.stop();
            }
            if (null != this._deliveryDelayManager) {
                this._deliveryDelayManager.stop();
            }
            if (null != this._cacheLoader) {
                this._cacheLoader.stop();
            }
            if (null != this._membershipMap) {
                this._membershipMap.clear();
            }
            if (null != this._persistentMessageStore) {
                this._persistentMessageStore.stop(arg0);
            }
            this._rootMembership = null;
            this._itemStorageManager = null;
            this._tickCountGenerator = null;
            this._uniqueIdentifierGenerator = null;
            this._uniqueLockIDGenerator = null;
            this._state = MessageStoreState.STATE_STOPPED;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message store state is : " + this._state));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"stop");
        }
    }

    public final String toString() {
        return super.toString() + "[State:" + this._state + "]";
    }

    public final void unregister(AbstractItemLink itemLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"unregister", (Object)itemLink);
        }
        this._membershipMap.remove(itemLink.getID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"unregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.startTag("MessageStore");
        writer.indent();
        StartLock startLock = _startLock;
        synchronized (startLock) {
            if (this._state == MessageStoreState.STATE_STARTED) {
                this._rootMembership.xmlWriteItemStreamsOn(writer);
            } else {
                writer.newLine();
                writer.write(XML_CANNOT_BE_WRITTEN);
            }
        }
        if (null != this._itemStorageManager) {
            this._itemStorageManager.xmlWriteOn(writer);
        }
        if (null != this._membershipMap) {
            this._membershipMap.xmlWriteOn(writer);
        }
        if (null != this._persistentMessageStore) {
            this._persistentMessageStore.xmlWriteOn(writer);
        }
        if (null != this._expirer) {
            this._expirer.xmlWriteOn(writer);
        }
        if (null != this._cacheLoader) {
            this._cacheLoader.xmlWriteOn(writer);
        }
        if (null != this._deliveryDelayManager) {
            this._deliveryDelayManager.xmlWriteOn(writer);
        }
        writer.outdent();
        writer.newLine();
        writer.endTag("MessageStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xmlWriteRawOn(FormattedWriter writer, boolean callbackToItem) throws IOException {
        StartLock startLock = _startLock;
        synchronized (startLock) {
            if (this._state == MessageStoreState.STATE_STARTED) {
                this._xmlWriteRawOn(writer, callbackToItem);
            } else {
                writer.startTag("MessageStore");
                writer.indent();
                writer.newLine();
                writer.write(XML_CANNOT_BE_WRITTEN);
                writer.outdent();
                writer.newLine();
                writer.endTag("MessageStore");
            }
        }
    }

    public void setCustomPropertyByReload(String key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"setCustomPropertyByReload", (Object)new Object[]{"Key=" + key, "Value=" + value});
        }
        this._customProperties.put(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"setCustomPropertyByReload");
        }
    }

    public void unsetCustomPropertyByReload(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"unsetCustomPropertyByReload", (Object)("Key=" + key));
        }
        this._customProperties.remove(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"unsetCustomPropertyByReload");
        }
    }

    public void setConfigByReload(JsEObject newConfig) {
    }

    public void reloadComponent(JsEObject config) {
    }

    public boolean isDeleteable() {
        return false;
    }

    public void setRestrictLongDBLock(boolean restrictLongDBLock) {
        this._restrictLongDBLock = restrictLongDBLock;
    }

    public boolean isRestrictLongDBLock() {
        return this._restrictLongDBLock;
    }

    public void setLastDBLockedTimestamp(long lastDBLockedTimestamp) {
        this._lastDBLockedTimestamp = lastDBLockedTimestamp;
    }

    public long getLastDBLockedTimestamp() {
        return this._lastDBLockedTimestamp;
    }

    public final void initialize(JsRecoveryMessagingEngine recoveryME, String mode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initialize", (Object)new Object[]{recoveryME, mode});
        }
        this._messagingEngine = recoveryME;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initialize", (Object)"Assigned new recoverME to messages store");
        }
    }

    public void setConfig(LWMConfig config) {
    }

    private static final class StartLock {
        private StartLock() {
        }
    }
}

