/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class PkCertPath
extends PkPipe
implements PkConstants {
    private static Debug debug = Debug.getInstance("keycertmanage");
    private static final Object className = "com.ibm.security.certclient.PkCertPath";
    private KeyStore kStore;
    private PKIXParameters pkixParms;

    public PkCertPath(String keyStoreType, String anchorFileName, char[] filePwd) throws PkException {
        block8: {
            this.kStore = null;
            this.pkixParms = null;
            try {
                this.kStore = KeyStore.getInstance(keyStoreType, PkEeFactory.getProvider());
                this.kStore.load(new FileInputStream(anchorFileName), filePwd);
                this.setPKIXParms();
            }
            catch (KeyStoreException e2) {
                if (debug != null) {
                    debug.text(0L, className, "PkCertPath", "KeyStoreException. keyStoreType {0}", keyStoreType);
                    debug.exception(0L, className, "PkCertPath", e2);
                }
            }
            catch (GeneralSecurityException e3) {
                if (debug != null) {
                    debug.text(0L, className, "PkCertPath", "GeneralSecurityException. file {0}", anchorFileName);
                    debug.exception(0L, className, "PkCertPath", e3);
                }
            }
            catch (FileNotFoundException e4) {
                if (debug != null) {
                    debug.text(0L, className, "PkCertPath", "FileNotFoundException for file {0}", anchorFileName);
                    debug.exception(0L, className, "PkCertPath", e4);
                }
            }
            catch (IOException e5) {
                if (debug == null) break block8;
                debug.text(0L, className, "PkCertPath", "IOException from file {0}", anchorFileName);
                debug.exception(0L, className, "PkCertPath", e5);
            }
        }
    }

    @Override
    public PkCertRepEvent doCertReq(PkCertReqEvent req) throws PkException {
        PkCertRepEvent rep = this.propagate(req);
        if (this.pkixParms != null && !(req instanceof PkXcerReqEvent)) {
            this.validateCert(rep);
        }
        return rep;
    }

    private boolean validateCert(PkCertRepEvent rep) throws PkException {
        boolean validated = false;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "IBMCertPath");
            Certificate[] cArray = new Certificate[]{rep.getCert()};
            List<Certificate> l2 = Arrays.asList(cArray);
            CertPath cp = cf.generateCertPath(l2);
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            cpv.validate(cp, this.pkixParms);
            validated = true;
            if (debug != null) {
                debug.text(0L, className, "validateCert", "certpath validated");
            }
        }
        catch (CertPathValidatorException e2) {
            if (debug != null) {
                debug.text(0L, className, "validateCert", "WARNING:certpath could not be validated.The issuer of this certificate is not trusted");
                debug.exception(0L, className, "validateCert", e2);
            }
        }
        catch (GeneralSecurityException e3) {
            throw new PkException(e3);
        }
        return validated;
    }

    private void setPKIXParms() throws PkException {
        Enumeration<String> enumerator = null;
        try {
            enumerator = this.kStore.aliases();
        }
        catch (Exception e2) {
            throw new PkException(e2);
        }
        try {
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e3) {
            throw new PkException(e3);
        }
        HashSet<TrustAnchor> s2 = new HashSet<TrustAnchor>();
        while (enumerator.hasMoreElements()) {
            String alias = enumerator.nextElement();
            try {
                if (!this.kStore.isCertificateEntry(alias)) continue;
                TrustAnchor tanchor = new TrustAnchor((X509Certificate)this.kStore.getCertificate(alias), null);
                s2.add(tanchor);
            }
            catch (Exception e4) {
                throw new PkException(e4);
            }
        }
        this.pkixParms = null;
        if (!s2.isEmpty()) {
            try {
                this.pkixParms = new PKIXParameters(s2);
                this.pkixParms.setRevocationEnabled(false);
            }
            catch (GeneralSecurityException g2) {
                throw new PkException(g2);
            }
        }
    }
}

