/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.runtime.requester;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webserver.plugin.runtime.interfaces.PluginConfigRequester;
import com.ibm.ws.webserver.plugin.runtime.interfaces.PluginUtilityConfigGenerator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.util.HashMap;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={PluginConfigRequester.class}, immediate=true, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=PluginUtility,name=PluginConfigRequester"})
public class PluginConfigRequesterImpl
extends StandardMBean
implements PluginConfigRequester {
    private static final TraceComponent tc = Tr.register(PluginConfigRequesterImpl.class, (String)"PluginRuntime", (String)"com.ibm.ws.plugin.runtime.resources.Messages");
    protected WsLocationAdmin locMgr;
    private final HashMap<PluginUtilityConfigGenerator.Types, PluginUtilityConfigGenerator> pluginConfigMbeans = new HashMap();
    private File writeDirectory;
    private BundleContext bundleContext = null;
    static final long serialVersionUID = 8820447438616096087L;

    public PluginConfigRequesterImpl() {
        super(PluginConfigRequester.class, false);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Activate
    protected void activate(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Deactivate
    protected void deactivate() {
    }

    @Reference(service=PluginUtilityConfigGenerator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setPluginUtilityConfigGenerator(PluginUtilityConfigGenerator mb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("PluginConfigRequesterImpl: setPluginUtilityConfigGenerator :" + mb.getPluginConfigType() + " : " + mb.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        this.pluginConfigMbeans.put(mb.getPluginConfigType(), mb);
    }

    protected void unsetPluginUtilityConfigGenerator(PluginUtilityConfigGenerator mb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("PluginConfigRequesterImpl: unsetGeneratePluginConfig :" + mb.getPluginConfigType() + " : " + mb.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        this.pluginConfigMbeans.remove(mb.getPluginConfigType());
    }

    @Reference(service=WsLocationAdmin.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setLocationAdmin(WsLocationAdmin locRef) {
        this.locMgr = locRef;
        WsResource outFile = null;
        outFile = this.locMgr.getServerOutputResource("logs" + File.separatorChar + "state" + File.separatorChar);
        this.writeDirectory = outFile.asFile();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("PluginConfigRequesterImpl.setLocationAdmin : write directory : " + this.writeDirectory.getPath()), (Object[])new Object[0]);
        }
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locMgr = null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean generateClusterPlugin(String cluster) {
        boolean result = false;
        PluginUtilityConfigGenerator mBean = this.pluginConfigMbeans.get(PluginUtilityConfigGenerator.Types.COLLECTIVE);
        if (mBean != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("PluginConfigRequesterImpl.generateClusterPlugin : write directory : " + this.writeDirectory.getPath()), (Object[])new Object[0]);
            }
            try {
                mBean.generatePluginConfig(cluster, this.writeDirectory);
                result = true;
            }
            catch (Throwable throwable) {
                void th;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webserver.plugin.runtime.requester.PluginConfigRequesterImpl", (String)"115", (Object)this, (Object[])new Object[]{cluster});
                FFDCFilter.processException((Throwable)th, (String)this.getClass().getName(), (String)"generateClusterPlugin");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Error generating cluster plugin-cfg.xml: " + th.getMessage()), (Object[])new Object[0]);
                }
            }
        } else {
            result = false;
            Tr.error((TraceComponent)tc, (String)"collective.mbean.not.available", (Object[])new Object[]{cluster});
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean generateAppServerPlugin() {
        boolean result = false;
        PluginUtilityConfigGenerator mBean = this.pluginConfigMbeans.get(PluginUtilityConfigGenerator.Types.WEBCONTAINER);
        if (mBean != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("PluginConfigRequesterImpl.generateAppServerPlugin : write directory : " + this.writeDirectory.getPath()), (Object[])new Object[0]);
            }
            try {
                mBean.generatePluginConfig(null, this.writeDirectory);
                result = true;
            }
            catch (Throwable throwable) {
                void th;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webserver.plugin.runtime.requester.PluginConfigRequesterImpl", (String)"141", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)th, (String)this.getClass().getName(), (String)"generateAppServerPlugin");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Error generating app server plugin-cfg.xml xml: " + th.getMessage()), (Object[])new Object[0]);
                }
            }
        } else {
            result = false;
            Tr.error((TraceComponent)tc, (String)"appserver.mbean.not.available", (Object[])new Object[0]);
        }
        return result;
    }
}

