/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.tag;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsWriter;
import java.util.List;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class TagWriter {
    private TagWriter() {
    }

    public static void writeTags(ObjectNode node, List<Tag> tags) {
        if (tags == null) {
            return;
        }
        ArrayNode array = node.putArray("tags");
        for (Tag tag : tags) {
            ObjectNode tagNode = array.addObject();
            JsonUtil.stringProperty(tagNode, "name", tag.getName());
            JsonUtil.stringProperty(tagNode, "description", tag.getDescription());
            ExternalDocsWriter.writeExternalDocumentation(tagNode, tag.getExternalDocs());
            ExtensionWriter.writeExtensions(tagNode, tag);
        }
    }
}

