/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.jsp.translator.compiler.utils.JspFileObject;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private List<JarFile> jarFilesOfWsjars;
    private ClassLoader classLoader;
    private final WebModuleClassLoaderPackageFinder finder;
    Map<String, LinkedList<JspFileObject>> compiledTagFiles;
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager";
    private boolean areTagFiles;
    static final long serialVersionUID = 1687500869996339049L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspFileManager(JavaFileManager fileManager, ClassLoader classLoader) {
        super(fileManager);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{fileManager, classLoader});
        }
        this.jarFilesOfWsjars = new ArrayList<JarFile>();
        this.compiledTagFiles = new HashMap<String, LinkedList<JspFileObject>>();
        this.areTagFiles = false;
        this.classLoader = classLoader;
        this.finder = new WebModuleClassLoaderPackageFinder();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JspFileManager", "Creating JspFileManager with classloader = " + classLoader);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "list", new Object[]{location, packageName, kinds, recurse});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "list", "Looking for classes in package = " + packageName + " from location = " + location.getName());
        }
        Iterable<JavaFileObject> results = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            results = super.list(location, packageName, kinds, recurse);
        } else if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS) && !(results = super.list(location, packageName, kinds, recurse)).iterator().hasNext()) {
            results = this.finder.find(packageName, recurse);
        }
        ArrayList<JavaFileObject> arrayList = results;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting(CLASS_NAME, "list", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "inferBinaryName", new Object[]{location, file});
        }
        if (file instanceof JspFileObject) {
            String binaryName = ((JspFileObject)file).getBinaryName();
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inferBinaryName", "JspFileObject.getBinaryName()  = " + binaryName);
            }
            String string = binaryName;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "inferBinaryName", string);
            }
            return string;
        }
        String string = super.inferBinaryName(location, file);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "inferBinaryName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJavaFileForOutput", new Object[]{location, className, kind, sibling});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getJavaFileForOutput", "className  = " + className + "sibling.getName() = " + sibling.getName());
        }
        if (this.areTagFiles) {
            JavaFileObject javaFileObject = super.getJavaFileForOutput(location, className, kind, sibling);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                javaFileObject = javaFileObject;
                logger.exiting(CLASS_NAME, "getJavaFileForOutput", javaFileObject);
            }
            return javaFileObject;
        }
        String classNameNoPackage = className.substring(className.lastIndexOf(46) + 1);
        JavaFileObject javaFileObject = super.getJavaFileForOutput(location, classNameNoPackage, kind, sibling);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            javaFileObject = javaFileObject;
            logger.exiting(CLASS_NAME, "getJavaFileForOutput", javaFileObject);
        }
        return javaFileObject;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addDependencies(JspResources[] dependencies) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addDependencies", new Object[]{dependencies});
        }
        if (dependencies != null) {
            for (JspResources resource : dependencies) {
                if (this.compiledTagFiles.containsKey(resource.getPackageName())) {
                    this.compiledTagFiles.get(resource.getPackageName()).add(new JspFileObject(resource, JavaFileObject.Kind.CLASS));
                    continue;
                }
                LinkedList<JspFileObject> firstCompiledTagFileOfPackage = new LinkedList<JspFileObject>();
                firstCompiledTagFileOfPackage.add(new JspFileObject(resource, JavaFileObject.Kind.CLASS));
                this.compiledTagFiles.put(resource.getPackageName(), firstCompiledTagFileOfPackage);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addDependencies");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getClassLoader", new Object[]{location});
        }
        ClassLoader classLoader = this.classLoader;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            logger.exiting(CLASS_NAME, "getClassLoader", classLoader);
        }
        return classLoader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAreTagFiles(boolean areTagFiles) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setAreTagFiles", new Object[]{areTagFiles});
        }
        this.areTagFiles = areTagFiles;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setAreTagFiles");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "close", new Object[0]);
        }
        for (JarFile jarFile : this.jarFilesOfWsjars) {
            jarFile.close();
            if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "close", "closing jar [" + jarFile.getName() + "]");
        }
        super.close();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "close");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class WebModuleClassLoaderPackageFinder {
        private List<BundleWiring> bundleWiringOfActiveBundles = new ArrayList<BundleWiring>();
        static final long serialVersionUID = 4041076877643335540L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private WebModuleClassLoaderPackageFinder() {
        }

        public List<JavaFileObject> find(String packageName, boolean recursive) throws IOException {
            String javaPackageName = packageName.replace('.', '/');
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            Collection<URL> urlCollection = this.getClassLoaderResources(javaPackageName);
            if (urlCollection.isEmpty()) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "find", "Nothing was found in the classloader after recovery. Checking if we find any JspFileObject from our dependencies list for packageName = " + packageName);
                }
                if (JspFileManager.this.compiledTagFiles.containsKey(packageName)) {
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "find", "Dependencies were found for packageName = " + packageName);
                    }
                    result.addAll((Collection<JavaFileObject>)JspFileManager.this.compiledTagFiles.get(packageName));
                }
            }
            Iterator<URL> urlIterator = urlCollection.iterator();
            while (urlIterator.hasNext()) {
                result.addAll(this.listUnder(packageName, urlIterator.next(), recursive));
            }
            return result;
        }

        private Collection<URL> getClassLoaderResources(String javaPackageName) throws IOException {
            Enumeration<URL> urlEnumeration = JspFileManager.this.classLoader.getResources(javaPackageName + '/');
            LinkedHashMap<String, URL> hashMap = new LinkedHashMap<String, URL>();
            while (urlEnumeration.hasMoreElements()) {
                URL packageFolderURL = urlEnumeration.nextElement();
                hashMap.put(packageFolderURL.getFile(), packageFolderURL);
            }
            return hashMap.values();
        }

        private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL, boolean recursive) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "listUnder", "Looking for packageName = " + packageName + "in URL = " + packageFolderURL);
            }
            final File directory = new File(packageFolderURL.getFile());
            boolean isDirectory = false;
            isDirectory = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -2914624509589050681L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return directory.isDirectory();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder$1", 1.class, null, null);
                }
            }).booleanValue() : directory.isDirectory();
            if (isDirectory) {
                return this.processDir(packageName, directory, recursive);
            }
            if (packageFolderURL.getProtocol().equals("bundleresource")) {
                return this.processBundle(packageName, recursive);
            }
            return this.processJar(packageFolderURL, recursive);
        }

        private Collection<JavaFileObject> processBundle(String packageName, boolean recursive) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            for (BundleWiring bundleWiring : this.getBundleWiringOfActiveBundles()) {
                Bundle bundle = bundleWiring.getBundle();
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processBundle", "Creating JspFileObjects of the classes in bundle = " + bundle.getSymbolicName());
                }
                Collection classesInBundle = bundleWiring.listResources(packageName.replace('.', '/'), "*" + JavaFileObject.Kind.CLASS.extension, 2);
                for (String location : classesInBundle) {
                    String binaryName = location.replace('/', '.').replaceAll(JavaFileObject.Kind.CLASS.extension + "$", "");
                    URI resourceURI = null;
                    try {
                        resourceURI = bundle.getResource(location).toURI();
                        String protocol = resourceURI.toURL().getProtocol();
                        result.add(new JspFileObject(binaryName, resourceURI, protocol));
                    }
                    catch (MalformedURLException e) {
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processBundle", "There was a problem getting the URL of the URI representing binaryName = " + binaryName, e);
                        }
                        result.add(new JspFileObject(binaryName, resourceURI, "bundleresource"));
                    }
                    catch (URISyntaxException e) {
                        if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                        logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processBundle", "There was a problem getting  the URI representing binaryName = " + binaryName, e);
                    }
                }
            }
            return result;
        }

        private List<BundleWiring> getBundleWiringOfActiveBundles() {
            if (this.bundleWiringOfActiveBundles.isEmpty()) {
                Bundle[] activeBundles;
                BundleContext jspBundleContext = null;
                jspBundleContext = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){
                    static final long serialVersionUID = 2752714363918574557L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public BundleContext run() {
                        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder$2", 2.class, null, null);
                    }
                }) : FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                for (final Bundle bundle : activeBundles = jspBundleContext.getBundles()) {
                    BundleWiring bundleWiring = null;
                    bundleWiring = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<BundleWiring>(){
                        static final long serialVersionUID = 1030833897155265091L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public BundleWiring run() {
                            return (BundleWiring)bundle.adapt(BundleWiring.class);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder$3", 3.class, null, null);
                        }
                    }) : (BundleWiring)bundle.adapt(BundleWiring.class);
                    this.bundleWiringOfActiveBundles.add(bundleWiring);
                }
            }
            return this.bundleWiringOfActiveBundles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<JavaFileObject> processJar(URL packageFolderURL, boolean recursive) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processJar", "Processing jar = " + packageFolderURL + " recursive = " + recursive);
            }
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            String packageName = packageFolderURL.getPath().split("!/")[1];
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processJar", "packageName = " + packageName);
            }
            ZipFile jarFile = null;
            try {
                URLConnection urlConnection = packageFolderURL.openConnection();
                Enumeration<JarEntry> entryEnum = null;
                URI jarFileURI = null;
                String protocol = packageFolderURL.getProtocol();
                if (protocol.equals("wsjar")) {
                    WSJarURLConnection wsJarUrlConnection = (WSJarURLConnection)urlConnection;
                    final File fileLocationOfJar = wsJarUrlConnection.getFile();
                    jarFile = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<JarFile>(){
                        static final long serialVersionUID = 537062512111117515L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public JarFile run() {
                            try {
                                return new JarFile(fileLocationOfJar);
                            }
                            catch (IOException e) {
                                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processJar", "IOException in doPriviledged processing jar.", e);
                                }
                                return null;
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder$4", 4.class, null, null);
                        }
                    }) : new JarFile(fileLocationOfJar);
                    jarFileURI = fileLocationOfJar.toURI();
                    entryEnum = jarFile != null ? ((JarFile)jarFile).entries() : new Vector().elements();
                } else {
                    JarURLConnection jarConn = (JarURLConnection)urlConnection;
                    jarFileURI = jarConn.getJarFileURL().toURI();
                    jarFile = jarConn.getJarFile();
                    entryEnum = ((JarFile)jarFile).entries();
                }
                Pattern classesInPackage = Pattern.compile(packageName + "[^/]*" + JavaFileObject.Kind.CLASS.extension);
                Matcher m = classesInPackage.matcher("");
                while (entryEnum.hasMoreElements()) {
                    JarEntry jarEntry = entryEnum.nextElement();
                    String fileName = jarEntry.getName();
                    if (!m.reset(fileName).matches()) continue;
                    String binaryName = fileName.replace('/', '.').replaceAll(JavaFileObject.Kind.CLASS.extension + "$", "");
                    JspFileObject jspFileObject = new JspFileObject(binaryName, jarFileURI, protocol);
                    result.add(jspFileObject);
                    if (!protocol.equals("wsjar")) continue;
                    JspFileManager.this.jarFilesOfWsjars.add(jspFileObject.getJarFile());
                }
            }
            catch (IOException e) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processJar", "IOException processing jar.", e);
                }
            }
            catch (URISyntaxException e) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processJar", "Unable to get URI of jar file.", e);
                }
            }
            finally {
                block24: {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException e) {
                        if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block24;
                        logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processJar", "Unable to close jarFile.", e);
                    }
                }
            }
            return result;
        }

        private List<JavaFileObject> processDir(String packageName, final File directory, boolean recursive) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processDir", "Processing directory = " + directory + " looking for classes in packageName = " + packageName);
            }
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            File[] childFiles = directory.listFiles();
            childFiles = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<File[]>(){
                static final long serialVersionUID = -6200052404642292424L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File[] run() {
                    return directory.listFiles();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder$5", 5.class, null, null);
                }
            }) : directory.listFiles();
            if (childFiles != null) {
                for (final File childFile : childFiles) {
                    boolean isFile = false;
                    isFile = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                        static final long serialVersionUID = 5259803223798825020L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Boolean run() {
                            return childFile.isFile();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder$6", 6.class, null, null);
                        }
                    }).booleanValue() : childFile.isFile();
                    if (isFile && childFile.getName().endsWith(JavaFileObject.Kind.CLASS.extension)) {
                        String protocol;
                        String binaryName;
                        block6: {
                            binaryName = packageName + "." + childFile.getName().replaceAll(JavaFileObject.Kind.CLASS.extension + "$", "");
                            protocol = "file";
                            try {
                                protocol = childFile.toURI().toURL().getProtocol();
                            }
                            catch (MalformedURLException e) {
                                if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block6;
                                logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", "processDir", "There was a problem getting the URL protocol; using file as the protocol ", e);
                            }
                        }
                        result.add(new JspFileObject(binaryName, childFile.toURI(), protocol));
                        continue;
                    }
                    if (!recursive || !childFile.isDirectory()) continue;
                    result.addAll(this.processDir(packageName + "." + childFile.getName(), childFile, recursive));
                }
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.compiler.utils.JspFileManager$WebModuleClassLoaderPackageFinder", WebModuleClassLoaderPackageFinder.class, null, null);
        }
    }
}

