/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.hibernate;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

@Trivial
public class LibertyJtaPlatform
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 8662020839696752408L;
    private static final TraceComponent tc = Tr.register(LibertyJtaPlatform.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object[])args);
        }
        Object r = null;
        try {
            if (args == null || args.length == 0) {
                if ("canRegisterSynchronization".equals(methodName)) {
                    r = this.canRegisterSynchronization();
                } else if ("getCurrentStatus".equals(methodName)) {
                    r = this.getCurrentStatus();
                } else if ("hashCode".equals(methodName)) {
                    r = System.identityHashCode(this);
                } else if ("retrieveTransactionManager".equals(methodName)) {
                    r = this.retrieveTransactionManager();
                } else if ("retrieveUserTransaction".equals(methodName)) {
                    r = this.retrieveUserTransaction();
                } else if ("toString".equals(methodName)) {
                    r = this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this));
                }
            } else if ("equals".equals(methodName)) {
                r = proxy == args[0];
            } else if ("getTransactionIdentifier".equals(methodName)) {
                r = this.getTransactionIdentifier((Transaction)args[0]);
            } else if ("registerSynchronization".equals(methodName)) {
                this.registerSynchronization((Synchronization)args[0]);
            }
        }
        catch (Throwable x) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)methodName, (Object)x);
            }
            throw x;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)methodName, (Object)r);
        }
        return r;
    }

    private boolean canRegisterSynchronization() {
        try {
            return TransactionManagerFactory.getTransactionManager().getStatus() == 0;
        }
        catch (SystemException x) {
            throw new RuntimeException(x);
        }
    }

    private int getCurrentStatus() throws SystemException {
        return TransactionManagerFactory.getTransactionManager().getStatus();
    }

    private Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    private void registerSynchronization(Synchronization synchronization) {
        try {
            TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (IllegalStateException x) {
            throw new RuntimeException(x);
        }
        catch (RollbackException x) {
            throw new RuntimeException(x);
        }
        catch (SystemException x) {
            throw new RuntimeException(x);
        }
    }

    private TransactionManager retrieveTransactionManager() {
        return TransactionManagerFactory.getTransactionManager();
    }

    private UserTransaction retrieveUserTransaction() {
        try {
            return (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        }
        catch (NamingException x) {
            throw new RuntimeException(x);
        }
    }
}

