/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.util;

import java.nio.charset.StandardCharsets;

public enum Utf8Codec {


    public static int getEncodedLength(String s) {
        int count = 0;
        int strLength = s.length();
        for (int i = 0; i < strLength; ++i) {
            int cp = s.codePointAt(i);
            if (cp < 128) {
                ++count;
                continue;
            }
            if (cp < 2048) {
                count += 2;
                continue;
            }
            if (cp < 65536) {
                count += 3;
                continue;
            }
            count += 4;
            ++i;
        }
        return count;
    }

    public static int encode(byte[] buff, int offset, String s) {
        byte[] ba = Utf8Codec.encode(s);
        System.arraycopy(ba, 0, buff, offset, ba.length);
        return ba.length;
    }

    public static byte[] encode(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static String decode(byte[] ba, int offset, int length) {
        return new String(ba, offset, length, StandardCharsets.UTF_8);
    }

    public static String decode(byte[] ba) {
        return Utf8Codec.decode(ba, 0, ba.length);
    }
}

