/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi30;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi30.MetricName;
import io.astefanutti.metrics.cdi30.MetricsExtension;
import io.openliberty.microprofile.metrics.internal.cdi30.helper.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricResolver {
    @Inject
    private MetricRegistry registry;
    @Inject
    protected MetricsExtension extension;
    @Inject
    protected MetricName metricName;
    @Inject
    protected BeanManager beanManager;
    static final long serialVersionUID = 1660225508244893560L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public <E extends Member & AnnotatedElement> Of<Counted> counted(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Counted.class);
    }

    public <E extends Member & AnnotatedElement> Of<ConcurrentGauge> concurentGauged(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)ConcurrentGauge.class);
    }

    public Of<Gauge> gauge(Class<?> topClass, Method method) {
        return this.resolverOf(topClass, method, Gauge.class);
    }

    public <E extends Member & AnnotatedElement> Of<Metered> metered(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Metered.class);
    }

    public <E extends Member & AnnotatedElement> Of<Timed> timed(Class<?> bean, E element) {
        return this.resolverOf(bean, element, (Class)Timed.class);
    }

    public <E extends Member & AnnotatedElement> Of<SimplyTimed> simplyTimed(Class<?> bean, E element) {
        return this.resolverOf(bean, element, (Class)SimplyTimed.class);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> resolverOf(Class<?> bean, E element, Class<T> metric) {
        if (((AnnotatedElement)element).isAnnotationPresent(metric)) {
            return this.elementResolverOf(element, metric);
        }
        return this.beanResolverOf(element, metric, bean);
    }

    protected <E extends Member & AnnotatedElement, T extends Annotation> Of<T> elementResolverOf(E element, Class<T> metric) {
        T annotation = ((AnnotatedElement)element).getAnnotation(metric);
        String name = this.extension.getMetricNameForMember(element, (Annotation)annotation);
        boolean initialDiscovery = false;
        if (name == null) {
            name = this.metricName(element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
            initialDiscovery = true;
        }
        MetadataBuilder mdb = Metadata.builder().withName(name).withType(this.getType((Annotation)annotation)).withUnit(this.getUnit((Annotation)annotation)).withDescription(this.getDescription((Annotation)annotation)).withDisplayName(this.getDisplayname((Annotation)annotation));
        String[] tags = this.getTags((Annotation)annotation);
        DoesHaveMetric of = new DoesHaveMetric((Annotation)annotation, name, mdb.build(), initialDiscovery, tags, null);
        this.checkReusable(of);
        return of;
    }

    protected <T extends Annotation> boolean hasMetricAnnotationBean(Class<T> metric, Class<?> bean) {
        Annotation[] beanAnotations;
        if (bean.isAnnotationPresent(metric)) {
            return true;
        }
        for (Annotation annotation : beanAnotations = bean.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.beanManager.isStereotype(annotationType) || !annotationType.isAnnotationPresent(metric)) continue;
            return true;
        }
        return false;
    }

    protected <T extends Annotation> T getAnnotationBean(Class<T> metric, Class<?> bean) {
        Annotation[] beanAnotations;
        T annotationObj = bean.getAnnotation(metric);
        if (annotationObj != null) {
            return annotationObj;
        }
        for (Annotation annotation : beanAnotations = bean.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.beanManager.isStereotype(annotationType) || !annotationType.isAnnotationPresent(metric) || (annotationObj = annotationType.getAnnotation(metric)) == null) continue;
            return annotationObj;
        }
        return null;
    }

    protected <E extends Member & AnnotatedElement, T extends Annotation> Of<T> beanResolverOf(E element, Class<T> metric, Class<?> bean) {
        if (this.hasMetricAnnotationBean(metric, bean)) {
            T annotation = this.getAnnotationBean(metric, bean);
            String name = this.extension.getMetricNameForMember(element, (Annotation)annotation);
            boolean initialDiscovery = false;
            if (name == null) {
                name = this.metricName(bean, element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
                initialDiscovery = true;
            }
            MetadataBuilder mdb = Metadata.builder().withName(name).withType(this.getType((Annotation)annotation)).withUnit(this.getUnit((Annotation)annotation)).withDescription(this.getDescription((Annotation)annotation)).withDisplayName(this.getDisplayname((Annotation)annotation));
            String[] tags = this.getTags((Annotation)annotation);
            DoesHaveMetric of = new DoesHaveMetric((Annotation)annotation, name, mdb.build(), initialDiscovery, tags, null);
            this.checkReusable(of);
            return of;
        }
        if (bean.getSuperclass() != null) {
            return this.beanResolverOf(element, metric, bean.getSuperclass());
        }
        return new DoesNotHaveMetric();
    }

    private <E extends Member & AnnotatedElement> String metricName(E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? this.defaultName(element, type) : this.metricName.of(name);
        return absolute ? metric : MetricRegistry.name(element.getDeclaringClass(), (String[])new String[]{metric});
    }

    private <E extends Member & AnnotatedElement> String metricName(Class<?> bean, E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? bean.getSimpleName() : this.metricName.of(name);
        return absolute ? MetricRegistry.name((String)metric, (String[])new String[]{this.defaultName(element, type)}) : MetricRegistry.name((String)bean.getPackage().getName(), (String[])new String[]{metric, this.defaultName(element, type)});
    }

    private <E extends Member & AnnotatedElement> String defaultName(E element, Class<? extends Annotation> type) {
        return this.memberName(element);
    }

    private String memberName(Member member) {
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getSimpleName();
        }
        return member.getName();
    }

    private String metricName(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).name();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).name();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).name();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).name();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).name();
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return ((SimplyTimed)annotation).name();
        }
        this.throwIAEUnsupportedMetric(annotation);
        return null;
    }

    private boolean isMetricAbsolute(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).absolute();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).absolute();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).absolute();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).absolute();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).absolute();
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return ((SimplyTimed)annotation).absolute();
        }
        this.throwIAEUnsupportedMetric(annotation);
        return false;
    }

    private String[] getTags(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).tags();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).tags();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).tags();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).tags();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).tags();
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return ((SimplyTimed)annotation).tags();
        }
        this.throwIAEUnsupportedMetric(annotation);
        return null;
    }

    private String getDisplayname(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).displayName();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).displayName();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).displayName();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).displayName();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).displayName();
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return ((SimplyTimed)annotation).displayName();
        }
        this.throwIAEUnsupportedMetric(annotation);
        return null;
    }

    private String getDescription(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).description();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).description();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).description();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).description();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).description();
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return ((SimplyTimed)annotation).description();
        }
        this.throwIAEUnsupportedMetric(annotation);
        return null;
    }

    private MetricType getType(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return MetricType.COUNTER;
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return MetricType.CONCURRENT_GAUGE;
        }
        if (Gauge.class.isInstance(annotation)) {
            return MetricType.GAUGE;
        }
        if (Metered.class.isInstance(annotation)) {
            return MetricType.METERED;
        }
        if (Timed.class.isInstance(annotation)) {
            return MetricType.TIMER;
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return MetricType.SIMPLE_TIMER;
        }
        this.throwIAEUnsupportedMetric(annotation);
        return null;
    }

    private String getUnit(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).unit();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return "none";
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).unit();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).unit();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).unit();
        }
        if (SimplyTimed.class.isInstance(annotation)) {
            return ((SimplyTimed)annotation).unit();
        }
        this.throwIAEUnsupportedMetric(annotation);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void throwIAEUnsupportedMetric(Annotation annotation) throws IllegalArgumentException {
        try {
            throw new IllegalArgumentException("Unsupported Metrics for Method [" + annotation.getClass().getName() + "]");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void exception;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"io.astefanutti.metrics.cdi30.MetricResolver", (String)"355", (Object)this, (Object[])new Object[]{annotation});
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Annotation> boolean checkReusable(Of<T> of) {
        if (!of.isInitialDiscovery()) {
            return true;
        }
        String name = of.metadata().getName();
        String[] tags = of.tags();
        MetricID metricID = new MetricID(name, Utils.tagsToTags(tags));
        Metadata existingMetadata = this.registry.getMetadata(name);
        if (existingMetadata != null && !existingMetadata.equals(of.metadata())) {
            try {
                throw new IllegalArgumentException("Cannot reuse metric with MetricID " + metricID.toString() + "with Metadata " + of.metadata().toString() + ". There already exists a Metadata for this metric name with different values: " + existingMetadata.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void exception;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"io.astefanutti.metrics.cdi30.MetricResolver", (String)"389", (Object)this, (Object[])new Object[]{of});
                throw exception;
            }
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi30.MetricResolver", MetricResolver.class, null, null);
    }

    @Vetoed
    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class DoesNotHaveMetric<T extends Annotation>
    implements Of<T> {
        static final long serialVersionUID = 7008839009101723057L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DoesNotHaveMetric() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String metricName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T metricAnnotation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata metadata() {
            return null;
        }

        @Override
        public boolean isInitialDiscovery() {
            return false;
        }

        @Override
        public String[] tags() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi30.MetricResolver$DoesNotHaveMetric", DoesNotHaveMetric.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class DoesHaveMetric<T extends Annotation>
    implements Of<T> {
        private final T annotation;
        private final String name;
        private final Metadata metadata;
        private final boolean initialDiscovery;
        private final String[] tags;
        static final long serialVersionUID = 6361969484439508911L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DoesHaveMetric(T annotation, String name, Metadata metadata, boolean initialDiscovery, String[] tags) {
            this.annotation = annotation;
            this.name = name;
            this.metadata = metadata;
            this.initialDiscovery = initialDiscovery;
            this.tags = tags;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String metricName() {
            return this.name;
        }

        @Override
        public T metricAnnotation() {
            return this.annotation;
        }

        @Override
        public Metadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean isInitialDiscovery() {
            return this.initialDiscovery;
        }

        @Override
        public String[] tags() {
            return this.tags;
        }

        /* synthetic */ DoesHaveMetric(Annotation x0, String x1, Metadata x2, boolean x3, String[] x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi30.MetricResolver$DoesHaveMetric", DoesHaveMetric.class, null, null);
        }
    }

    public static interface Of<T extends Annotation> {
        public boolean isPresent();

        public String metricName();

        public String[] tags();

        public Metadata metadata();

        public T metricAnnotation();

        public boolean isInitialDiscovery();
    }
}

